/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SpinnerUI;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class JSpinnerOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String VALUE_DPROP = "Value";
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());
    private JButtonOperator increaseOperator = null;
    private JButtonOperator decreaseOperator = null;
    static /* synthetic */ Class class$javax$swing$JSpinner;
    static /* synthetic */ Class class$javax$swing$SpinnerNumberModel;
    static /* synthetic */ Class class$javax$swing$SpinnerListModel;
    static /* synthetic */ Class class$javax$swing$SpinnerDateModel;

    public JSpinnerOperator(JSpinner jSpinner) {
        super(jSpinner);
    }

    public JSpinnerOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JSpinner)containerOperator.waitSubComponent(new JSpinnerFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JSpinnerOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JSpinnerOperator(ContainerOperator containerOperator, String string, int n) {
        this((JSpinner)JSpinnerOperator.waitComponent(containerOperator, (ComponentChooser)new JSpinnerByTextFinder(string, containerOperator.getComparator()), n));
        this.copyEnvironment(containerOperator);
    }

    public JSpinnerOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public JSpinnerOperator(ContainerOperator containerOperator, int n) {
        this((JSpinner)JSpinnerOperator.waitComponent(containerOperator, (ComponentChooser)new JSpinnerFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JSpinnerOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JSpinner findJSpinner(Container container, ComponentChooser componentChooser, int n) {
        return (JSpinner)JSpinnerOperator.findComponent(container, new JSpinnerFinder(componentChooser), n);
    }

    public static JSpinner findJSpinner(Container container, ComponentChooser componentChooser) {
        return JSpinnerOperator.findJSpinner(container, componentChooser, 0);
    }

    public static JSpinner findJSpinner(Container container, int n) {
        return JSpinnerOperator.findJSpinner(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JSpinner instance"), n);
    }

    public static JSpinner findJSpinner(Container container) {
        return JSpinnerOperator.findJSpinner(container, 0);
    }

    public static JSpinner waitJSpinner(Container container, ComponentChooser componentChooser, int n) {
        return (JSpinner)JSpinnerOperator.waitComponent(container, (ComponentChooser)new JSpinnerFinder(componentChooser), n);
    }

    public static JSpinner waitJSpinner(Container container, ComponentChooser componentChooser) {
        return JSpinnerOperator.waitJSpinner(container, componentChooser, 0);
    }

    public static JSpinner waitJSpinner(Container container, int n) {
        return JSpinnerOperator.waitJSpinner(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JSpinner instance"), n);
    }

    public static JSpinner waitJSpinner(Container container) {
        return JSpinnerOperator.waitJSpinner(container, 0);
    }

    public static void checkModel(JSpinnerOperator jSpinnerOperator, Class clazz) {
        if (!clazz.isInstance(jSpinnerOperator.getModel())) {
            throw new SpinnerModelException("JSpinner model is not a " + clazz.getName(), jSpinnerOperator.getSource());
        }
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public NumberSpinnerOperator getNumberSpinner() {
        return new NumberSpinnerOperator(this);
    }

    public ListSpinnerOperator getListSpinner() {
        return new ListSpinnerOperator(this);
    }

    public DateSpinnerOperator getDateSpinner() {
        return new DateSpinnerOperator(this);
    }

    public void scrollTo(final ScrollAdjuster scrollAdjuster) {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JSpinnerOperator.this.driver.scroll(JSpinnerOperator.this, scrollAdjuster);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSpinnerOperator.WholeScrollTimeout"));
    }

    public void scrollToMaximum() {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JSpinnerOperator.this.driver.scrollToMaximum(JSpinnerOperator.this, 1);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSpinnerOperator.WholeScrollTimeout"));
    }

    public void scrollToMinimum() {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JSpinnerOperator.this.driver.scrollToMinimum(JSpinnerOperator.this, 1);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSpinnerOperator.WholeScrollTimeout"));
    }

    public void scrollToObject(Object object, int n) {
        this.scrollTo(new ExactScrollAdjuster(this, object, n));
    }

    public void scrollToString(String string, Operator.StringComparator stringComparator, int n) {
        this.scrollTo(new ToStringScrollAdjuster(this, string, stringComparator, n));
    }

    public void scrollToString(String string, int n) {
        this.scrollToString(string, this.getComparator(), n);
    }

    public JButtonOperator getIncreaseOperator() {
        if (this.increaseOperator == null) {
            this.increaseOperator = (JButtonOperator)this.createSubOperator(new JButtonOperator.JButtonFinder(), 0);
            this.increaseOperator.copyEnvironment(this);
            this.increaseOperator.setOutput(this.getOutput().createErrorOutput());
        }
        return this.increaseOperator;
    }

    public JButtonOperator getDecreaseOperator() {
        if (this.decreaseOperator == null) {
            this.decreaseOperator = (JButtonOperator)this.createSubOperator(new JButtonOperator.JButtonFinder(), 1);
            this.decreaseOperator.copyEnvironment(this);
            this.decreaseOperator.setOutput(this.getOutput().createErrorOutput());
        }
        return this.decreaseOperator;
    }

    public Object getMinimum() {
        SpinnerModel spinnerModel = this.getModel();
        if (spinnerModel instanceof SpinnerNumberModel) {
            return ((SpinnerNumberModel)spinnerModel).getMinimum();
        }
        if (spinnerModel instanceof SpinnerDateModel) {
            return ((SpinnerDateModel)spinnerModel).getEnd();
        }
        if (spinnerModel instanceof SpinnerListModel) {
            List<?> list = ((SpinnerListModel)spinnerModel).getList();
            return list.get(list.size() - 1);
        }
        return null;
    }

    public Object getMaximum() {
        SpinnerModel spinnerModel = this.getModel();
        if (spinnerModel instanceof SpinnerNumberModel) {
            return ((SpinnerNumberModel)spinnerModel).getMaximum();
        }
        if (spinnerModel instanceof SpinnerDateModel) {
            return ((SpinnerDateModel)spinnerModel).getEnd();
        }
        if (spinnerModel instanceof SpinnerListModel) {
            List<?> list = ((SpinnerListModel)spinnerModel).getList();
            return list.get(list.size() - 1);
        }
        return null;
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        hashtable.put(VALUE_DPROP, ((JSpinner)this.getSource()).getValue().toString());
        return hashtable;
    }

    public Object getValue() {
        return this.runMapping(new Operator.MapAction("getValue"){

            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getValue();
            }
        });
    }

    public void setValue(final Object object) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).setValue(object);
            }
        });
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getUI();
            }
        });
    }

    public void setUI(final SpinnerUI spinnerUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).setUI(spinnerUI);
            }
        });
    }

    public void setModel(final SpinnerModel spinnerModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).setModel(spinnerModel);
            }
        });
    }

    public SpinnerModel getModel() {
        return (SpinnerModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getModel();
            }
        });
    }

    public Object getNextValue() {
        return this.runMapping(new Operator.MapAction("getNextValue"){

            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getNextValue();
            }
        });
    }

    public void addChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("addChangeListener"){

            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).addChangeListener(changeListener);
            }
        });
    }

    public void removeChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("removeChangeListener"){

            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).removeChangeListener(changeListener);
            }
        });
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.runMapping(new Operator.MapAction("getChangeListeners"){

            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getChangeListeners();
            }
        });
    }

    public Object getPreviousValue() {
        return this.runMapping(new Operator.MapAction("getPreviousValue"){

            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getPreviousValue();
            }
        });
    }

    public void setEditor(final JComponent jComponent) {
        this.runMapping(new Operator.MapVoidAction("setEditor"){

            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).setEditor(jComponent);
            }
        });
    }

    public JComponent getEditor() {
        return (JComponent)this.runMapping(new Operator.MapAction("getEditor"){

            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getEditor();
            }
        });
    }

    public void commitEdit() {
        this.runMapping(new Operator.MapVoidAction("commitEdit"){

            public void map() throws ParseException {
                ((JSpinner)JSpinnerOperator.this.getSource()).commitEdit();
            }
        });
    }

    static {
        Timeouts.initDefault("JSpinnerOperator.WholeScrollTimeout", 60000L);
    }

    public static class SpinnerModelException
    extends JemmyException {
        public SpinnerModelException(String string, Component component) {
            super(string, component);
        }
    }

    public class DateSpinnerOperator
    extends JSpinnerOperator {
        private DateSpinnerOperator(JSpinnerOperator jSpinnerOperator2) {
            super((JSpinner)jSpinnerOperator2.getSource());
            this.copyEnvironment(jSpinnerOperator2);
            DateSpinnerOperator.checkModel(this, class$javax$swing$SpinnerDateModel == null ? (class$javax$swing$SpinnerDateModel = JSpinnerOperator.class$("javax.swing.SpinnerDateModel")) : class$javax$swing$SpinnerDateModel);
        }

        public SpinnerDateModel getDateModel() {
            return (SpinnerDateModel)this.getModel();
        }

        public void scrollToDate(Date date) {
            this.scrollTo(new DateScrollAdjuster(this, date));
        }
    }

    public class ListSpinnerOperator
    extends JSpinnerOperator {
        private ListSpinnerOperator(JSpinnerOperator jSpinnerOperator2) {
            super((JSpinner)jSpinnerOperator2.getSource());
            this.copyEnvironment(jSpinnerOperator2);
            ListSpinnerOperator.checkModel(this, class$javax$swing$SpinnerListModel == null ? (class$javax$swing$SpinnerListModel = JSpinnerOperator.class$("javax.swing.SpinnerListModel")) : class$javax$swing$SpinnerListModel);
        }

        public SpinnerListModel getListModel() {
            return (SpinnerListModel)this.getModel();
        }

        public int findItem(String string, Operator.StringComparator stringComparator) {
            List<?> list = this.getListModel().getList();
            for (int i = 0; i < list.size(); ++i) {
                if (!stringComparator.equals(list.get(i).toString(), string)) continue;
                return i;
            }
            return -1;
        }

        public int findItem(String string) {
            return this.findItem(string, this.getComparator());
        }

        public void scrollToIndex(int n) {
            this.scrollTo(new ListScrollAdjuster((JSpinnerOperator)this, n));
        }

        public void scrollToString(String string, Operator.StringComparator stringComparator) {
            int n = this.findItem(string, stringComparator);
            if (n == -1) {
                throw new JemmyException("No \"" + string + "\" item in JSpinner", this.getSource());
            }
            this.scrollToIndex(n);
        }

        public void scrollToString(String string) {
            this.scrollToString(string, this.getComparator());
        }
    }

    public class NumberSpinnerOperator
    extends JSpinnerOperator {
        private NumberSpinnerOperator(JSpinnerOperator jSpinnerOperator2) {
            super((JSpinner)jSpinnerOperator2.getSource());
            this.copyEnvironment(jSpinnerOperator2);
            NumberSpinnerOperator.checkModel(this, class$javax$swing$SpinnerNumberModel == null ? (class$javax$swing$SpinnerNumberModel = JSpinnerOperator.class$("javax.swing.SpinnerNumberModel")) : class$javax$swing$SpinnerNumberModel);
        }

        public SpinnerNumberModel getNumberModel() {
            return (SpinnerNumberModel)this.getModel();
        }

        public void scrollToValue(double d) {
            this.scrollTo(new NumberScrollAdjuster((JSpinnerOperator)this, d));
        }

        public void scrollToValue(Number number) {
            this.scrollTo(new NumberScrollAdjuster((JSpinnerOperator)this, number));
        }
    }

    public static class ToStringScrollAdjuster
    extends ObjectScrollAdjuster {
        String pattern;
        Operator.StringComparator comparator;

        public ToStringScrollAdjuster(JSpinnerOperator jSpinnerOperator, String string, Operator.StringComparator stringComparator, int n) {
            super(jSpinnerOperator, n);
            this.pattern = string;
            this.comparator = stringComparator;
        }

        public ToStringScrollAdjuster(JSpinnerOperator jSpinnerOperator, String string, int n) {
            this(jSpinnerOperator, string, jSpinnerOperator.getComparator(), n);
        }

        public boolean equals(Object object) {
            return this.comparator.equals(object.toString(), this.pattern);
        }

        public String getDescription() {
            return "Spin to \"" + this.pattern + "\" value";
        }

        public int getScrollOrientation() {
            return 1;
        }
    }

    public static class ExactScrollAdjuster
    extends ObjectScrollAdjuster {
        Object obj;

        public ExactScrollAdjuster(JSpinnerOperator jSpinnerOperator, Object object, int n) {
            super(jSpinnerOperator, n);
            this.obj = object;
        }

        public boolean equals(Object object) {
            return object.equals(this.obj);
        }

        public String getDescription() {
            return "Spin to " + this.obj.toString() + " value";
        }

        public int getScrollOrientation() {
            return 1;
        }
    }

    public static abstract class ObjectScrollAdjuster
    implements ScrollAdjuster {
        SpinnerModel model;
        int direction;

        public ObjectScrollAdjuster(JSpinnerOperator jSpinnerOperator, int n) {
            this.direction = n;
            this.model = jSpinnerOperator.getModel();
        }

        public int getScrollDirection() {
            if (this.equals(this.model.getValue())) {
                return 0;
            }
            if (this.direction == 1 && this.model.getNextValue() != null || this.direction == -1 && this.model.getPreviousValue() != null) {
                return this.direction;
            }
            return 0;
        }

        public abstract boolean equals(Object var1);

        public int getScrollOrientation() {
            return 1;
        }
    }

    public static class DateScrollAdjuster
    implements ScrollAdjuster {
        Date date;
        SpinnerDateModel model;

        public DateScrollAdjuster(JSpinnerOperator jSpinnerOperator, Date date) {
            this.date = date;
            JSpinnerOperator.checkModel(jSpinnerOperator, class$javax$swing$SpinnerDateModel == null ? (class$javax$swing$SpinnerDateModel = JSpinnerOperator.class$("javax.swing.SpinnerDateModel")) : class$javax$swing$SpinnerDateModel);
            this.model = (SpinnerDateModel)jSpinnerOperator.getModel();
        }

        public int getScrollDirection() {
            if (this.date.after(this.model.getDate())) {
                return 1;
            }
            if (this.date.before(this.model.getDate())) {
                return -1;
            }
            return 0;
        }

        public int getScrollOrientation() {
            return 1;
        }

        public String getDescription() {
            return "Spin to " + this.date.toString() + " date";
        }
    }

    public static class ListScrollAdjuster
    implements ScrollAdjuster {
        SpinnerListModel model;
        int itemIndex;
        List elements;

        private ListScrollAdjuster(JSpinnerOperator jSpinnerOperator) {
            JSpinnerOperator.checkModel(jSpinnerOperator, class$javax$swing$SpinnerListModel == null ? (class$javax$swing$SpinnerListModel = JSpinnerOperator.class$("javax.swing.SpinnerListModel")) : class$javax$swing$SpinnerListModel);
            this.model = (SpinnerListModel)jSpinnerOperator.getModel();
            this.elements = this.model.getList();
        }

        public ListScrollAdjuster(JSpinnerOperator jSpinnerOperator, Object object) {
            this(jSpinnerOperator);
            this.itemIndex = this.elements.indexOf(object);
        }

        public ListScrollAdjuster(JSpinnerOperator jSpinnerOperator, int n) {
            this(jSpinnerOperator);
            this.itemIndex = n;
        }

        public int getScrollDirection() {
            int n = this.elements.indexOf(this.model.getValue());
            if (this.itemIndex > n) {
                return 1;
            }
            if (this.itemIndex < n) {
                return -1;
            }
            return 0;
        }

        public int getScrollOrientation() {
            return 1;
        }

        public String getDescription() {
            return "Spin to " + Integer.toString(this.itemIndex) + "'th item";
        }
    }

    public static class NumberScrollAdjuster
    implements ScrollAdjuster {
        SpinnerNumberModel model;
        double value;

        public NumberScrollAdjuster(JSpinnerOperator jSpinnerOperator, double d) {
            this.value = d;
            JSpinnerOperator.checkModel(jSpinnerOperator, class$javax$swing$SpinnerNumberModel == null ? (class$javax$swing$SpinnerNumberModel = JSpinnerOperator.class$("javax.swing.SpinnerNumberModel")) : class$javax$swing$SpinnerNumberModel);
            this.model = (SpinnerNumberModel)jSpinnerOperator.getModel();
        }

        public NumberScrollAdjuster(JSpinnerOperator jSpinnerOperator, Number number) {
            this(jSpinnerOperator, number.doubleValue());
        }

        public int getScrollDirection() {
            if (this.value > this.model.getNumber().doubleValue()) {
                return 1;
            }
            if (this.value < this.model.getNumber().doubleValue()) {
                return -1;
            }
            return 0;
        }

        public int getScrollOrientation() {
            return 1;
        }

        public String getDescription() {
            return "Spin to " + this.value + " value";
        }
    }

    public static class JSpinnerFinder
    extends Operator.Finder {
        public JSpinnerFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JSpinner == null ? (class$javax$swing$JSpinner = JSpinnerOperator.class$("javax.swing.JSpinner")) : class$javax$swing$JSpinner, componentChooser);
        }

        public JSpinnerFinder() {
            super(class$javax$swing$JSpinner == null ? (class$javax$swing$JSpinner = JSpinnerOperator.class$("javax.swing.JSpinner")) : class$javax$swing$JSpinner);
        }
    }

    public static class JSpinnerByTextFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public JSpinnerByTextFinder(String string, Operator.StringComparator stringComparator) {
            this.label = string;
            this.comparator = stringComparator;
        }

        public JSpinnerByTextFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof JSpinner && ((JSpinner)component).getValue() != null) {
                return this.comparator.equals(((JSpinner)component).getValue().toString(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "JSpinner with text \"" + this.label + "\"";
        }
    }
}

