/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class JProgressBarOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String MINIMUM_DPROP = "Minimum";
    public static final String MAXIMUM_DPROP = "Maximum";
    public static final String VALUE_DPROP = "Value";
    private static long WAIT_VALUE_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    static /* synthetic */ Class class$javax$swing$JProgressBar;

    public JProgressBarOperator(JProgressBar jProgressBar) {
        super(jProgressBar);
    }

    public JProgressBarOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JProgressBar)containerOperator.waitSubComponent(new JProgressBarFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JProgressBarOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JProgressBarOperator(ContainerOperator containerOperator, int n) {
        this((JProgressBar)JProgressBarOperator.waitComponent(containerOperator, (ComponentChooser)new JProgressBarFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JProgressBarOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JProgressBar findJProgressBar(Container container, ComponentChooser componentChooser, int n) {
        return (JProgressBar)JProgressBarOperator.findComponent(container, new JProgressBarFinder(componentChooser), n);
    }

    public static JProgressBar findJProgressBar(Container container, ComponentChooser componentChooser) {
        return JProgressBarOperator.findJProgressBar(container, componentChooser, 0);
    }

    public static JProgressBar findJProgressBar(Container container, int n) {
        return JProgressBarOperator.findJProgressBar(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JProgressBar instance"), n);
    }

    public static JProgressBar findJProgressBar(Container container) {
        return JProgressBarOperator.findJProgressBar(container, 0);
    }

    public static JProgressBar waitJProgressBar(Container container, ComponentChooser componentChooser, int n) {
        return (JProgressBar)JProgressBarOperator.waitComponent(container, (ComponentChooser)new JProgressBarFinder(componentChooser), n);
    }

    public static JProgressBar waitJProgressBar(Container container, ComponentChooser componentChooser) {
        return JProgressBarOperator.waitJProgressBar(container, componentChooser, 0);
    }

    public static JProgressBar waitJProgressBar(Container container, int n) {
        return JProgressBarOperator.waitJProgressBar(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JProgressBar instance"), n);
    }

    public static JProgressBar waitJProgressBar(Container container) {
        return JProgressBarOperator.waitJProgressBar(container, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void waitValue(final ValueChooser valueChooser) {
        this.output.printLine("Wait \"" + valueChooser.getDescription() + "\" value in progressbar\n    : " + this.toStringSource());
        this.output.printGolden("Wait \"" + valueChooser.getDescription() + "\" value in progressbar");
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                return valueChooser.checkValue(((JProgressBar)JProgressBarOperator.this.getSource()).getValue()) ? "" : null;
            }

            public String getDescription() {
                return "\"" + valueChooser.getDescription() + "\" value";
            }
        });
        waiter.setTimeouts(this.timeouts.cloneThis());
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JProgressBarOperator.WaitValueTimeout"));
        waiter.setOutput(this.output.createErrorOutput());
        try {
            waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Exception during progressbar value waiting", interruptedException);
        }
    }

    public void waitValue(final int n) {
        this.output.printLine("Wait \"" + n + "\" value in progressbar\n    : " + this.toStringSource());
        this.output.printGolden("Wait \"" + n + "\" value in progressbar");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return ((JProgressBar)component).getValue() >= n;
            }

            public String getDescription() {
                return "greater then " + Integer.toString(n);
            }
        });
    }

    public void waitValue(final String string) {
        this.output.printLine("Wait \"" + string + "\" string in progressbar\n    : " + this.toStringSource());
        this.output.printGolden("Wait \"" + string + "\" string in progressbar");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JProgressBarOperator.this.getComparator().equals(((JProgressBar)component).getString(), string);
            }

            public String getDescription() {
                return "'" + string + "' string";
            }
        });
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        hashtable.put(MINIMUM_DPROP, Integer.toString(((JProgressBar)this.getSource()).getMinimum()));
        hashtable.put(MAXIMUM_DPROP, Integer.toString(((JProgressBar)this.getSource()).getMaximum()));
        hashtable.put(VALUE_DPROP, Integer.toString(((JProgressBar)this.getSource()).getValue()));
        return hashtable;
    }

    public void addChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("addChangeListener"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).addChangeListener(changeListener);
            }
        });
    }

    public int getMaximum() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximum"){

            public int map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getMaximum();
            }
        });
    }

    public int getMinimum() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimum"){

            public int map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getMinimum();
            }
        });
    }

    public BoundedRangeModel getModel() {
        return (BoundedRangeModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getModel();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getOrientation();
            }
        });
    }

    public double getPercentComplete() {
        return this.runMapping(new Operator.MapDoubleAction("getPercentComplete"){

            public double map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getPercentComplete();
            }
        });
    }

    public String getString() {
        return (String)this.runMapping(new Operator.MapAction("getString"){

            public Object map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getString();
            }
        });
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getUI();
            }
        });
    }

    public int getValue() {
        return this.runMapping(new Operator.MapIntegerAction("getValue"){

            public int map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getValue();
            }
        });
    }

    public boolean isBorderPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isBorderPainted"){

            public boolean map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).isBorderPainted();
            }
        });
    }

    public boolean isStringPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isStringPainted"){

            public boolean map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).isStringPainted();
            }
        });
    }

    public void removeChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("removeChangeListener"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).removeChangeListener(changeListener);
            }
        });
    }

    public void setBorderPainted(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setBorderPainted"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setBorderPainted(bl);
            }
        });
    }

    public void setMaximum(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMaximum"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setMaximum(n);
            }
        });
    }

    public void setMinimum(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMinimum"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setMinimum(n);
            }
        });
    }

    public void setModel(final BoundedRangeModel boundedRangeModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setModel(boundedRangeModel);
            }
        });
    }

    public void setOrientation(final int n) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setOrientation(n);
            }
        });
    }

    public void setString(final String string) {
        this.runMapping(new Operator.MapVoidAction("setString"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setString(string);
            }
        });
    }

    public void setStringPainted(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setStringPainted"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setStringPainted(bl);
            }
        });
    }

    public void setUI(final ProgressBarUI progressBarUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setUI(progressBarUI);
            }
        });
    }

    public void setValue(final int n) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setValue(n);
            }
        });
    }

    static {
        Timeouts.initDefault("JProgressBarOperator.WaitValueTimeout", WAIT_VALUE_TIMEOUT);
    }

    public static class JProgressBarFinder
    extends Operator.Finder {
        public JProgressBarFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JProgressBar == null ? (class$javax$swing$JProgressBar = JProgressBarOperator.class$("javax.swing.JProgressBar")) : class$javax$swing$JProgressBar, componentChooser);
        }

        public JProgressBarFinder() {
            super(class$javax$swing$JProgressBar == null ? (class$javax$swing$JProgressBar = JProgressBarOperator.class$("javax.swing.JProgressBar")) : class$javax$swing$JProgressBar);
        }
    }

    public static interface ValueChooser {
        public boolean checkValue(int var1);

        public String getDescription();
    }
}

