/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.DialogWaiter;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;

public class DialogOperator
extends WindowOperator {
    public static final String TITLE_DPROP = "Title";
    public static final String IS_MODAL_DPROP = "Modal";
    public static final String IS_RESIZABLE_DPROP = "Resizable";
    static /* synthetic */ Class class$java$awt$Dialog;

    public DialogOperator(Dialog dialog) {
        super(dialog);
    }

    public DialogOperator(ComponentChooser componentChooser, int n, Operator operator) {
        this(DialogOperator.waitDialog(new DialogFinder(componentChooser), n, operator.getTimeouts(), operator.getOutput()));
        this.copyEnvironment(operator);
    }

    public DialogOperator(ComponentChooser componentChooser, int n) {
        this(componentChooser, n, Operator.getEnvironmentOperator());
    }

    public DialogOperator(ComponentChooser componentChooser) {
        this(componentChooser, 0);
    }

    public DialogOperator(WindowOperator windowOperator, ComponentChooser componentChooser, int n) {
        this((Dialog)windowOperator.waitSubWindow(new DialogFinder(componentChooser), n));
        this.copyEnvironment(windowOperator);
    }

    public DialogOperator(WindowOperator windowOperator, ComponentChooser componentChooser) {
        this(windowOperator, componentChooser, 0);
    }

    public DialogOperator(WindowOperator windowOperator, String string, int n) {
        this(DialogOperator.waitDialog(windowOperator, new DialogByTitleFinder(string, windowOperator.getComparator()), n));
        this.copyEnvironment(windowOperator);
    }

    public DialogOperator(WindowOperator windowOperator, String string) {
        this(windowOperator, string, 0);
    }

    public DialogOperator(WindowOperator windowOperator, int n) {
        this(DialogOperator.waitDialog(windowOperator, new DialogFinder(), n));
        this.copyEnvironment(windowOperator);
    }

    public DialogOperator(WindowOperator windowOperator) {
        this(windowOperator, 0);
    }

    public DialogOperator(String string, int n, Operator operator) {
        this(new DialogByTitleFinder(string, operator.getComparator()), n, operator);
    }

    public DialogOperator(String string, int n) {
        this(string, n, ComponentOperator.getEnvironmentOperator());
    }

    public DialogOperator(String string) {
        this(string, 0);
    }

    public DialogOperator(int n) {
        this(DialogOperator.waitDialog(new DialogFinder(), n, ComponentOperator.getEnvironmentOperator().getTimeouts(), ComponentOperator.getEnvironmentOperator().getOutput()));
        this.copyEnvironment(ComponentOperator.getEnvironmentOperator());
    }

    public DialogOperator() {
        this(0);
    }

    public void waitTitle(String string) {
        this.getOutput().printLine("Wait \"" + string + "\" title of dialog \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + string + "\" title");
        this.waitState(new DialogByTitleFinder(string, this.getComparator()));
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        if (((Dialog)this.getSource()).getTitle() != null) {
            hashtable.put(TITLE_DPROP, ((Dialog)this.getSource()).getTitle());
        }
        hashtable.put(IS_MODAL_DPROP, ((Dialog)this.getSource()).isModal() ? "true" : "false");
        hashtable.put(IS_RESIZABLE_DPROP, ((Dialog)this.getSource()).isResizable() ? "true" : "false");
        return hashtable;
    }

    public String getTitle() {
        return (String)this.runMapping(new Operator.MapAction("getTitle"){

            public Object map() {
                return ((Dialog)DialogOperator.this.getSource()).getTitle();
            }
        });
    }

    public boolean isModal() {
        return this.runMapping(new Operator.MapBooleanAction("isModal"){

            public boolean map() {
                return ((Dialog)DialogOperator.this.getSource()).isModal();
            }
        });
    }

    public boolean isResizable() {
        return this.runMapping(new Operator.MapBooleanAction("isResizable"){

            public boolean map() {
                return ((Dialog)DialogOperator.this.getSource()).isResizable();
            }
        });
    }

    public void setModal(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setModal"){

            public void map() {
                ((Dialog)DialogOperator.this.getSource()).setModal(bl);
            }
        });
    }

    public void setResizable(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setResizable"){

            public void map() {
                ((Dialog)DialogOperator.this.getSource()).setResizable(bl);
            }
        });
    }

    public void setTitle(final String string) {
        this.runMapping(new Operator.MapVoidAction("setTitle"){

            public void map() {
                ((Dialog)DialogOperator.this.getSource()).setTitle(string);
            }
        });
    }

    protected static Dialog waitDialog(ComponentChooser componentChooser, int n, Timeouts timeouts, TestOut testOut) {
        try {
            DialogWaiter dialogWaiter = new DialogWaiter();
            dialogWaiter.setTimeouts(timeouts);
            dialogWaiter.setOutput(testOut);
            return dialogWaiter.waitDialog(new DialogFinder(componentChooser), n);
        }
        catch (InterruptedException interruptedException) {
            testOut.printStackTrace(interruptedException);
            return null;
        }
    }

    protected static Dialog waitDialog(WindowOperator windowOperator, ComponentChooser componentChooser, int n) {
        return DialogOperator.waitDialog((Window)windowOperator.getSource(), componentChooser, n, windowOperator.getTimeouts(), windowOperator.getOutput());
    }

    protected static Dialog waitDialog(Window window, ComponentChooser componentChooser, int n, Timeouts timeouts, TestOut testOut) {
        try {
            DialogWaiter dialogWaiter = new DialogWaiter();
            dialogWaiter.setTimeouts(timeouts);
            dialogWaiter.setOutput(testOut);
            return dialogWaiter.waitDialog(window, new DialogFinder(componentChooser), n);
        }
        catch (InterruptedException interruptedException) {
            JemmyProperties.getCurrentOutput().printStackTrace(interruptedException);
            return null;
        }
    }

    public static class DialogByTitleFinder
    implements ComponentChooser {
        String title;
        Operator.StringComparator comparator;

        public DialogByTitleFinder(String string, Operator.StringComparator stringComparator) {
            this.title = string;
            this.comparator = stringComparator;
        }

        public DialogByTitleFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Dialog && ((Dialog)component).isShowing() && ((Dialog)component).getTitle() != null) {
                return this.comparator.equals(((Dialog)component).getTitle(), this.title);
            }
            return false;
        }

        public String getDescription() {
            return "Dialog with title \"" + this.title + "\"";
        }
    }

    public static class DialogFinder
    extends Operator.Finder {
        public DialogFinder(ComponentChooser componentChooser) {
            super(class$java$awt$Dialog == null ? (class$java$awt$Dialog = DialogOperator.class$("java.awt.Dialog")) : class$java$awt$Dialog, componentChooser);
        }

        public DialogFinder() {
            super(class$java$awt$Dialog == null ? (class$java$awt$Dialog = DialogOperator.class$("java.awt.Dialog")) : class$java$awt$Dialog);
        }
    }
}

