/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.explorer;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;

public class TrialListenerManager
implements Outputable {
    Component comp;
    TrialMouseListener mListener;
    TrialMouseMotionListener mmListener;
    TrialKeyListener kListener;
    TestOut output;

    public TrialListenerManager(Component component) {
        this.comp = component;
        this.mListener = new TrialMouseListener();
        this.mmListener = new TrialMouseMotionListener();
        this.kListener = new TrialKeyListener();
        this.output = JemmyProperties.getCurrentOutput();
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void removeMouseListener() {
        this.comp.removeMouseListener(this.mListener);
    }

    public void addMouseListener() {
        this.removeMouseListener();
        this.comp.addMouseListener(this.mListener);
    }

    public void removeMouseMotionListener() {
        this.comp.removeMouseMotionListener(this.mmListener);
    }

    public void addMouseMotionListener() {
        this.removeMouseMotionListener();
        this.comp.addMouseMotionListener(this.mmListener);
    }

    public void removeKeyListener() {
        this.comp.removeKeyListener(this.kListener);
    }

    public void addKeyListener() {
        this.removeKeyListener();
        this.comp.addKeyListener(this.kListener);
    }

    void printEvent(final AWTEvent aWTEvent) {
        String string = (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("event.toString()"){

            public Object launch() {
                return aWTEvent.toString();
            }
        });
        this.output.printLine(string);
    }

    private class TrialKeyListener
    implements KeyListener {
        private TrialKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            TrialListenerManager.this.printEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            TrialListenerManager.this.printEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            TrialListenerManager.this.printEvent(keyEvent);
        }
    }

    private class TrialMouseMotionListener
    implements MouseMotionListener {
        private TrialMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            TrialListenerManager.this.printEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            TrialListenerManager.this.printEvent(mouseEvent);
        }
    }

    private class TrialMouseListener
    implements MouseListener {
        private TrialMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TrialListenerManager.this.printEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            TrialListenerManager.this.printEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            TrialListenerManager.this.printEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TrialListenerManager.this.printEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TrialListenerManager.this.printEvent(mouseEvent);
        }
    }
}

