/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import java.awt.Adjustable;
import java.awt.Point;
import org.netbeans.jemmy.drivers.scrolling.AWTScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ScrollPaneOperator;

public class ScrollPaneDriver
extends AWTScrollDriver {
    private static final int CLICK_OFFSET = 5;

    public ScrollPaneDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.ScrollPaneOperator"});
    }

    public void scrollToMinimum(ComponentOperator componentOperator, final int n) {
        final Adjustable adjustable = n == 0 ? ((ScrollPaneOperator)componentOperator).getHAdjustable() : ((ScrollPaneOperator)componentOperator).getVAdjustable();
        this.scroll(componentOperator, new ScrollAdjuster(){

            public int getScrollDirection() {
                return adjustable.getMinimum() < adjustable.getValue() ? -1 : 0;
            }

            public int getScrollOrientation() {
                return n;
            }

            public String getDescription() {
                return "Scroll to minimum";
            }
        });
    }

    public void scrollToMaximum(ComponentOperator componentOperator, final int n) {
        final Adjustable adjustable = n == 0 ? ((ScrollPaneOperator)componentOperator).getHAdjustable() : ((ScrollPaneOperator)componentOperator).getVAdjustable();
        this.scroll(componentOperator, new ScrollAdjuster(){

            public int getScrollDirection() {
                return adjustable.getMaximum() - adjustable.getVisibleAmount() > adjustable.getValue() ? 1 : 0;
            }

            public int getScrollOrientation() {
                return n;
            }

            public String getDescription() {
                return "Scroll to maximum";
            }
        });
    }

    protected Point getClickPoint(ComponentOperator componentOperator, int n, int n2) {
        int n3;
        int n4;
        if (n2 == 0) {
            int n5;
            int n6 = n5 = ((ScrollPaneOperator)componentOperator).isScrollbarVisible(1) ? ((ScrollPaneOperator)componentOperator).getVScrollbarWidth() : 0;
            if (n == 1) {
                n4 = componentOperator.getWidth() - 1 - 5 - n5;
            } else if (n == -1) {
                n4 = 5;
            } else {
                return null;
            }
            n3 = componentOperator.getHeight() - ((ScrollPaneOperator)componentOperator).getHScrollbarHeight() / 2;
        } else if (n2 == 1) {
            int n7;
            int n8 = n7 = ((ScrollPaneOperator)componentOperator).isScrollbarVisible(0) ? ((ScrollPaneOperator)componentOperator).getHScrollbarHeight() : 0;
            if (n == 1) {
                n3 = componentOperator.getHeight() - 1 - 5 - n7;
            } else if (n == -1) {
                n3 = 5;
            } else {
                return null;
            }
            n4 = componentOperator.getWidth() - ((ScrollPaneOperator)componentOperator).getVScrollbarWidth() / 2;
        } else {
            return null;
        }
        return new Point(n4, n3);
    }
}

