/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.input;

import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;

public class RobotDriver
extends LightSupportiveDriver {
    private boolean haveOldPos;
    private boolean smooth = false;
    private double oldX;
    private double oldY;
    private static final double CONSTANT1 = 0.75;
    private static final double CONSTANT2 = 12.0;
    protected ClassReference robotReference = null;
    protected QueueTool qtool = new QueueTool();
    protected Timeout autoDelay;

    public RobotDriver(Timeout timeout, String[] stringArray) {
        super(stringArray);
        this.qtool.setOutput(TestOut.getNullOutput());
        this.autoDelay = timeout;
    }

    public RobotDriver(Timeout timeout, String[] stringArray, boolean bl) {
        this(timeout, stringArray);
        this.smooth = bl;
    }

    public RobotDriver(Timeout timeout) {
        this(timeout, new String[]{"org.netbeans.jemmy.operators.ComponentOperator"});
    }

    public RobotDriver(Timeout timeout, boolean bl) {
        this(timeout);
        this.smooth = bl;
    }

    public void pressMouse(int n, int n2) {
        this.pressModifiers(n2);
        this.makeAnOperation("mousePress", new Object[]{new Integer(n)}, new Class[]{Integer.TYPE});
    }

    public void releaseMouse(int n, int n2) {
        this.makeAnOperation("mouseRelease", new Object[]{new Integer(n)}, new Class[]{Integer.TYPE});
        this.releaseModifiers(n2);
    }

    public void moveMouse(int n, int n2) {
        if (!this.smooth) {
            this.makeAnOperation("mouseMove", new Object[]{new Integer(n), new Integer(n2)}, new Class[]{Integer.TYPE, Integer.TYPE});
        } else {
            double d = n;
            double d2 = n2;
            if (this.haveOldPos) {
                double d3 = this.oldX;
                double d4 = this.oldY;
                double d5 = 0.0;
                double d6 = 0.0;
                while (Math.round(d3) != Math.round(d) || Math.round(d4) != Math.round(d2)) {
                    d5 = d5 * 0.75 + (d - d3) / 12.0 * 0.25;
                    d6 = d6 * 0.75 + (d2 - d4) / 12.0 * 0.25;
                    this.makeAnOperation("mouseMove", new Object[]{new Integer((int)Math.round(d3 += d5)), new Integer((int)Math.round(d4 += d6))}, new Class[]{Integer.TYPE, Integer.TYPE});
                }
            } else {
                this.makeAnOperation("mouseMove", new Object[]{new Integer((int)Math.round(d)), new Integer((int)Math.round(d2))}, new Class[]{Integer.TYPE, Integer.TYPE});
            }
            this.haveOldPos = true;
            this.oldX = d;
            this.oldY = d2;
        }
    }

    public void clickMouse(int n, int n2, int n3, int n4, int n5, Timeout timeout) {
        this.pressModifiers(n5);
        this.moveMouse(n, n2);
        this.makeAnOperation("mousePress", new Object[]{new Integer(n4)}, new Class[]{Integer.TYPE});
        for (int i = 1; i < n3; ++i) {
            this.makeAnOperation("mouseRelease", new Object[]{new Integer(n4)}, new Class[]{Integer.TYPE});
            this.makeAnOperation("mousePress", new Object[]{new Integer(n4)}, new Class[]{Integer.TYPE});
        }
        timeout.sleep();
        this.makeAnOperation("mouseRelease", new Object[]{new Integer(n4)}, new Class[]{Integer.TYPE});
        this.releaseModifiers(n5);
    }

    public void dragMouse(int n, int n2, int n3, int n4) {
        this.moveMouse(n, n2);
    }

    public void dragNDrop(int n, int n2, int n3, int n4, int n5, int n6, Timeout timeout, Timeout timeout2) {
        this.moveMouse(n, n2);
        this.pressMouse(n5, n6);
        timeout.sleep();
        this.moveMouse(n3, n4);
        timeout2.sleep();
        this.releaseMouse(n5, n6);
    }

    public void pressKey(int n, int n2) {
        this.pressModifiers(n2);
        this.makeAnOperation("keyPress", new Object[]{new Integer(n)}, new Class[]{Integer.TYPE});
    }

    public void releaseKey(int n, int n2) {
        this.releaseModifiers(n2);
        this.makeAnOperation("keyRelease", new Object[]{new Integer(n)}, new Class[]{Integer.TYPE});
    }

    protected void makeAnOperation(String string, Object[] objectArray, Class[] classArray) {
        if (this.robotReference == null) {
            this.initRobot();
        }
        try {
            this.robotReference.invokeMethod(string, objectArray, classArray);
            this.synchronizeRobot();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", invocationTargetException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", illegalStateException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", illegalAccessException);
        }
    }

    protected void synchronizeRobot() {
        RobotDriver robotDriver = this;
        if (!robotDriver.qtool.isDispatchThread() && (JemmyProperties.getCurrentDispatchingModel() & JemmyProperties.QUEUE_MODEL_MASK) != 0) {
            if (this.robotReference == null) {
                this.initRobot();
            }
            try {
                this.robotReference.invokeMethod("waitForIdle", null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void pressModifiers(int n) {
        if ((n & 1) != 0) {
            this.pressKey(16, n & 0xFFFFFFFE);
        } else if ((n & 0x20) != 0) {
            this.pressKey(65406, n & 0xFFFFFFDF);
        } else if ((n & 8) != 0) {
            this.pressKey(18, n & 0xFFFFFFF7);
        } else if ((n & 4) != 0) {
            this.pressKey(157, n & 0xFFFFFFFB);
        } else if ((n & 2) != 0) {
            this.pressKey(17, n & 0xFFFFFFFD);
        }
    }

    protected void releaseModifiers(int n) {
        if ((n & 1) != 0) {
            this.releaseKey(16, n & 0xFFFFFFFE);
        } else if ((n & 0x20) != 0) {
            this.releaseKey(65406, n & 0xFFFFFFDF);
        } else if ((n & 8) != 0) {
            this.releaseKey(18, n & 0xFFFFFFF7);
        } else if ((n & 4) != 0) {
            this.releaseKey(157, n & 0xFFFFFFFB);
        } else if ((n & 2) != 0) {
            this.releaseKey(17, n & 0xFFFFFFFD);
        }
    }

    private void initRobot() {
        RobotDriver robotDriver = this;
        if (robotDriver.qtool.isDispatchThread()) {
            this.doInitRobot();
        } else {
            this.qtool.invokeAndWait(new Runnable(){

                public void run() {
                    RobotDriver.this.doInitRobot();
                }
            });
        }
    }

    private void doInitRobot() {
        try {
            ClassReference classReference = new ClassReference("java.awt.Robot");
            this.robotReference = new ClassReference(classReference.newInstance(null, null));
            this.robotReference.invokeMethod("setAutoDelay", new Object[]{new Integer((int)(this.autoDelay != null ? this.autoDelay.getValue() : 0L))}, new Class[]{Integer.TYPE});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", invocationTargetException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", illegalStateException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new JemmyException("Exception during java.awt.Robot accessing", instantiationException);
        }
    }
}

