/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentIsNotFocusedException;
import org.netbeans.jemmy.ComponentIsNotVisibleException;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.NoComponentUnderMouseException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;

public class EventDispatcher
implements Outputable,
Timeoutable {
    private static final long WAIT_QUEUE_EMPTY_TIMEOUT = 180000L;
    private static final long ROBOT_AUTO_DELAY = 10L;
    private static final long WAIT_COMPONENT_UNDER_MOUSE_TIMEOUT = 60000L;
    private static Field[] keyFields;
    private static MotionListener motionListener;
    protected Component component;
    private TestOut output;
    private Timeouts timeouts;
    private ClassReference reference;
    private int model;
    private ClassReference robotReference = null;
    private boolean outsider = false;
    private QueueTool queueTool;

    public EventDispatcher(Component component) {
        this.component = component;
        this.reference = new ClassReference(component);
        this.queueTool = new QueueTool();
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setDispatchingModel(JemmyProperties.getProperties().getDispatchingModel());
    }

    public static void waitQueueEmpty(TestOut testOut, Timeouts timeouts) {
        QueueTool queueTool = new QueueTool();
        queueTool.setTimeouts(timeouts.cloneThis());
        queueTool.getTimeouts().setTimeout("QueueTool.WaitQueueEmptyTimeout", JemmyProperties.getCurrentTimeout("EventDispatcher.WaitQueueEmptyTimeout"));
        queueTool.setOutput(testOut);
        queueTool.waitEmpty();
    }

    public static void waitQueueEmpty() {
        EventDispatcher.waitQueueEmpty(JemmyProperties.getCurrentOutput(), JemmyProperties.getCurrentTimeouts());
    }

    public static void waitQueueEmpty(long l, TestOut testOut, Timeouts timeouts) {
        QueueTool queueTool = new QueueTool();
        queueTool.setTimeouts(timeouts.cloneThis());
        queueTool.getTimeouts().setTimeout("QueueTool.WaitQueueEmptyTimeout", JemmyProperties.getCurrentTimeout("EventDispatcher.WaitQueueEmptyTimeout"));
        queueTool.setOutput(testOut);
        queueTool.waitEmpty(l);
    }

    public static void waitQueueEmpty(long l) {
        EventDispatcher.waitQueueEmpty(l, JemmyProperties.getCurrentOutput(), JemmyProperties.getCurrentTimeouts());
    }

    public static String getModifiersString(int n) {
        String string = "";
        if ((n & 2) != 0) {
            string = string + "CTRL_MASK | ";
        }
        if ((n & 4) != 0) {
            string = string + "META_MASK | ";
        }
        if ((n & 8) != 0) {
            string = string + "ALT_MASK | ";
        }
        if ((n & 0x20) != 0) {
            string = string + "ALT_GRAPH_MASK | ";
        }
        if ((n & 1) != 0) {
            string = string + "SHIFT_MASK | ";
        }
        if (string.length() > 0) {
            return string.substring(0, string.length() - 3);
        }
        return string;
    }

    public static String getKeyDescription(int n) {
        for (int i = 0; i < keyFields.length; ++i) {
            try {
                if (!keyFields[i].getName().startsWith("VK_") || keyFields[i].getInt(null) != n) continue;
                return keyFields[i].getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                JemmyProperties.getCurrentOutput().printStackTrace(illegalAccessException);
            }
        }
        return "VK_UNKNOWN";
    }

    public static String getMouseButtonDescription(int n) {
        String string = (n & 0x10) != 0 ? "BUTTON1" : ((n & 8) != 0 ? "BUTTON2" : ((n & 4) != 0 ? "BUTTON3" : "UNKNOWN_BUTTON"));
        return string;
    }

    public void checkComponentUnderMouse(boolean bl) {
        this.outsider = !bl;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        this.queueTool.setOutput(testOut);
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        this.queueTool.setTimeouts(timeouts);
        this.queueTool.getTimeouts().setTimeout("QueueTool.WaitQueueEmptyTimeout", timeouts.getTimeout("EventDispatcher.WaitQueueEmptyTimeout"));
        if (this.robotReference != null) {
            try {
                Object[] objectArray = new Object[]{new Integer((int)timeouts.getTimeout("EventDispatcher.RobotAutoDelay"))};
                Class[] classArray = new Class[]{Integer.TYPE};
                this.robotReference.invokeMethod("setAutoDelay", objectArray, classArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.output.printStackTrace(invocationTargetException);
            }
            catch (IllegalStateException illegalStateException) {
                this.output.printStackTrace(illegalStateException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.output.printStackTrace(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.output.printStackTrace(illegalAccessException);
            }
        }
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setDispatchingModel(int n) {
        this.model = n;
        if ((this.model & JemmyProperties.ROBOT_MODEL_MASK) != 0) {
            this.createRobot();
            try {
                Object[] objectArray = new Object[]{(this.model & JemmyProperties.QUEUE_MODEL_MASK) != 0 ? Boolean.TRUE : Boolean.FALSE};
                Class[] classArray = new Class[]{Boolean.TYPE};
                this.robotReference.invokeMethod("setAutoWaitForIdle", objectArray, classArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.output.printStackTrace(invocationTargetException);
            }
            catch (IllegalStateException illegalStateException) {
                this.output.printStackTrace(illegalStateException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.output.printStackTrace(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.output.printStackTrace(illegalAccessException);
            }
        }
    }

    public int getDispatchingModel() {
        return this.model;
    }

    public void dispatchEvent(final AWTEvent aWTEvent) {
        String string = (String)this.queueTool.invokeSmoothly(new QueueTool.QueueAction("event.toString()"){

            public Object launch() {
                return aWTEvent.toString();
            }
        });
        this.output.printLine("Dispatch event " + string);
        this.output.printGolden("Dispatch event " + aWTEvent.getClass().toString());
        Dispatcher dispatcher = new Dispatcher(aWTEvent);
        this.queueTool.invokeAndWait(dispatcher);
    }

    public void dispatchMouseEvent(int n, int n2, int n3, int n4, int n5, boolean bl) {
        MouseEvent mouseEvent = new MouseEvent(this.component, n, System.currentTimeMillis(), n2, n4, n5, n3, bl);
        this.dispatchEvent(mouseEvent);
    }

    public void dispatchMouseEvent(int n, int n2, int n3, boolean bl) {
        int n4 = this.component.getWidth() / 2;
        int n5 = this.component.getHeight() / 2;
        this.dispatchMouseEvent(n, n2, n3, n4, n5, bl);
    }

    public void dispatchWindowEvent(int n) {
        WindowEvent windowEvent = new WindowEvent((Window)this.component, n);
        this.dispatchEvent(windowEvent);
    }

    public void dispatchKeyEvent(int n, int n2, int n3) {
        KeyEvent keyEvent = new KeyEvent(this.component, n, System.currentTimeMillis(), n2, n3);
        this.dispatchEvent(keyEvent);
    }

    public void dispatchKeyEvent(int n, int n2, int n3, char c) {
        KeyEvent keyEvent = new KeyEvent(this.component, n, System.currentTimeMillis(), n2, n3, c);
        this.dispatchEvent(keyEvent);
    }

    public void waitForIdle() {
        this.makeRobotOperation("waitForIdle", null, null);
    }

    protected int getAbsoluteX(int n) {
        return (int)this.component.getLocationOnScreen().getX() + n;
    }

    protected int getAbsoluteY(int n) {
        return (int)this.component.getLocationOnScreen().getY() + n;
    }

    public void delayRobot(long l) {
        Object[] objectArray = new Object[]{new Integer((int)l)};
        Class[] classArray = new Class[]{Integer.TYPE};
        this.makeRobotOperation("delay", objectArray, classArray);
    }

    public void robotMoveMouse(int n, int n2) {
        if (motionListener == null) {
            this.initMotionListener();
        }
        this.output.printLine("Move mouse to (" + Integer.toString(n) + "," + Integer.toString(n2) + ")");
        Object[] objectArray = new Object[]{new Integer(this.getAbsoluteX(n)), new Integer(this.getAbsoluteY(n2))};
        Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
        this.makeRobotOperation("mouseMove", objectArray, classArray);
    }

    public void robotPressMouse(int n, int n2) {
        if (!this.outsider) {
            this.waitMouseOver();
        }
        this.robotPressModifiers(n2);
        this.output.printLine("Press " + EventDispatcher.getMouseButtonDescription(n) + " mouse button");
        Object[] objectArray = new Object[]{new Integer(n)};
        Class[] classArray = new Class[]{Integer.TYPE};
        this.makeRobotOperation("mousePress", objectArray, classArray);
    }

    public void robotPressMouse(int n) {
        this.robotPressMouse(n, 0);
    }

    public void robotReleaseMouse(int n, int n2) {
        this.output.printLine("Release " + EventDispatcher.getMouseButtonDescription(n) + " mouse button");
        Object[] objectArray = new Object[]{new Integer(n)};
        Class[] classArray = new Class[]{Integer.TYPE};
        this.makeRobotOperation("mouseRelease", objectArray, classArray);
        this.robotReleaseModifiers(n2);
    }

    public void robotReleaseMouse(int n) {
        this.robotReleaseMouse(n, 0);
    }

    public void robotPressKey(int n, int n2) {
        this.robotPressModifiers(n2);
        this.output.printLine("Press " + EventDispatcher.getKeyDescription(n) + " key");
        Object[] objectArray = new Object[]{new Integer(n)};
        Class[] classArray = new Class[]{Integer.TYPE};
        this.makeRobotOperation("keyPress", objectArray, classArray);
    }

    public void robotPressKey(int n) {
        this.robotPressKey(n, 0);
    }

    public void robotReleaseKey(int n, int n2) {
        this.output.printLine("Release " + EventDispatcher.getKeyDescription(n) + " key");
        Object[] objectArray = new Object[]{new Integer(n)};
        Class[] classArray = new Class[]{Integer.TYPE};
        this.makeRobotOperation("keyRelease", objectArray, classArray);
        this.robotReleaseModifiers(n2);
    }

    public void robotReleaseKey(int n) {
        this.robotReleaseKey(n, 0);
    }

    public Object invokeMethod(String string, Object[] objectArray, Class[] classArray) throws InvocationTargetException, IllegalStateException, NoSuchMethodException, IllegalAccessException {
        Invoker invoker = new Invoker(string, objectArray, classArray);
        try {
            return this.queueTool.invokeAndWait(invoker);
        }
        catch (JemmyException jemmyException) {
            if (invoker.getException() != null) {
                if (invoker.getException() instanceof InvocationTargetException) {
                    throw (InvocationTargetException)invoker.getException();
                }
                if (invoker.getException() instanceof IllegalStateException) {
                    throw (IllegalStateException)invoker.getException();
                }
                if (invoker.getException() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)invoker.getException();
                }
                if (invoker.getException() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)invoker.getException();
                }
            }
            throw jemmyException;
        }
    }

    public Object getField(String string) throws InvocationTargetException, IllegalStateException, NoSuchFieldException, IllegalAccessException {
        Getter getter = new Getter(string);
        try {
            return this.queueTool.invokeAndWait(getter);
        }
        catch (JemmyException jemmyException) {
            if (getter.getException() != null) {
                if (getter.getException() instanceof InvocationTargetException) {
                    throw (InvocationTargetException)getter.getException();
                }
                if (getter.getException() instanceof IllegalStateException) {
                    throw (IllegalStateException)getter.getException();
                }
                if (getter.getException() instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)getter.getException();
                }
                if (getter.getException() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)getter.getException();
                }
            }
            throw jemmyException;
        }
    }

    public void setField(String string, Object object) throws InvocationTargetException, IllegalStateException, NoSuchFieldException, IllegalAccessException {
        Setter setter = new Setter(string, object);
        try {
            this.queueTool.invokeAndWait(setter);
        }
        catch (JemmyException jemmyException) {
            if (setter.getException() != null) {
                if (setter.getException() instanceof InvocationTargetException) {
                    throw (InvocationTargetException)setter.getException();
                }
                if (setter.getException() instanceof IllegalStateException) {
                    throw (IllegalStateException)setter.getException();
                }
                if (setter.getException() instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)setter.getException();
                }
                if (setter.getException() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)setter.getException();
                }
            }
            throw jemmyException;
        }
    }

    public Object invokeExistingMethod(String string, Object[] objectArray, Class[] classArray, TestOut testOut) {
        try {
            return this.invokeMethod(string, objectArray, classArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            testOut.printStackTrace(invocationTargetException);
        }
        catch (IllegalStateException illegalStateException) {
            testOut.printStackTrace(illegalStateException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            testOut.printStackTrace(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            testOut.printStackTrace(illegalAccessException);
        }
        return null;
    }

    public Object getExistingField(String string, TestOut testOut) {
        try {
            return this.getField(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            testOut.printStackTrace(invocationTargetException);
        }
        catch (IllegalStateException illegalStateException) {
            testOut.printStackTrace(illegalStateException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            testOut.printStackTrace(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            testOut.printStackTrace(illegalAccessException);
        }
        return null;
    }

    public void setExistingField(String string, Object object, TestOut testOut) {
        try {
            this.setField(string, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            testOut.printStackTrace(invocationTargetException);
        }
        catch (IllegalStateException illegalStateException) {
            testOut.printStackTrace(illegalStateException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            testOut.printStackTrace(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            testOut.printStackTrace(illegalAccessException);
        }
    }

    public Object invokeExistingMethod(String string, Object[] objectArray, Class[] classArray) {
        return this.invokeExistingMethod(string, objectArray, classArray, this.output);
    }

    public Object getExistingField(String string) {
        return this.getExistingField(string, this.output);
    }

    public void setExistingField(String string, Object object) {
        this.setExistingField(string, this.output);
    }

    private void robotReleaseModifiers(int n) {
        if ((n & 1) != 0) {
            this.robotReleaseKey(16, n - (1 & n));
        } else if ((n & 0x20) != 0) {
            this.robotReleaseKey(65406, n - (0x20 & n));
        } else if ((n & 8) != 0) {
            this.robotReleaseKey(18, n - (8 & n));
        } else if ((n & 4) != 0) {
            this.robotReleaseKey(157, n - (4 & n));
        } else if ((n & 2) != 0) {
            this.robotReleaseKey(17, n - (2 & n));
        }
    }

    private void checkVisibility() {
        if (!this.component.isVisible()) {
            throw new ComponentIsNotVisibleException(this.component);
        }
    }

    private void checkFocus() {
        if (!this.component.hasFocus()) {
            throw new ComponentIsNotFocusedException(this.component);
        }
    }

    private void createRobot() {
        try {
            ClassReference classReference = new ClassReference("java.awt.Robot");
            this.robotReference = new ClassReference(classReference.newInstance(null, null));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.output.printStackTrace(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            this.output.printStackTrace(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.output.printStackTrace(invocationTargetException);
        }
        catch (IllegalStateException illegalStateException) {
            this.output.printStackTrace(illegalStateException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.output.printStackTrace(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.output.printStackTrace(illegalAccessException);
        }
    }

    private void waitMouseOver() {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    if (motionListener.getComponent() != null) {
                        return "";
                    }
                    return null;
                }

                public String getDescription() {
                    return "Mouse over component";
                }
            });
            waiter.setTimeouts(this.timeouts.cloneThis());
            waiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("EventDispatcher.WaitComponentUnderMouseTimeout"));
            waiter.setOutput(this.output.createErrorOutput());
            waiter.waitAction(this.component);
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            throw new NoComponentUnderMouseException();
        }
    }

    private void makeRobotOperation(String string, Object[] objectArray, Class[] classArray) {
        try {
            this.robotReference.invokeMethod(string, objectArray, classArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.output.printStackTrace(invocationTargetException);
        }
        catch (IllegalStateException illegalStateException) {
            this.output.printStackTrace(illegalStateException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.output.printStackTrace(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.output.printStackTrace(illegalAccessException);
        }
        if ((this.model & JemmyProperties.QUEUE_MODEL_MASK) != 0) {
            try {
                EventDispatcher.waitQueueEmpty(this.output.createErrorOutput(), this.timeouts);
            }
            catch (TimeoutExpiredException timeoutExpiredException) {
                this.output.printStackTrace(timeoutExpiredException);
            }
        }
    }

    private void robotPressModifiers(int n) {
        if ((n & 1) != 0) {
            this.robotPressKey(16, n & 0xFFFFFFFE);
        } else if ((n & 0x20) != 0) {
            this.robotPressKey(65406, n & 0xFFFFFFDF);
        } else if ((n & 8) != 0) {
            this.robotPressKey(18, n & 0xFFFFFFF7);
        } else if ((n & 4) != 0) {
            this.robotPressKey(157, n & 0xFFFFFFFB);
        } else if ((n & 2) != 0) {
            this.robotPressKey(17, n & 0xFFFFFFFD);
        }
    }

    private void initMotionListener() {
        if (motionListener == null) {
            motionListener = new MotionListener();
            Toolkit.getDefaultToolkit().addAWTEventListener(motionListener, 16L);
            Object[] objectArray = new Object[2];
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            objectArray[0] = new Integer(this.getAbsoluteX(-1));
            objectArray[1] = new Integer(this.getAbsoluteX(-1));
            this.makeRobotOperation("mouseMove", objectArray, classArray);
            objectArray[0] = new Integer(this.getAbsoluteX(0));
            objectArray[1] = new Integer(this.getAbsoluteX(0));
            this.makeRobotOperation("mouseMove", objectArray, classArray);
        }
    }

    static {
        motionListener = null;
        Timeouts.initDefault("EventDispatcher.WaitQueueEmptyTimeout", 180000L);
        Timeouts.initDefault("EventDispatcher.RobotAutoDelay", 10L);
        Timeouts.initDefault("EventDispatcher.WaitComponentUnderMouseTimeout", 60000L);
        try {
            keyFields = Class.forName("java.awt.event.KeyEvent").getFields();
        }
        catch (ClassNotFoundException classNotFoundException) {
            JemmyProperties.getCurrentOutput().printStackTrace(classNotFoundException);
        }
    }

    private static class MotionListener
    implements AWTEventListener {
        private Component mouseComponent;

        private MotionListener() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (mouseEvent.getID() == 504) {
                    this.mouseComponent = mouseEvent.getComponent();
                } else if (mouseEvent.getID() == 505) {
                    this.mouseComponent = null;
                }
            }
        }

        public Component getComponent() {
            return this.mouseComponent;
        }
    }

    private class Setter
    extends QueueTool.QueueAction {
        String fieldName;
        Object newValue;

        public Setter(String string, Object object) {
            super(string + " field changing");
            this.fieldName = string;
            this.newValue = object;
        }

        public Object launch() throws InvocationTargetException, NoSuchFieldException, IllegalAccessException {
            EventDispatcher.this.reference.setField(this.fieldName, this.newValue);
            return null;
        }
    }

    private class Getter
    extends QueueTool.QueueAction {
        String fieldName;

        public Getter(String string) {
            super(string + " field receiving");
            this.fieldName = string;
        }

        public Object launch() throws InvocationTargetException, NoSuchFieldException, IllegalAccessException {
            return EventDispatcher.this.reference.getField(this.fieldName);
        }
    }

    private class Invoker
    extends QueueTool.QueueAction {
        protected String methodName;
        protected Object[] params;
        protected Class[] paramClasses;

        public Invoker(String string, Object[] objectArray, Class[] classArray) {
            super(string + " method invocation");
            this.methodName = string;
            this.params = objectArray;
            this.paramClasses = classArray;
        }

        public Object launch() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            EventDispatcher.this.checkVisibility();
            if (this.methodName.equals("keyPress") || this.methodName.equals("keyRelease")) {
                EventDispatcher.this.checkFocus();
            }
            return EventDispatcher.this.reference.invokeMethod(this.methodName, this.params, this.paramClasses);
        }
    }

    private class Dispatcher
    extends QueueTool.QueueAction {
        AWTEvent event;

        public Dispatcher(AWTEvent aWTEvent) {
            super(aWTEvent.getClass().getName() + " event dispatching");
            this.event = aWTEvent;
        }

        public Object launch() {
            if (this.event instanceof MouseEvent || this.event instanceof KeyEvent) {
                EventDispatcher.this.checkVisibility();
            }
            EventDispatcher.this.component.dispatchEvent(this.event);
            return null;
        }
    }
}

