/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;

public class DialogWaiter
extends WindowWaiter
implements Timeoutable,
Outputable {
    private static final long WAIT_TIME = 60000L;
    private static final long AFTER_WAIT_TIME = 0L;
    private Timeouts timeouts;
    private TestOut output;

    public DialogWaiter() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public static Dialog getDialog(ComponentChooser componentChooser) {
        return (Dialog)WindowWaiter.getWindow(new DialogSubChooser(componentChooser));
    }

    public static Dialog getDialog(ComponentChooser componentChooser, int n) {
        return (Dialog)WindowWaiter.getWindow(new DialogSubChooser(componentChooser), n);
    }

    public static Dialog getDialog(String string, boolean bl, boolean bl2) {
        return (Dialog)WindowWaiter.getWindow(new DialogByTitleChooser(string, bl, bl2));
    }

    public static Dialog getDialog(String string, boolean bl, boolean bl2, int n) {
        return DialogWaiter.getDialog(new DialogByTitleChooser(string, bl, bl2), n);
    }

    public static Dialog getDialog(Window window, ComponentChooser componentChooser) {
        return (Dialog)WindowWaiter.getWindow(window, new DialogSubChooser(componentChooser));
    }

    public static Dialog getDialog(Window window, ComponentChooser componentChooser, int n) {
        return (Dialog)WindowWaiter.getWindow(window, new DialogSubChooser(componentChooser), n);
    }

    public static Dialog getDialog(Window window, String string, boolean bl, boolean bl2) {
        return (Dialog)WindowWaiter.getWindow(window, new DialogByTitleChooser(string, bl, bl2));
    }

    public static Dialog getDialog(Window window, String string, boolean bl, boolean bl2, int n) {
        return DialogWaiter.getDialog(window, new DialogByTitleChooser(string, bl, bl2), n);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts timeouts2 = timeouts.cloneThis();
        timeouts2.setTimeout("WindowWaiter.WaitWindowTimeout", timeouts.getTimeout("DialogWaiter.WaitDialogTimeout"));
        timeouts2.setTimeout("WindowWaiter.AfterWindowTimeout", timeouts.getTimeout("DialogWaiter.AfterDialogTimeout"));
        super.setTimeouts(timeouts2);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(testOut);
    }

    public TestOut getOutput() {
        return this.output;
    }

    public Dialog waitDialog(ComponentChooser componentChooser, int n) throws InterruptedException {
        this.setTimeouts(this.timeouts);
        return (Dialog)this.waitWindow(new DialogSubChooser(componentChooser), n);
    }

    public Dialog waitDialog(ComponentChooser componentChooser) throws InterruptedException {
        return this.waitDialog(componentChooser, 0);
    }

    public Dialog waitDialog(String string, boolean bl, boolean bl2, int n) throws InterruptedException {
        return this.waitDialog(new DialogByTitleChooser(string, bl, bl2), n);
    }

    public Dialog waitDialog(String string, boolean bl, boolean bl2) throws InterruptedException {
        return this.waitDialog(string, bl, bl2, 0);
    }

    public Dialog waitDialog(Window window, ComponentChooser componentChooser, int n) throws InterruptedException {
        this.setTimeouts(this.timeouts);
        return (Dialog)this.waitWindow(window, new DialogSubChooser(componentChooser), n);
    }

    public Dialog waitDialog(Window window, ComponentChooser componentChooser) throws InterruptedException {
        return this.waitDialog(window, componentChooser, 0);
    }

    public Dialog waitDialog(Window window, String string, boolean bl, boolean bl2, int n) throws InterruptedException {
        return this.waitDialog(window, new DialogByTitleChooser(string, bl, bl2), n);
    }

    public Dialog waitDialog(Window window, String string, boolean bl, boolean bl2) throws InterruptedException {
        return this.waitDialog(window, string, bl, bl2, 0);
    }

    protected String getWaitingStartedMessage() {
        return "Start to wait dialog \"" + this.getComponentChooser().getDescription() + "\" opened";
    }

    protected String getTimeoutExpiredMessage(long l) {
        return "Dialog \"" + this.getComponentChooser().getDescription() + "\" has not been opened in " + new Long(l).toString() + " milliseconds";
    }

    protected String getActionProducedMessage(long l, final Object object) {
        String string = object instanceof Component ? (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

            public Object launch() {
                return object.toString();
            }
        }) : object.toString();
        return "Dialog \"" + this.getComponentChooser().getDescription() + "\" has been opened in " + new Long(l).toString() + " milliseconds" + "\n    " + string;
    }

    protected String getGoldenWaitingStartedMessage() {
        return "Start to wait dialog \"" + this.getComponentChooser().getDescription() + "\" opened";
    }

    protected String getGoldenTimeoutExpiredMessage() {
        return "Dialog \"" + this.getComponentChooser().getDescription() + "\" has not been opened";
    }

    protected String getGoldenActionProducedMessage() {
        return "Dialog \"" + this.getComponentChooser().getDescription() + "\" has been opened";
    }

    private Dialog waitDialog() throws InterruptedException {
        return (Dialog)this.waitAction("");
    }

    static {
        Timeouts.initDefault("DialogWaiter.WaitDialogTimeout", 60000L);
        Timeouts.initDefault("DialogWaiter.AfterDialogTimeout", 0L);
    }

    private static class DialogByTitleChooser
    implements ComponentChooser {
        String title;
        boolean compareExactly;
        boolean compareCaseSensitive;

        public DialogByTitleChooser(String string, boolean bl, boolean bl2) {
            this.title = string;
            this.compareExactly = bl;
            this.compareCaseSensitive = bl2;
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Dialog && ((Dialog)component).isShowing() && component.isVisible() && ((Dialog)component).getTitle() != null) {
                String string = ((Dialog)component).getTitle();
                String string2 = this.title;
                if (this.compareCaseSensitive) {
                    string = string.toUpperCase();
                    string2 = string2.toUpperCase();
                }
                if (this.compareExactly) {
                    return string.equals(string2);
                }
                return string.indexOf(string2) != -1;
            }
            return false;
        }

        public String getDescription() {
            return this.title;
        }
    }

    private static class DialogSubChooser
    implements ComponentChooser {
        private ComponentChooser chooser;

        public DialogSubChooser(ComponentChooser componentChooser) {
            this.chooser = componentChooser;
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Dialog) {
                return component.isShowing() && component.isVisible() && this.chooser.checkComponent(component);
            }
            return false;
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }
}

