/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.jemmy.CharBindingMap;
import org.netbeans.jemmy.ClassReference;

public class DefaultCharBindingMap
implements CharBindingMap {
    private Hashtable chars;
    private ClassReference cl;

    public DefaultCharBindingMap() {
        try {
            this.cl = new ClassReference("java.awt.event.KeyEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.initMap();
    }

    public int getCharKey(char c) {
        return this.getKeyAndModifiers(c)[0];
    }

    public int getCharModifiers(char c) {
        return this.getKeyAndModifiers(c)[1];
    }

    public int[] getKeyAndModifiers(char c) {
        CharKey charKey = (CharKey)this.chars.get(new Character(c));
        if (charKey != null) {
            return new int[]{charKey.key, charKey.modifiers};
        }
        return new int[]{0, 0};
    }

    public char[] getSupportedChars() {
        char[] cArray = new char[this.chars.size()];
        Enumeration enumeration = this.chars.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            cArray[n] = ((Character)enumeration.nextElement()).charValue();
        }
        return cArray;
    }

    public void removeChar(char c) {
        this.chars.remove(new Character(c));
    }

    public void addChar(char c, int n, int n2) {
        this.chars.put(new Character(c), new CharKey(n, n2));
    }

    private void initMap() {
        this.chars = new Hashtable();
        Field[] fieldArray = KeyEvent.class.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if ((fieldArray[i].getModifiers() & 1) == 0 || (fieldArray[i].getModifiers() & 8) == 0 || fieldArray[i].getType() != Integer.TYPE || !string.startsWith("VK_") || string.length() != 4) continue;
            String string2 = string.substring(3, 4);
            try {
                int n = fieldArray[i].getInt(null);
                this.addChar(string2.toLowerCase().charAt(0), n, 0);
                if (string2.toUpperCase().equals(string2.toLowerCase())) continue;
                this.addChar(string2.toUpperCase().charAt(0), n, 1);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.addChar('\t', 9, 0);
        this.addChar(' ', 32, 0);
        this.addChar('!', 49, 1);
        this.addChar('\"', 222, 1);
        this.addChar('#', 51, 1);
        this.addChar('$', 52, 1);
        this.addChar('%', 53, 1);
        this.addChar('&', 55, 1);
        this.addChar('\'', 222, 0);
        this.addChar('(', 57, 1);
        this.addChar(')', 48, 1);
        this.addChar('*', 56, 1);
        this.addChar('+', 61, 1);
        this.addChar(',', 44, 0);
        this.addChar('-', 45, 0);
        this.addChar('.', 46, 0);
        this.addChar('/', 47, 0);
        this.addChar(':', 59, 1);
        this.addChar(';', 59, 0);
        this.addChar('<', 44, 1);
        this.addChar('=', 61, 0);
        this.addChar('>', 46, 1);
        this.addChar('?', 47, 1);
        this.addChar('@', 50, 1);
        this.addChar('[', 91, 0);
        this.addChar('\\', 92, 0);
        this.addChar(']', 93, 0);
        this.addChar('^', 54, 1);
        this.addChar('_', 45, 1);
        this.addChar('`', 192, 0);
        this.addChar('{', 91, 1);
        this.addChar('|', 92, 1);
        this.addChar('}', 93, 1);
        this.addChar('~', 192, 1);
        this.addChar('\n', 10, 0);
    }

    private static class CharKey {
        public int key;
        public int modifiers;

        public CharKey(int n, int n2) {
            this.key = n;
            this.modifiers = n2;
        }
    }
}

