/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.test.ui.DiffStreamSource;
import org.netbeans.modules.compapp.test.ui.DiffTopComponent;
import org.netbeans.modules.compapp.test.ui.PropertyFileWrapper;
import org.netbeans.modules.compapp.test.ui.PropertySpec;
import org.netbeans.modules.compapp.test.ui.TestCaseResultNode;
import org.netbeans.modules.compapp.test.ui.TestcaseChildren;
import org.netbeans.modules.compapp.test.ui.actions.TestCaseDebugAction;
import org.netbeans.modules.compapp.test.ui.actions.TestCaseResultsDeleteAction;
import org.netbeans.modules.compapp.test.ui.actions.TestCaseRunAction;
import org.netbeans.modules.compapp.test.ui.actions.TestcaseCookie;
import org.netbeans.modules.compapp.test.ui.actions.TestcaseDiffAction;
import org.netbeans.modules.compapp.test.util.FileNodeUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestcaseNode
extends FilterNode {
    private static final Logger mLogger = Logger.getLogger("org.netbeans.modules.compapp.projects.jbi.ui.TestcaseNode");
    private static Image WARNING_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/compapp/test/ui/resources/warningBadge.gif", (boolean)true);
    private static Image TEST_CASE_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/compapp/test/ui/resources/testCase.png", (boolean)true);
    public static final String ACTUAL_OUTPUT_REGEX = "^Actual_\\d{14}(_[FS])?.xml$";
    public static final String SUCCESSFUL_ACTUAL_OUTPUT_REGEX = "^Actual_\\d{14}_S.xml$";
    public static final String FAILED_ACTUAL_OUTPUT_REGEX = "^Actual_\\d{14}(_F)?.xml$";
    private PropertyFileWrapper mPropertyFileWrapper;
    private FileObject mTestcaseDir;
    private FileObject mPropertyFile;
    private TestcaseCookie mTestcaseCookie;
    private DiffTopComponent mDiffTopComponent;
    private JbiProject mProject;
    private FileChangeListener mFileChangeListener;
    private FileChangeListener mTestDirChangeListener;
    private FileChangeListener mTestResultsDirChangeListener;
    private FileChangeListener mTestCaseResultsDirChangeListener;
    private TestcaseChildren mChildren;
    private FileObject mTestDir;
    private FileObject mTestResultsDir;
    private FileObject mTestCaseResultsDir;
    private static Set<FileObject> runningTestCases = new HashSet<FileObject>();

    public TestcaseNode(JbiProject jbiProject, FileObject fileObject) {
        super(DataFolder.findFolder((FileObject)fileObject).getNodeDelegate(), (Children)new TestcaseChildren(jbiProject, fileObject));
        this.mTestcaseDir = fileObject;
        this.mProject = jbiProject;
        this.registerPropertyFileChangeListener(fileObject);
        this.mTestcaseCookie = new TestcaseCookie(this);
        final String string = this.mTestcaseDir.getName();
        this.mFileChangeListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fileEvent) {
                TestcaseNode.this.checkOutputChange(fileEvent.getFile());
                TestcaseNode.this.update();
            }

            public void fileDataCreated(FileEvent fileEvent) {
                TestcaseNode.this.checkOutputChange(fileEvent.getFile());
                TestcaseNode.this.update();
            }

            public void fileDeleted(FileEvent fileEvent) {
                TestcaseNode.this.checkOutputChange(fileEvent.getFile());
                TestcaseNode.this.update();
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                TestcaseNode.this.checkOutputChange(fileRenameEvent.getFile());
                TestcaseNode.this.update();
            }
        };
        this.getFileObject().addFileChangeListener(this.mFileChangeListener);
        this.mTestDir = this.mProject.getTestDirectory();
        this.mTestDirChangeListener = new FileChangeAdapter(){

            public void fileFolderCreated(FileEvent fileEvent) {
                FileObject fileObject;
                FileObject fileObject2 = fileEvent.getFile();
                if (fileObject2.getName().equals("results")) {
                    TestcaseNode.this.mTestResultsDir = fileObject2;
                    TestcaseNode.this.mTestResultsDir.addFileChangeListener(TestcaseNode.this.mTestResultsDirChangeListener);
                }
                if ((fileObject = fileObject2.getFileObject(string)) != null) {
                    fileObject.addFileChangeListener(TestcaseNode.this.mTestCaseResultsDirChangeListener);
                }
                TestcaseNode.this.update();
            }

            public void fileDeleted(FileEvent fileEvent) {
                FileObject fileObject = fileEvent.getFile();
                if (fileObject.getName().equals("results")) {
                    fileObject.removeFileChangeListener(TestcaseNode.this.mTestResultsDirChangeListener);
                }
                TestcaseNode.this.update();
            }
        };
        this.mTestDir.addFileChangeListener(this.mTestDirChangeListener);
        this.mTestResultsDirChangeListener = new FileChangeAdapter(){

            public void fileFolderCreated(FileEvent fileEvent) {
                FileObject fileObject = fileEvent.getFile();
                if (fileObject.getName().equals(string)) {
                    TestcaseNode.this.mTestCaseResultsDir = fileObject;
                    TestcaseNode.this.mTestCaseResultsDir.addFileChangeListener(TestcaseNode.this.mTestCaseResultsDirChangeListener);
                }
                TestcaseNode.this.update();
            }

            public void fileDeleted(FileEvent fileEvent) {
                FileObject fileObject = fileEvent.getFile();
                if (fileObject.getName().equals(string)) {
                    fileObject.removeFileChangeListener(TestcaseNode.this.mTestCaseResultsDirChangeListener);
                }
                TestcaseNode.this.update();
            }
        };
        this.mTestResultsDir = this.mProject.getTestResultsDirectory();
        if (this.mTestResultsDir != null) {
            this.mTestResultsDir.addFileChangeListener(this.mTestResultsDirChangeListener);
        }
        this.mTestCaseResultsDirChangeListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fileEvent) {
                TestcaseNode.this.update();
                this.doFirstResultCheck(fileEvent.getFile());
            }

            public void fileDeleted(FileEvent fileEvent) {
                TestcaseNode.this.update();
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                TestcaseNode.this.update();
            }

            private void doFirstResultCheck(FileObject fileObject) {
                FileObject fileObject2 = TestcaseNode.this.getOutputFile();
                if (fileObject2 == null) {
                    return;
                }
                File file = FileUtil.toFile((FileObject)fileObject2);
                if (file.length() == 0L && fileObject.getNameExt().matches(TestcaseNode.ACTUAL_OUTPUT_REGEX) && FileUtil.toFile((FileObject)fileObject).length() != 0L) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TestcaseNode.class, (String)"MSG_OverwriteEmptyOutput"), NbBundle.getMessage(TestcaseNode.class, (String)"TTL_OverwriteEmptyOutput"), 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION) {
                        try {
                            FileNodeUtil.overwriteFile(fileObject, fileObject2);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)iOException.getMessage(), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                    }
                }
            }
        };
        if (this.mTestResultsDir != null) {
            this.mTestCaseResultsDir = this.mTestResultsDir.getFileObject(string);
            if (this.mTestCaseResultsDir != null) {
                this.mTestCaseResultsDir.addFileChangeListener(this.mTestCaseResultsDirChangeListener);
            }
        }
        this.mChildren = (TestcaseChildren)this.getChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        String string2 = this.getName();
        super.setName(string);
        if (this.getName().equals(string)) {
            if (this.mTestResultsDir == null) {
                return;
            }
            if (this.mTestCaseResultsDir == null) {
                this.mTestCaseResultsDir = this.mTestResultsDir.getFileObject(string2);
                if (this.mTestCaseResultsDir != null) {
                    this.mTestCaseResultsDir.removeFileChangeListener(this.mTestCaseResultsDirChangeListener);
                    this.mTestCaseResultsDir.addFileChangeListener(this.mTestCaseResultsDirChangeListener);
                }
            }
            if (this.mTestCaseResultsDir != null) {
                FileLock fileLock = null;
                try {
                    fileLock = this.mTestCaseResultsDir.lock();
                    this.mTestCaseResultsDir.rename(fileLock, string, null);
                }
                catch (IOException iOException) {
                    super.setName(string2);
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)iOException.getMessage(), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }
    }

    private void registerPropertyFileChangeListener(FileObject fileObject) {
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        arrayList.add(PropertySpec.DESCRIPTION);
        arrayList.add(PropertySpec.DESTINATION);
        arrayList.add(PropertySpec.SOAP_ACTION);
        arrayList.add(PropertySpec.INPUT_FILE);
        arrayList.add(PropertySpec.OUTPUT_FILE);
        arrayList.add(PropertySpec.CONCURRENT_THREADS);
        arrayList.add(PropertySpec.INVOKES_PER_THREAD);
        arrayList.add(PropertySpec.TEST_TIMEOUT);
        arrayList.add(PropertySpec.CALCULATE_THROUGHPUT);
        arrayList.add(PropertySpec.COMPARISON_TYPE);
        arrayList.add(PropertySpec.FEATURE_STATUS);
        this.mPropertyFile = fileObject.getFileObject("Invoke.properties");
        if (this.mPropertyFile == null) {
            this.mPropertyFile = fileObject.getFileObject("Concurrent.properties");
        }
        if (this.mPropertyFile == null) {
            this.mPropertyFile = fileObject.getFileObject("Correlation.properties");
        }
        this.mPropertyFileWrapper = new PropertyFileWrapper(this.mPropertyFile, arrayList);
        this.mPropertyFile.addFileChangeListener((FileChangeListener)new PropertyFileChangeListener());
    }

    private void update() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TestcaseNode.this.updateChildren();
            }
        });
    }

    private FileObject getFileObject() {
        DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
        return dataObject.getPrimaryFile();
    }

    private void updateChildren() {
        if (this.mChildren != null) {
            this.mChildren.addNotify();
        }
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == TestcaseCookie.class) {
            return this.mTestcaseCookie;
        }
        return super.getCookie(clazz);
    }

    public JbiProject getProject() {
        return this.mProject;
    }

    public FileObject getTestCaseDir() {
        return this.mTestcaseDir;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        arrayList.add(SystemAction.get(TestCaseRunAction.class));
        arrayList.add(SystemAction.get(TestCaseDebugAction.class));
        arrayList.add(null);
        arrayList.add(SystemAction.get(TestcaseDiffAction.class));
        arrayList.add(null);
        arrayList.add(SystemAction.get(RenameAction.class));
        arrayList.add(SystemAction.get(DeleteAction.class));
        arrayList.add(SystemAction.get(TestCaseResultsDeleteAction.class));
        arrayList.add(null);
        arrayList.add(SystemAction.get(PropertiesAction.class));
        return arrayList.toArray(new Action[0]);
    }

    public void destroy() throws IOException {
        FileObject fileObject;
        super.destroy();
        if (this.isDiffTopComponentVisible()) {
            this.closeDiffTopComponent();
            this.releaseDiffTopComponent();
        }
        if ((fileObject = this.getResultFileLocation()) != null) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public Node.PropertySet[] getPropertySets() {
        return this.mPropertyFileWrapper.getSheet().toArray();
    }

    public FileObject getOutputFile() {
        return this.getOutputFile(false);
    }

    public FileObject getOutputFile(boolean bl) {
        FileObject fileObject = this.getTestCaseDir();
        FileObject fileObject2 = fileObject.getFileObject("Output.xml");
        if (fileObject2 == null) {
            try {
                fileObject2 = fileObject.createData("Output.xml");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return fileObject2;
    }

    private FileObject getResultFileLocation() {
        String string;
        FileObject fileObject = null;
        FileObject fileObject2 = this.mProject.getTestResultsDirectory();
        if (fileObject2 != null && (fileObject = fileObject2.getFileObject(string = this.mTestcaseDir.getName())) == null) {
            try {
                fileObject = fileObject2.createFolder(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return fileObject;
    }

    public List<String> getSortedResultFileNameList(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileObject fileObject = this.getResultFileLocation();
        if (fileObject != null) {
            FileObject[] fileObjectArray = this.getResultFileLocation().getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string = fileObjectArray[i].getNameExt();
                if ((!bl || !string.matches(FAILED_ACTUAL_OUTPUT_REGEX)) && (bl || !string.matches(ACTUAL_OUTPUT_REGEX))) continue;
                arrayList.add(string);
            }
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public FileObject getLatestResultFileObject() {
        FileObject fileObject = null;
        List<String> list = this.getSortedResultFileNameList(false);
        int n = list.size();
        if (n > 0) {
            String string = list.get(n - 1);
            FileObject fileObject2 = this.getResultFileLocation();
            fileObject = fileObject2.getFileObject(string);
        }
        return fileObject;
    }

    public void showDiffTopComponentVisible() {
        if (this.mDiffTopComponent == null) {
            this.mDiffTopComponent = new DiffTopComponent(this);
        } else {
            this.mDiffTopComponent.refreshView(true, true);
        }
        this.mDiffTopComponent.open();
        this.mDiffTopComponent.requestActive();
    }

    public void showDiffTopComponentVisible(String string) {
        if (this.mDiffTopComponent == null) {
            this.mDiffTopComponent = new DiffTopComponent(this);
        }
        this.mDiffTopComponent.refreshView(true, string);
        this.mDiffTopComponent.open();
        this.mDiffTopComponent.requestActive();
    }

    public void closeDiffTopComponent() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.mDiffTopComponent.close();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TestcaseNode.this.mDiffTopComponent.close();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public boolean isDiffTopComponentVisible() {
        return this.mDiffTopComponent != null;
    }

    public void refreshDiffTopComponent() {
        if (this.mDiffTopComponent != null) {
            this.mDiffTopComponent.refreshView(true, true);
        }
    }

    public void releaseDiffTopComponent() {
        this.mDiffTopComponent = null;
    }

    public StreamSource getActualStreamSource(String string) {
        FileObject fileObject = this.getResultFileLocation().getFileObject(string);
        File file = null;
        if (fileObject != null) {
            file = FileUtil.toFile((FileObject)fileObject);
        }
        return new DiffStreamSource(string, TestCaseResultNode.getActualResultTimeStamp(string), file);
    }

    public StreamSource getExpectedStreamSource() {
        FileObject fileObject = this.mTestcaseDir.getFileObject("Output.xml");
        File file = FileUtil.toFile((FileObject)fileObject);
        return new DiffStreamSource("Output.xml", ResourceBundle.getBundle("org/netbeans/modules/compapp/test/ui/Bundle").getString("Expected_Output"), file);
    }

    public boolean isTestCaseRunning() {
        return TestcaseNode.isTestCaseRunning(this.mTestcaseDir);
    }

    public void setTestCaseRunning(boolean bl) {
        TestcaseNode.setTestCaseRunning(this.mTestcaseDir, bl);
    }

    public static boolean isTestCaseRunning(FileObject fileObject) {
        return runningTestCases.contains(fileObject);
    }

    public static void setTestCaseRunning(FileObject fileObject, boolean bl) {
        if (bl) {
            runningTestCases.add(fileObject);
        } else {
            runningTestCases.remove(fileObject);
        }
    }

    public PasteType[] getPasteTypes(Transferable transferable) {
        return new PasteType[0];
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return null;
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    public void deleteResults() {
        FileObject fileObject;
        if (this.isDiffTopComponentVisible()) {
            this.closeDiffTopComponent();
            this.releaseDiffTopComponent();
        }
        if ((fileObject = this.getResultFileLocation()) != null) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private Image computeIcon(boolean bl, int n) {
        FileObject fileObject = this.mTestcaseDir.getFileObject("Output.xml");
        Image image = TEST_CASE_ICON;
        File file = null;
        if (fileObject != null) {
            file = FileUtil.toFile((FileObject)fileObject);
        }
        if (file != null && file.length() > 0L) {
            this.setShortDescription(this.getName());
            return image;
        }
        this.setShortDescription(NbBundle.getMessage(TestcaseNode.class, (String)"HINT_WARNING_BADGE"));
        return ImageUtilities.mergeImages((Image)image, (Image)WARNING_BADGE, (int)15, (int)8);
    }

    private void checkOutputChange(FileObject fileObject) {
        if (fileObject != null && fileObject.getNameExt().equals("Output.xml")) {
            this.fireIconChange();
        }
    }

    class PropertyFileChangeListener
    extends FileChangeAdapter {
        PropertyFileChangeListener() {
        }

        public void fileChanged(FileEvent fileEvent) {
            TestcaseNode.this.mPropertyFileWrapper.loadProperties();
            TestcaseNode.this.firePropertyChange(null, null, null);
        }
    }
}

