/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.test.ui.TestChildren;
import org.netbeans.modules.compapp.test.ui.actions.AddTestcaseAction;
import org.netbeans.modules.compapp.test.ui.actions.TestCookie;
import org.netbeans.modules.compapp.test.ui.actions.TestResultsDeleteAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class TestNode
extends FilterNode {
    private static final Logger mLogger = Logger.getLogger("org.netbeans.modules.compapp.projects.jbi.ui.TestNode");
    private static Image JBI_TEST_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/compapp/test/ui/resources/testCases_badge.png", (boolean)true);
    private JbiProject mProject;
    private FileObject mTestDir;
    private TestChildren mChildren;
    private FileChangeListener mFileChangeListener;
    private TestCookie mTestCookie;
    private boolean testRunning = false;

    public TestNode(JbiProjectProperties jbiProjectProperties, JbiProject jbiProject) {
        super(TestNode.getTestFolder(jbiProjectProperties, jbiProject).getNodeDelegate(), (Children)new TestChildren(jbiProject, TestNode.getTestDir(jbiProjectProperties, jbiProject)));
        this.mProject = jbiProject;
        this.mFileChangeListener = new FileChangeAdapter(){

            private void update() {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            TestNode.this.updateChildren();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }

            public void fileFolderCreated(FileEvent fileEvent) {
                this.update();
            }

            public void fileDeleted(FileEvent fileEvent) {
                this.update();
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                this.update();
            }
        };
        this.mTestDir = TestNode.getTestDir(jbiProjectProperties, jbiProject);
        this.mTestDir.addFileChangeListener(this.mFileChangeListener);
        this.mChildren = (TestChildren)this.getChildren();
        this.mTestCookie = new TestCookie(this);
    }

    private void updateChildren() {
        if (this.mChildren != null) {
            this.mChildren.addNotify();
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TestNode.class, (String)"LBL_TestNode");
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    private Image computeIcon(boolean bl, int n) {
        DataFolder dataFolder = TestNode.getProjectFolder(this.mProject);
        Node node = dataFolder.getNodeDelegate();
        Image image = bl ? node.getOpenedIcon(n) : node.getIcon(n);
        return ImageUtilities.mergeImages((Image)image, (Image)JBI_TEST_BADGE, (int)7, (int)7);
    }

    public Action[] getActions(boolean bl) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        arrayList.add(SystemAction.get(AddTestcaseAction.class));
        arrayList.add(null);
        arrayList.add(SystemAction.get(TestResultsDeleteAction.class));
        return arrayList.toArray(new Action[0]);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == TestCookie.class) {
            return this.mTestCookie;
        }
        return super.getCookie(clazz);
    }

    public FileChangeListener getFileChangeListener() {
        return this.mFileChangeListener;
    }

    public JbiProject getProject() {
        return this.mProject;
    }

    public FileObject getTestDir() {
        return this.mTestDir;
    }

    public boolean isTestRunning() {
        return this.testRunning;
    }

    public void setTestRunning(boolean bl) {
        this.testRunning = bl;
    }

    private static DataFolder getProjectFolder(JbiProject jbiProject) {
        DataFolder dataFolder = null;
        FileObject fileObject = jbiProject.getProjectDirectory();
        if (fileObject.isFolder()) {
            dataFolder = DataFolder.findFolder((FileObject)fileObject);
        }
        return dataFolder;
    }

    private static DataFolder getTestFolder(JbiProjectProperties jbiProjectProperties, JbiProject jbiProject) {
        DataFolder dataFolder = null;
        FileObject fileObject = TestNode.getTestDir(jbiProjectProperties, jbiProject);
        if (fileObject.isFolder()) {
            dataFolder = DataFolder.findFolder((FileObject)fileObject);
        }
        return dataFolder;
    }

    private static FileObject getTestDir(JbiProjectProperties jbiProjectProperties, JbiProject jbiProject) {
        FileObject fileObject = null;
        FileObject fileObject2 = jbiProject.getProjectDirectory();
        Object object = jbiProjectProperties.get("test.dir");
        fileObject = fileObject2.getFileObject((String)object);
        return fileObject;
    }
}

