/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.awt.Image;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.test.ui.TestCaseInputNode;
import org.netbeans.modules.compapp.test.ui.actions.TestCaseOutputCookie;
import org.netbeans.modules.compapp.test.ui.actions.TestCaseSaveRecentResultAsOutputAction;
import org.openide.actions.EditAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class TestCaseOutputNode
extends FilterNode {
    private static final Logger mLogger = Logger.getLogger("org.netbeans.modules.compapp.projects.jbi.ui.TestCaseOutputNode");
    private static final Image OUTPUT_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/compapp/test/ui/resources/output.png", (boolean)true);
    private static final Image WARNING_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/compapp/test/ui/resources/warningBadge.gif", (boolean)true);
    private JbiProject mProject;
    private FileObject mOutputFile;
    private FileChangeListener mFileChangeListener;
    private TestCaseOutputCookie mTestCaseOutputCookie;

    public TestCaseOutputNode(JbiProject jbiProject, DataObject dataObject) {
        super(dataObject.getNodeDelegate(), FilterNode.Children.LEAF);
        this.mProject = jbiProject;
        this.mOutputFile = dataObject.getPrimaryFile();
        this.mFileChangeListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fileEvent) {
                TestCaseOutputNode.this.fireIconChange();
            }
        };
        this.mOutputFile.addFileChangeListener(this.mFileChangeListener);
        this.mTestCaseOutputCookie = new TestCaseOutputCookie(this);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TestCaseInputNode.class, (String)"LBL_TestOutputNode");
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    private Image computeIcon(boolean bl, int n) {
        Image image = OUTPUT_ICON;
        File file = FileUtil.toFile((FileObject)this.mOutputFile);
        if (file.length() == 0L) {
            return ImageUtilities.mergeImages((Image)image, (Image)WARNING_BADGE, (int)15, (int)8);
        }
        return image;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(EditAction.class), SystemAction.get(TestCaseSaveRecentResultAsOutputAction.class)};
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == TestCaseOutputCookie.class) {
            return this.mTestCaseOutputCookie;
        }
        return super.getCookie(clazz);
    }
}

