/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.compapp.test.ui.TestcaseNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DiffStreamSource
extends org.netbeans.api.diff.StreamSource {
    private static final Logger mLogger = Logger.getLogger("org.netbeans.modules.compapp.projects.jbi.ui.DiffStreamSource");
    private File mFile;
    private String mName;
    private String mTitle;
    private String mMimeType;

    public DiffStreamSource(String string, String string2, File file) {
        this.mFile = file;
        this.mName = string;
        this.mTitle = string2;
    }

    public String getName() {
        return this.mName;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getMIMEType() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            return null;
        }
        return this.mMimeType;
    }

    public Reader createReader() throws IOException {
        this.init();
        if (this.mFile == null || !this.mFile.exists()) {
            return null;
        }
        try {
            StreamSource streamSource = new StreamSource(this.mFile);
            String string = this.getXMLEncoding(this.mFile);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", string);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.transform(streamSource, new StreamResult(byteArrayOutputStream));
            return new InputStreamReader((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string);
        }
        catch (Exception exception) {
            mLogger.log(Level.SEVERE, NbBundle.getMessage(TestcaseNode.class, (String)"MSG_Fail_to_load_file", (Object)this.mFile.getAbsolutePath()), exception);
            return null;
        }
    }

    private String getXMLEncoding(File file) throws FileNotFoundException, IOException {
        String string = "UTF-8";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.mFile));
        String string2 = bufferedReader.readLine();
        Pattern pattern = Pattern.compile("encoding=[\"'](.*?)[\"']");
        Matcher matcher = pattern.matcher(string2);
        boolean bl = matcher.find();
        if (bl && matcher.groupCount() == 1) {
            string = matcher.group(1);
        }
        bufferedReader.close();
        return string;
    }

    public Writer createWriter(Difference[] differenceArray) throws IOException {
        throw new IOException("MSG_Operation_not_supported");
    }

    synchronized void init() throws IOException {
        if (this.mFile == null || !this.mFile.exists()) {
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)this.mFile);
        this.mMimeType = fileObject != null ? fileObject.getMIMEType() : "xml";
    }
}

