/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui.customizer;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.JBIComponentInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.compapp.jbiserver.JbiManager;
import org.netbeans.modules.compapp.projects.jbi.AdministrationServiceHelper;
import org.netbeans.modules.compapp.projects.jbi.JbiActionProvider;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectConstants;
import org.netbeans.modules.compapp.projects.jbi.ui.NoSelectedServerWarning;
import org.netbeans.modules.compapp.projects.jbi.ui.actions.AddProjectAction;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.compapp.projects.jbi.ui.deployInfo.ComponentObject;
import org.netbeans.modules.compapp.projects.jbi.ui.deployInfo.ComponentTableModel;
import org.netbeans.modules.compapp.projects.jbi.ui.deployInfo.TableSorterUtil;
import org.netbeans.modules.sun.manager.jbi.management.JBIComponentType;
import org.netbeans.modules.sun.manager.jbi.management.model.ComponentInformationParser;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VisualArchiveIncludesSupport {
    private static final int COMPONENT_TYPE_COLUMN = 0;
    private static final int COMPONENT_NAME_COLUMN = 1;
    private JbiProjectProperties projProperties;
    private Project project;
    private JTable componentTable;
    private ComponentTableModel componentTableModel;
    private JTable classpathTable;
    private ClasspathTableModel classpathTableModel;
    private Object[][] data;
    private JButton addProjectButton;
    private JButton removeProjectButton;
    private JButton updateComponentsButton;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private String compInfoFileLoc;
    private String assemblyInfoFileLoc;
    private List<String> componentNames = new ArrayList<String>();
    private List<VisualClassPathItem> bindingVisualClassPathItems = null;
    private AntArtifact bcJar = null;

    public VisualArchiveIncludesSupport(JbiProjectProperties jbiProjectProperties, JTable jTable, JTable jTable2, JButton jButton, JButton jButton2, JButton jButton3) {
        Object object;
        this.projProperties = jbiProjectProperties;
        this.componentTable = jTable;
        this.classpathTable = jTable2;
        this.updateComponentsButton = jButton;
        this.addProjectButton = jButton2;
        this.removeProjectButton = jButton3;
        this.project = jbiProjectProperties.getProject();
        this.bindingVisualClassPathItems = jbiProjectProperties.getBindingList();
        this.initClassPathTable();
        this.initComponentTable();
        ClasspathSupportListener classpathSupportListener = new ClasspathSupportListener();
        this.updateComponentsButton.addActionListener(classpathSupportListener);
        this.addProjectButton.addActionListener(classpathSupportListener);
        this.removeProjectButton.addActionListener(classpathSupportListener);
        this.classpathTable.getSelectionModel().addListSelectionListener(classpathSupportListener);
        this.classpathTableModel.addTableModelListener(classpathSupportListener);
        classpathSupportListener.valueChanged(null);
        JbiProject jbiProject = jbiProjectProperties.getProject();
        File file = FileUtil.toFile((FileObject)jbiProject.getProjectDirectory());
        List list = (List)jbiProjectProperties.get("meta.inf");
        if (list != null && list.size() > 0) {
            object = file.getPath() + File.separator + list.get(0).toString();
            this.compInfoFileLoc = (String)object + File.separator + "ComponentInformation.xml";
            this.assemblyInfoFileLoc = (String)object + File.separator + "AssemblyInformation.xml";
        }
        object = (AntProjectHelper)jbiProject.getLookup().lookup(AntProjectHelper.class);
        this.bcJar = object.createSimpleAntArtifact("CAPS.jbiserver:bpelse", "build/BCDeployment.jar", object.getStandardPropertyEvaluator(), "dist_bc", "clean");
    }

    public void setVisualWarItems(List<VisualClassPathItem> list) {
        this.data = new Object[list.size()][2];
        for (int i = 0; i < list.size(); ++i) {
            VisualClassPathItem visualClassPathItem = list.get(i);
            this.classpathTableModel.setValueAt(visualClassPathItem, i, 0);
            this.classpathTableModel.setValueAt(visualClassPathItem.getAsaType(), i, 1);
        }
        this.classpathTableModel.fireTableDataChanged();
    }

    public List<VisualClassPathItem> getVisualWarItems() {
        ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>();
        for (int i = 0; i < this.data.length; ++i) {
            arrayList.add((VisualClassPathItem)this.classpathTableModel.getValueAt(i, 0));
        }
        return arrayList;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed() {
        ArrayList<ActionListener> arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<ActionListener>(this.actionListeners);
        }
        object = new ActionEvent(this, 0, null);
        for (ActionListener actionListener : arrayList) {
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    private void addArtifacts(AntArtifact[] antArtifactArray) {
        int n;
        HashMap<AntArtifact, VisualClassPathItem> hashMap = new HashMap<AntArtifact, VisualClassPathItem>();
        ArrayList<AntArtifact> arrayList = new ArrayList<AntArtifact>();
        for (int i = 0; i < antArtifactArray.length; ++i) {
            VisualClassPathItem visualClassPathItem = new VisualClassPathItem(antArtifactArray[i], 2, null, antArtifactArray[i].getArtifactLocations()[0].toString(), true);
            hashMap.put(antArtifactArray[i], visualClassPathItem);
            boolean bl = false;
            for (int j = 0; j < this.data.length; ++j) {
                if (!this.data[j][0].toString().equals(visualClassPathItem.toString())) continue;
                bl = true;
                break;
            }
            if (bl) {
                String string = NbBundle.getMessage(AddProjectAction.class, (String)"MSG_DuplicateJBIModule", (Object)visualClassPathItem.toString());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                continue;
            }
            arrayList.add(antArtifactArray[i]);
        }
        if (arrayList.size() == 0) {
            return;
        }
        Object[][] objectArray = new Object[this.data.length + arrayList.size()][2];
        for (n = 0; n < this.data.length; ++n) {
            objectArray[n] = this.data[n];
        }
        for (n = 0; n < arrayList.size(); ++n) {
            AntArtifact antArtifact = (AntArtifact)arrayList.get(n);
            VisualClassPathItem visualClassPathItem = (VisualClassPathItem)hashMap.get(antArtifact);
            objectArray[this.data.length + n][0] = visualClassPathItem;
            objectArray[this.data.length + n][1] = visualClassPathItem.getAsaType();
            if (!VisualClassPathItem.isJavaEEProjectAntArtifact(antArtifact)) continue;
            this.projProperties.addSunResourceProject(antArtifact);
        }
        this.data = objectArray;
        this.classpathTableModel.fireTableRowsInserted(this.data.length, this.data.length + arrayList.size() - 1);
        this.fireActionPerformed();
    }

    private void removeElements() {
        int n;
        ListSelectionModel listSelectionModel = this.classpathTable.getSelectionModel();
        Object object = null;
        int n2 = listSelectionModel.getMinSelectionIndex();
        if (listSelectionModel.isSelectionEmpty()) assert (false) : "Remove button should be disabled";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n3 = this.data.length;
        for (n = 0; n < n3; ++n) {
            if (!listSelectionModel.isSelectedIndex(n)) {
                arrayList.add(this.data[n]);
                continue;
            }
            if (!(this.data[n][0] instanceof VisualClassPathItem) || !((object = ((VisualClassPathItem)this.data[n][0]).getObject()) instanceof AntArtifact) || !VisualClassPathItem.isJavaEEProjectAntArtifact((AntArtifact)object)) continue;
            this.projProperties.removeSunResourceProject((AntArtifact)object);
        }
        n = arrayList.size();
        this.data = (Object[][])arrayList.toArray((T[])new Object[n][2]);
        this.classpathTableModel.fireTableRowsDeleted(arrayList.size(), n3 - 1);
        if (n2 >= n) {
            n2 = n - 1;
        }
        listSelectionModel.setSelectionInterval(n2, n2);
        this.fireActionPerformed();
    }

    private void updateClassPathTableModel(String string, String string2, String string3, String string4) {
        int n = this.classpathTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            VisualClassPathItem visualClassPathItem = (VisualClassPathItem)this.classpathTableModel.getValueAt(i, 0);
            String string5 = visualClassPathItem.getShortName();
            if (string5.compareTo(string) != 0 && (!string5.endsWith(".jar") || !string.endsWith("@SEDeployment.jar") || !string5.substring(0, string5.length() - 4).equals(string.substring(0, string.length() - 17)))) continue;
            visualClassPathItem.setAsaDescription(string3);
            visualClassPathItem.setAsaTarget(string4);
            this.classpathTableModel.setValueAt(string4, i, 1);
        }
        for (VisualClassPathItem visualClassPathItem : this.bindingVisualClassPathItems) {
            if (visualClassPathItem.getAsaTarget().compareTo(string4) != 0) continue;
            visualClassPathItem.setAsaDescription(string3);
            return;
        }
    }

    private void updateClassPathTable() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new File(this.assemblyInfoFileLoc));
            NodeList nodeList = document.getElementsByTagName("service-unit");
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node;
                    int n3;
                    int n4;
                    NodeList nodeList3;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeName().equals("identification")) {
                        nodeList3 = node2.getChildNodes();
                        n4 = nodeList3.getLength();
                        for (n3 = 0; n3 < n4; ++n3) {
                            node = nodeList3.item(n3);
                            if (node.getNodeName().equals("name")) {
                                string = node.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (node.getNodeName().compareTo("description") != 0) continue;
                            string2 = node.getFirstChild() == null ? "" : node.getFirstChild().getNodeValue();
                        }
                        continue;
                    }
                    if (!node2.getNodeName().equals("target")) continue;
                    nodeList3 = node2.getChildNodes();
                    n4 = nodeList3.getLength();
                    for (n3 = 0; n3 < n4; ++n3) {
                        node = nodeList3.item(n3);
                        if (node.getNodeName().equals("component-name")) {
                            string3 = node.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!node.getNodeName().equals("artifacts-zip")) continue;
                        string4 = node.getFirstChild().getNodeValue();
                    }
                }
                if (string4 == null) continue;
                this.updateClassPathTableModel(string4, string, string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initClassPathTable() {
        this.classpathTableModel = new ClasspathTableModel();
        this.classpathTable.setModel(this.classpathTableModel);
        this.classpathTable.setSelectionMode(2);
        TableColumnModel tableColumnModel = this.classpathTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn.setHeaderValue(NbBundle.getMessage(this.getClass(), (String)"TXT_Archive_Item"));
        tableColumn2.setHeaderValue(NbBundle.getMessage(this.getClass(), (String)"TXT_Archive_PathInArchive"));
        tableColumn.setCellRenderer(new ClassPathCellRenderer());
    }

    private void initComponentTable() {
        ArrayList<ComponentObject> arrayList = new ArrayList<ComponentObject>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(NbBundle.getMessage(this.getClass(), (String)"Type"));
        arrayList2.add(NbBundle.getMessage(this.getClass(), (String)"Component_ID"));
        this.componentTableModel = new ComponentTableModel(arrayList, arrayList2);
        TableSorterUtil tableSorterUtil = new TableSorterUtil(this.componentTableModel);
        this.componentTable.setModel(tableSorterUtil);
        this.componentTable.setShowHorizontalLines(true);
        this.componentTable.setShowVerticalLines(false);
        this.componentTable.setShowGrid(false);
        this.componentTable.setAutoCreateColumnsFromModel(false);
        this.componentTable.setRowSelectionAllowed(true);
        this.componentTable.setColumnSelectionAllowed(false);
        this.componentTable.getTableHeader().setReorderingAllowed(false);
        this.componentTable.getTableHeader().setAlignmentY(0.0f);
        this.componentTable.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.componentTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(70);
        tableColumnModel.getColumn(1).setPreferredWidth(300);
    }

    public void initTableValues() {
        this.updateComponentTable();
        this.updateClassPathTable();
    }

    private void updateComponentTable() {
        File file = new File(this.compInfoFileLoc);
        try {
            if (file.exists()) {
                List list = ComponentInformationParser.parse((File)file);
                this.updateComponentTable(list);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateComponentTable(List<? extends JBIComponentInfo> list) {
        ArrayList<ComponentObject> arrayList = new ArrayList<ComponentObject>();
        this.componentNames.clear();
        this.bindingVisualClassPathItems.clear();
        for (JBIComponentInfo jBIComponentInfo : list) {
            String string = jBIComponentInfo.getType();
            if (string.equals("sharedLibrary")) continue;
            ComponentObject componentObject = new ComponentObject(string, jBIComponentInfo.getState(), jBIComponentInfo.getName(), jBIComponentInfo.getDescription());
            arrayList.add(componentObject);
            this.componentNames.add(jBIComponentInfo.getName());
            if (!string.equals("bindingComponent")) continue;
            VisualClassPathItem visualClassPathItem = new VisualClassPathItem(this.bcJar, 2, "BCDeployment.jar", null, true);
            visualClassPathItem.setAsaTarget(jBIComponentInfo.getName());
            this.bindingVisualClassPathItems.add(visualClassPathItem);
        }
        this.componentTableModel.setData(arrayList);
    }

    private boolean isSelectedServer() {
        NoSelectedServerWarning noSelectedServerWarning;
        Object object;
        String string = (String)this.projProperties.get("j2ee.server.instance");
        boolean bl = true;
        if (string == null || !JbiManager.isAppServer(string)) {
            object = JbiManager.getAppServers();
            if (((String[])object).length < 1) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_NoInstalledServerError"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return false;
            }
            noSelectedServerWarning = new NoSelectedServerWarning((String[])object);
            Object[] objectArray = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)noSelectedServerWarning, NbBundle.getMessage(NoSelectedServerWarning.class, (String)"CTL_NoSelectedServerWarning_Title"), true, objectArray, objectArray[0], 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() != objectArray[0]) {
                bl = false;
            } else {
                string = noSelectedServerWarning.getSelectedInstance();
                boolean bl2 = bl = string != null;
                if (bl) {
                    this.projProperties.put("j2ee.server.instance", string);
                    this.projProperties.store();
                }
            }
            dialog.dispose();
        }
        if (string == null || !bl) {
            object = NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_NoSelectedServerError");
            noSelectedServerWarning = new NotifyDescriptor.Message(object, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)noSelectedServerWarning);
            return false;
        }
        if (!JbiManager.isRunningAppServer(string)) {
            object = NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_NoRunningServerError");
            noSelectedServerWarning = new NotifyDescriptor.Message(object, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)noSelectedServerWarning);
            return false;
        }
        return true;
    }

    private void fetchInfo() {
        try {
            RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getAdministrationService();
            if (runtimeManagementServiceWrapper != null) {
                runtimeManagementServiceWrapper.clearJBIComponentStatusCache(JBIComponentType.SERVICE_ENGINE);
                runtimeManagementServiceWrapper.clearJBIComponentStatusCache(JBIComponentType.BINDING_COMPONENT);
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(runtimeManagementServiceWrapper.listServiceEngines("server"));
                arrayList.addAll(runtimeManagementServiceWrapper.listBindingComponents("server"));
                this.updateComponentTable(arrayList);
            }
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private RuntimeManagementServiceWrapper getAdministrationService() throws MalformedURLException, IOException, MalformedObjectNameException, ManagementRemoteException {
        String string = (String)this.projProperties.get("j2ee.server.instance");
        if (string == null) {
            if (!this.isSelectedServer()) {
                return null;
            }
            string = (String)this.projProperties.get("j2ee.server.instance");
        } else if (!JbiManager.isRunningAppServer(string)) {
            String string2 = NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_NoRunningServerError");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return null;
        }
        return AdministrationServiceHelper.getRuntimeManagementServiceWrapper(string);
    }

    private void updateProperties(JbiProjectProperties jbiProjectProperties, ClasspathTableModel classpathTableModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        VisualClassPathItem visualClassPathItem = null;
        ArrayList<VisualClassPathItem> arrayList2 = new ArrayList<VisualClassPathItem>();
        Object object = null;
        for (int i = 0; i < classpathTableModel.getRowCount(); ++i) {
            arrayList.add((String)classpathTableModel.getValueAt(i, 1));
            visualClassPathItem = (VisualClassPathItem)classpathTableModel.getValueAt(i, 0);
            if (visualClassPathItem == null || !((object = visualClassPathItem.getObject()) instanceof AntArtifact) || !VisualClassPathItem.isJavaEEProjectAntArtifact((AntArtifact)object)) continue;
            arrayList2.add(visualClassPathItem);
        }
        jbiProjectProperties.put("jbi.content.component", arrayList);
        jbiProjectProperties.put("jbi.content.javaee.jars", arrayList2);
    }

    private class ClasspathTableModel
    extends AbstractTableModel {
        private ClasspathTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return VisualArchiveIncludesSupport.this.data == null ? 0 : VisualArchiveIncludesSupport.this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return VisualArchiveIncludesSupport.this.data[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            ((VisualArchiveIncludesSupport)VisualArchiveIncludesSupport.this).data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }

    private static class ClassPathCellRenderer
    extends DefaultTableCellRenderer {
        private ClassPathCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            assert (object == null || object instanceof VisualClassPathItem);
            return super.getTableCellRendererComponent(jTable, object == null ? null : object.toString(), bl, false, n, n2);
        }
    }

    private class ClasspathSupportListener
    implements ActionListener,
    ListSelectionListener,
    TableModelListener {
        private ClasspathSupportListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == VisualArchiveIncludesSupport.this.addProjectButton) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(JbiProjectConstants.JAVA_EE_AA_TYPES);
                arrayList.add("CAPS.asa");
                AntArtifact[] antArtifactArray = AntArtifactChooser.showDialog(arrayList, VisualArchiveIncludesSupport.this.project, null, null);
                if (antArtifactArray != null) {
                    VisualArchiveIncludesSupport.this.addArtifacts(antArtifactArray);
                }
            } else if (object == VisualArchiveIncludesSupport.this.removeProjectButton) {
                VisualArchiveIncludesSupport.this.removeElements();
            } else if (object == VisualArchiveIncludesSupport.this.updateComponentsButton) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        VisualArchiveIncludesSupport.this.fetchInfo();
                    }
                });
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            VisualClassPathItem visualClassPathItem;
            boolean bl;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)VisualArchiveIncludesSupport.this.classpathTable.getSelectionModel();
            int n = defaultListSelectionModel.getMinSelectionIndex();
            boolean bl2 = bl = n != -1;
            if (bl && !(visualClassPathItem = (VisualClassPathItem)VisualArchiveIncludesSupport.this.classpathTableModel.getValueAt(n, 0)).canDelete()) {
                bl = false;
            }
            VisualArchiveIncludesSupport.this.removeProjectButton.setEnabled(bl);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            VisualArchiveIncludesSupport.this.updateProperties(VisualArchiveIncludesSupport.this.projProperties, VisualArchiveIncludesSupport.this.classpathTableModel);
            if (tableModelEvent.getColumn() == 1) {
                VisualArchiveIncludesSupport.this.fireActionPerformed();
            }
        }
    }
}

