/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.api.InternalProjectTypePlugin;
import org.netbeans.modules.compapp.projects.jbi.api.JbiInstalledProjectPluginInfo;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectActionPerformer;
import org.netbeans.modules.compapp.projects.jbi.ui.JbiModuleViewChildren;
import org.netbeans.modules.compapp.projects.jbi.ui.actions.AddProjectAction;
import org.netbeans.modules.compapp.projects.jbi.ui.actions.JbiProjectCookie;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.OutputWriter;

public class JbiModuleViewNode
extends AbstractNode {
    private static Image JBI_MODULES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/compapp/projects/jbi/ui/resources/compositeApplicationBadge.png", (boolean)true);
    private final DataFolder aFolder;
    private final JbiProject project;
    private JbiModuleViewChildren children;
    private FileChangeAdapter projectXmlChangeAdapter;

    public JbiModuleViewNode(JbiProjectProperties jbiProjectProperties, JbiProject jbiProject) {
        super((Children)new JbiModuleViewChildren(jbiProject));
        this.project = jbiProject;
        DataFolder dataFolder = null;
        FileObject fileObject = jbiProject.getProjectDirectory();
        if (fileObject.isFolder()) {
            dataFolder = DataFolder.findFolder((FileObject)fileObject);
        }
        this.aFolder = dataFolder;
        this.setName("preferablyUniqueNameForThisNodeAmongSiblings");
        this.setDisplayName(NbBundle.getMessage(JbiModuleViewNode.class, (String)"LBL_ModuleViewNode"));
        this.getCookieSet().add((Node.Cookie)new JbiProjectCookie(jbiProject));
        this.projectXmlChangeAdapter = new FileChangeAdapter(){

            public void fileChanged(FileEvent fileEvent) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JbiModuleViewNode.this.updateChildren();
                    }
                });
            }
        };
        FileObject fileObject2 = jbiProject.getProjectDirectory().getFileObject("nbproject/project.xml");
        fileObject2.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.projectXmlChangeAdapter, (Object)fileObject2));
        this.children = (JbiModuleViewChildren)this.getChildren();
    }

    private void updateChildren() {
        if (this.children != null) {
            this.children.addNotify();
        }
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    private Image computeIcon(boolean bl, int n) {
        if (this.aFolder != null) {
            Node node = this.aFolder.getNodeDelegate();
            Image image = bl ? node.getOpenedIcon(n) : node.getIcon(n);
            return ImageUtilities.mergeImages((Image)image, (Image)JBI_MODULES_BADGE, (int)7, (int)7);
        }
        return JBI_MODULES_BADGE;
    }

    public Action[] getActions(boolean bl) {
        ResourceBundle resourceBundle = NbBundle.getBundle(JbiModuleViewNode.class);
        int n = 0;
        Action[] actionArray = null;
        AbstractAction abstractAction = new AbstractAction(resourceBundle.getString("LBL_AddProjectAction_Name"), null){

            public void actionPerformed(ActionEvent actionEvent) {
                new AddProjectAction().perform(JbiModuleViewNode.this.project);
            }
        };
        JbiInstalledProjectPluginInfo jbiInstalledProjectPluginInfo = JbiInstalledProjectPluginInfo.getProjectPluginInfo();
        ArrayList<JbiProjectActionPerformer> arrayList = new ArrayList<JbiProjectActionPerformer>();
        if (jbiInstalledProjectPluginInfo != null) {
            List<InternalProjectTypePlugin> list = jbiInstalledProjectPluginInfo.getUncategorizedProjectPluginList();
            for (InternalProjectTypePlugin object : list) {
                List<JbiProjectActionPerformer> list2 = object.getProjectActions();
                for (JbiProjectActionPerformer jbiProjectActionPerformer : list2) {
                    if (!jbiProjectActionPerformer.getActionType().equalsIgnoreCase("PluginAction_AddProject")) continue;
                    arrayList.add(jbiProjectActionPerformer);
                }
            }
            if (arrayList.size() > 0) {
                actionArray = new Action[arrayList.size() + 1];
                actionArray[n++] = abstractAction;
                for (final JbiProjectActionPerformer jbiProjectActionPerformer : arrayList) {
                    actionArray[n++] = new AbstractAction(jbiProjectActionPerformer.getLabel(), jbiProjectActionPerformer.getIcon()){

                        public void actionPerformed(ActionEvent actionEvent) {
                            jbiProjectActionPerformer.perform(JbiModuleViewNode.this.project);
                        }
                    };
                }
            }
        }
        if (actionArray == null) {
            actionArray = new Action[]{abstractAction};
        }
        return actionArray;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void log(String string) {
        OutputWriter outputWriter = IOProvider.getDefault().getStdOut();
        outputWriter.println(string);
        outputWriter.flush();
    }

    public JbiProject getProject() {
        return this.project;
    }
}

