/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.tool.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.compapp.javaee.sunresources.ResourceAggregator;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.ActivationConfigPropertyAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.MessageDrivenAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.StatefulAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.StatelessAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.WebServiceAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.EJBNode;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.MDBNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAnnotation {
    private ResourceAggregator resAggregator;

    public EJBAnnotation(ResourceAggregator resourceAggregator) {
        this.resAggregator = resourceAggregator;
    }

    public void fillWebServiceNode(EJBNode eJBNode, ClassFile classFile) {
        WebServiceAnnoWrapper webServiceAnnoWrapper = new WebServiceAnnoWrapper(classFile.getAnnotation(ClassName.getClassName((String)"javax/jws/WebService")));
        Properties properties = eJBNode.getProps();
        properties.setProperty("endpointInterface", webServiceAnnoWrapper.endpointInterface());
        properties.setProperty("name", webServiceAnnoWrapper.name());
        properties.setProperty("portName", webServiceAnnoWrapper.portName());
        properties.setProperty("serviceName", webServiceAnnoWrapper.serviceName());
        properties.setProperty("targetNamespace", webServiceAnnoWrapper.targetNamespace());
        properties.setProperty("wsdlLocation", webServiceAnnoWrapper.wsdlLocation());
    }

    public void fillStatelessNode(EJBNode eJBNode, ClassFile classFile) {
        StatelessAnnoWrapper statelessAnnoWrapper = new StatelessAnnoWrapper(classFile.getAnnotation(ClassName.getClassName((String)"javax/ejb/Stateless")));
        Properties properties = eJBNode.getProps();
        properties.setProperty("description", statelessAnnoWrapper.description());
        properties.setProperty("mappedName", statelessAnnoWrapper.mappedName());
        properties.setProperty("name", statelessAnnoWrapper.name());
    }

    public void fillStatefulNode(EJBNode eJBNode, ClassFile classFile) {
        StatefulAnnoWrapper statefulAnnoWrapper = new StatefulAnnoWrapper(classFile.getAnnotation(ClassName.getClassName((String)"javax/ejb/Stateful")));
        Properties properties = eJBNode.getProps();
        properties.setProperty("description", statefulAnnoWrapper.description());
        properties.setProperty("mappedName", statefulAnnoWrapper.mappedName());
        properties.setProperty("name", statefulAnnoWrapper.name());
    }

    public void fillMessageDrivenNode(MDBNode mDBNode, ClassFile classFile) {
        String string;
        MessageDrivenAnnoWrapper messageDrivenAnnoWrapper = new MessageDrivenAnnoWrapper(classFile.getAnnotation(ClassName.getClassName((String)"javax/ejb/MessageDriven")));
        Properties properties = mDBNode.getProps();
        properties.setProperty("description", messageDrivenAnnoWrapper.description());
        properties.setProperty("mappedName", messageDrivenAnnoWrapper.mappedName());
        properties.setProperty("name", messageDrivenAnnoWrapper.name());
        mDBNode.setMappedName(messageDrivenAnnoWrapper.mappedName());
        ArrayList<String> arrayList = EJBAnnotation.filterExcludedEJBIntf(classFile.getInterfaces());
        if (arrayList.size() == 1) {
            mDBNode.setMsgListenerIntClassName(arrayList.get(0));
        } else {
            mDBNode.setMsgListenerIntClassName(messageDrivenAnnoWrapper.messageListenerInterface());
        }
        Properties properties2 = mDBNode.getActivationConfig();
        ActivationConfigPropertyAnnoWrapper[] activationConfigPropertyAnnoWrapperArray = messageDrivenAnnoWrapper.activationConfig();
        for (int i = 0; i < activationConfigPropertyAnnoWrapperArray.length; ++i) {
            properties2.setProperty(activationConfigPropertyAnnoWrapperArray[i].propertyName(), activationConfigPropertyAnnoWrapperArray[i].propertyValue());
        }
        ResourceAggregator.ResourceEntry resourceEntry = this.resAggregator.getAdminObjectResourceEntry(messageDrivenAnnoWrapper.mappedName());
        if (resourceEntry == null) {
            string = null;
            for (int i = 0; i < activationConfigPropertyAnnoWrapperArray.length; ++i) {
                if (!activationConfigPropertyAnnoWrapperArray[i].propertyName().equals("destinationType")) continue;
                string = activationConfigPropertyAnnoWrapperArray[i].propertyValue();
            }
            Properties properties3 = new Properties();
            properties3.setProperty("Name", classFile.getName().getSimpleName());
            resourceEntry = this.resAggregator.addAdminObjectResourceEntry(messageDrivenAnnoWrapper.mappedName(), string, "jmsra", properties3);
        } else {
            resourceEntry.obsolete = false;
            resourceEntry.orphanStatus = ResourceAggregator.OrphanStatus.BOTH;
        }
        string = classFile.getName().getPackage().replace('.', '/') + "/" + classFile.getSourceFileName();
        resourceEntry.addResourceUsage(string, null);
    }

    public static ArrayList<String> filterExcludedEJBIntf(Collection<ClassName> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ClassName className : collection) {
            String string = className.getExternalName();
            if (string.equals("java.io.Serializable") || string.equals("java.io.Externalizable") || string.startsWith("javax.ejb.")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }
}

