/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.actions;

import java.awt.Point;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.javaee.sunresources.actions.WidgetMoveProvider;
import org.netbeans.modules.compapp.javaee.sunresources.tool.graph.JAXBHandler;

public final class WidgetMoveAction
extends WidgetAction.LockedAdapter {
    private MoveStrategy strategy = new MoveStrategy(){

        public Point locationSuggested(Widget widget, Point point, Point point2) {
            return point2;
        }
    };
    private MoveProvider provider;
    private Widget movingWidget = null;
    private Point dragSceneLocation = null;
    private Point originalSceneLocation = null;

    public WidgetMoveAction(JAXBHandler jAXBHandler) {
        this.provider = new WidgetMoveProvider(jAXBHandler);
    }

    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1) {
            this.movingWidget = widget;
            this.originalSceneLocation = widget.getPreferredLocation();
            if (this.originalSceneLocation == null) {
                this.originalSceneLocation = new Point();
            }
            this.dragSceneLocation = widget.convertLocalToScene(widgetMouseEvent.getPoint());
            this.provider.movementStarted(widget);
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        boolean bl = this.move(widget, widgetMouseEvent.getPoint());
        if (bl) {
            this.movingWidget = null;
            this.provider.movementFinished(widget);
        }
        return bl ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.move(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.movingWidget != widget) {
            return false;
        }
        point = widget.convertLocalToScene(point);
        Point point2 = new Point(this.originalSceneLocation.x + point.x - this.dragSceneLocation.x, this.originalSceneLocation.y + point.y - this.dragSceneLocation.y);
        this.provider.setNewLocation(widget, this.strategy.locationSuggested(widget, this.originalSceneLocation, point2));
        widget.getScene().repaint();
        return true;
    }
}

