/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.api.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.extexecution.api.input.LineProcessor;
import org.netbeans.modules.extexecution.api.print.ConvertedLine;
import org.netbeans.modules.extexecution.api.print.LineConvertor;
import org.openide.windows.OutputWriter;

public final class LineProcessors {
    private static final Logger LOGGER = Logger.getLogger(LineProcessors.class.getName());

    private LineProcessors() {
    }

    public static LineProcessor proxy(LineProcessor ... lineProcessorArray) {
        return new ProxyLineProcessor(lineProcessorArray);
    }

    public static LineProcessor printing(OutputWriter outputWriter, boolean bl) {
        return LineProcessors.printing(outputWriter, null, bl);
    }

    public static LineProcessor printing(OutputWriter outputWriter, LineConvertor lineConvertor, boolean bl) {
        return new PrintingLineProcessor(outputWriter, lineConvertor, bl);
    }

    public static LineProcessor patternWaiting(Pattern pattern, CountDownLatch countDownLatch) {
        return new WaitingLineProcessor(pattern, countDownLatch);
    }

    private static class WaitingLineProcessor
    implements LineProcessor {
        private final Pattern pattern;
        private final CountDownLatch latch;
        private boolean processed;
        private boolean closed;

        public WaitingLineProcessor(Pattern pattern, CountDownLatch countDownLatch) {
            assert (pattern != null);
            assert (countDownLatch != null);
            this.pattern = pattern;
            this.latch = countDownLatch;
        }

        public synchronized void processLine(String string) {
            assert (string != null);
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            if (!this.processed && this.pattern.matcher(string).matches()) {
                this.latch.countDown();
                this.processed = true;
            }
        }

        public synchronized void reset() {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
        }

        public synchronized void close() {
            this.closed = true;
        }
    }

    private static class PrintingLineProcessor
    implements LineProcessor {
        private final OutputWriter out;
        private final LineConvertor convertor;
        private final boolean resetEnabled;
        private boolean closed;

        public PrintingLineProcessor(OutputWriter outputWriter, LineConvertor lineConvertor, boolean bl) {
            assert (outputWriter != null);
            this.out = outputWriter;
            this.convertor = lineConvertor;
            this.resetEnabled = bl;
        }

        public void processLine(String string) {
            assert (string != null);
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            LOGGER.log(Level.FINEST, string);
            if (this.convertor != null) {
                for (ConvertedLine convertedLine : this.convertor.convert(string)) {
                    if (convertedLine.getListener() == null) {
                        this.out.println(convertedLine.getText());
                        continue;
                    }
                    try {
                        this.out.println(convertedLine.getText(), convertedLine.getListener());
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, null, iOException);
                        this.out.println(convertedLine.getText());
                    }
                }
            } else {
                this.out.println(string);
            }
            this.out.flush();
        }

        public void reset() {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            if (!this.resetEnabled) {
                return;
            }
            try {
                this.out.reset();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
        }

        public void close() {
            this.closed = true;
            this.out.flush();
            this.out.close();
        }
    }

    private static class ProxyLineProcessor
    implements LineProcessor {
        private final List<LineProcessor> processors = new ArrayList<LineProcessor>();
        private boolean closed;

        public ProxyLineProcessor(LineProcessor ... lineProcessorArray) {
            for (LineProcessor lineProcessor : lineProcessorArray) {
                if (lineProcessor == null) continue;
                this.processors.add(lineProcessor);
            }
        }

        public void processLine(String string) {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (LineProcessor lineProcessor : this.processors) {
                lineProcessor.processLine(string);
            }
        }

        public void reset() {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (LineProcessor lineProcessor : this.processors) {
                lineProcessor.reset();
            }
        }

        public void close() {
            this.closed = true;
            for (LineProcessor lineProcessor : this.processors) {
                lineProcessor.close();
            }
        }
    }
}

