/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.project.ui.CDCFoldersListSettings;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.PanelConfigurePlatform;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCDCProjectWizardIterator
implements TemplateWizard.Iterator {
    public static final int TYPE_APP = 0;
    public static final int TYPE_LIB = 1;
    public static final int TYPE_EXT = 2;
    public static final int TYPE_SAMPLE = 3;
    static final String PROP_NAME_INDEX = "nameIndex";
    static final String MANIFEST_FILE = "manifest.mf";
    private static final long serialVersionUID = 1L;
    private int type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;

    public NewCDCProjectWizardIterator() {
        this(0);
    }

    public NewCDCProjectWizardIterator(int n) {
        this.type = n;
    }

    public static NewCDCProjectWizardIterator library() {
        return new NewCDCProjectWizardIterator(1);
    }

    public static NewCDCProjectWizardIterator existing() {
        return new NewCDCProjectWizardIterator(2);
    }

    private WizardDescriptor.Panel[] createPanels() {
        WizardDescriptor.Panel[] panelArray;
        int n = NewCDCProjectWizardIterator.getNumberOfCdcPlatforms();
        if (n != 0) {
            WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[2];
            panelArray2[0] = new PanelConfigureProject(this.type);
            panelArray = panelArray2;
            panelArray2[1] = new PanelConfigurePlatform();
        } else {
            WizardDescriptor.Panel[] panelArray3 = new WizardDescriptor.Panel[3];
            panelArray3[0] = new PlatformInstallPanel.WizardPanel("cdc");
            panelArray3[1] = new PanelConfigureProject(this.type);
            panelArray = panelArray3;
            panelArray3[2] = new PanelConfigurePlatform();
        }
        return panelArray;
    }

    private String[] createSteps() {
        String[] stringArray;
        int n = NewCDCProjectWizardIterator.getNumberOfCdcPlatforms();
        if (n != 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_ConfigureProject");
            stringArray = stringArray2;
            stringArray2[1] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_SelectPlatform");
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_Step_AddPlatform");
            stringArray3[1] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_ConfigureProject");
            stringArray = stringArray3;
            stringArray3[2] = NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_SelectPlatform");
        }
        return stringArray;
    }

    private static String createMainClass(String string, FileObject fileObject, String string2) throws IOException {
        DataObject dataObject;
        Object object;
        String string3;
        String string4;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            string4 = string.trim();
            string3 = null;
        } else {
            string4 = string.substring(n + 1).trim();
            string3 = string.substring(0, n).trim();
        }
        if (string4.length() == 0 || string2 == null) {
            return null;
        }
        FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("MainTemplates/org.netbeans.modules.kjava.j2meproject/" + string2);
        if (fileObject2 == null) {
            return null;
        }
        String string5 = (String)fileObject2.getAttribute("templateName");
        String string6 = (String)fileObject2.getAttribute("templateType");
        if (string5 == null || string6 == null) {
            return null;
        }
        fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource(string5);
        if (fileObject2 == null) {
            return null;
        }
        DataObject dataObject2 = DataObject.find((FileObject)fileObject2);
        FileObject fileObject3 = fileObject;
        if (string3 != null) {
            object = string3.replace('.', '/');
            fileObject3 = FileUtil.createFolder((FileObject)fileObject, (String)object);
        }
        if ((dataObject = dataObject2.createFromTemplate(object = DataFolder.findFolder((FileObject)fileObject3), string4)) != null) {
            dataObject.getPrimaryFile().setAttribute("justCreatedByNewWizard", (Object)Boolean.TRUE);
        }
        return string6;
    }

    private static String normalizePath(File file, File file2, String string) {
        String string2;
        String string3 = file2.getAbsolutePath();
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        if ((string2 = file.getAbsolutePath()).startsWith(string3)) {
            return "${" + string + "}" + File.separator + string2.substring(string3.length());
        }
        return string2;
    }

    public static void generatePlatformProperties(CDCPlatform cDCPlatform, String string, String string2, EditableProperties editableProperties) {
        Collection collection = cDCPlatform.getInstallFolders();
        if (collection.size() > 0) {
            File file = FileUtil.toFile((FileObject)((FileObject)collection.iterator().next()));
            StringBuffer stringBuffer = new StringBuffer();
            ClassPath classPath = cDCPlatform.getBootstrapLibrariesForProfile(string, string2);
            for (ClassPath.Entry entry : classPath.entries()) {
                URL uRL = entry.getURL();
                if ("jar".equals(uRL.getProtocol())) {
                    uRL = FileUtil.getArchiveFile((URL)uRL);
                }
                File file2 = new File(URI.create(uRL.toExternalForm()));
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(File.pathSeparator);
                }
                stringBuffer.append(NewCDCProjectWizardIterator.normalizePath(file2, file, "platform.home"));
            }
            editableProperties.setProperty("platform.fat.jar", Boolean.toString(cDCPlatform.isFatJar()));
            editableProperties.setProperty("platform.bootclasspath", stringBuffer.toString());
            editableProperties.setProperty("javac.source", cDCPlatform.getClassVersion());
            editableProperties.setProperty("javac.target", cDCPlatform.getClassVersion());
        }
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        Object object;
        FileObject fileObject;
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        File file = (File)templateWizard.getProperty("projdir");
        if (file != null) {
            file = FileUtil.normalizeFile((File)file);
        }
        String string = (String)templateWizard.getProperty("name");
        final String string2 = (String)templateWizard.getProperty("mainClass");
        String string3 = (String)templateWizard.getProperty("appName");
        final String string4 = (String)templateWizard.getProperty("activePlatform");
        final String string5 = (String)templateWizard.getProperty("activeDevice");
        final String string6 = (String)templateWizard.getProperty("activeProfile");
        Properties properties = (Properties)templateWizard.getProperty("additionalProperties");
        PlatformSelectionPanel.PlatformDescription platformDescription = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        AntProjectHelper antProjectHelper = J2MEProjectGenerator.createProject((File)file, (String)string, (PlatformSelectionPanel.PlatformDescription)platformDescription, (J2MEProjectGenerator.ProjectGeneratorCallback)new J2MEProjectGenerator.ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper antProjectHelper, FileObject fileObject, File file, ArrayList<String> arrayList) throws IOException {
                String string;
                EditableProperties editableProperties;
                CDCPlatform cDCPlatform;
                FileObject fileObject2 = fileObject.createFolder("src");
                JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(string4, new Specification("cdc", null));
                if (javaPlatformArray.length != 0) {
                    cDCPlatform = (CDCPlatform)javaPlatformArray[0];
                    editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                    if (string2 != null) {
                        string = NewCDCProjectWizardIterator.createMainClass(string2, fileObject2, cDCPlatform.getType());
                        editableProperties.setProperty("main.class", string2);
                        if (string != null) {
                            editableProperties.setProperty("main.class.class", string);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("No CDC platform installed");
                }
                editableProperties.setProperty("application.name", project.getProjectDirectory().getNameExt());
                editableProperties.setProperty("platform.active", cDCPlatform.getAntName());
                editableProperties.setProperty("platform.active.description", cDCPlatform.getDisplayName());
                editableProperties.setProperty("platform.trigger", "CDC");
                editableProperties.setProperty("platform.type", cDCPlatform.getType());
                string = cDCPlatform.getClassVersion();
                editableProperties.setProperty("platform.device", string5);
                editableProperties.setProperty("platform.profile", string6);
                NewCDCProjectWizardIterator.generatePlatformProperties(cDCPlatform, string5, string6, editableProperties);
                editableProperties.setProperty("javac.source", string != null ? string : "1.2");
                editableProperties.setProperty("javac.target", string != null ? string : "1.2");
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
            }
        });
        if (string2 != null && string2.length() > 0) {
            try {
                fileObject = antProjectHelper.getProjectDirectory().getFileObject("src");
                object = this.getMainClassFO(fileObject, string2);
                assert (object != null) : "sourcesRoot: " + fileObject + ", mainClass: " + string2;
                hashSet.add(DataObject.find((FileObject)object));
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        fileObject = FileUtil.toFileObject((File)file);
        if (this.type == 0 || this.type == 2) {
            NewCDCProjectWizardIterator.createManifest(fileObject, MANIFEST_FILE);
        }
        object = (Integer)templateWizard.getProperty(PROP_NAME_INDEX);
        switch (this.type) {
            case 0: {
                CDCFoldersListSettings.setNewApplicationCount((Integer)object);
                break;
            }
            case 1: {
                CDCFoldersListSettings.setNewLibraryCount((Integer)object);
                break;
            }
            case 2: {
                CDCFoldersListSettings.setNewProjectCount((Integer)object);
            }
        }
        hashSet.add(DataObject.find((FileObject)antProjectHelper.getProjectDirectory()));
        File file2 = file = file != null ? file.getParentFile() : null;
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        return hashSet;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
        templateWizard.putProperty("additionalProperties", (Object)new Properties());
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (templateWizard != null) {
            templateWizard.putProperty("additionalProperties", null);
            templateWizard.putProperty("projdir", null);
            templateWizard.putProperty("name", null);
            templateWizard.putProperty("mainClass", null);
            if (this.type == 2) {
                templateWizard.putProperty("sourceRoot", null);
                templateWizard.putProperty("testRoot", null);
            }
        }
        templateWizard = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private FileObject getMainClassFO(FileObject fileObject, String string) {
        string = string.replace('.', '/');
        return fileObject.getFileObject(string + ".java");
    }

    static String getPackageName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((bl || !Character.isJavaIdentifierPart(c)) && (!bl || !Character.isJavaIdentifierStart(c))) continue;
            bl = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.length() == 0 ? NbBundle.getMessage(NewCDCProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createManifest(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.createData(MANIFEST_FILE);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                PrintWriter printWriter = new PrintWriter(outputStream);
                printWriter.println("Manifest-Version: 1.0");
                printWriter.println("X-COMMENT: Main-Class will be added automatically by build");
                printWriter.println();
                printWriter.flush();
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    static int getNumberOfCdcPlatforms() {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
        int n = javaPlatformArray.length;
        for (JavaPlatform javaPlatform : javaPlatformArray) {
            if (javaPlatform.getInstallFolders().size() != 0) continue;
            --n;
        }
        return n;
    }
}

