/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class CvsRootRewriter {
    private static final String CVS_FOLDER = "CVS";
    private static final String ROOT_FILE = "Root";
    private final File file;
    private final String newRoot;
    private ProgressHandle handle;

    public CvsRootRewriter(File file, String string) {
        this.file = file;
        this.newRoot = string;
    }

    public void rewrite() {
        StatusDisplayer.getDefault().setStatusText("");
        try {
            Collection collection = this.scanForFiles();
            this.rewriteFolders(collection);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Success"));
        }
        catch (IOException iOException) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Failure", (Object)iOException.getMessage()));
        }
    }

    private Collection scanForFiles() throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        HashSet<File> hashSet2 = new HashSet<File>();
        hashSet2.add(this.file);
        this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Progress"));
        int n = 0;
        int n2 = 1;
        this.handle.start(100);
        int n3 = 0;
        do {
            HashSet<File> hashSet3 = new HashSet<File>();
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                iterator.remove();
                File file2 = CvsRootRewriter.getCvsRootFile(file);
                if (file2 != null) {
                    this.handle.progress(NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Scanning", (Object)file.getPath()));
                    hashSet.add(file2);
                    hashSet3.addAll(Arrays.asList(file.listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory();
                        }
                    })));
                }
                ++n;
            }
            hashSet2.addAll(hashSet3);
            n3 = Math.max(n3, (int)((double)n / (double)(n2 += hashSet2.size()) * 50.0));
            this.handle.progress(n3);
        } while (!hashSet2.isEmpty());
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteFolders(Collection collection) {
        int n = 0;
        for (File file : collection) {
            if (file.exists() && file.canWrite()) {
                Object var8_7;
                PrintStream printStream = null;
                try {
                    try {
                        printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                        printStream.println(this.newRoot);
                    }
                    catch (IOException iOException) {
                        CvsRootRewriter.notify(iOException);
                        var8_7 = null;
                        if (printStream != null) {
                            printStream.close();
                        }
                    }
                    var8_7 = null;
                    if (printStream != null) {
                        printStream.close();
                    }
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (printStream != null) {
                        printStream.close();
                    }
                    throw throwable;
                }
            }
            this.handle.progress(NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Rewriting", (Object)file.getPath()), (int)((double)(++n) / (double)collection.size() * 50.0) + 50);
        }
        this.handle.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static File getCvsRootFile(File file) throws IOException {
        File file2;
        block8: {
            if (file == null) return null;
            if (!file.isDirectory()) {
                return null;
            }
            file2 = new File(file, CVS_FOLDER + File.separator + ROOT_FILE);
            File file3 = new File(file, CVS_FOLDER + File.separator + "Repository");
            if (file3.canRead()) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file3);
                    if (((InputStream)fileInputStream).read() == 47) {
                        throw new IOException("#68881 Absolute CVS/Repository paths are unsupported.");
                    }
                    Object var5_4 = null;
                    if (fileInputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        ((InputStream)fileInputStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)fileInputStream).close();
            }
        }
        if (!file2.exists()) return null;
        if (file2.isDirectory()) return null;
        File file4 = file2;
        return file4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    static String getCvsRoot(File file) throws IOException {
        File file2 = CvsRootRewriter.getCvsRootFile(file);
        if (file2 == null) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            String string = bufferedReader.readLine();
            Object var6_6 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                CvsRootRewriter.notify(iOException);
            }
            {
                return string;
                catch (IOException iOException) {
                    CvsRootRewriter.notify(iOException);
                    String string2 = null;
                    Object var6_7 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        CvsRootRewriter.notify(iOException2);
                    }
                    return string2;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    CvsRootRewriter.notify(iOException);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            CvsRootRewriter.notify(fileNotFoundException);
            return null;
        }
    }

    private static void notify(Throwable throwable) {
        ErrorManager.getDefault().notify(65536, throwable);
    }
}

