/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.xslt.mapper.model.nodes.TreeNode;
import org.netbeans.modules.xslt.mapper.view.XsltMapper;

public abstract class XsltNodesTreeModel
implements TreeModel {
    private TreeNode myRootNode;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private XsltMapper mapper;

    public XsltNodesTreeModel(XsltMapper xsltMapper) {
        this.mapper = xsltMapper;
        this.resetRoot();
    }

    public abstract TreeNode loadRoot();

    public XsltMapper getMapper() {
        return this.mapper;
    }

    public Object getRoot() {
        return this.myRootNode;
    }

    public void resetRoot() {
        TreeNode treeNode = this.loadRoot();
        if (treeNode != null && this.myRootNode != null && treeNode.getDataObject() == this.myRootNode.getDataObject()) {
            return;
        }
        if (this.myRootNode != null) {
            this.myRootNode.removeFromTree();
        }
        this.myRootNode = treeNode;
    }

    public int getIndexOfChild(Object object, Object object2) {
        assert (object instanceof TreeNode);
        assert (object2 instanceof TreeNode);
        List<TreeNode> list = ((TreeNode)object).getChildren();
        return list.indexOf(object2);
    }

    public Object getChild(Object object, int n) {
        assert (object instanceof TreeNode);
        List<TreeNode> list = ((TreeNode)object).getChildren();
        return list.get(n);
    }

    public boolean isLeaf(Object object) {
        assert (object instanceof TreeNode);
        return ((TreeNode)object).getChildren().isEmpty();
    }

    public int getChildCount(Object object) {
        assert (object instanceof TreeNode);
        return ((TreeNode)object).getChildren().size();
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void fireTreeChanged(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }
}

