/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.model;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.mapper.model.TreeExpandedState;
import org.netbeans.modules.xslt.mapper.model.XsltModelBridge;
import org.netbeans.modules.xslt.mapper.model.XsltNodesTreeModel;
import org.netbeans.modules.xslt.mapper.model.nodes.TreeNode;
import org.netbeans.modules.xslt.mapper.view.XsltMapper;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.Template;
import org.netbeans.modules.xslt.model.XslModel;
import org.openide.util.NbBundle;

public abstract class ModelBridge
implements ComponentListener,
PropertyChangeListener {
    private UpdateTimer updateTimer = new UpdateTimer();
    private XsltMapper mapper;

    public ModelBridge(XsltMapper xsltMapper) {
        this.mapper = xsltMapper;
    }

    public XsltMapper getMapper() {
        return this.mapper;
    }

    protected void subscribe(Model model) {
        if (model != null) {
            model.addComponentListener((ComponentListener)this);
            model.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected abstract void onModelChanged();

    /*
     * Enabled aggressive block sorting
     */
    protected boolean checkErrors() {
        String string = "";
        if (this.getMapper().getContext() != null) {
            List list;
            Stylesheet stylesheet;
            XslModel xslModel;
            String string2 = this.getMapper().getContext().getValidationMessage();
            if (string2 != null) {
                string = string + string2;
            }
            if ((xslModel = this.getMapper().getContext().getXSLModel()) == null || xslModel.getState() != Model.State.VALID) {
                string = string + NbBundle.getMessage(XsltModelBridge.class, (String)"MSG_Error_BadXSL");
            } else {
                stylesheet = xslModel.getStylesheet();
                if (stylesheet == null) {
                    string = string + NbBundle.getMessage(XsltModelBridge.class, (String)"MSG_Error_NoStylesheet");
                } else {
                    list = stylesheet.getChildren(Template.class);
                    boolean bl = false;
                    for (Template template : list) {
                        if (template.getMatch() == null || !template.getMatch().equals("/")) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        string = string + NbBundle.getMessage(XsltModelBridge.class, (String)"MSG_Error_NoRootTemplate");
                    }
                }
            }
            stylesheet = this.getMapper().getContext().getSourceType();
            if (stylesheet == null || stylesheet.getModel() == null || stylesheet.getModel().getState() != Model.State.VALID) {
                // empty if block
            }
            if ((list = this.getMapper().getContext().getTargetType()) != null && list.getModel() != null && list.getModel().getState() == Model.State.VALID) {
                // empty if block
            }
        } else {
            string = string + NbBundle.getMessage(XsltModelBridge.class, (String)"MSG_Error_BadXSLTMAP");
        }
        if (string != null && !"".equals(string)) {
            this.mapper.setError(NbBundle.getMessage(XsltModelBridge.class, (String)"MSG_Error_Diagram", (Object)string));
            return false;
        }
        this.mapper.setError(null);
        return true;
    }

    protected void reloadTree(JTree jTree) {
        TreeExpandedState treeExpandedState = new TreeExpandedState(jTree);
        treeExpandedState.save();
        XsltNodesTreeModel xsltNodesTreeModel = (XsltNodesTreeModel)jTree.getModel();
        xsltNodesTreeModel.resetRoot();
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        TreePath treePath = TreeNode.getTreePath(treeNode);
        treeNode.reload();
        ((XsltNodesTreeModel)jTree.getModel()).fireTreeChanged(treePath);
        treeExpandedState.restore();
    }

    public void valueChanged(ComponentEvent componentEvent) {
        this.updateDiagram();
    }

    public void childrenAdded(ComponentEvent componentEvent) {
        this.updateDiagram();
    }

    public void childrenDeleted(ComponentEvent componentEvent) {
        this.updateDiagram();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateDiagram();
    }

    public void updateDiagram() {
        this.updateTimer.onEvent();
    }

    private class UpdateTimer {
        private Timer timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModelBridge.this.onModelChanged();
            }
        });

        public UpdateTimer() {
            this.timer.setRepeats(false);
        }

        public void onEvent() {
            if (this.timer.isRunning()) {
                this.timer.restart();
            } else {
                this.timer.start();
            }
        }
    }
}

