/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.validation.util;

import java.io.File;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LineUtil {
    public static final String FOUND_VALIDATION_ERRORS = "Found validation error(s).";

    private LineUtil() {
    }

    public static Line.Part getLinePart(Validator.ResultItem resultItem) {
        Line line = LineUtil.getLine(resultItem);
        if (line == null) {
            return null;
        }
        int n = LineUtil.getColumnNumber(resultItem.getComponents());
        if (n == -1) {
            n = 0;
        }
        int n2 = line.getText().length() - n;
        return line.createPart(n, n2);
    }

    public static Line getLine(Validator.ResultItem resultItem) {
        DataObject dataObject;
        Component component = resultItem.getComponents();
        int n = component == null ? resultItem.getLineNumber() - 1 : LineUtil.getLineNumber(resultItem.getComponents());
        if (n < 1) {
            return null;
        }
        FileObject fileObject = SoaUtil.getFileObjectByModel((Model)(component == null ? resultItem.getModel() : component.getModel()));
        if (fileObject == null) {
            return null;
        }
        LineCookie lineCookie = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        if (lineCookie == null) {
            return null;
        }
        dataObject = lineCookie.getLineSet().getCurrent(n);
        if (dataObject == null) {
            return null;
        }
        return lineCookie.getLineSet().getCurrent(n);
    }

    public static String getValidationError(File file, Validator.ResultItem resultItem) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LineUtil.getLocation(file, resultItem.getComponents()));
        String string = resultItem.getDescription();
        String string2 = resultItem.getType().name();
        stringBuffer.append("\n" + string2 + ": " + string);
        return stringBuffer.toString();
    }

    public static String getLocation(File file, Component component) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = LineUtil.getLineNumber(component) + 1;
        int n2 = LineUtil.getColumnNumber(component);
        if (file != null) {
            stringBuffer.append(file.getPath().replace("\\", "/"));
            if (n != -1) {
                stringBuffer.append(":");
                stringBuffer.append(n);
            }
            if (n2 != -1) {
                stringBuffer.append(": ");
                stringBuffer.append(n2);
            }
        }
        return stringBuffer.toString();
    }

    private static int getColumnNumber(Component component) {
        AbstractDocument abstractDocument = LineUtil.getAbstractDocument(component);
        if (abstractDocument == null) {
            return -1;
        }
        int n = LineUtil.findPosition((AbstractDocumentModel)component.getModel(), ((AbstractDocumentComponent)component).getPeer());
        return LineUtil.findColumn(abstractDocument, n);
    }

    private static AbstractDocument getAbstractDocument(Component component) {
        if (component == null) {
            return null;
        }
        Model model = component.getModel();
        if (model == null) {
            return null;
        }
        ModelSource modelSource = model.getModelSource();
        if (modelSource == null) {
            return null;
        }
        return (AbstractDocument)modelSource.getLookup().lookup(AbstractDocument.class);
    }

    private static int getLineNumber(Component component) {
        if (!(component instanceof DocumentComponent)) {
            return -1;
        }
        DocumentComponent documentComponent = (DocumentComponent)component;
        if (documentComponent == null) {
            return -1;
        }
        Model model = documentComponent.getModel();
        if (model == null) {
            return -1;
        }
        ModelSource modelSource = model.getModelSource();
        if (modelSource == null) {
            return -1;
        }
        Lookup lookup = modelSource.getLookup();
        if (lookup == null) {
            return -1;
        }
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)documentComponent.findPosition());
    }

    private static int findColumn(AbstractDocument abstractDocument, int n) {
        javax.swing.text.Element element = LineUtil.findLineRootElement(abstractDocument);
        int n2 = element.getElementIndex(n);
        return n - element.getElement(n2).getStartOffset();
    }

    private static int findPosition(AbstractDocumentModel abstractDocumentModel, Node node) {
        Element element = abstractDocumentModel.getRootComponent().getPeer();
        Document document = abstractDocumentModel.getBaseDocument();
        try {
            String string = document.getText(0, document.getLength());
            if (node instanceof Element) {
                return LineUtil.findPosition((Element)node, string, element, LineUtil.getRootElementPosition(string, element));
            }
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        return -1;
    }

    private static javax.swing.text.Element findLineRootElement(AbstractDocument abstractDocument) {
        javax.swing.text.Element element = abstractDocument.getParagraphElement(0).getParentElement();
        if (element == null) {
            element = abstractDocument.getDefaultRootElement();
        }
        return element;
    }

    private static int getRootElementPosition(String string, Element element) {
        Node node;
        NodeList nodeList = element.getOwnerDocument().getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength() && (node = nodeList.item(i)) != element; ++i) {
            String string2 = node.getNodeValue();
            if (string2 == null) continue;
            n += string2.length();
        }
        return string.indexOf(element.getTagName(), n);
    }

    private static int findPosition(Element element, String string, Element element2, Integer n) {
        if (element == element2) {
            return n;
        }
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) {
                object = node.getNodeValue();
                if (object == null) {
                    object = node.getTextContent();
                }
                if (object == null) continue;
                n = n + ((String)object).length();
                continue;
            }
            object = (Element)nodeList.item(i);
            String string2 = "<" + object.getTagName();
            n = string.indexOf(string2, (int)n);
            if (object == element) {
                return n;
            }
            int n2 = LineUtil.findPosition(element, string, (Element)object, n);
            if (n2 <= -1) continue;
            return n2;
        }
        return -1;
    }
}

