/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.spi;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.xml.search.api.SearchElement;
import org.netbeans.modules.xml.search.api.SearchEvent;
import org.netbeans.modules.xml.search.api.SearchException;
import org.netbeans.modules.xml.search.api.SearchOption;
import org.netbeans.modules.xml.search.api.SearchPattern;
import org.netbeans.modules.xml.search.spi.SearchListener;

public interface SearchEngine {
    public void search(SearchOption var1) throws SearchException;

    public boolean isApplicable(Object var1);

    public void addSearchListener(SearchListener var1);

    public void removeSearchListeners();

    public String getDisplayName();

    public String getShortDescription();

    public static abstract class Adapter
    implements SearchEngine {
        private SearchPattern mySearchPattern;
        private List<SearchListener> mySearchListeners;

        public Adapter() {
            this.removeSearchListeners();
        }

        public Object[] getTargets() {
            return new Object[0];
        }

        public synchronized void addSearchListener(SearchListener searchListener) {
            this.mySearchListeners.add(searchListener);
        }

        public synchronized void removeSearchListeners() {
            this.mySearchListeners = new LinkedList<SearchListener>();
        }

        protected final synchronized void fireSearchStarted(SearchOption searchOption) throws SearchException {
            try {
                this.createSearchPattern(searchOption);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SearchException(patternSyntaxException.getMessage());
            }
            SearchEvent.Adapter adapter = new SearchEvent.Adapter(searchOption, null);
            for (SearchListener searchListener : this.mySearchListeners) {
                searchListener.searchStarted(adapter);
            }
        }

        protected final synchronized void fireSearchFound(SearchElement searchElement) {
            SearchEvent.Adapter adapter = new SearchEvent.Adapter(null, searchElement);
            for (SearchListener searchListener : this.mySearchListeners) {
                searchListener.searchFound(adapter);
            }
        }

        protected final synchronized void fireSearchFinished(SearchOption searchOption) {
            SearchEvent.Adapter adapter = new SearchEvent.Adapter(searchOption, null);
            for (SearchListener searchListener : this.mySearchListeners) {
                searchListener.searchFinished(adapter);
            }
        }

        protected final boolean accepts(String string) {
            return this.mySearchPattern.accepts(string);
        }

        private void createSearchPattern(SearchOption searchOption) {
            this.mySearchPattern = new SearchPattern(searchOption.getText(), searchOption.getSearchMatch(), searchOption.isCaseSensitive());
        }
    }
}

