/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.api;

import java.util.regex.Pattern;
import org.netbeans.modules.xml.search.api.SearchMatch;

public final class SearchPattern {
    private String myText;
    private boolean myCaseSensitive;
    private SearchMatch mySearchMatch;
    private Pattern myPattern;

    public SearchPattern(String string, SearchMatch searchMatch, boolean bl) {
        this.myText = string;
        this.mySearchMatch = searchMatch;
        this.myCaseSensitive = bl;
        if (this.mySearchMatch == SearchMatch.PATTERN) {
            this.myText = this.replace(this.myText);
        }
        if (this.mySearchMatch == SearchMatch.PATTERN || this.mySearchMatch == SearchMatch.REGULAR_EXPRESSION) {
            int n = 0;
            if (!this.myCaseSensitive) {
                n |= 2;
            }
            this.myPattern = Pattern.compile(this.myText, n);
        }
    }

    public boolean accepts(String string) {
        if (string == null) {
            return this.myText == null;
        }
        if (this.myText == null) {
            return string == null;
        }
        if (this.mySearchMatch == SearchMatch.PATTERN || this.mySearchMatch == SearchMatch.REGULAR_EXPRESSION) {
            return this.regexp(string);
        }
        return this.text(string);
    }

    private boolean regexp(String string) {
        return this.myPattern.matcher(string).find();
    }

    private boolean text(String string) {
        if (this.myCaseSensitive) {
            return this.myText.equals(string);
        }
        return this.myText.equalsIgnoreCase(string);
    }

    private String replace(String string) {
        StringBuffer stringBuffer = new StringBuffer("^");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("$^.+(){}[]|\\".indexOf(c) != -1) {
                stringBuffer.append("\\" + c);
                continue;
            }
            if (c == '?') {
                stringBuffer.append(".");
                continue;
            }
            if (c == '*') {
                stringBuffer.append(".*");
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('$');
        return stringBuffer.toString();
    }
}

