/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceConfigurator;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceWizardPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.setFocus;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Field;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CPVendorPanel
extends ResourceWizardPanel
implements ChangeListener,
DocumentListener,
ListDataListener {
    static final long serialVersionUID = 93474632245456421L;
    private ArrayList dbconns;
    private ResourceConfigHelper helper;
    private FieldGroup generalGroup;
    private FieldGroup propGroup;
    private FieldGroup vendorGroup;
    private boolean useExistingConnection = true;
    private String[] vendors;
    private boolean firstTime = true;
    private boolean setupValid = true;
    private static final String CONST_TRUE = "true";
    private JTextArea descriptionTextArea;
    private JComboBox existingConnComboBox;
    private JRadioButton existingConnRadioButton;
    private JCheckBox isXA;
    private JPanel jPanel1;
    private JComboBox nameComboBox;
    private JTextField nameField;
    private JLabel nameLabel;
    private JRadioButton newCofigRadioButton;

    public CPVendorPanel(ResourceConfigHelper resourceConfigHelper, Wizard wizard) {
        int n;
        Object object;
        this.helper = resourceConfigHelper;
        this.generalGroup = FieldGroupHelper.getFieldGroup(wizard, "general");
        this.propGroup = FieldGroupHelper.getFieldGroup(wizard, "properties");
        this.vendorGroup = FieldGroupHelper.getFieldGroup(wizard, "propertiesUrl");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.dbconns = new ArrayList();
        this.setName(this.bundle.getString("TITLE_ConnPoolWizardPanel_dbConn"));
        this.initComponents();
        this.nameLabel.setLabelFor(this.nameField);
        this.nameComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPVendorPanel.this.nameComboBox.requestFocus();
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        buttonGroup.add(this.existingConnRadioButton);
        buttonGroup.add(this.newCofigRadioButton);
        buttonGroup.getSelection().addChangeListener(this);
        try {
            object = ConnectionManager.getDefault().getConnections();
            for (n = 0; n < ((DatabaseConnection[])object).length; ++n) {
                this.existingConnComboBox.addItem(object[n].getName());
                this.dbconns.add(object[n]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.existingConnComboBox.getItemCount() == 0) {
            this.existingConnComboBox.insertItemAt(this.bundle.getString("NoConnection"), 0);
            this.newCofigRadioButton.setSelected(true);
            this.newCofigRadioButton.setEnabled(true);
            this.nameComboBox.setEnabled(true);
            this.existingConnComboBox.setEnabled(false);
        } else {
            this.existingConnComboBox.insertItemAt(this.bundle.getString("SelectFromTheList"), 0);
            this.existingConnRadioButton.setSelected(true);
            this.existingConnRadioButton.setEnabled(true);
            this.existingConnComboBox.setEnabled(true);
            this.nameComboBox.setEnabled(false);
            this.setExistingConnData();
        }
        object = FieldHelper.getField(this.generalGroup, "database-vendor");
        this.vendors = FieldHelper.getTags((Field)((Object)object));
        for (n = 0; n < this.vendors.length; ++n) {
            this.nameComboBox.addItem(this.bundle.getString("DBVendor_" + this.vendors[n]));
        }
        if (this.nameComboBox.getItemCount() == 0) {
            this.nameComboBox.insertItemAt(this.bundle.getString("NoTemplate"), 0);
        } else {
            this.nameComboBox.insertItemAt(this.bundle.getString("SelectFromTheList"), 0);
        }
        this.nameComboBox.setSelectedIndex(0);
        this.existingConnComboBox.getModel().addListDataListener(this);
        this.nameComboBox.getModel().addListDataListener(this);
        this.isXA.setSelected(resourceConfigHelper.getData().getString("isXA").equals(CONST_TRUE));
        this.isXA.addChangeListener(this);
        this.newCofigRadioButton.addChangeListener(this);
        this.firstTime = false;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.descriptionTextArea = new JTextArea();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.existingConnRadioButton = new JRadioButton();
        this.existingConnComboBox = new JComboBox();
        this.newCofigRadioButton = new JRadioButton();
        this.nameComboBox = new JComboBox();
        this.isXA = new JCheckBox();
        this.setMaximumSize(new Dimension(600, 350));
        this.setMinimumSize(new Dimension(600, 350));
        this.setPreferredSize(new Dimension(600, 350));
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(5);
        this.descriptionTextArea.setText(NbBundle.getMessage(CPVendorPanel.class, (String)"Description"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setFocusable(false);
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setRequestFocusEnabled(false);
        this.descriptionTextArea.setVerifyInputWhenFocusTarget(false);
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CPVendorPanel.class, (String)"LBL_pool-name"));
        this.nameField.setText(this.helper.getData().getString("name"));
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPVendorPanel.this.nameFieldActionPerformed(actionEvent);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CPVendorPanel.this.nameFieldKeyReleased(keyEvent);
            }
        });
        this.existingConnRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.existingConnRadioButton, (String)NbBundle.getMessage(CPVendorPanel.class, (String)"ExistingConnection"));
        this.existingConnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPVendorPanel.this.existingConnComboBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.newCofigRadioButton, (String)NbBundle.getMessage(CPVendorPanel.class, (String)"NewConfiguration"));
        this.nameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPVendorPanel.this.nameComboBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.isXA, (String)NbBundle.getMessage(CPVendorPanel.class, (String)"isXA"));
        this.isXA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPVendorPanel.this.isXAActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(30, 30, 30).add((Component)this.existingConnComboBox, 0, 539, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.isXA).addContainerGap()).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.nameComboBox, 0, 538, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.newCofigRadioButton).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.existingConnRadioButton).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.nameLabel).add(10, 10, 10).add((Component)this.nameField, -1, 404, Short.MAX_VALUE).addContainerGap())))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.descriptionTextArea, -1, 560, Short.MAX_VALUE).add(9, 9, 9)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.descriptionTextArea).add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameField, -2, -1, -2).add((Component)this.nameLabel)).add(18, 18, 18).add((Component)this.existingConnRadioButton).addPreferredGap(1).add((Component)this.existingConnComboBox, -2, -1, -2).addPreferredGap(1).add((Component)this.newCofigRadioButton).addPreferredGap(1).add((Component)this.nameComboBox, -2, -1, -2).add(18, 18, 18).add((Component)this.isXA).add(67, 67, 67)));
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_DescriptionA11yName"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_DescriptionA11yDesc"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_pool-nameA11yDesc"));
        this.existingConnRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_ExistingConnectionA11yDesc"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_ExistingConnectionComboBoxA11yName"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_ExistingConnectionComboBoxA11yDesc"));
        this.newCofigRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_NewConnectionA11yDesc"));
        this.nameComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_NewConnectionComboBoxA11yName"));
        this.nameComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_NewConnectionComboBoxA11yDesc"));
        this.isXA.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"ACS_isXA_A11yDesc"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(11, 11, 11)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CPVendorPanel.class, (String)"TITLE_ConnPoolWizardPanel_dbConn"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CPVendorPanel.class, (String)"TITLE_ConnPoolWizardPanel_dbConn"));
    }

    private void nameFieldKeyReleased(KeyEvent keyEvent) {
        String string;
        ResourceConfigData resourceConfigData = this.helper.getData();
        String string2 = resourceConfigData.getString("name");
        if (!string2.equals(string = this.nameField.getText())) {
            this.helper.getData().setString("name", string);
        }
        this.fireChange(this);
    }

    private void nameFieldActionPerformed(ActionEvent actionEvent) {
        this.setResourceName();
    }

    public String getNameField() {
        return this.nameField.getText();
    }

    private void setResourceName() {
        String string;
        ResourceConfigData resourceConfigData = this.helper.getData();
        String string2 = resourceConfigData.getString("name");
        if (!string2.equals(string = this.nameField.getText())) {
            this.helper.getData().setString("name", string);
            this.fireChange(this);
        }
        if (this.getRootPane().getDefaultButton() != null && this.getRootPane().getDefaultButton().isEnabled()) {
            this.getRootPane().getDefaultButton().doClick();
        }
    }

    private void isXAActionPerformed(ActionEvent actionEvent) {
        this.setNewConfigData(false);
    }

    private void nameComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setNewConfigData(true);
    }

    private void setNewConfigData(boolean bl) {
        if (this.firstTime) {
            return;
        }
        int n = this.nameComboBox.getSelectedIndex();
        if (n > 0) {
            if (this.useExistingConnection) {
                this.useExistingConnection = false;
            }
            ResourceConfigData resourceConfigData = this.helper.getData();
            resourceConfigData.setString("is-cp-existing", "false");
            String string = this.vendors[n - 1];
            String string2 = resourceConfigData.getString("database-vendor");
            String string3 = resourceConfigData.getString("isXA");
            String string4 = this.isXA.isSelected() ? CONST_TRUE : "false";
            boolean bl2 = string.equals(string2);
            boolean bl3 = string4.equals(string3);
            if (bl2 && bl3) {
                return;
            }
            if (!bl2) {
                resourceConfigData.setString("database-vendor", string);
            }
            if (!bl3) {
                resourceConfigData.setString("isXA", string4);
            }
            this.setDataSourceClassNameAndResTypeInData(string);
            if (bl) {
                this.setPropertiesInData(string);
            }
        }
    }

    private void setDataSourceClassNameAndResTypeInData(String string) {
        ResourceConfigData resourceConfigData = this.helper.getData();
        Field field = this.isXA.isSelected() ? FieldHelper.getField(this.generalGroup, "datasource-classname-xa") : FieldHelper.getField(this.generalGroup, "datasource-classname");
        resourceConfigData.setString("datasource-classname", FieldHelper.getConditionalFieldValue(field, string));
        if (this.isXA.isSelected()) {
            resourceConfigData.setString("res-type", "javax.sql.XADataSource");
            resourceConfigData.setString("isXA", CONST_TRUE);
        } else {
            resourceConfigData.setString("res-type", "javax.sql.DataSource");
            resourceConfigData.setString("isXA", "false");
        }
    }

    private void setPropertiesInData(String string) {
        ResourceConfigData resourceConfigData = this.helper.getData();
        resourceConfigData.setProperties(new Vector());
        Field[] fieldArray = this.propGroup.getField();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string2 = FieldHelper.getConditionalFieldValue(fieldArray[i], string);
            String string3 = fieldArray[i].getName();
            if (string3.equals("URL") && string2.length() > 0) {
                resourceConfigData.addProperty(string3, FieldHelper.toUrl(string2));
                continue;
            }
            if (string3.equals("databaseName") && string2.length() > 0) {
                resourceConfigData.addProperty(string3, FieldHelper.toUrl(string2));
                continue;
            }
            if (string3.equals("User") || string3.equals("Password")) {
                resourceConfigData.addProperty(fieldArray[i].getName(), string2);
                continue;
            }
            if (string2.length() <= 0 || !string2.equals("NA")) continue;
            resourceConfigData.addProperty(fieldArray[i].getName(), "");
        }
    }

    private void existingConnComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setExistingConnData();
    }

    public void setExistingConnData() {
        if (this.existingConnComboBox.getSelectedIndex() > 0) {
            if (!this.useExistingConnection) {
                this.helper.getData().setResourceName("jdbc-connection-pool");
                this.useExistingConnection = true;
            }
            this.helper.getData().setString("is-cp-existing", CONST_TRUE);
            DatabaseConnection databaseConnection = (DatabaseConnection)this.dbconns.get(this.existingConnComboBox.getSelectedIndex() - 1);
            String string = databaseConnection.getDatabaseURL();
            String string2 = databaseConnection.getUser();
            String string3 = databaseConnection.getPassword();
            if (string2 != null && (string3 == null || string3.trim().length() == 0)) {
                string3 = "()";
            }
            String string4 = string;
            Field field = FieldHelper.getField(this.vendorGroup, "vendorUrls");
            String string5 = FieldHelper.getOptionNameFromValue(field, string4);
            ResourceConfigData resourceConfigData = this.helper.getData();
            resourceConfigData.setProperties(new Vector());
            resourceConfigData.setString("database-vendor", string5);
            if (string5.equals("pointbase")) {
                resourceConfigData.addProperty("databaseName", databaseConnection.getDatabaseURL());
            } else if (string5.startsWith("derby")) {
                this.setDerbyProps(string5, string);
            } else {
                resourceConfigData.addProperty("URL", string);
            }
            resourceConfigData.addProperty("User", string2);
            resourceConfigData.addProperty("Password", string3);
            this.setDataSourceClassNameAndResTypeInData(string5);
        }
    }

    private void setDerbyProps(String string, String string2) {
        ResourceConfigData resourceConfigData = this.helper.getData();
        resourceConfigData.setProperties(new Vector());
        resourceConfigData.addProperty("URL", string2);
        Field[] fieldArray = this.propGroup.getField();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string3 = FieldHelper.getConditionalFieldValue(fieldArray[i], string);
            if (!string3.equals("NA")) continue;
            String string4 = fieldArray[i].getName();
            if (!string.equals("derby_net")) continue;
            String string5 = "";
            String string6 = "";
            String string7 = "";
            try {
                String string8 = string2.substring(string2.indexOf("//") + 2, string2.length());
                ResourceConfigurator resourceConfigurator = new ResourceConfigurator();
                string5 = resourceConfigurator.getDerbyServerName(string8);
                string6 = resourceConfigurator.getDerbyPortNo(string8);
                string7 = resourceConfigurator.getDerbyDatabaseName(string8);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            if (string4.equals("PortNumber")) {
                resourceConfigData.addProperty(string4, string6);
                continue;
            }
            if (string4.equals("DatabaseName")) {
                resourceConfigData.addProperty(string4, string7);
                continue;
            }
            if (!string4.equals("serverName")) continue;
            resourceConfigData.addProperty(string4, string5);
        }
    }

    public boolean isValid() {
        if (!this.setupValid) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidSetup"));
            return false;
        }
        this.setErrorMsg(this.bundle.getString("Empty_String"));
        String string = this.nameField.getText();
        if (string == null || string.length() == 0) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidName"));
            return false;
        }
        if (!ResourceUtils.isLegalResourceName(string)) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidName"));
            return false;
        }
        if (!ResourceUtils.isUniqueFileName(string, this.helper.getData().getTargetFileObject(), "connectionPool")) {
            this.setErrorMsg(this.bundle.getString("Err_DuplFileName"));
            return false;
        }
        if (this.existingConnRadioButton.isSelected()) {
            if (this.existingConnComboBox.getSelectedIndex() > 0) {
                return true;
            }
            this.setErrorMsg(this.bundle.getString("Err_ChooseDBConn"));
        } else if (this.newCofigRadioButton.isSelected()) {
            if (this.nameComboBox.getSelectedIndex() > 0) {
                return true;
            }
            this.setErrorMsg(this.bundle.getString("Err_ChooseDBVendor"));
        }
        return false;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange(this);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange(this);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange(this);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.firstTime) {
            return;
        }
        if (changeEvent.getSource().getClass() == JToggleButton.ToggleButtonModel.class) {
            if (this.existingConnRadioButton.isSelected()) {
                if (this.firstTime) {
                    return;
                }
                this.existingConnComboBox.setEnabled(true);
                this.nameComboBox.setEnabled(false);
                this.setExistingConnData();
            } else {
                this.existingConnComboBox.setEnabled(false);
                this.nameComboBox.setEnabled(true);
                this.setNewConfigData(true);
            }
        }
        this.fireChange(this);
    }

    public CPVendorPanel setFirstTime(boolean bl) {
        this.firstTime = bl;
        return this;
    }

    protected void initData() {
    }

    public HelpCtx getHelp() {
        return new HelpCtx("AS_Wiz_ConnPool_chooseDB");
    }

    public void readSettings(Object object) {
        this.wizDescriptor = (WizardDescriptor)object;
        TemplateWizard templateWizard = (TemplateWizard)object;
        String string = templateWizard.getTargetName();
        if (this.helper.getData().getString("dynamicPanel").equals(CONST_TRUE)) {
            string = null;
        }
        FileObject fileObject = ResourceUtils.getResourceDirectory(this.helper.getData().getTargetFileObject());
        this.helper.getData().setTargetFileObject(fileObject);
        if (fileObject != null) {
            String string2 = this.helper.getData().getString("name");
            if (string2 != null && !string2.equals("")) {
                string = string2;
            }
            string = ResourceUtils.createUniqueFileName(string, fileObject, "connectionPool");
            this.helper.getData().setTargetFile(string);
            this.nameField.setText(string);
            this.helper.getData().setString("name", string);
        } else {
            this.setupValid = false;
        }
    }

    public void setInitialFocus() {
        new setFocus(this.nameField);
    }
}

