/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.MonitorInfo;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.Java6Methods;
import org.netbeans.modules.debugger.jpda.SingleThreadWatcher;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.MonitorInfoImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPDAThreadImpl
implements JPDAThread,
Customizer {
    private static final String PROP_LOCKER_THREADS = "lockerThreads";
    private static final String PROP_STEP_SUSPENDED_BY_BREAKPOINT = "stepSuspendedByBreakpoint";
    private ThreadReference threadReference;
    private JPDADebuggerImpl debugger;
    private boolean suspended;
    private int suspendCount;
    private EditorContext.Operation currentOperation;
    private List<EditorContext.Operation> lastOperations;
    private boolean doKeepLastOperations;
    private ReturnVariableImpl returnVariable;
    private PropertyChangeSupport pch = new PropertyChangeSupport(this);
    private CallStackFrame[] cachedFrames;
    private int cachedFramesFrom = -1;
    private int cachedFramesTo = -1;
    private final Object cachedFramesLock = new Object();
    private JPDABreakpoint currentBreakpoint;
    private String threadName;
    private final Object lockerThreadsLock = new Object();
    private ObjectReference lockerThreadsMonitor;
    private List<JPDAThread> lockerThreadsList;
    private List<ThreadReference> resumedBlockingThreads;
    private final Object stepBreakpointLock = new Object();
    private JPDABreakpoint stepSuspendedByBreakpoint;
    private SingleThreadWatcher watcher = null;
    private boolean methodInvoking;
    private boolean methodInvokingDisabledUntilResumed;
    private boolean resumedToFinishMethodInvocation;
    private boolean unsuspendedStateWhenInvoking;
    private boolean inStep = false;

    public JPDAThreadImpl(ThreadReference threadReference, JPDADebuggerImpl jPDADebuggerImpl) {
        this.threadReference = threadReference;
        this.debugger = jPDADebuggerImpl;
        boolean bl = false;
        this.threadName = "";
        try {
            this.threadName = threadReference.name();
            this.suspended = threadReference.isSuspended();
            this.suspendCount = threadReference.suspendCount();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            bl = true;
        }
        catch (ObjectCollectedException objectCollectedException) {
            bl = true;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            bl = true;
        }
        if (bl) {
            this.suspended = false;
            this.suspendCount = 0;
        }
    }

    public String getName() {
        return this.threadName;
    }

    public JPDAThreadGroup getParentThreadGroup() {
        try {
            ThreadGroupReference threadGroupReference = this.threadReference.threadGroup();
            if (threadGroupReference == null) {
                return null;
            }
            return this.debugger.getThreadGroup(threadGroupReference);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return null;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
    }

    public int getLineNumber(String string) {
        try {
            if (this.threadReference.frameCount() < 1) {
                return -1;
            }
            return this.threadReference.frame(0).location().lineNumber(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return -1;
    }

    public synchronized EditorContext.Operation getCurrentOperation() {
        return this.currentOperation;
    }

    public synchronized void setCurrentOperation(EditorContext.Operation operation) {
        this.currentOperation = operation;
    }

    public synchronized List<EditorContext.Operation> getLastOperations() {
        return this.lastOperations;
    }

    public synchronized void addLastOperation(EditorContext.Operation operation) {
        if (this.lastOperations == null) {
            this.lastOperations = new ArrayList<EditorContext.Operation>();
        }
        this.lastOperations.add(operation);
    }

    public synchronized void clearLastOperations() {
        if (this.lastOperations != null) {
            for (EditorContext.Operation operation : this.lastOperations) {
                operation.setReturnValue(null);
            }
        }
        this.lastOperations = null;
    }

    public synchronized void holdLastOperations(boolean bl) {
        this.doKeepLastOperations = bl;
    }

    public synchronized JPDABreakpoint getCurrentBreakpoint() {
        return this.currentBreakpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentBreakpoint(JPDABreakpoint jPDABreakpoint) {
        JPDABreakpoint jPDABreakpoint2;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            jPDABreakpoint2 = this.currentBreakpoint;
            this.currentBreakpoint = jPDABreakpoint;
        }
        this.pch.firePropertyChange("currentBreakpoint", jPDABreakpoint2, jPDABreakpoint);
    }

    public int getState() {
        try {
            return this.threadReference.status();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return -1;
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public boolean isThreadSuspended() {
        try {
            return this.threadReference.isSuspended();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return false;
    }

    public String getClassName() {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().declaringType().name();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getMethodName() {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().method().name();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getSourceName(String string) throws AbsentInformationException {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().sourceName(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getSourcePath(String string) throws AbsentInformationException {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().sourcePath(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public CallStackFrame[] getCallStack() throws AbsentInformationException {
        return this.getCallStack(0, this.getStackDepth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallStackFrame[] getCallStack(int n, int n2) throws AbsentInformationException {
        try {
            List<StackFrame> list;
            int n3;
            CallStackFrame[] callStackFrameArray = null;
            JPDAThreadImpl jPDAThreadImpl = this;
            synchronized (jPDAThreadImpl) {
                int n4 = this.threadReference.frameCount();
                n = Math.min(n, n4);
                n2 = Math.min(n2, n4);
                if (n2 - n > 1) {
                    Object object = this.cachedFramesLock;
                    synchronized (object) {
                        if (n == this.cachedFramesFrom && n2 == this.cachedFramesTo) {
                            return this.cachedFrames;
                        }
                        if (n >= this.cachedFramesFrom && n2 <= this.cachedFramesTo) {
                            return JPDAThreadImpl.copyOfRange(this.cachedFrames, n - this.cachedFramesFrom, n2 - this.cachedFramesFrom);
                        }
                        if (this.cachedFramesFrom >= 0 && this.cachedFramesTo > this.cachedFramesFrom) {
                            int n5 = n2 - n;
                            callStackFrameArray = new CallStackFrame[n5];
                            for (int i = 0; i < n5; ++i) {
                                callStackFrameArray[i] = i >= this.cachedFramesFrom && i < this.cachedFramesTo ? this.cachedFrames[i - this.cachedFramesFrom] : null;
                            }
                        }
                    }
                }
                if (n < 0) {
                    throw new IndexOutOfBoundsException("from = " + n);
                }
                if (n == n2) {
                    return new CallStackFrame[0];
                }
                if (n >= n4) {
                    throw new IndexOutOfBoundsException("from = " + n + " is too high, frame count = " + n4);
                }
                n3 = n2 - n;
                if (n3 < 0 || n + n3 > n4) {
                    throw new IndexOutOfBoundsException("from = " + n + ", to = " + n2 + ", frame count = " + n4);
                }
                try {
                    list = this.threadReference.frames(n, n3);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    IndexOutOfBoundsException indexOutOfBoundsException2 = (IndexOutOfBoundsException)Exceptions.attachMessage((Throwable)indexOutOfBoundsException, (String)("from = " + n + ", to = " + n2 + ", frame count = " + n4 + ", length = " + n3 + ", fresh frame count = " + this.threadReference.frameCount()));
                    throw indexOutOfBoundsException2;
                }
            }
            int n6 = list.size();
            CallStackFrame[] callStackFrameArray2 = new CallStackFrame[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                callStackFrameArray2[n3] = callStackFrameArray != null && callStackFrameArray[n3] != null ? callStackFrameArray[n3] : new CallStackFrameImpl(this, list.get(n3), n + n3, this.debugger);
                if (n != 0 || n3 != 0 || this.currentOperation == null) continue;
                ((CallStackFrameImpl)callStackFrameArray2[n3]).setCurrentOperation(this.currentOperation);
            }
            Object object = this.cachedFramesLock;
            synchronized (object) {
                this.cachedFrames = callStackFrameArray2;
                this.cachedFramesFrom = n;
                this.cachedFramesTo = n2;
            }
            return callStackFrameArray2;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(incompatibleThreadStateException.getLocalizedMessage());
            absentInformationException.initCause(incompatibleThreadStateException);
            throw absentInformationException;
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(invalidStackFrameException.getLocalizedMessage());
            absentInformationException.initCause(invalidStackFrameException);
            throw absentInformationException;
        }
        catch (ObjectCollectedException objectCollectedException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(objectCollectedException.getLocalizedMessage());
            absentInformationException.initCause(objectCollectedException);
            throw absentInformationException;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(illegalThreadStateException.getLocalizedMessage());
            absentInformationException.initCause(illegalThreadStateException);
            throw absentInformationException;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return new CallStackFrame[0];
        }
    }

    private static CallStackFrame[] copyOfRange(CallStackFrame[] callStackFrameArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        CallStackFrame[] callStackFrameArray2 = new CallStackFrame[n3];
        System.arraycopy(callStackFrameArray, n, callStackFrameArray2, 0, Math.min(callStackFrameArray.length - n, n3));
        return callStackFrameArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCachedFrames() {
        Object object = this.cachedFramesLock;
        synchronized (object) {
            this.cachedFrames = null;
            this.cachedFramesFrom = -1;
            this.cachedFramesTo = -1;
        }
    }

    public int getStackDepth() {
        try {
            return this.threadReference.frameCount();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popFrames(StackFrame stackFrame) throws IncompatibleThreadStateException {
        block10: {
            try {
                this.notifyToBeResumed();
                this.threadReference.popFrames(stackFrame);
                this.cleanCachedFrames();
                this.setReturnVariable(null);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                throw new IncompatibleThreadStateException("Thread exited.");
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw new IncompatibleThreadStateException("Thread died.");
            }
            catch (NativeMethodException nativeMethodException) {
                this.cleanCachedFrames();
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)nativeMethodException, NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NativeMethodPop")));
            }
            catch (InternalException internalException) {
                this.cleanCachedFrames();
                if (internalException.errorCode() == 32) {
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)internalException, NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NativeMethodPop")));
                    break block10;
                }
                throw internalException;
            }
            finally {
                this.notifySuspended();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Boolean bl = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            try {
                if (!this.isSuspended()) {
                    this.threadReference.suspend();
                    bl = Boolean.TRUE;
                    ++this.suspendCount;
                    this.threadName = this.threadReference.name();
                }
                this.suspended = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (bl != null) {
            this.pch.firePropertyChange("suspended", (Object)(bl == false ? 1 : 0), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean bl;
        if (this == this.debugger.getCurrentThread() && !(bl = this.debugger.currentThreadToBeResumed())) {
            return;
        }
        Boolean bl2 = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            this.waitUntilMethodInvokeDone();
            this.setReturnVariable(null);
            this.setCurrentOperation(null);
            this.currentBreakpoint = null;
            if (!this.doKeepLastOperations) {
                this.clearLastOperations();
            }
            try {
                if (this.isSuspended()) {
                    for (int i = this.threadReference.suspendCount(); i > 0; --i) {
                        this.threadReference.resume();
                    }
                    bl2 = Boolean.FALSE;
                }
                this.suspendCount = 0;
                this.suspended = false;
                this.methodInvokingDisabledUntilResumed = false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        jPDAThreadImpl = null;
        Object object = this.stepBreakpointLock;
        synchronized (object) {
            if (this.stepSuspendedByBreakpoint != null) {
                jPDAThreadImpl = this.stepSuspendedByBreakpoint;
            }
        }
        if (jPDAThreadImpl != null) {
            this.pch.firePropertyChange(PROP_STEP_SUSPENDED_BY_BREAKPOINT, jPDAThreadImpl, null);
        }
        this.cleanCachedFrames();
        if (bl2 != null) {
            this.pch.firePropertyChange("suspended", (Object)(bl2 == false ? 1 : 0), bl2);
        }
    }

    public void notifyToBeResumed() {
        List<PropertyChangeEvent> list = this.notifyToBeRunning(true, true);
        for (PropertyChangeEvent propertyChangeEvent : list) {
            this.pch.firePropertyChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyChangeEvent> notifyToBeRunning(boolean bl, boolean bl2) {
        Boolean bl3 = null;
        Object object = this;
        synchronized (object) {
            if (bl2) {
                this.waitUntilMethodInvokeDone();
            }
            if (bl2 && --this.suspendCount > 0) {
                return Collections.emptyList();
            }
            this.suspendCount = 0;
            if (bl) {
                this.setCurrentOperation(null);
                this.setReturnVariable(null);
                this.currentBreakpoint = null;
                if (!this.doKeepLastOperations) {
                    this.clearLastOperations();
                }
            }
            if (this.suspended) {
                this.suspended = false;
                bl3 = Boolean.FALSE;
                this.methodInvokingDisabledUntilResumed = false;
            }
        }
        this.cleanCachedFrames();
        object = null;
        Object object2 = this.stepBreakpointLock;
        synchronized (object2) {
            if (this.stepSuspendedByBreakpoint != null) {
                object = new PropertyChangeEvent(this, PROP_STEP_SUSPENDED_BY_BREAKPOINT, this.stepSuspendedByBreakpoint, null);
                this.stepSuspendedByBreakpoint = null;
            }
        }
        if (bl3 != null) {
            object2 = new PropertyChangeEvent(this, "suspended", bl3 == false, bl3);
            if (object != null) {
                return Arrays.asList(object, object2);
            }
            return Collections.singletonList(object2);
        }
        if (object != null) {
            return Collections.singletonList(object);
        }
        return Collections.emptyList();
    }

    public void notifySuspended() {
        this.notifySuspended(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuspended(boolean bl) {
        Boolean bl2 = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            try {
                this.suspendCount = this.threadReference.suspendCount();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            catch (ObjectCollectedException objectCollectedException) {
                return;
            }
            if (!this.suspended && this.isThreadSuspended()) {
                this.suspended = true;
                bl2 = Boolean.TRUE;
                this.threadName = this.threadReference.name();
            }
        }
        if (bl2 != null && bl) {
            this.pch.firePropertyChange("suspended", (Object)(bl2 == false ? 1 : 0), bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvoking() throws PropertyVetoException {
        List<Object> list;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (this.methodInvokingDisabledUntilResumed) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_DisabledUntilResumed"), null);
            }
            if (this.methodInvoking) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_AlreadyInvoking"), null);
            }
            if (!this.isThreadSuspended()) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NoCurrentContext"), null);
            }
            this.methodInvoking = true;
            this.unsuspendedStateWhenInvoking = !this.isSuspended();
            list = this.unsuspendedStateWhenInvoking ? Collections.emptyList() : this.notifyToBeRunning(false, false);
            this.watcher = new SingleThreadWatcher(this);
        }
        for (PropertyChangeEvent propertyChangeEvent : list) {
            this.pch.firePropertyChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvokeDone() {
        boolean bl;
        SingleThreadWatcher singleThreadWatcher = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (this.resumedToFinishMethodInvocation) {
                this.threadReference.suspend();
                this.resumedToFinishMethodInvocation = false;
            }
            this.methodInvoking = false;
            bl = this.unsuspendedStateWhenInvoking;
            this.unsuspendedStateWhenInvoking = false;
            this.notifyAll();
            singleThreadWatcher = this.watcher;
            this.watcher = null;
        }
        if (singleThreadWatcher != null) {
            singleThreadWatcher.destroy();
        }
        if (!bl) {
            this.notifySuspended();
        }
    }

    public synchronized boolean isMethodInvoking() {
        return this.methodInvoking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilMethodInvokeDone() {
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            while (this.methodInvoking) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public synchronized void disableMethodInvokeUntilResumed() {
        this.methodInvokingDisabledUntilResumed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInStep(boolean bl, EventRequest eventRequest) {
        SingleThreadWatcher singleThreadWatcher = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            this.inStep = bl;
            if (bl) {
                if (eventRequest.suspendPolicy() == 1) {
                    this.watcher = new SingleThreadWatcher(this);
                }
            } else if (this.watcher != null) {
                singleThreadWatcher = this.watcher;
                this.watcher = null;
            }
        }
        if (singleThreadWatcher != null) {
            singleThreadWatcher.destroy();
        }
    }

    public synchronized boolean isInStep() {
        return this.inStep;
    }

    public void interrupt() {
        try {
            if (this.isSuspended()) {
                return;
            }
            this.threadReference.interrupt();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public void makeCurrent() {
        this.debugger.setCurrentThread(this);
        Session session = this.debugger.getSession();
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        if (session != debuggerManager.getCurrentSession()) {
            debuggerManager.setCurrentSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectVariable getContendedMonitor() {
        ObjectReference objectReference;
        try {
            if (!this.threadReference.virtualMachine().canGetCurrentContendedMonitor()) {
                return null;
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return null;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (!this.isSuspended()) {
                return null;
            }
            if ("DestroyJavaVM".equals(this.threadReference.name())) {
                return null;
            }
            try {
                objectReference = this.threadReference.currentContendedMonitor();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return null;
            }
            catch (ObjectCollectedException objectCollectedException) {
                return null;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                String string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, string, incompatibleThreadStateException);
                return null;
            }
            catch (InternalException internalException) {
                String string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, string, internalException);
                return null;
            }
        }
        if (objectReference == null) {
            return null;
        }
        return new ThisVariable(this.debugger, objectReference, "" + objectReference.uniqueID());
    }

    public MonitorInfo getContendedMonitorAndOwner() {
        ObjectVariable objectVariable = this.getContendedMonitor();
        if (objectVariable == null) {
            return null;
        }
        MonitorInfo monitorInfo = null;
        JPDAThread jPDAThread = null;
        List<JPDAThread> list = this.debugger.getThreadsCollector().getAllThreads();
        for (JPDAThread jPDAThread2 : list) {
            ObjectVariable[] objectVariableArray;
            if (this == jPDAThread2) continue;
            block1: for (ObjectVariable objectVariable2 : objectVariableArray = jPDAThread2.getOwnedMonitors()) {
                if (!objectVariable.equals(objectVariable2)) continue;
                jPDAThread = jPDAThread2;
                List list2 = jPDAThread2.getOwnedMonitorsAndFrames();
                for (MonitorInfo monitorInfo2 : list2) {
                    if (!objectVariable.equals(monitorInfo2.getMonitor())) continue;
                    monitorInfo = monitorInfo2;
                    break block1;
                }
                break;
            }
            if (jPDAThread == null) continue;
            break;
        }
        if (monitorInfo != null) {
            return monitorInfo;
        }
        return new MonitorInfoImpl(jPDAThread, null, objectVariable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectVariable[] getOwnedMonitors() {
        List<ObjectReference> list;
        try {
            if (!this.threadReference.virtualMachine().canGetOwnedMonitorInfo()) {
                return new ObjectVariable[0];
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return new ObjectVariable[0];
        }
        catch (ObjectCollectedException objectCollectedException) {
            return new ObjectVariable[0];
        }
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (!this.isSuspended()) {
                return new ObjectVariable[0];
            }
            if ("DestroyJavaVM".equals(this.threadReference.name())) {
                return new ObjectVariable[0];
            }
            try {
                list = this.threadReference.ownedMonitors();
                if (list == null) {
                    list = Collections.emptyList();
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return new ObjectVariable[0];
            }
            catch (ObjectCollectedException objectCollectedException) {
                return new ObjectVariable[0];
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                String string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, string, incompatibleThreadStateException);
                return new ObjectVariable[0];
            }
            catch (InternalException internalException) {
                String string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, string, internalException);
                return new ObjectVariable[0];
            }
        }
        int n = list.size();
        ObjectVariable[] objectVariableArray = new ObjectVariable[n];
        for (int i = 0; i < n; ++i) {
            ObjectReference objectReference = list.get(i);
            objectVariableArray[i] = new ThisVariable(this.debugger, objectReference, "" + objectReference.uniqueID());
        }
        return objectVariableArray;
    }

    public ThreadReference getThreadReference() {
        return this.threadReference;
    }

    public synchronized ReturnVariableImpl getReturnVariable() {
        return this.returnVariable;
    }

    public synchronized void setReturnVariable(ReturnVariableImpl returnVariableImpl) {
        this.returnVariable = returnVariableImpl;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pch.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pch.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireSuspended(boolean bl) {
        this.pch.firePropertyChange("suspended", (Object)(!bl ? 1 : 0), (Object)bl);
    }

    @Override
    public void setObject(Object object) {
        throw new UnsupportedOperationException("Not supported, do not call. Implementing Customizer interface just because of add/remove PropertyChangeListener.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MonitorInfo> getOwnedMonitorsAndFrames() {
        if (CallStackFrameImpl.IS_JDK_16) {
            try {
                Method method = this.threadReference.virtualMachine().getClass().getMethod("canGetMonitorFrameInfo", new Class[0]);
                method.setAccessible(true);
                JPDAThreadImpl jPDAThreadImpl = this;
                synchronized (jPDAThreadImpl) {
                    Method method2;
                    List list;
                    if (!this.isSuspended()) {
                        return Collections.emptyList();
                    }
                    boolean bl = (Boolean)method.invoke((Object)this.threadReference.virtualMachine(), new Object[0]);
                    if (bl && (list = (List)(method2 = this.threadReference.getClass().getMethod("ownedMonitorsAndFrames", new Class[0])).invoke((Object)this.threadReference, new Object[0])) != null && list.size() > 0) {
                        ArrayList<MonitorInfo> arrayList = new ArrayList<MonitorInfo>(list.size());
                        for (Object e : list) {
                            arrayList.add(this.createMonitorInfo(e));
                        }
                        return Collections.unmodifiableList(arrayList);
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager.getDefault().notify((Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = "";
                try {
                    string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, string, invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private MonitorInfo createMonitorInfo(Object object) {
        try {
            CallStackFrame[] callStackFrameArray;
            Method method = object.getClass().getMethod("stackDepth", new Class[0]);
            int n = (Integer)method.invoke(object, new Object[0]);
            CallStackFrame callStackFrame = null;
            if (n >= 0) {
                try {
                    callStackFrameArray = this.getCallStack(n, n + 1);
                    if (callStackFrameArray.length > 0) {
                        callStackFrame = callStackFrameArray[0];
                    }
                }
                catch (AbsentInformationException absentInformationException) {
                    Exceptions.printStackTrace((Throwable)absentInformationException);
                }
            }
            callStackFrameArray = object.getClass().getMethod("monitor", new Class[0]);
            ObjectReference objectReference = (ObjectReference)callStackFrameArray.invoke(object, new Object[0]);
            ThisVariable thisVariable = new ThisVariable(this.debugger, objectReference, "" + objectReference.uniqueID());
            return new MonitorInfoImpl(this, callStackFrame, thisVariable);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkForBlockingThreads() {
        try {
            List<JPDAThread> list;
            List<JPDAThread> list2;
            if (!this.threadReference.virtualMachine().canGetCurrentContendedMonitor()) return false;
            if (!this.threadReference.virtualMachine().canGetMonitorInfo()) {
                return false;
            }
            VirtualMachine virtualMachine = this.threadReference.virtualMachine();
            Map<ThreadReference, ObjectReference> map = null;
            virtualMachine.suspend();
            try {
                Object object;
                ObjectReference objectReference = this.threadReference.currentContendedMonitor();
                if (objectReference != null) {
                    object = this.lockerThreadsLock;
                    synchronized (object) {
                        if (((Object)objectReference).equals(this.lockerThreadsMonitor)) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    map = JPDAThreadImpl.findLockPath(this.threadReference, objectReference);
                }
                object = this.lockerThreadsLock;
                synchronized (object) {
                    list2 = this.lockerThreadsList;
                    if (map != null) {
                        this.lockerThreadsMonitor = objectReference;
                        if (!this.submitMonitorEnteredFor(objectReference)) {
                            this.submitCheckForMonitorEntered(objectReference);
                        }
                        this.lockerThreadsList = new ThreadListDelegate(this.debugger, new ArrayList<ThreadReference>(map.keySet()));
                    } else {
                        this.lockerThreadsMonitor = null;
                        this.lockerThreadsList = null;
                    }
                    list = this.lockerThreadsList;
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                boolean bl = false;
                return bl;
            }
            finally {
                virtualMachine.resume();
            }
            if (list2 != list) {
                this.pch.firePropertyChange(PROP_LOCKER_THREADS, list2, list);
            }
            if (map == null) return false;
            return true;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
        catch (InternalException internalException) {
            return false;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        return false;
    }

    private static Map<ThreadReference, ObjectReference> findLockPath(ThreadReference threadReference, ObjectReference objectReference) throws IncompatibleThreadStateException {
        LinkedHashMap<ThreadReference, ObjectReference> linkedHashMap = new LinkedHashMap<ThreadReference, ObjectReference>();
        HashMap<ObjectReference, ThreadReference> hashMap = new HashMap<ObjectReference, ThreadReference>();
        for (ThreadReference threadReference2 : threadReference.virtualMachine().allThreads()) {
            List<ObjectReference> list = threadReference2.ownedMonitors();
            if (list == null) continue;
            for (ObjectReference objectReference2 : list) {
                hashMap.put(objectReference2, threadReference2);
            }
        }
        while (threadReference != null && objectReference != null) {
            threadReference = (ThreadReference)hashMap.get(objectReference);
            if (threadReference == null) continue;
            if (threadReference.suspendCount() > 1) {
                linkedHashMap.put(threadReference, objectReference);
            }
            objectReference = threadReference.currentContendedMonitor();
        }
        if (linkedHashMap.size() > 0) {
            return linkedHashMap;
        }
        return null;
    }

    public synchronized List<JPDAThread> getLockerThreads() {
        return this.lockerThreadsList;
    }

    public JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeBlockingThreads() {
        ArrayList<JPDAThread> arrayList;
        ArrayList<ThreadReference> arrayList2 = this.lockerThreadsLock;
        synchronized (arrayList2) {
            if (this.lockerThreadsList == null) {
                return false;
            }
            arrayList = new ArrayList<JPDAThread>(this.lockerThreadsList);
        }
        arrayList2 = new ArrayList<ThreadReference>(arrayList.size());
        for (JPDAThread jPDAThread : arrayList) {
            if (!jPDAThread.isSuspended()) continue;
            jPDAThread.resume();
            arrayList2.add(((JPDAThreadImpl)jPDAThread).getThreadReference());
        }
        Object object = this.lockerThreadsLock;
        synchronized (object) {
            this.resumedBlockingThreads = arrayList2;
        }
        return true;
    }

    private void submitMonitorEnteredRequest(EventRequest eventRequest) {
        eventRequest.setSuspendPolicy(2);
        eventRequest.putProperty("silent", Boolean.TRUE);
        this.debugger.getOperator().register(eventRequest, new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean exec(Event event) {
                List list;
                List list2;
                JPDAThreadImpl.this.threadReference.virtualMachine().eventRequestManager().deleteEventRequest(event.request());
                JPDAThreadImpl.this.debugger.getOperator().unregister(event.request());
                Iterator iterator = JPDAThreadImpl.this.lockerThreadsLock;
                synchronized (iterator) {
                    list2 = JPDAThreadImpl.this.lockerThreadsList;
                    JPDAThreadImpl.this.lockerThreadsMonitor = null;
                    JPDAThreadImpl.this.lockerThreadsList = null;
                    list = JPDAThreadImpl.this.resumedBlockingThreads;
                }
                JPDAThreadImpl.this.pch.firePropertyChange(JPDAThreadImpl.PROP_LOCKER_THREADS, list2, null);
                if (list != null) {
                    for (ThreadReference threadReference : list) {
                        threadReference.suspend();
                        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)JPDAThreadImpl.this.debugger.getExistingThread(threadReference);
                        if (jPDAThreadImpl == null) continue;
                        jPDAThreadImpl.notifySuspended();
                    }
                }
                if (JPDAThreadImpl.this.isMethodInvoking()) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            JPDAThreadImpl jPDAThreadImpl = JPDAThreadImpl.this;
                            synchronized (jPDAThreadImpl) {
                                JPDAThreadImpl.this.resumedToFinishMethodInvocation = true;
                                JPDAThreadImpl.this.threadReference.resume();
                            }
                        }
                    }, 200);
                }
                return true;
            }

            public void removed(EventRequest eventRequest) {
            }
        });
        eventRequest.enable();
    }

    private boolean submitMonitorEnteredFor(ObjectReference objectReference) {
        if (!Java6Methods.isJDK6() || !Java6Methods.canRequestMonitorEvents(this.threadReference.virtualMachine())) {
            return false;
        }
        EventRequest eventRequest = Java6Methods.createMonitorContendedEnteredRequest(this.threadReference.virtualMachine().eventRequestManager());
        Java6Methods.addThreadFilter2MonitorContendedEnteredRequest(eventRequest, this.threadReference);
        this.submitMonitorEnteredRequest(eventRequest);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitCheckForMonitorEntered(ObjectReference objectReference) {
        try {
            this.threadReference.suspend();
            ObjectReference objectReference2 = this.threadReference.currentContendedMonitor();
            if (objectReference2 == null) {
                return;
            }
            Location location = this.threadReference.frame(0).location();
            if ((location = location.method().locationOfCodeIndex(location.codeIndex() + 1L)) == null) {
                return;
            }
            BreakpointRequest breakpointRequest = this.threadReference.virtualMachine().eventRequestManager().createBreakpointRequest(location);
            breakpointRequest.addThreadFilter(this.threadReference);
            this.submitMonitorEnteredRequest(breakpointRequest);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            Exceptions.printStackTrace((Throwable)incompatibleThreadStateException);
        }
        finally {
            this.threadReference.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStepSuspendedBy(JPDABreakpoint jPDABreakpoint) {
        Object object = this.stepBreakpointLock;
        synchronized (object) {
            this.stepSuspendedByBreakpoint = jPDABreakpoint;
        }
        this.pch.firePropertyChange(PROP_STEP_SUSPENDED_BY_BREAKPOINT, null, jPDABreakpoint);
    }

    public String toString() {
        return "'" + this.getName() + "' (" + Integer.toHexString(System.identityHashCode(this)) + ") from DBG(" + Integer.toHexString(((Object)((Object)this.debugger)).hashCode()) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadListDelegate
    extends AbstractList<JPDAThread> {
        private List<ThreadReference> threads;
        private JPDADebuggerImpl debugger;

        public ThreadListDelegate(JPDADebuggerImpl jPDADebuggerImpl, List<ThreadReference> list) {
            this.debugger = jPDADebuggerImpl;
            this.threads = list;
        }

        @Override
        public JPDAThread get(int n) {
            return this.debugger.getThread(this.threads.get(n));
        }

        @Override
        public int size() {
            return this.threads.size();
        }
    }
}

