/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAWatchImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;
import org.openide.util.NbBundle;

class JPDAObjectWatchImpl
extends AbstractObjectVariable
implements JPDAWatch,
ObjectVariable {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;

    JPDAObjectWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, Value value) {
        super(jPDADebuggerImpl, value, "" + watch + (value instanceof ObjectReference ? "^" : ""));
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
    }

    JPDAObjectWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, String string) {
        super(jPDADebuggerImpl, null, "" + watch);
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
        this.exceptionDescription = string;
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String string) {
        this.watch.setExpression(string);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        Object object;
        CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
        if (callStackFrameImpl == null) {
            throw new InvalidExpressionException("No curent frame.");
        }
        try {
            object = callStackFrameImpl.getLocalVariable(this.getExpression());
            if (object != null) {
                if (object instanceof Local) {
                    ((Local)object).setValue(value);
                } else {
                    ((ObjectLocalVariable)object).setValue(value);
                }
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        object = callStackFrameImpl.getStackFrame().location().declaringType();
        Field field = object.fieldByName(this.getExpression());
        if (field == null) {
            throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
        }
        if (field.isStatic()) {
            if (object instanceof ClassType) {
                try {
                    ((ClassType)object).setValue(field, value);
                }
                catch (InvalidTypeException invalidTypeException) {
                    throw new InvalidExpressionException((Throwable)invalidTypeException);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    throw new InvalidExpressionException((Throwable)classNotLoadedException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidExpressionException((Throwable)illegalArgumentException);
                }
            }
            throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
        }
        ObjectReference objectReference = callStackFrameImpl.getStackFrame().thisObject();
        if (objectReference == null) {
            throw new InvalidExpressionException("no instance context.");
        }
        try {
            objectReference.setValue(field, value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidExpressionException((Throwable)illegalArgumentException);
        }
    }

    protected void setInnerValue(Value value) {
        super.setInnerValue(value);
        this.exceptionDescription = null;
    }

    void setException(String string) {
        super.setInnerValue(null);
        this.exceptionDescription = string;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }

    public JPDAObjectWatchImpl clone() {
        JPDAObjectWatchImpl jPDAObjectWatchImpl = this.exceptionDescription == null ? new JPDAObjectWatchImpl(this.getDebugger(), this.watch, this.getJDIValue()) : new JPDAObjectWatchImpl(this.getDebugger(), this.watch, this.exceptionDescription);
        return jPDAObjectWatchImpl;
    }
}

