/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.Java6Methods;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ClassVariableImpl;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;
import org.netbeans.modules.debugger.jpda.models.SuperVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDAClassTypeImpl
implements JPDAClassType {
    private static final Logger loggerValue = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private JPDADebuggerImpl debugger;
    private ReferenceType classType;

    public JPDAClassTypeImpl(JPDADebuggerImpl jPDADebuggerImpl, ReferenceType referenceType) {
        this.debugger = jPDADebuggerImpl;
        this.classType = referenceType;
    }

    public ReferenceType getType() {
        return this.classType;
    }

    public String getName() {
        return this.classType.name();
    }

    public String getSourceName() throws AbsentInformationException {
        return this.classType.sourceName();
    }

    public ClassVariable classObject() {
        return new ClassVariableImpl(this.debugger, this.classType.classObject(), "");
    }

    public ObjectVariable getClassLoader() {
        return new AbstractObjectVariable(this.debugger, this.classType.classLoader(), "Loader " + this.getName());
    }

    public SuperVariable getSuperClass() {
        if (this.classType instanceof ClassType) {
            return new SuperVariable(this.debugger, null, ((ClassType)this.classType).superclass(), this.getName());
        }
        return null;
    }

    public List<JPDAClassType> getSubClasses() {
        List<ReferenceType> list;
        if (this.classType instanceof ClassType && (list = ((ClassType)this.classType).subclasses()).size() > 0) {
            ArrayList<JPDAClassTypeImpl> arrayList = new ArrayList<JPDAClassTypeImpl>(list.size());
            for (ClassType classType : list) {
                arrayList.add(new JPDAClassTypeImpl(this.debugger, classType));
            }
            return Collections.unmodifiableList(arrayList);
        }
        if (this.classType instanceof InterfaceType) {
            list = ((InterfaceType)this.classType).subinterfaces();
            List<ClassType> list2 = ((InterfaceType)this.classType).implementors();
            int n = list.size();
            int n2 = list2.size();
            if (n > 0 || n2 > 0) {
                ArrayList<JPDAClassTypeImpl> arrayList = new ArrayList<JPDAClassTypeImpl>(n + n2);
                for (InterfaceType referenceType : list) {
                    arrayList.add(new JPDAClassTypeImpl(this.debugger, referenceType));
                }
                for (ClassType classType : list2) {
                    arrayList.add(new JPDAClassTypeImpl(this.debugger, classType));
                }
                return Collections.unmodifiableList(arrayList);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isInstanceOf(String string) {
        List<ReferenceType> list = this.classType.virtualMachine().classesByName(string);
        for (ReferenceType referenceType : list) {
            if (!EvaluatorVisitor.instanceOf(this.classType, referenceType)) continue;
            return true;
        }
        return false;
    }

    public List<org.netbeans.api.debugger.jpda.Field> staticFields() {
        List<Field> list = this.classType.allFields();
        ArrayList<org.netbeans.api.debugger.jpda.Field> arrayList = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        for (int i = 0; i < list.size(); ++i) {
            Value value = null;
            Field field = list.get(i);
            if (!field.isStatic()) continue;
            if (loggerValue.isLoggable(Level.FINE)) {
                loggerValue.fine("STARTED : " + this.classType + ".getValue(" + field + ")");
            }
            value = this.classType.getValue(field);
            if (loggerValue.isLoggable(Level.FINE)) {
                loggerValue.fine("FINISHED: " + this.classType + ".getValue(" + field + ") = " + value);
            }
            if (value instanceof PrimitiveValue) {
                arrayList.add(new FieldVariable(this.debugger, (PrimitiveValue)value, field, "", null));
                continue;
            }
            arrayList.add(new ObjectFieldVariable(this.debugger, (ObjectReference)value, field, "", null));
        }
        return arrayList;
    }

    public long getInstanceCount() {
        if (Java6Methods.isJDK6()) {
            long[] lArray = Java6Methods.instanceCounts(this.classType.virtualMachine(), Collections.singletonList(this.classType));
            return lArray[0];
        }
        return 0L;
    }

    public List<ObjectVariable> getInstances(long l) {
        if (Java6Methods.isJDK6()) {
            final List<ObjectReference> list = Java6Methods.instances(this.classType, l);
            return new AbstractList<ObjectVariable>(){

                @Override
                public ObjectVariable get(int n) {
                    ObjectReference objectReference = (ObjectReference)list.get(n);
                    return new AbstractObjectVariable(JPDAClassTypeImpl.this.debugger, objectReference, JPDAClassTypeImpl.this.classType.name() + " instance " + n);
                }

                @Override
                public int size() {
                    return list.size();
                }
            };
        }
        return Collections.emptyList();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JPDAClassTypeImpl)) {
            return false;
        }
        return ((Object)this.classType).equals(((JPDAClassTypeImpl)object).classType);
    }

    public int hashCode() {
        return ((Object)this.classType).hashCode() + 1000;
    }
}

