/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import javax.swing.Action;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.CheckDeadlocksAction;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DebuggingActionsProviderFilter
implements NodeActionsProviderFilter {
    private RequestProcessor rp;
    private Action SUSPEND_ALL_ACTION = Models.createAction((String)NbBundle.getBundle(DebuggingActionsProviderFilter.class).getString("CTL_ThreadAction_Suspend_All_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return object == "Root" && DebuggingActionsProviderFilter.this.debugger.getThreadsCollector().isSomeThreadRunning();
        }

        public void perform(Object[] objectArray) {
            DebuggingActionsProviderFilter.this.getRP().post(new Runnable(){

                public void run() {
                    DebuggingActionsProviderFilter.this.debugger.suspend();
                }
            });
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private Action RESUME_ALL_ACTION = Models.createAction((String)NbBundle.getBundle(DebuggingActionsProviderFilter.class).getString("CTL_ThreadAction_Resume_All_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return object == "Root" && DebuggingActionsProviderFilter.this.debugger.getThreadsCollector().isSomeThreadSuspended();
        }

        public void perform(Object[] objectArray) {
            DebuggingActionsProviderFilter.this.getRP().post(new Runnable(){

                public void run() {
                    DebuggingActionsProviderFilter.this.debugger.resume();
                }
            });
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private Action DEADLOCK_DETECT_ACTION = Models.createAction((String)CheckDeadlocksAction.getDisplayName(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return object == "Root";
        }

        public void perform(Object[] objectArray) {
            DebuggingActionsProviderFilter.this.getRP().post(new Runnable(){

                public void run() {
                    CheckDeadlocksAction.checkForDeadlock(DebuggingActionsProviderFilter.this.debugger);
                }
            });
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private JPDADebuggerImpl debugger;

    private synchronized RequestProcessor getRP() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("Debugging Actions", 1);
        }
        return this.rp;
    }

    public DebuggingActionsProviderFilter(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object == "Root") {
            int n;
            Action[] actionArray = new Action[]{this.RESUME_ALL_ACTION, this.SUSPEND_ALL_ACTION, null, this.DEADLOCK_DETECT_ACTION};
            Action[] actionArray2 = nodeActionsProvider.getActions(object);
            if (actionArray2 == null || actionArray2.length == 0) {
                return actionArray;
            }
            Action[] actionArray3 = new Action[actionArray.length + 1 + actionArray2.length];
            for (n = 0; n < actionArray.length; ++n) {
                actionArray3[n] = actionArray[n];
            }
            actionArray3[actionArray.length] = null;
            for (n = 0; n < actionArray2.length; ++n) {
                actionArray3[actionArray.length + 1 + n] = actionArray2[n];
            }
            return actionArray3;
        }
        return nodeActionsProvider.getActions(object);
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }
}

