/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;

public class ExceptionBreakpointImpl
extends ClassBasedBreakpoint {
    private ExceptionBreakpoint breakpoint;

    public ExceptionBreakpointImpl(ExceptionBreakpoint exceptionBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)exceptionBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = exceptionBreakpoint;
        this.set();
    }

    protected void setRequests() {
        this.setClassRequests(new String[]{this.breakpoint.getExceptionClassName()}, new String[0], 1);
        this.checkLoadedClasses(this.breakpoint.getExceptionClassName(), null);
    }

    protected void classLoaded(ReferenceType referenceType) {
        try {
            ExceptionRequest exceptionRequest = this.getEventRequestManager().createExceptionRequest(referenceType, (this.breakpoint.getCatchType() & 1) != 0, (this.breakpoint.getCatchType() & 2) != 0);
            this.addFilters(exceptionRequest, this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters());
            this.addEventRequest(exceptionRequest);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    protected ExceptionRequest createEventRequest(EventRequest eventRequest) {
        ExceptionRequest exceptionRequest = (ExceptionRequest)eventRequest;
        ExceptionRequest exceptionRequest2 = this.getEventRequestManager().createExceptionRequest(exceptionRequest.exception(), exceptionRequest.notifyCaught(), exceptionRequest.notifyUncaught());
        this.addFilters(exceptionRequest2, this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters());
        return exceptionRequest2;
    }

    private void addFilters(ExceptionRequest exceptionRequest, String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            exceptionRequest.addClassFilter(stringArray[n]);
        }
        n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            exceptionRequest.addClassExclusionFilter(stringArray2[n]);
        }
    }

    public boolean processCondition(Event event) {
        if (event instanceof ExceptionEvent) {
            return this.processCondition(event, this.breakpoint.getCondition(), ((ExceptionEvent)event).thread(), null);
        }
        return true;
    }

    public boolean exec(Event event) {
        if (event instanceof ExceptionEvent) {
            return this.perform(event, ((ExceptionEvent)event).thread(), ((ExceptionEvent)event).location().declaringType(), ((ExceptionEvent)event).exception());
        }
        return super.exec(event);
    }
}

