/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.toolbox;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.StringTokenizer;
import javax.swing.JViewport;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;
import org.netbeans.modules.visualweb.gravy.DNDDriver;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.designer.DesignerPaneOperator;
import org.netbeans.modules.visualweb.gravy.toolbox.ToolBoxOperator;
import org.netbeans.modules.visualweb.gravy.toolbox.actions.ShowPaletteAction;

public class PaletteContainerOperator
extends ContainerOperator {
    private static final String PALETTE_TITLE = "Palette";
    JListOperator theTree = null;
    JCheckBoxOperator categoryButton = null;
    private String name;
    static String defaultPaletteCategory = "Basic";

    private PaletteContainerOperator(ContainerOperator containerOperator, String string) {
        super(containerOperator, (ComponentChooser)new PaletteContainerChooser(string));
        this.name = string;
    }

    private static Container findPaletteContainer(String string) {
        return new JCheckBoxOperator((ContainerOperator)new TopComponentOperator(PALETTE_TITLE), string).getParent();
    }

    public PaletteContainerOperator(String string) {
        super(PaletteContainerOperator.findPaletteContainer(string));
        this.name = string;
    }

    public static String getDefaultPaletteCategory() {
        return defaultPaletteCategory;
    }

    public void showComponents() {
        if (this.categoryButton == null) {
            this.categoryButton = new JCheckBoxOperator((ContainerOperator)this, this.name);
        }
        this.categoryButton.changeSelection(true);
    }

    public void hideComponents() {
        if (this.categoryButton == null) {
            this.categoryButton = new JCheckBoxOperator((ContainerOperator)this, this.name);
        }
        this.categoryButton.changeSelection(false);
    }

    public Point getClickPoint(String string) {
        JListOperator jListOperator = this.getComponentsTree();
        return jListOperator.getClickPoint(jListOperator.findItemIndex(string));
    }

    public Point getClickPoint(String string, int n) {
        return this.getComponentsTree().getClickPoint(this.getComponentsTree().findItemIndex(string, n));
    }

    public Point getClickPointOfClass(Class clazz) {
        return this.getClickPoint(this.getDisplayNameOfClass(clazz));
    }

    public Point getClickPointOfClass(String string) {
        try {
            return this.getClickPointOfClass(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.getClickPoint(this.getShortClassName(string));
        }
    }

    private JViewport findViewportOfPalette() {
        JViewport jViewport = (JViewport)ContainerOperator.findContainerUnder((Component)this.getSource(), (ComponentChooser)new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JViewport.class.isInstance(component);
            }

            public String getDescription() {
                return "JViewport";
            }
        });
        return jViewport;
    }

    public void dndPaletteComponent(String string, ComponentOperator componentOperator, Point point) {
        Point point2 = this.getClickPoint(string);
        Util.wait(1000);
        this.dndPaletteComponent(point2, componentOperator, point);
    }

    public void dndComponentOfClass(String string, ComponentOperator componentOperator, Point point) {
        Point point2 = this.getClickPointOfClass(string);
        Util.wait(1000);
        this.dndPaletteComponent(point2, componentOperator, point);
    }

    private void dndPaletteComponent(Point point, ComponentOperator componentOperator, Point point2) {
        JViewport jViewport = this.findViewportOfPalette();
        JListOperator jListOperator = this.getComponentsTree();
        int n = jListOperator.getLocationOnScreen().x - jViewport.getLocationOnScreen().x + point.x;
        int n2 = jListOperator.getLocationOnScreen().y - jViewport.getLocationOnScreen().y + point.y;
        System.out.println();
        System.out.println("+++ coordinates of component in Palette Panel = [" + n + ", " + n2 + "]");
        System.out.println();
        jViewport.setViewPosition(new Point(n, n2));
        Util.wait(1000);
        jListOperator.clickMouse(point.x, point.y, 1);
        Util.wait(2000);
        System.out.println();
        System.out.println("+++ Component in Palette Panel should be visible and selected");
        System.out.println("+++ Left-top position in Palette Panel = " + jViewport.getViewPosition());
        System.out.println();
        DNDDriver dNDDriver = new DNDDriver();
        Util.wait(1000);
        dNDDriver.dnd((ComponentOperator)jListOperator, point, componentOperator, point2, 16, 0);
        Util.wait(3000);
        System.out.println();
        System.out.println("+++ Component should be put from Palette on Designer Pane");
        System.out.println();
    }

    public JListOperator getComponentsTree() {
        this.showComponents();
        if (this.theTree == null) {
            this.theTree = new JListOperator((ContainerOperator)this);
        }
        return this.theTree;
    }

    public void addComponent(String string) {
        Point point = this.getClickPoint(string);
        this.theTree.clickMouse(point.x, point.y, 2);
    }

    public void addComponent(String string, int n) {
        Point point = this.getClickPoint(string, n);
        this.theTree.clickMouse(point.x, point.y, 2);
    }

    public void addComponentOfClass(Class clazz) {
        Point point = this.getClickPointOfClass(clazz);
        this.theTree.clickMouse(point.x, point.y, 2);
        TestUtils.wait(2000);
    }

    public void addComponentOfClass(String string) {
        Point point = this.getClickPointOfClass(string);
        this.theTree.clickMouse(point.x, point.y, 2);
        TestUtils.wait(2000);
    }

    public void addComponent(String string, DesignerPaneOperator designerPaneOperator, Point point) {
        Point point2 = this.getClickPoint(string);
        JListOperator jListOperator = this.getComponentsTree();
        if (jListOperator.isSelectionEmpty()) {
            jListOperator.selectItem(string);
        } else {
            jListOperator.clearSelection();
            jListOperator.selectItem(string);
        }
        TestUtils.wait(2000);
        designerPaneOperator.clickMouse(point.x, point.y, 1);
        TestUtils.wait(2000);
        designerPaneOperator.clickMouse(1, 100, 1);
        TestUtils.wait(2000);
        designerPaneOperator.clickMouse(point.x + 5, point.y + 5, 1);
        TestUtils.wait(2000);
    }

    public void addComponent(String string, int n, DesignerPaneOperator designerPaneOperator, Point point) {
        Point point2 = this.getClickPoint(string, n);
        this.getComponentsTree().clickMouse(point2.x, point2.y, 1);
        TestUtils.wait(2000);
        designerPaneOperator.clickMouse(point.x, point.y, 1);
        TestUtils.wait(2000);
    }

    public void addComponentOfClass(Class clazz, DesignerPaneOperator designerPaneOperator, Point point) {
        Point point2 = this.getClickPointOfClass(clazz);
        this.getComponentsTree().clickMouse(point2.x, point2.y, 1);
        designerPaneOperator.clickMouse(point.x, point.y, 1);
        TestUtils.wait(2000);
    }

    public void addComponentOfClass(String string, DesignerPaneOperator designerPaneOperator, Point point) {
        Point point2 = this.getClickPointOfClass(string);
        this.getComponentsTree().clickMouse(point2.x, point2.y, 1);
        designerPaneOperator.clickMouse(point.x, point.y, 1);
        TestUtils.wait(2000);
    }

    public void placeClip(String string, JEditorPaneOperator jEditorPaneOperator, int n) {
        Rectangle rectangle = jEditorPaneOperator.modelToView(n);
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        this.dndComponentOfClass(string, (ComponentOperator)jEditorPaneOperator, point);
    }

    public void placeClip(String string, JEditorPaneOperator jEditorPaneOperator) {
        this.placeClip(string, jEditorPaneOperator, jEditorPaneOperator.getCaretPosition());
    }

    private String getDisplayNameOfClass(Class clazz) {
        String string = null;
        try {
            string = Introspector.getBeanInfo(clazz).getBeanDescriptor().getDisplayName();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (string == null) {
            string = this.getShortClassName(clazz.getName());
        }
        return string;
    }

    private String getShortClassName(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static void showPalette() {
        Util.getMainMenu().pushMenu("Window|Palette");
        new QueueTool().waitEmpty();
    }

    public static PaletteContainerOperator showPalette(String string, String string2) {
        new ShowPaletteAction().perform();
        new QueueTool().waitEmpty();
        new JToggleButtonOperator((ContainerOperator)new ToolBoxOperator(), string).push();
        return new PaletteContainerOperator(string2);
    }

    public static PaletteContainerOperator showCodeClips() {
        new ShowPaletteAction().perform();
        new QueueTool().waitEmpty();
        new JToggleButtonOperator((ContainerOperator)new ToolBoxOperator(), Bundle.getStringTrimmed((String)"com.sun.rave.toolbox.Bundle", (String)"CODE_CLIPS")).push();
        return new PaletteContainerOperator("Samples");
    }

    private static class PaletteContainerChooser
    implements ComponentChooser {
        String name;

        public PaletteContainerChooser(String string) {
            this.name = string;
        }

        public boolean checkComponent(Component component) {
            System.out.println("Class =" + component.getClass() + "   Name=" + component.getClass().getName());
            return component.getClass().getName().equals("org.netbeans.modules.palette.ui.CategoryDescriptor$1");
        }

        public String getDescription() {
            return " with \"" + this.name + "\" name";
        }
    }
}

