/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetOperator;
import org.netbeans.modules.visualweb.gravy.properties.SheetButtonOperator;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class Property {
    protected ContainerOperator contOper;
    private String name;
    private SheetButtonOperator nameButtonOperator;
    private SheetButtonOperator valueButtonOperator;
    public static final String STRING_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$StringRenderer";
    public static final String CHECKBOX_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$CheckboxRenderer";
    public static final String COMBOBOX_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$ComboboxRenderer";
    public static final String RADIOBUTTON_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$RadioButtonRenderer";
    public static final String SET_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$SetRenderer";
    protected Node.Property property;
    protected PropertySheetOperator propertySheetOper;

    public Property(PropertySheetOperator propertySheetOperator, String string) {
        this.propertySheetOper = propertySheetOperator;
        this.property = this.waitProperty(propertySheetOperator, string);
    }

    public Property(PropertySheetOperator propertySheetOperator, int n) {
        this.propertySheetOper = propertySheetOperator;
        this.property = this.waitProperty(propertySheetOperator, n);
    }

    public Property(ContainerOperator containerOperator, String string) {
        this(new PropertySheetOperator(containerOperator), string);
    }

    public Property(ContainerOperator containerOperator, int n) {
        this(new PropertySheetOperator(containerOperator), n);
    }

    private Node.Property waitProperty(final PropertySheetOperator propertySheetOperator, final String string) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    Node.Property property = null;
                    JTableOperator jTableOperator = propertySheetOperator.tblSheet();
                    for (int i = 0; i < jTableOperator.getRowCount(); ++i) {
                        if (!(jTableOperator.getValueAt(i, 1) instanceof Node.Property)) continue;
                        property = (Node.Property)jTableOperator.getValueAt(i, 1);
                        if (!propertySheetOperator.getComparator().equals(property.getDisplayName(), string)) continue;
                        return property;
                    }
                    return null;
                }

                public String getDescription() {
                    return "Wait property " + string;
                }
            });
            return (Node.Property)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    private Node.Property waitProperty(final PropertySheetOperator propertySheetOperator, final int n) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    JTableOperator jTableOperator = propertySheetOperator.tblSheet();
                    if (jTableOperator.getRowCount() <= n) {
                        return null;
                    }
                    Object object2 = jTableOperator.getValueAt(n, 1);
                    if (object2 instanceof Node.Property) {
                        return (Node.Property)object2;
                    }
                    throw new JemmyException("On row " + n + " in table there is no property");
                }

                public String getDescription() {
                    return "Wait property on row " + n + " in property sheet.";
                }
            });
            return (Node.Property)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    public SheetButtonOperator nameButtonOperator() {
        throw new JemmyException("Don't use this! Property sheet uses JTable instead of SheetButton.");
    }

    public SheetButtonOperator valueButtonOperator() {
        throw new JemmyException("Don't use this! Property sheet uses JTable instead of SheetButton.");
    }

    public String getName() {
        return this.property.getDisplayName();
    }

    public String getValue() {
        PropertyEditor propertyEditor = this.property.getPropertyEditor();
        try {
            if (this.property.getValue() != propertyEditor.getValue()) {
                propertyEditor.setValue(this.property.getValue());
            }
        }
        catch (Exception exception) {
            throw new JemmyException("Exception while synchronizing value of property and property editor - property.getValue() != pe.getValue()", (Throwable)exception);
        }
        return propertyEditor.getAsText();
    }

    public void setValue(String string) {
        this.propertySheetOper.getOutput().printTrace("Setting value \"" + string + "\" of property \"" + this.getName() + "\".");
        if (!this.isEnabled()) {
            throw new JemmyException("Property \"" + this.getName() + "\" is read only.");
        }
        PropertyEditor propertyEditor = this.property.getPropertyEditor();
        try {
            if (this.property.getValue() != propertyEditor.getValue()) {
                propertyEditor.setValue(this.property.getValue());
            }
        }
        catch (Exception exception) {
            throw new JemmyException("Exception while synchronizing value of property and property editor - property.getValue() != pe.getValue()", (Throwable)exception);
        }
        try {
            JemmyProperties.getCurrentOutput().printTrace("Setting property \"" + this.getName() + "\" to value \"" + string + "\".");
            propertyEditor.setAsText(string);
            this.property.setValue(propertyEditor.getValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            throw new JemmyException("Exception while setting value of property.", (Throwable)exception);
        }
    }

    public void setValue(int n) {
        PropertyEditor propertyEditor = this.property.getPropertyEditor();
        String[] stringArray = propertyEditor.getTags();
        if (stringArray == null) {
            throw new JemmyException("Property doesn't support changing value by index.");
        }
        this.setValue(stringArray[n]);
    }

    public boolean isEditable() {
        throw new JemmyException("Don't use this! Use setValue() to change property value.");
    }

    public void startEditing() {
        throw new JemmyException("Don't use this! Property sheet uses JTable instead of SheetButton.");
    }

    public void stopEditing() {
        throw new JemmyException("Don't use this! Property sheet uses JTable instead of SheetButton.");
    }

    public void openEditor() {
        if (this.supportsCustomEditor()) {
            final JTableOperator jTableOperator = this.propertySheetOper.tblSheet();
            for (int i = 0; i < jTableOperator.getRowCount(); ++i) {
                if (!(jTableOperator.getValueAt(i, 1) instanceof Node.Property) || this.property != (Node.Property)jTableOperator.getValueAt(i, 1)) continue;
                ((JTable)jTableOperator.getSource()).changeSelection(i, 0, false, false);
                final Action action = ((JComponent)jTableOperator.getSource()).getActionMap().get("invokeCustomEditor");
                new Thread(new Runnable(){

                    public void run() {
                        action.actionPerformed(new ActionEvent(jTableOperator.getSource(), 0, null));
                    }
                }, "Thread to open custom editor no block").start();
                return;
            }
        }
    }

    public boolean supportsCustomEditor() {
        return this.property.getPropertyEditor().supportsCustomEditor();
    }

    public void setDefaultValue() {
        try {
            this.property.restoreDefaultValue();
        }
        catch (Exception exception) {
            throw new JemmyException("Exception while restoring default value.", (Throwable)exception);
        }
    }

    public boolean isEnabled() {
        return this.property.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEditAsText() {
        if (!this.isEnabled()) {
            return false;
        }
        JTableOperator jTableOperator = this.propertySheetOper.tblSheet();
        for (int i = 0; i < jTableOperator.getRowCount(); ++i) {
            if (!(jTableOperator.getValueAt(i, 1) instanceof Node.Property) || this.property != (Node.Property)jTableOperator.getValueAt(i, 1)) continue;
            jTableOperator.clickForEdit(i, 1);
            long l = this.propertySheetOper.getTimeouts().getTimeout("ComponentOperator.WaitComponentTimeout");
            this.propertySheetOper.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", 1000L);
            try {
                new JTextFieldOperator((ContainerOperator)this.propertySheetOper);
                boolean bl = true;
                return bl;
            }
            catch (JemmyException jemmyException) {
                boolean bl = false;
                return bl;
            }
            finally {
                jTableOperator.pushKey(27);
                this.propertySheetOper.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", l);
            }
        }
        throw new JemmyException("Property " + this.getName() + " not found in this sheet:\n" + this.propertySheetOper.getSource().toString());
    }

    public String getRendererName() {
        return this.getRenderer().getClass().getName();
    }

    private Component getRenderer() {
        JTableOperator jTableOperator = this.propertySheetOper.tblSheet();
        for (int i = 0; i < jTableOperator.getRowCount(); ++i) {
            if (!(jTableOperator.getValueAt(i, 1) instanceof Node.Property) || this.property != (Node.Property)jTableOperator.getValueAt(i, 1)) continue;
            TableCellRenderer tableCellRenderer = jTableOperator.getCellRenderer(i, 1);
            Component component = tableCellRenderer.getTableCellRendererComponent((JTable)jTableOperator.getSource(), jTableOperator.getValueAt(i, 1), false, false, i, 1);
            try {
                Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.RendererPropertyDisplayer");
                Method method = clazz.getDeclaredMethod("findInnermostRenderer", JComponent.class);
                method.setAccessible(true);
                component = (Component)method.invoke(null, component);
            }
            catch (Exception exception) {
                throw new JemmyException("RendererPropertyDisplayer.findInnermostRenderer() by reflection failed.", (Throwable)exception);
            }
            return component;
        }
        throw new JemmyException("Property " + this.getName() + " not found in this sheet:\n" + this.propertySheetOper.getSource().toString());
    }

    public String getShortDescription() {
        return this.property.getShortDescription();
    }
}

