/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.RaveWindowOperator;
import org.netbeans.modules.visualweb.gravy.TopComponentOperator;
import org.netbeans.modules.visualweb.gravy.actions.SaveAction;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditor;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.windows.TopComponent;

public class EditorOperator
extends TopComponentOperator {
    private static int WAIT_TIME = 60000;
    private JEditorPaneOperator _txtEditorPane;
    private JLabelOperator _lblRowColumn;
    private JLabelOperator _lblInputMode;
    private JLabelOperator _lblStatusBar;
    private JComboBoxOperator _cboQuickBrowse;

    public EditorOperator(String string) {
        this(string, 0);
    }

    public EditorOperator(String string, int n) {
        super(EditorOperator.waitTopComponent(null, string, n, new EditorSubchooser(string)));
        this.requestFocus();
    }

    public EditorOperator(ContainerOperator containerOperator, String string) {
        super(containerOperator, new EditorSubchooser(string));
        this.requestFocus();
    }

    public EditorOperator(ContainerOperator containerOperator, String string, int n) {
        super(EditorOperator.waitTopComponent(containerOperator, string, n, new EditorSubchooser(string)));
        this.copyEnvironment((Operator)containerOperator);
        this.requestFocus();
    }

    public static void closeDiscardAll() {
        JTabbedPaneOperator jTabbedPaneOperator = new JTabbedPaneOperator((ContainerOperator)RaveWindowOperator.getDefault());
        for (int i = 0; i < jTabbedPaneOperator.getTabCount(); ++i) {
            EditorOperator.close((TopComponent)jTabbedPaneOperator.getComponent(i), false);
        }
    }

    public void close(boolean bl) {
        if (bl) {
            super.save();
            this.close();
        } else {
            this.closeDiscard();
        }
    }

    static void close(TopComponent topComponent, boolean bl) {
        TopComponentOperator topComponentOperator = new TopComponentOperator((JComponent)topComponent);
        if (bl) {
            topComponentOperator.save();
            topComponentOperator.close();
        } else {
            topComponentOperator.closeDiscard();
        }
    }

    public JEditorPaneOperator txtEditorPane() {
        if (this._txtEditorPane == null) {
            this._txtEditorPane = new JEditorPaneOperator((ContainerOperator)this);
        }
        return this._txtEditorPane;
    }

    public JLabelOperator lblRowColumn() {
        if (this._lblRowColumn == null) {
            this._lblRowColumn = new JLabelOperator((ContainerOperator)this, 0);
        }
        return this._lblRowColumn;
    }

    public JLabelOperator lblInputMode() {
        if (this._lblInputMode == null) {
            this._lblInputMode = new JLabelOperator((ContainerOperator)this, 1);
        }
        return this._lblInputMode;
    }

    public JLabelOperator lblStatusBar() {
        if (this._lblStatusBar == null) {
            this._lblStatusBar = new JLabelOperator((ContainerOperator)this, 2);
        }
        return this._lblStatusBar;
    }

    public JComboBoxOperator cboQuickBrowse() {
        if (this._cboQuickBrowse == null) {
            this._cboQuickBrowse = new JComboBoxOperator((ContainerOperator)this);
        }
        return this._cboQuickBrowse;
    }

    public void setQuickBrowse(String string) {
        this.cboQuickBrowse().selectItem(string);
    }

    public String getText() {
        return this.txtEditorPane().getText();
    }

    public String getText(int n) {
        return ((Line)this.getLine(n)).getText();
    }

    private Object getLine(int n) {
        Document document = this.txtEditorPane().getDocument();
        DataObject dataObject = (DataObject)document.getProperty("stream");
        Line.Set set = ((LineCookie)dataObject.getCookie(LineCookie.class)).getLineSet();
        try {
            return set.getCurrent(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JemmyException("Index must be > 0", (Throwable)indexOutOfBoundsException);
        }
    }

    public boolean contains(String string) {
        return this.getText().indexOf(string) != -1;
    }

    public void select(int n) {
        int n2 = this.getLineOffset(n);
        this.setCaretPosition(n2);
        this.txtEditorPane().moveCaretPosition(n2 + this.getText(n).length());
    }

    public void select(int n, int n2) {
        this.setCaretPosition(this.getLineOffset(n));
        this.txtEditorPane().moveCaretPosition(this.getLineOffset(n2) + this.getText(n2).length());
    }

    public void select(int n, int n2, int n3) {
        int n4 = this.getLineOffset(n);
        this.setCaretPosition(n4 + n2 - 1);
        this.txtEditorPane().moveCaretPosition(n4 + n3);
    }

    public void select(String string, int n) {
        int n2 = this.txtEditorPane().getPositionByText(string, n);
        if (n2 == -1) {
            throw new JemmyException(n + "-th occurence of \"" + string + "\" not found.");
        }
        this.setCaretPosition(n2);
        this.txtEditorPane().moveCaretPosition(n2 + string.length());
    }

    public void select(String string) {
        this.select(string, 0);
    }

    public void replace(String string, String string2) {
        this.replace(string, string2, 0);
    }

    public void replace(String string, String string2, int n) {
        this.select(string, n);
        this.txtEditorPane().replaceSelection(string2);
    }

    public void insert(final String string) {
        final int n = this.txtEditorPane().getCaretPosition();
        this.runMapping(new Operator.MapVoidAction("insertString"){

            public void map() {
                try {
                    EditorOperator.this.txtEditorPane().getDocument().insertString(n, string, null);
                }
                catch (BadLocationException badLocationException) {
                    throw new JemmyException("Cannot insert \"" + string + "\" to position " + n + ".", (Throwable)badLocationException);
                }
            }
        });
    }

    public void insert(String string, int n, int n2) {
        this.setCaretPosition(n, n2);
        this.insert(string);
    }

    public void delete(int n, int n2) {
        try {
            this.txtEditorPane().getDocument().remove(n, n2);
        }
        catch (BadLocationException badLocationException) {
            throw new JemmyException("Cannot delete " + n2 + " characters from position " + n + ".", (Throwable)badLocationException);
        }
    }

    public void delete(int n) {
        this.delete(this.txtEditorPane().getCaretPosition(), n);
    }

    public void deleteLine(int n) {
        this.delete(this.getLineOffset(n), this.getText(n).length());
    }

    public void delete(int n, int n2, int n3) {
        this.delete(this.getLineOffset(n) + n2 - 1, n3 - n2 + 1);
    }

    public int getLineNumber() {
        StyledDocument styledDocument = (StyledDocument)this.txtEditorPane().getDocument();
        int n = this.txtEditorPane().getCaretPosition();
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n) + 1;
    }

    public void pushKey(int n) {
        this.requestFocus();
        this.txtEditorPane().pushKey(n);
    }

    public void pushHomeKey() {
        this.pushKey(36);
    }

    public void pushEndKey() {
        this.pushKey(35);
    }

    public void pushTabKey() {
        this.pushKey(9);
    }

    public void pushDownArrowKey() {
        this.pushKey(40);
    }

    public void pushUpArrowKey() {
        this.pushKey(38);
    }

    private int getLineOffset(int n) {
        try {
            StyledDocument styledDocument = (StyledDocument)this.txtEditorPane().getDocument();
            return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JemmyException("Invalid line number " + n, (Throwable)indexOutOfBoundsException);
        }
    }

    public void setCaretPositionRelative(int n) {
        this.setCaretPosition(this.txtEditorPane().getCaretPosition() + n);
    }

    public void setCaretPositionToLine(int n) {
        this.txtEditorPane().setCaretPosition(this.getLineOffset(n));
    }

    public void setCaretPositionToEndOfLine(int n) {
        this.txtEditorPane().setCaretPosition(this.getLineOffset(n) + this.getText(n).length() - 1);
    }

    public void setCaretPosition(int n, int n2) {
        this.setCaretPosition(this.getLineOffset(n) + n2 - 1);
    }

    public void setCaretPosition(int n) {
        if (n < 0 || n > this.getText().length()) {
            throw new JemmyException("Invalid caret position " + n);
        }
        this.txtEditorPane().setCaretPosition(n);
    }

    public void setCaretPosition(String string, int n, boolean bl) {
        this.setCaretPosition(this.txtEditorPane().getPositionByText(string, n) + (bl ? 0 : string.length()));
    }

    public void setCaretPosition(String string, boolean bl) {
        this.setCaretPosition(string, 0, bl);
    }

    public Object[] getAnnotations(int n) {
        return this.getAnnotations(this.getLine(n)).toArray(new Annotation[0]);
    }

    private List getAnnotations(Object object) {
        try {
            Method method = Annotatable.class.getDeclaredMethod("getAnnotations", null);
            method.setAccessible(true);
            return (List)method.invoke(object, null);
        }
        catch (Exception exception) {
            throw new JemmyException("getAnnotations() by reflection failed.", (Throwable)exception);
        }
    }

    public Object[] getAnnotations() {
        Document document = this.txtEditorPane().getDocument();
        DataObject dataObject = (DataObject)document.getProperty("stream");
        Line.Set set = ((LineCookie)dataObject.getCookie(LineCookie.class)).getLineSet();
        Iterator iterator = set.getLines().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getAnnotations((Line)iterator.next()));
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.netbeans.modules.java.JavaEditor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getOutput().printLine("WARNING: Class org.netbeans.modules.java.JavaEditor not found.");
        }
        Node.Cookie cookie = dataObject.getCookie(clazz);
        if (cookie != null) {
            ArrayList arrayList2;
            Object object;
            try {
                object = clazz.getDeclaredField("errorAnnotations");
                ((Field)object).setAccessible(true);
                arrayList2 = (ArrayList)((Field)object).get(cookie);
            }
            catch (Exception exception) {
                throw new JemmyException("Get errorAnnotations field failed.", (Throwable)exception);
            }
            arrayList.addAll(arrayList2);
            try {
                Field field = clazz.getDeclaredField("overrideAnnotations");
                field.setAccessible(true);
                object = (ArrayList)field.get(cookie);
            }
            catch (Exception exception) {
                throw new JemmyException("Get overrideAnnotations field failed.", (Throwable)exception);
            }
            arrayList.addAll(object);
        }
        return arrayList.toArray(new Annotation[arrayList.size()]);
    }

    public static String getAnnotationType(Object object) {
        return ((Annotation)object).getAnnotationType();
    }

    public static String getAnnotationShortDescription(Object object) {
        return ((Annotation)object).getShortDescription();
    }

    public JButtonOperator getToolbarButton(String string) {
        ToolbarButtonChooser toolbarButtonChooser = new ToolbarButtonChooser(string, this.getComparator());
        return new JButtonOperator(JButtonOperator.waitJButton((Container)((Container)this.getSource()), (ComponentChooser)toolbarButtonChooser));
    }

    public JButtonOperator getToolbarButton(int n) {
        ComponentChooser componentChooser = new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JToolBar;
            }

            public String getDescription() {
                return "javax.swing.JToolBar";
            }
        };
        Container container = (Container)EditorOperator.findComponent((Container)((Container)this.getSource()), (ComponentChooser)componentChooser);
        if (container == null) {
            throw new JemmyException("Toolbar not present.");
        }
        JComboBox jComboBox = JComboBoxOperator.findJComboBox((Container)container, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"JComboBox"));
        if (jComboBox != null) {
            ++n;
        }
        return new JButtonOperator(JButtonOperator.waitJButton((Container)container, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"JButton"), (int)n));
    }

    public void pushToolbarPopupMenu(String string) {
        this.getToolbarButton(0).clickForPopup();
        new JPopupMenuOperator().pushMenu(string, "|");
    }

    public boolean isModified() {
        return this.getName().endsWith("*");
    }

    public void waitModified(final boolean bl) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return EditorOperator.this.isModified() == bl ? new Object() : null;
                }

                public String getDescription() {
                    return "Wait Modified State";
                }
            });
            Timeouts timeouts = this.getTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("EditorOperator.WaitModifiedTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(this.getOutput());
            waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void save() {
        new SaveAction().perform((ComponentOperator)this);
        if (this.getVerification()) {
            this.waitModified(false);
        }
    }

    public void closeAndCancelByPopup() {
        this.clickForPopup();
        new JPopupMenuOperator().pushMenu("Close");
        new EventTool().waitNoEvent(500L);
        try {
            JDialogOperator jDialogOperator = new JDialogOperator("Question");
            new QueueTool().waitEmpty(100L);
            new JButtonOperator((ContainerOperator)jDialogOperator, "Cancel").push();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void verify() {
        this.txtEditorPane();
        this.cboQuickBrowse();
        this.lblInputMode();
        this.lblRowColumn();
        this.lblStatusBar();
    }

    static {
        Timeouts.initDefault((String)"EditorOperator.WaitModifiedTimeout", (long)WAIT_TIME);
    }

    private static final class EditorSubchooser
    implements ComponentChooser {
        String ID;

        public EditorSubchooser(String string) {
            this.ID = string;
        }

        public boolean checkComponent(Component component) {
            return component instanceof CloneableEditor && ((CloneableEditor)component).getName().indexOf(this.ID) != -1 && component.isShowing();
        }

        public String getDescription() {
            return "org.openide.text.CloneableEditor";
        }
    }

    private static class ToolbarButtonChooser
    implements ComponentChooser {
        private String buttonTooltip;
        private Operator.StringComparator comparator;

        public ToolbarButtonChooser(String string, Operator.StringComparator stringComparator) {
            this.buttonTooltip = string;
            this.comparator = stringComparator;
        }

        public boolean checkComponent(Component component) {
            return this.comparator.equals(((JComponent)component).getToolTipText(), this.buttonTooltip);
        }

        public String getDescription() {
            return "Toolbar button with tooltip \"" + this.buttonTooltip + "\".";
        }
    }
}

