/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.vertexitemeditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.VertexItemEditor;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.MetalTextFieldBorder;

public abstract class AbstractTextVertexItemEditor
extends JTextField
implements FocusListener,
ActionListener,
VertexItemEditor {
    private List<CellEditorListener> listeners = null;

    public AbstractTextVertexItemEditor() {
        MetalTextFieldBorder.installIfItIsNeeded(this);
        this.addFocusListener(this);
        this.addActionListener(this);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTextVertexItemEditor.this.fireEditingCanceled();
            }
        };
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel-editing-action");
        actionMap.put("cancel-editing-action", abstractAction);
    }

    public void addEditorListener(CellEditorListener cellEditorListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CellEditorListener>();
        }
        this.listeners.add(cellEditorListener);
    }

    public void removeEditorListener(CellEditorListener cellEditorListener) {
        int n;
        if (this.listeners != null && (n = this.listeners.lastIndexOf(cellEditorListener)) >= 0) {
            this.listeners.remove(n);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    protected CellEditorListener[] getEditorListeners() {
        return this.listeners == null ? null : this.listeners.toArray(new CellEditorListener[this.listeners.size()]);
    }

    protected void fireEditingStopped() {
        CellEditorListener[] cellEditorListenerArray = this.getEditorListeners();
        if (cellEditorListenerArray != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = cellEditorListenerArray.length - 1; i >= 0; --i) {
                cellEditorListenerArray[i].editingStopped(changeEvent);
            }
        }
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] cellEditorListenerArray = this.getEditorListeners();
        if (cellEditorListenerArray != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = cellEditorListenerArray.length - 1; i >= 0; --i) {
                cellEditorListenerArray[i].editingCanceled(changeEvent);
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.getParent() != null) {
            this.fireEditingStopped();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireEditingStopped();
    }

    public abstract Component getVertexItemEditorComponent(Mapper var1, TreePath var2, VertexItem var3);

    public abstract Object getVertexItemEditorValue();

    public void stopVertexItemEditing() {
        this.fireEditingStopped();
    }

    public void cancelVertexItemEditing() {
        this.fireEditingCanceled();
    }
}

