/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.netbeans.modules.soa.mappercore.Mapper;

public class MapperLayout
implements LayoutManager {
    private JComponent leftScroll;
    private JComponent rightScroll;
    private JComponent centerScroll;
    private JComponent leftDivider;
    private JComponent rightDivider;
    private JComponent toolBar;
    public static final String TOOL_BAR = "TOOL_BAR";
    public static final String LEFT_SCROLL = "LEFT_SCROLL";
    public static final String RIGHT_SCROLL = "RIGHT_SCROLL";
    public static final String CENTER_SCROLL = "CENTER_SCROLL";
    public static final String LEFT_DIVIDER = "LEFT_DIVIDER";
    public static final String RIGHT_DIVIDER = "RIGHT_DIVIDER";
    public static final int MIN_WIDTH = 64;
    public static final int DIVIDER_WIDTH = 6;
    public static final int MIN_DELTA = 76;

    public void addLayoutComponent(String string, Component component) {
        if (LEFT_SCROLL.equals(string)) {
            this.leftScroll = (JComponent)component;
        } else if (RIGHT_SCROLL.equals(string)) {
            this.rightScroll = (JComponent)component;
        } else if (CENTER_SCROLL.equals(string)) {
            this.centerScroll = (JComponent)component;
        } else if (LEFT_DIVIDER.equals(string)) {
            this.leftDivider = (JComponent)component;
        } else if (RIGHT_DIVIDER.equals(string)) {
            this.rightDivider = (JComponent)component;
        } else if (TOOL_BAR.equals(string)) {
            this.toolBar = (JComponent)component;
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateSize((Mapper)container, false);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateSize((Mapper)container, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calculateSize(Mapper mapper, boolean bl) {
        Object object = mapper.getTreeLock();
        synchronized (object) {
            Insets insets = mapper.getInsets();
            Dimension dimension = bl ? this.leftScroll.getMinimumSize() : this.leftScroll.getPreferredSize();
            Dimension dimension2 = bl ? this.centerScroll.getMinimumSize() : this.centerScroll.getPreferredSize();
            Dimension dimension3 = bl ? this.rightScroll.getMinimumSize() : this.rightScroll.getPreferredSize();
            int n = dimension.width + 6 + dimension2.width + 6 + dimension3.width;
            int n2 = Math.max(dimension2.height, Math.max(dimension.height, dimension3.height));
            if (this.toolBar != null) {
                Dimension dimension4 = bl ? this.toolBar.getMinimumSize() : this.toolBar.getPreferredSize();
                n = Math.max(n, dimension4.width);
                n2 += dimension4.height;
            }
            return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            Mapper mapper = (Mapper)container;
            Insets insets = mapper.getInsets();
            int n10 = mapper.getWidth();
            int n11 = mapper.getHeight();
            int n12 = mapper.getLeftDividerPosition();
            int n13 = mapper.getRightDividerPosition();
            if (n12 < 0 || n13 < 0) {
                n9 = n10 - insets.right - insets.left - 12;
                n12 = n9 / 4;
                n13 = n9 / 4;
            }
            if ((n9 = (n12 = Math.max(n12, 64)) + (n13 = Math.max(n13, 64)) + 12 + 64 + insets.left + insets.right) > n10) {
                n8 = n12 - 64;
                n7 = n13 - 64;
                n6 = n9 - n10;
                n7 -= n6 - n6 / 2;
                if ((n8 -= n6 / 2) < 0) {
                    n7 += n8;
                } else if (n7 < 0) {
                    n8 += n7;
                }
                n12 = 64 + Math.max(n8, 0);
                n13 = 64 + Math.max(n7, 0);
            }
            n8 = insets.top;
            n11 -= insets.top + insets.bottom;
            if (this.toolBar != null) {
                n7 = this.toolBar.getPreferredSize().height;
                this.toolBar.setBounds(insets.left, n8, n10 - insets.right - insets.left, n7);
                n8 += n7;
                n11 -= n7;
            }
            if ((n5 = (n4 = (n3 = (n6 = n10 - insets.right) - n13) - 6) - (n2 = (n = (n7 = insets.left) + n12) + 6) - 64) < 0) {
                n4 -= n5;
                n3 -= n5;
                n6 -= n5;
            }
            this.leftScroll.setBounds(n7, n8, n - n7, n11);
            this.leftDivider.setBounds(n, n8, n2 - n, n11);
            this.centerScroll.setBounds(n2, n8, n4 - n2, n11);
            this.rightDivider.setBounds(n4, n8, n3 - n4, n11);
            this.rightScroll.setBounds(n3, n8, n6 - n3, n11);
            mapper.setDividerPositions(n12, n13);
        }
    }
}

