/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjar.project.ui;

import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ServerResourceNode
extends FilterNode {
    private static final Logger LOGGER = Logger.getLogger(ServerResourceNode.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final Image RESOURCE_FILE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ejbjar/project/ui/resourcesBadge.gif", (boolean)true);
    private static final String SETUP_DIR = "setup";
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
    private Project project;
    private FileChangeListener projectDirectoryListener = new ProjectDirectoryListener();

    public ServerResourceNode(Project project) {
        this(ServerResourceNode.getSetupDataFolder(project), project);
    }

    private ServerResourceNode(DataFolder dataFolder, Project project) {
        super(ServerResourceNode.getDataFolderNode(dataFolder, project), ServerResourceNode.getDataFolderNodeChildren(dataFolder));
        if (LOG) {
            LOGGER.log(Level.FINE, "Adding file listener to " + project.getProjectDirectory());
        }
        project.getProjectDirectory().addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.projectDirectoryListener, (Object)project.getProjectDirectory()));
        this.project = project;
    }

    public Image getIcon(int n) {
        return ServerResourceNode.badgeIcon(super.getIcon(n));
    }

    public Image getOpenedIcon(int n) {
        return ServerResourceNode.badgeIcon(super.getOpenedIcon(n));
    }

    private static Image badgeIcon(Image image) {
        return ImageUtilities.mergeImages((Image)image, (Image)RESOURCE_FILE_BADGE, (int)7, (int)7);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ServerResourceNode.class, (String)"LBL_Node_ResourceNode");
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class)};
    }

    private void refresh() {
        if (LOG) {
            LOGGER.log(Level.FINE, "Refreshing");
        }
        DataFolder dataFolder = ServerResourceNode.getSetupDataFolder(this.project);
        if (LOG) {
            LOGGER.log(Level.FINE, "The DataFolder is: " + dataFolder);
        }
        final Node node = ServerResourceNode.getDataFolderNode(dataFolder, this.project);
        final Children children = ServerResourceNode.getDataFolderNodeChildren(dataFolder);
        if (LOG) {
            LOGGER.log(Level.FINE, "New children count: " + children.getNodes(true).length);
        }
        FilterNode.Children.MUTEX.postWriteRequest(new Runnable(){

            public void run() {
                ServerResourceNode.this.changeOriginal(node, false);
                ServerResourceNode.this.setChildren(children);
            }
        });
    }

    private static DataFolder getSetupDataFolder(Project project) {
        FileObject fileObject = project.getProjectDirectory().getFileObject(SETUP_DIR);
        DataFolder dataFolder = null;
        if (fileObject != null && fileObject.isFolder()) {
            try {
                dataFolder = DataFolder.findFolder((FileObject)fileObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return dataFolder;
    }

    private static Node getDataFolderNode(DataFolder dataFolder, Project project) {
        return dataFolder != null ? dataFolder.getNodeDelegate() : new PlaceHolderNode(Lookups.singleton((Object)project));
    }

    private static Children getDataFolderNodeChildren(DataFolder dataFolder) {
        return dataFolder != null ? dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER) : FilterNode.Children.LEAF;
    }

    private static final class PlaceHolderNode
    extends AbstractNode {
        public PlaceHolderNode(Lookup lookup) {
            super(FilterNode.Children.LEAF, lookup);
        }

        public Image getIcon(int n) {
            Image image = null;
            Node node = PlaceHolderNode.getImageDelegate();
            if (node != null) {
                image = node.getIcon(n);
            }
            if (image == null) {
                image = super.getIcon(n);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = null;
            Node node = PlaceHolderNode.getImageDelegate();
            if (node != null) {
                image = node.getOpenedIcon(n);
            }
            if (image == null) {
                image = super.getOpenedIcon(n);
            }
            return image;
        }

        private static Node getImageDelegate() {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    return dataObject.getNodeDelegate();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger("global").log(Level.INFO, null, dataObjectNotFoundException);
                }
            }
            return null;
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        private EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }

    private final class ProjectDirectoryListener
    extends FileChangeAdapter {
        private ProjectDirectoryListener() {
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (this.isWatchedFile(this.getFileName(fileEvent))) {
                ServerResourceNode.this.refresh();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            if (this.isWatchedFile(this.getFileName(fileEvent))) {
                ServerResourceNode.this.refresh();
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (this.isWatchedFile(this.getFileName((FileEvent)fileRenameEvent)) || this.isWatchedFile(this.getOldFileName(fileRenameEvent))) {
                ServerResourceNode.this.refresh();
            }
        }

        private boolean isWatchedFile(String string) {
            return string.equals(ServerResourceNode.SETUP_DIR);
        }

        private String getFileName(FileEvent fileEvent) {
            return fileEvent.getFile().getNameExt();
        }

        private String getOldFileName(FileRenameEvent fileRenameEvent) {
            String string = fileRenameEvent.getName();
            if (fileRenameEvent.getExt() != "") {
                string = string + "." + fileRenameEvent.getExt();
            }
            return string;
        }
    }
}

