/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.Position;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.modules.bpel.debugger.api.variables.NamedValueHost;
import org.netbeans.modules.bpel.debugger.api.variables.SimpleValue;
import org.netbeans.modules.bpel.debugger.api.variables.SimpleVariable;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.WsdlMessageValue;
import org.netbeans.modules.bpel.debugger.api.variables.WsdlMessageVariable;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementValue;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementVariable;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.XmlUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VariablesUtil {
    private BpelDebugger myDebugger;
    private static final String ICONS_ROOT = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/";
    private static final String DEFAULT_VARIABLE_ICON = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    private static final String WSDL_MESSAGE_VARIABLE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/VARIABLE_MESSAGE";
    private static final String WSDL_MESSAGE_PART_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/MESSAGE_PART";
    private static final String XML_ELEMENT_VARIABLE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/VARIABLE_XML_ELEMENT";
    private static final String SIMPLE_VARIABLE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/VARIABLE_SIMPLE";
    private static final String DEFAULT_NODE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/DEFAULT_NODE";
    private static final String ELEMENT_NODE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/ELEMENT_NODE";
    private static final String ATTRIBUTE_NODE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/ATTRIBUTE_NODE";
    private static final String TEXT_NODE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/TEXT_NODE";
    private static final String CDATA_NODE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/CDATA_NODE";

    public VariablesUtil(BpelDebugger bpelDebugger) {
        this.myDebugger = bpelDebugger;
    }

    public String getDisplayName(Object object) {
        if (object instanceof NamedValueHost) {
            return ((NamedValueHost)object).getName();
        }
        if (object instanceof Node) {
            return ((Node)object).getNodeName();
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_CannotResolveDN", (Object)object);
    }

    public String getIconBase(Object object) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return WSDL_MESSAGE_VARIABLE_ICON;
            }
            if (object instanceof WsdlMessageValue.Part) {
                return WSDL_MESSAGE_PART_ICON;
            }
            if (object instanceof XmlElementVariable) {
                return XML_ELEMENT_VARIABLE_ICON;
            }
            if (object instanceof SimpleVariable) {
                return SIMPLE_VARIABLE_ICON;
            }
            return DEFAULT_VARIABLE_ICON;
        }
        if (object instanceof Node) {
            switch (((Node)object).getNodeType()) {
                case 1: {
                    return ELEMENT_NODE_ICON;
                }
                case 2: {
                    return ATTRIBUTE_NODE_ICON;
                }
                case 3: {
                    return TEXT_NODE_ICON;
                }
                case 4: {
                    return CDATA_NODE_ICON;
                }
            }
            return DEFAULT_NODE_ICON;
        }
        return DEFAULT_VARIABLE_ICON;
    }

    public Object[] getChildren(Object object) {
        if (object.equals("Root")) {
            ProcessInstance processInstance = this.myDebugger.getCurrentProcessInstance();
            if (processInstance != null) {
                return processInstance.getVariables();
            }
            return new Object[0];
        }
        if (object instanceof NamedValueHost) {
            Value value = ((NamedValueHost)object).getValue();
            if (value != null) {
                return this.getChildren(value);
            }
            return new Object[0];
        }
        if (object instanceof Node) {
            return this.getChildren((Node)object);
        }
        return new Object[0];
    }

    private Object[] getChildren(Node node) {
        int n;
        int n2;
        Object object;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (node.getNodeType() == 1) {
            object = (Element)node;
            NamedNodeMap namedNodeMap = object.getAttributes();
            n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2.getPrefix() != null && node2.getPrefix().equals("xmlns") || node2.getLocalName().equals("xmlns")) continue;
                linkedList.add(node2);
            }
        }
        if ((n = (object = node.getChildNodes()).getLength()) != 1 || object.item(0).getNodeType() != 3) {
            for (n2 = 0; n2 < n; ++n2) {
                Node node3 = object.item(n2);
                if (node3.getNodeType() == 8 || node3.getNodeType() == 3 && (node3.getNodeValue() == null || node3.getNodeValue().trim().equals(""))) continue;
                linkedList.add(node3);
            }
        }
        return linkedList.toArray(new Object[linkedList.size()]);
    }

    private Object[] getChildren(Value value) {
        if (value instanceof SimpleValue) {
            return new Object[0];
        }
        if (value instanceof WsdlMessageValue) {
            return ((WsdlMessageValue)value).getParts();
        }
        if (value instanceof XmlElementValue) {
            return this.getChildren(((XmlElementValue)value).getElement());
        }
        return new Object[0];
    }

    public String getType(Object object) {
        String string = null;
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                string = this.getType((WsdlMessageVariable)object);
            }
            if (object instanceof WsdlMessageValue.Part) {
                string = this.getType((WsdlMessageValue.Part)object);
            }
            if (object instanceof XmlElementVariable) {
                string = this.getType((XmlElementVariable)object);
            }
            if (object instanceof SimpleVariable) {
                string = this.getType((SimpleVariable)object);
            }
            if (string == null) {
                return "";
            }
            return " " + string + " ";
        }
        if (object instanceof Node) {
            string = this.getType((Node)object);
            if (string == null) {
                return "";
            }
            return " " + string + " ";
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_CannotResolveType", (Object)object);
    }

    public String getTypeTooltip(Object object) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return " " + this.getTypeTooltip((WsdlMessageVariable)object) + " ";
            }
            if (object instanceof WsdlMessageValue.Part) {
                return " " + this.getTypeTooltip((WsdlMessageValue.Part)object) + " ";
            }
            if (object instanceof XmlElementVariable) {
                return " " + this.getTypeTooltip((XmlElementVariable)object) + " ";
            }
            if (object instanceof SimpleVariable) {
                return " " + this.getTypeTooltip((SimpleVariable)object) + " ";
            }
        }
        if (object instanceof Node) {
            return " " + this.getTypeTooltip((Node)object) + " ";
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_CannotResolveType", (Object)object);
    }

    private String getType(WsdlMessageVariable wsdlMessageVariable) {
        QName qName = this.getTypeQName(wsdlMessageVariable);
        if (qName != null) {
            return this.formatShort(qName);
        }
        return null;
    }

    private String getType(WsdlMessageValue.Part part) {
        QName qName = this.getTypeQName(part);
        if (qName != null) {
            return this.formatShort(qName);
        }
        return null;
    }

    private String getType(XmlElementVariable xmlElementVariable) {
        QName qName = this.getTypeQName(xmlElementVariable);
        if (qName != null) {
            return this.formatShort(qName);
        }
        return null;
    }

    private String getType(SimpleVariable simpleVariable) {
        QName qName = this.getTypeQName(simpleVariable);
        if (qName != null) {
            return this.formatShort(qName);
        }
        return null;
    }

    private String getType(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return NbBundle.getMessage(VariablesUtil.class, (String)"VU_TypeElement");
            }
            case 2: {
                return NbBundle.getMessage(VariablesUtil.class, (String)"VU_TypeAttribute");
            }
            case 3: {
                return NbBundle.getMessage(VariablesUtil.class, (String)"VU_TypeText");
            }
            case 4: {
                return NbBundle.getMessage(VariablesUtil.class, (String)"VU_TypeCDATA");
            }
        }
        return null;
    }

    private String getTypeTooltip(WsdlMessageVariable wsdlMessageVariable) {
        QName qName = this.getTypeQName(wsdlMessageVariable);
        if (qName != null) {
            return this.formatLong(qName);
        }
        return null;
    }

    private String getTypeTooltip(WsdlMessageValue.Part part) {
        QName qName = this.getTypeQName(part);
        if (qName != null) {
            return this.formatLong(qName);
        }
        return null;
    }

    private String getTypeTooltip(XmlElementVariable xmlElementVariable) {
        QName qName = this.getTypeQName(xmlElementVariable);
        if (qName != null) {
            return this.formatLong(qName);
        }
        return null;
    }

    private String getTypeTooltip(SimpleVariable simpleVariable) {
        QName qName = this.getTypeQName(simpleVariable);
        if (qName != null) {
            return this.formatLong(qName);
        }
        return null;
    }

    private String getTypeTooltip(Node node) {
        return this.getType(node);
    }

    private QName getTypeQName(WsdlMessageVariable wsdlMessageVariable) {
        String string = wsdlMessageVariable.getName();
        Variable variable = this.getBpelVariable(string);
        if (variable != null) {
            return variable.getMessageType().getQName();
        }
        return null;
    }

    private QName getTypeQName(WsdlMessageValue.Part part) {
        Part part2;
        String string = part.getName();
        String string2 = part.getMessage().getValueHost().getName();
        Variable variable = this.getBpelVariable(string2);
        if (variable != null && (part2 = this.getWsdlMessagePart(variable, string)) != null) {
            NamedComponentReference namedComponentReference;
            QName qName = part2.getType() != null ? part2.getType().getQName() : ((namedComponentReference = ((GlobalElement)part2.getElement().get()).getType()) != null ? namedComponentReference.getQName() : part2.getElement().getQName());
            return qName;
        }
        return null;
    }

    private QName getTypeQName(XmlElementVariable xmlElementVariable) {
        String string = xmlElementVariable.getName();
        Variable variable = this.getBpelVariable(string);
        if (variable != null) {
            if (variable.getElement() != null) {
                return variable.getElement().getQName();
            }
            return variable.getType().getQName();
        }
        return null;
    }

    private QName getTypeQName(SimpleVariable simpleVariable) {
        String string = simpleVariable.getName();
        Variable variable = this.getBpelVariable(string);
        if (variable != null) {
            return variable.getType().getQName();
        }
        return null;
    }

    public String getValue(Object object) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return this.getValue((WsdlMessageVariable)object);
            }
            if (object instanceof WsdlMessageValue.Part) {
                return this.getValue((WsdlMessageValue.Part)object);
            }
            if (object instanceof XmlElementVariable) {
                return this.getValue((XmlElementVariable)object);
            }
            if (object instanceof SimpleVariable) {
                return this.getValue((SimpleVariable)object);
            }
        }
        if (object instanceof Node) {
            return this.getValue((Node)object);
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_CannotResolveValue", (Object)object);
    }

    public String getValueTooltip(Object object) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return " " + this.getValueTooltip((WsdlMessageVariable)object) + " ";
            }
            if (object instanceof WsdlMessageValue.Part) {
                return " " + this.getValueTooltip((WsdlMessageValue.Part)object) + " ";
            }
            if (object instanceof XmlElementVariable) {
                return " " + this.getValueTooltip((XmlElementVariable)object) + " ";
            }
            if (object instanceof SimpleVariable) {
                return " " + this.getValueTooltip((SimpleVariable)object) + " ";
            }
        }
        if (object instanceof Node) {
            return " " + this.getValueTooltip((Node)object) + " ";
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_CannotResolveValue", (Object)object);
    }

    private String getValue(WsdlMessageVariable wsdlMessageVariable) {
        WsdlMessageValue wsdlMessageValue = (WsdlMessageValue)wsdlMessageVariable.getValue();
        if (wsdlMessageValue != null) {
            return NbBundle.getMessage(VariablesUtil.class, (String)"VU_ValueWSDL", (Object)wsdlMessageValue.getParts().length);
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_ValueNotInitialized", (Object)this.getDisplayName(wsdlMessageVariable));
    }

    private String getValue(WsdlMessageValue.Part part) {
        if (part.getValue() == null) {
            return NbBundle.getMessage(VariablesUtil.class, (String)"VU_ValueNotInitialized", (Object)this.getDisplayName(part));
        }
        if (part.getValue() instanceof XmlElementValue) {
            return this.getValue(((XmlElementValue)part.getValue()).getElement());
        }
        return ((SimpleValue)part.getValue()).getValueAsString();
    }

    private String getValue(XmlElementVariable xmlElementVariable) {
        if (xmlElementVariable.getValue() != null) {
            return this.getValue(((XmlElementValue)xmlElementVariable.getValue()).getElement());
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_ValueNotInitialized", (Object)this.getDisplayName(xmlElementVariable));
    }

    private String getValue(SimpleVariable simpleVariable) {
        if (simpleVariable.getValue() != null) {
            return ((SimpleValue)simpleVariable.getValue()).getValueAsString();
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_ValueNotInitialized", (Object)this.getDisplayName(simpleVariable));
    }

    private String getValue(Node node) {
        if (node.getNodeType() == 1) {
            if (XmlUtil.isTextOnlyNode(node)) {
                return node.getChildNodes().item(0).getNodeValue();
            }
            return NbBundle.getMessage(VariablesUtil.class, (String)"VU_ValueXMLData");
        }
        return node.getTextContent();
    }

    private String getValueTooltip(WsdlMessageVariable wsdlMessageVariable) {
        return this.getValue(wsdlMessageVariable);
    }

    private String getValueTooltip(WsdlMessageValue.Part part) {
        return this.getValue(part);
    }

    private String getValueTooltip(XmlElementVariable xmlElementVariable) {
        return this.getValue(xmlElementVariable);
    }

    private String getValueTooltip(SimpleVariable simpleVariable) {
        return this.getValue(simpleVariable);
    }

    private String getValueTooltip(Node node) {
        return this.getValue(node);
    }

    public boolean isValueReadOnly(Object object) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return this.isValueReadOnly((WsdlMessageVariable)object);
            }
            if (object instanceof WsdlMessageValue.Part) {
                return this.isValueReadOnly((WsdlMessageValue.Part)object);
            }
            if (object instanceof XmlElementVariable) {
                return this.isValueReadOnly((XmlElementVariable)object);
            }
            if (object instanceof SimpleVariable) {
                return this.isValueReadOnly((SimpleVariable)object);
            }
        }
        if (object instanceof Node) {
            return this.isValueReadOnly((Node)object);
        }
        return true;
    }

    private boolean isValueReadOnly(WsdlMessageVariable wsdlMessageVariable) {
        return true;
    }

    private boolean isValueReadOnly(WsdlMessageValue.Part part) {
        return part.getValue() instanceof XmlElementValue;
    }

    private boolean isValueReadOnly(XmlElementVariable xmlElementVariable) {
        return true;
    }

    private boolean isValueReadOnly(SimpleVariable simpleVariable) {
        return simpleVariable.getValue() == null;
    }

    private boolean isValueReadOnly(Node node) {
        if (!(node.getNodeType() != 2 || node.getNodeName().equals("xmlns") || node.getNodeName().equals("targetNamespace") || node.getNodeName().startsWith("xmlns:"))) {
            return false;
        }
        return !XmlUtil.isTextOnlyNode(node);
    }

    public void setValue(Object object, String string) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                // empty if block
            }
            if (object instanceof WsdlMessageValue.Part) {
                this.setValue((WsdlMessageValue.Part)object, string);
            }
            if (object instanceof XmlElementVariable) {
                // empty if block
            }
            if (object instanceof SimpleVariable) {
                this.setValue((SimpleVariable)object, string);
            }
        }
        if (object instanceof Node) {
            this.setValue((Node)object, string);
        }
    }

    private void setValue(WsdlMessageValue.Part part, String string) {
        if (!(part.getValue() instanceof SimpleValue)) {
            return;
        }
        NamedValueHost namedValueHost = part.getMessage().getValueHost();
        if (namedValueHost instanceof WsdlMessageVariable) {
            ((WsdlMessageVariable)namedValueHost).setPartSimpleValue(part, string);
        }
    }

    private void setValue(SimpleVariable simpleVariable, String string) {
        simpleVariable.setValue(string);
    }

    private void setValue(Node node, String string) {
        WsdlMessageValue.Part part;
        NamedValueHost namedValueHost;
        if (XmlUtil.isTextOnlyNode(node)) {
            this.setValue(node.getChildNodes().item(0), string);
            return;
        }
        XmlElementValue xmlElementValue = XmlElementValue.Helper.find((Node)node);
        NamedValueHost namedValueHost2 = xmlElementValue.getValueHost();
        if (namedValueHost2 instanceof XmlElementVariable) {
            ((XmlElementVariable)namedValueHost2).setNodeValue(node, string);
            return;
        }
        if (namedValueHost2 instanceof WsdlMessageValue.Part && (namedValueHost = (part = (WsdlMessageValue.Part)namedValueHost2).getMessage().getValueHost()) instanceof WsdlMessageVariable) {
            ((WsdlMessageVariable)namedValueHost).setPartNodeValue(part, node, string);
        }
        node.setNodeValue(string);
    }

    public boolean supportsCustomEditor(Object object) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return false;
            }
            if (object instanceof WsdlMessageValue.Part) {
                return ((NamedValueHost)object).getValue() != null;
            }
            if (object instanceof XmlElementVariable) {
                return ((NamedValueHost)object).getValue() != null;
            }
            if (object instanceof SimpleVariable) {
                return ((NamedValueHost)object).getValue() != null;
            }
        }
        return object instanceof Node;
    }

    public String getCustomEditorValue(Object object) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return null;
            }
            if (object instanceof WsdlMessageValue.Part) {
                Value value = ((NamedValueHost)object).getValue();
                if (value instanceof XmlElementValue) {
                    return XmlUtil.toString(((XmlElementValue)value).getElement());
                }
                return this.getValue((WsdlMessageValue.Part)object);
            }
            if (object instanceof XmlElementVariable) {
                XmlElementValue xmlElementValue = (XmlElementValue)((XmlElementVariable)object).getValue();
                return XmlUtil.toString(xmlElementValue.getElement());
            }
            if (object instanceof SimpleVariable) {
                return this.getValue((SimpleVariable)object);
            }
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            if (node instanceof Element && !XmlUtil.isTextOnlyNode(node)) {
                return XmlUtil.toString(node);
            }
            return ((Node)object).getTextContent();
        }
        return NbBundle.getMessage(VariablesUtil.class, (String)"VU_CannotResolveValue", (Object)object);
    }

    public String getCustomEditorMimeType(Object object) {
        if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return null;
            }
            if (object instanceof WsdlMessageValue.Part) {
                Value value = ((NamedValueHost)object).getValue();
                if (value instanceof XmlElementValue) {
                    return "text/xml";
                }
                return "text/plain";
            }
            if (object instanceof XmlElementVariable) {
                return "text/xml";
            }
            if (object instanceof SimpleVariable) {
                return "text/plain";
            }
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            if (node instanceof Element && !XmlUtil.isTextOnlyNode(node)) {
                return "text/xml";
            }
            return "text/plain";
        }
        return "text/plain";
    }

    public BpelModel getBpelModel() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        SourcePath sourcePath = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
        ProcessInstance processInstance = this.myDebugger.getCurrentProcessInstance();
        if (sourcePath == null || processInstance == null) {
            return null;
        }
        return EditorUtil.getBpelModel(sourcePath.getSourcePath(processInstance.getProcess().getQName()));
    }

    public Variable getBpelVariable(String string) {
        ProcessInstance processInstance;
        LinkedList<Variable> linkedList = new LinkedList<Variable>();
        BpelModel bpelModel = this.getBpelModel();
        if (bpelModel == null) {
            return null;
        }
        VariableContainer variableContainer = bpelModel.getProcess().getVariableContainer();
        if (variableContainer != null && variableContainer.sizeOfVariable() > 0) {
            linkedList.addAll(Arrays.asList(variableContainer.getVariables()));
        }
        if ((processInstance = this.myDebugger.getCurrentProcessInstance()) == null) {
            return null;
        }
        Position position = processInstance.getCurrentPosition();
        if (position == null) {
            return null;
        }
        String string2 = position.getXpath();
        int n = string2.indexOf("scope");
        while (n != -1) {
            int n2 = string2.indexOf("/", n);
            Object object = n2 == -1 ? string2 : string2.substring(0, n2);
            Scope scope = this.getScopeEntity((String)object);
            if (scope != null && (variableContainer = scope.getVariableContainer()) != null && variableContainer.sizeOfVariable() > 0) {
                linkedList.addAll(Arrays.asList(variableContainer.getVariables()));
            }
            n = n2 == -1 ? n2 : string2.indexOf("scope", n2);
        }
        for (Object object : linkedList) {
            if (!object.getName().equals(string)) continue;
            return object;
        }
        return null;
    }

    public Scope getScopeEntity(String string) {
        BpelModel bpelModel = this.getBpelModel();
        if (bpelModel == null) {
            return null;
        }
        Process process = bpelModel.getProcess();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        block0: while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            int n2 = 1;
            if (string2.equals("")) continue;
            int n3 = string2.indexOf(":");
            if (n3 > -1) {
                string2 = string2.substring(n3 + 1);
            }
            if ((n = string2.indexOf("[")) > -1) {
                int n4 = string2.lastIndexOf("]");
                n2 = Integer.parseInt(string2.substring(n + 1, n4));
                string2 = string2.substring(0, n);
            }
            if (string2.equals("process")) continue;
            for (BpelEntity bpelEntity : process.getChildren()) {
                if (bpelEntity.getPeer().getNodeName().equals(string2)) {
                    --n2;
                }
                if (n2 != 0) continue;
                process = bpelEntity;
                continue block0;
            }
        }
        return (Scope)(process instanceof Scope ? process : null);
    }

    public Part getWsdlMessagePart(Variable variable, String string) {
        WSDLReference wSDLReference = variable.getMessageType();
        if (wSDLReference == null) {
            return null;
        }
        Message message = (Message)wSDLReference.get();
        for (Part part : message.getParts()) {
            if (!part.getName().equals(string)) continue;
            return part;
        }
        return null;
    }

    public String formatShort(QName qName) {
        return qName.getPrefix() + ":" + qName.getLocalPart();
    }

    public String formatLong(QName qName) {
        return "{" + qName.getNamespaceURI() + "} " + qName.getLocalPart();
    }
}

