/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.editor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.bpel.core.SelectBpelElement;
import org.netbeans.modules.bpel.debugger.api.AnnotationType;
import org.netbeans.modules.bpel.debugger.spi.EditorContext;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BreakpointTranslator;
import org.netbeans.modules.bpel.debugger.ui.editor.BpelAnnotation;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.Log;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelEditorContext
implements EditorContext {
    private Map<BpelAnnotation, PropertyChangeSupport> myAnnotationToListeners = new IdentityHashMap<BpelAnnotation, PropertyChangeSupport>();
    private Map<EditorCookie, Set<BpelAnnotation>> myEditorToAnnotations = new HashMap<EditorCookie, Set<BpelAnnotation>>();
    private BreakpointTranslator myTranslator;

    public Object addAnnotation(String string, String string2, int n, AnnotationType annotationType) {
        DataObject dataObject = EditorUtil.getDataObject(string);
        if (dataObject == null) {
            Log.out("DataObject is null: " + string);
            return null;
        }
        BpelModel bpelModel = EditorUtil.getBpelModel(dataObject);
        if (bpelModel == null) {
            Log.out("BpelModel is null: " + string);
            return null;
        }
        BpelAnnotation bpelAnnotation = new BpelAnnotation(annotationType, dataObject, string2, n);
        if (bpelAnnotation.attach()) {
            return bpelAnnotation;
        }
        return null;
    }

    public void removeAnnotation(Object object) {
        BpelAnnotation bpelAnnotation = (BpelAnnotation)object;
        bpelAnnotation.detach();
    }

    public boolean isAttached(Object object) {
        BpelAnnotation bpelAnnotation = (BpelAnnotation)object;
        return bpelAnnotation.getState() == BpelAnnotation.State.ATTACHED;
    }

    public boolean isValid(Object object) {
        BpelAnnotation bpelAnnotation = (BpelAnnotation)object;
        return !bpelAnnotation.getType().isForDiagram() || bpelAnnotation.getBpelModel().getEntity(bpelAnnotation.getBpelEntityId()) != null;
    }

    public AnnotationType getAnnotationType(Object object) {
        BpelAnnotation bpelAnnotation = (BpelAnnotation)object;
        return bpelAnnotation.getType();
    }

    public String getXpath(Object object) {
        BpelAnnotation bpelAnnotation = (BpelAnnotation)object;
        return bpelAnnotation.getXpath();
    }

    public int getLineNumber(Object object) {
        BpelAnnotation bpelAnnotation = (BpelAnnotation)object;
        return bpelAnnotation.getLineNumber();
    }

    public QName getProcessQName(String string) {
        BpelModel bpelModel = EditorUtil.getBpelModel(string);
        if (bpelModel == null) {
            Log.out("BpelModel is null: " + string);
            return null;
        }
        Process process = bpelModel.getProcess();
        if (process == null) {
            Log.out("Process is null: " + string);
            return null;
        }
        if (process.getName() == null) {
            Log.out("Process name is null: " + string);
            return null;
        }
        return new QName(process.getTargetNamespace(), process.getName());
    }

    public QName getCurrentProcessQName() {
        Node[] nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return null;
        }
        BpelModel bpelModel = (BpelModel)nodeArray[0].getLookup().lookup(BpelModel.class);
        if (bpelModel == null) {
            return null;
        }
        try {
            return new QName(bpelModel.getProcess().getTargetNamespace(), bpelModel.getProcess().getName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean showSource(String string, String string2, String string3) {
        DataObject dataObject = EditorUtil.getDataObject(string);
        if (dataObject == null) {
            Log.out("DataObject is null: " + string);
            return false;
        }
        BpelModel bpelModel = EditorUtil.getBpelModel(dataObject);
        if (bpelModel == null) {
            Log.out("BpelModel is null: " + string);
            return false;
        }
        UniqueId uniqueId = ModelUtil.getBpelEntityId(bpelModel, string2);
        if (uniqueId == null) {
            Log.out("BPEL Entity not found: " + dataObject + ", " + string2);
            return false;
        }
        this.showBpelEntity(uniqueId, string3);
        return true;
    }

    public int translateBreakpointLine(String string, int n) {
        return this.getBreakpointTranslator().translateBreakpointLine(string, n);
    }

    public synchronized void addAnnotationListener(Object object, PropertyChangeListener propertyChangeListener) {
        BpelAnnotation bpelAnnotation = (BpelAnnotation)object;
        bpelAnnotation.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeAnnotationListener(Object object, PropertyChangeListener propertyChangeListener) {
        BpelAnnotation bpelAnnotation = (BpelAnnotation)object;
        bpelAnnotation.removePropertyChangeListener(propertyChangeListener);
    }

    private BreakpointTranslator getBreakpointTranslator() {
        if (this.myTranslator == null) {
            this.myTranslator = new BreakpointTranslator();
        }
        return this.myTranslator;
    }

    private void showBpelEntity(final UniqueId uniqueId, final String string) {
        BpelModel bpelModel = uniqueId.getModel();
        final BpelEntity bpelEntity = bpelModel.getEntity(uniqueId);
        final DataObject dataObject = (DataObject)bpelModel.getModelSource().getLookup().lookup(DataObject.class);
        final LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (lineCookie == null || editCookie == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - void declaration
             */
            public void run() {
                MultiViewPerspective multiViewPerspective;
                Object object;
                editCookie.edit();
                TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
                if (multiViewHandler == null) {
                    return;
                }
                Object object2 = multiViewHandler.getSelectedPerspective();
                if (string != null) {
                    for (MultiViewPerspective object3 : multiViewHandler.getPerspectives()) {
                        if (!object3.preferredID().equals(string)) continue;
                        object2 = object3;
                        break;
                    }
                    multiViewHandler.requestVisible(object2);
                    multiViewHandler.requestActive(object2);
                } else {
                    object = multiViewHandler.getSelectedPerspective().preferredID();
                    if (!((String)object).equals("orch-designer") && !((String)object).equals("bpelsource")) {
                        void var7_14;
                        MultiViewPerspective[] multiViewPerspectiveArray = multiViewHandler.getPerspectives();
                        int n = multiViewPerspectiveArray.length;
                        boolean bl = false;
                        while (var7_14 < n) {
                            multiViewPerspective = multiViewPerspectiveArray[var7_14];
                            if (multiViewPerspective.preferredID().equals("orch-designer")) {
                                object2 = multiViewPerspective;
                                break;
                            }
                            ++var7_14;
                        }
                        multiViewHandler.requestVisible(object2);
                        multiViewHandler.requestActive(object2);
                    }
                }
                if (object2.preferredID().equals("orch-designer")) {
                    object = BpelEditorContext.this.getAssociatedTopComponents(dataObject);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        TopComponent topComponent2 = (TopComponent)iterator.next();
                        MultiViewHandler multiViewHandler2 = MultiViews.findMultiViewHandler((TopComponent)topComponent2);
                        if (multiViewHandler2 == null || topComponent2 == null) continue;
                        multiViewPerspective = (SelectBpelElement)topComponent2.getLookup().lookup(SelectBpelElement.class);
                        if (multiViewPerspective == null) {
                            return;
                        }
                        multiViewPerspective.select(bpelEntity);
                    }
                } else if (object2.preferredID().equals("bpelsource")) {
                    int n = ModelUtil.getLineNumber(uniqueId);
                    if (n < 0) {
                        return;
                    }
                    Line line = lineCookie.getLineSet().getCurrent(n - 1);
                    line.show(2);
                }
            }
        });
    }

    private List<TopComponent> getAssociatedTopComponents(DataObject dataObject) {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && dataObject == topComponent.getLookup().lookup(DataObject.class)) {
            arrayList.add(topComponent);
        }
        Set set = TopComponent.getRegistry().getOpened();
        for (Object e : set) {
            TopComponent topComponent2 = (TopComponent)e;
            if (dataObject != topComponent2.getLookup().lookup(DataObject.class)) continue;
            arrayList.add(topComponent2);
        }
        return arrayList;
    }
}

