/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.namespace.QName;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.breakpoints.BpelFaultBreakpoint;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BpelFaultBreakpointPanel
extends JPanel
implements Controller {
    private BpelFaultBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JCheckBox cbAllFaults;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel pSettings;
    private JTextField tfFaultName;
    private JTextField tfFaultNamespace;
    private JTextField tfProcessName;
    private JTextField tfProcessNamespace;

    private static BpelFaultBreakpoint createBreakpoint() {
        BpelFaultBreakpoint bpelFaultBreakpoint = BpelFaultBreakpoint.create((QName)EditorContextBridge.getCurrentProcessQName(), null);
        return bpelFaultBreakpoint;
    }

    public BpelFaultBreakpointPanel() {
        this(BpelFaultBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public BpelFaultBreakpointPanel(BpelFaultBreakpoint bpelFaultBreakpoint) {
        this.breakpoint = bpelFaultBreakpoint;
        this.initComponents();
        if (this.breakpoint.getProcessQName() != null) {
            this.tfProcessNamespace.setText(this.breakpoint.getProcessQName().getNamespaceURI());
            this.tfProcessName.setText(this.breakpoint.getProcessQName().getLocalPart());
        }
        if (this.breakpoint.getFaultQName() != null) {
            this.tfFaultNamespace.setText(this.breakpoint.getFaultQName().getNamespaceURI());
            this.tfFaultName.setText(this.breakpoint.getFaultQName().getLocalPart());
            this.cbAllFaults.setSelected(false);
        } else {
            this.tfFaultNamespace.setEnabled(false);
            this.tfFaultName.setEnabled(false);
            this.cbAllFaults.setSelected(true);
        }
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.tfProcessName = new JTextField();
        this.tfProcessNamespace = new JTextField();
        this.jLabel4 = new JLabel();
        this.tfFaultNamespace = new JTextField();
        this.jLabel5 = new JLabel();
        this.tfFaultName = new JTextField();
        this.cbAllFaults = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/bpel/debugger/ui/breakpoint/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Fault_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.tfProcessNamespace);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)resourceBundle.getString("L_Fault_Breakpoint_Process_Namespace"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Fault_Breakpoint_Process_Namespace"));
        this.jLabel3.setLabelFor(this.tfProcessName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("L_Fault_Breakpoint_Process_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Fault_Breakpoint_Process_Name"));
        this.tfProcessName.setToolTipText(resourceBundle.getString("TTT_TF_Fault_Breakpoint_Process_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfProcessName, gridBagConstraints);
        this.tfProcessName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Fault_Breakpoint_Process_Name"));
        this.tfProcessNamespace.setToolTipText(resourceBundle.getString("TTT_TF_Fault_Breakpoint_Process_Namespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfProcessNamespace, gridBagConstraints);
        this.tfProcessNamespace.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Fault_Breakpoint_Process_Namespace"));
        this.jLabel4.setLabelFor(this.tfFaultNamespace);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)resourceBundle.getString("L_Fault_Breakpoint_Fault_Namespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Fault_Breakpoint_Fault_Namespace"));
        this.tfFaultNamespace.setToolTipText(resourceBundle.getString("ACSD_L_Fault_Breakpoint_Fault_Namespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFaultNamespace, gridBagConstraints);
        this.tfFaultNamespace.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Fault_Breakpoint_Fault_Namespace"));
        this.jLabel5.setLabelFor(this.tfFaultName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)resourceBundle.getString("L_Fault_Breakpoint_Fault_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Fault_Breakpoint_Fault_Name"));
        this.tfFaultName.setToolTipText(resourceBundle.getString("TTT_TF_Fault_Breakpoint_Fault_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFaultName, gridBagConstraints);
        this.tfFaultName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Fault_Breakpoint_Fault_Name"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAllFaults, (String)resourceBundle.getString("CB_Fault_Breakpoint_All_Faults"));
        this.cbAllFaults.setMargin(new Insets(0, 0, 0, 0));
        this.cbAllFaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BpelFaultBreakpointPanel.this.cbAllFaultsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbAllFaults, gridBagConstraints);
        this.cbAllFaults.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BpelFaultBreakpointPanel.class, (String)"ACS_All_Faults_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void cbAllFaultsActionPerformed(ActionEvent actionEvent) {
        if (this.cbAllFaults.isSelected()) {
            this.tfFaultNamespace.setEnabled(false);
            this.tfFaultName.setEnabled(false);
        } else {
            this.tfFaultNamespace.setEnabled(true);
            this.tfFaultName.setEnabled(true);
        }
    }

    public boolean ok() {
        String string = this.tfProcessNamespace.getText().trim();
        String string2 = this.tfProcessName.getText().trim();
        String string3 = this.tfFaultNamespace.getText().trim();
        String string4 = this.tfFaultName.getText().trim();
        boolean bl = this.cbAllFaults.isSelected();
        if (string2.equals("")) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(BpelFaultBreakpointPanel.class, (String)"MSG_No_Process_Name_Spec"));
            return false;
        }
        if (!bl && string4.equals("")) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(BpelFaultBreakpointPanel.class, (String)"MSG_No_Fault_Name_Spec"));
            return false;
        }
        this.breakpoint.setProcessQName(new QName(string.equals("") ? null : string, string2));
        if (bl) {
            this.breakpoint.setFaultQName(null);
        } else {
            this.breakpoint.setFaultQName(new QName(string3.equals("") ? null : string3, string4));
        }
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }
}

