/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bpel.debugger.api.AttachingCookie;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BpelConnectPanel
extends JPanel
implements Controller {
    private static final String PROPERTIES_KEY = "BpelDebuggerConnection";
    private JTextField mHostField;
    private JTextField mPortField;
    private static final String DEFAULT_PORT = "3343";
    private static final String DEFAULT_HOST = "localhost";

    public BpelConnectPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.mHostField = new JTextField(BpelConnectPanel.getSavedHost());
        String string = NbBundle.getMessage(BpelConnectPanel.class, (String)"CTL_Host");
        this.addSettingUI(string, this.mHostField);
        this.mPortField = new JTextField(BpelConnectPanel.getSavedPort());
        String string2 = NbBundle.getMessage(BpelConnectPanel.class, (String)"CTL_Port");
        this.addSettingUI(string2, this.mPortField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(1, 1));
        this.add((Component)jPanel, gridBagConstraints);
    }

    public boolean isValid() {
        return true;
    }

    public boolean cancel() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ok() {
        String string = this.mHostField.getText();
        String string2 = this.mPortField.getText();
        BpelConnectPanel.saveArgs(string, string2);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(BpelConnectPanel.class, (String)"CTL_connectProgress"));
        try {
            progressHandle.start();
            DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-bpel-AttachingDICookie", (Object[])new Object[]{AttachingCookie.create((String)string, (String)string2)}));
        }
        finally {
            progressHandle.finish();
        }
        return true;
    }

    private void addSettingUI(String string, JTextField jTextField) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 0, 0, 3);
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(string);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
        jLabel.setToolTipText(string);
        this.add((Component)jLabel, gridBagConstraints);
        jLabel.setLabelFor(jTextField);
        jTextField.setName(string);
        jTextField.getAccessibleContext().setAccessibleDescription(new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"ACSD_CTL_Argument")).format(new Object[]{string}));
        jTextField.setToolTipText(string);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jTextField, gridBagConstraints);
    }

    private static String getSavedHost() {
        String string;
        Map map = Properties.getDefault().getProperties("debugger").getMap("connection_settings", new HashMap());
        Map map2 = (Map)map.get(PROPERTIES_KEY);
        if (map2 != null && (string = (String)map2.get("host")) != null) {
            return string;
        }
        return DEFAULT_HOST;
    }

    private static String getSavedPort() {
        String string;
        Map map = Properties.getDefault().getProperties("debugger").getMap("connection_settings", new HashMap());
        Map map2 = (Map)map.get(PROPERTIES_KEY);
        if (map2 != null && (string = (String)map2.get("port")) != null) {
            return string;
        }
        return DEFAULT_PORT;
    }

    private static void saveArgs(String string, String string2) {
        Map map = Properties.getDefault().getProperties("debugger").getMap("connection_settings", new HashMap());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("host", string);
        hashMap.put("port", string2);
        map.put(PROPERTIES_KEY, hashMap);
        Properties.getDefault().getProperties("debugger").setString("last_attaching_connector", PROPERTIES_KEY);
        Properties.getDefault().getProperties("debugger").setMap("connection_settings", map);
    }
}

