/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.http.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.web.client.javascript.debugger.http.api.HttpActivity;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.HttpMonitorPreferences;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.HttpMonitorUtility;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.HttpActivitiesModel;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.HttpHeaderModel;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSHttpRequest;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.Models;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class HttpMonitorTopComponent
extends TopComponent {
    private static HttpMonitorTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/web/client/javascript/debugger/http/ui/resources/HttpMonitor.png";
    static final String START_ICON_PATH = "/org/netbeans/modules/web/client/javascript/debugger/http/ui/resources/Continue.gif";
    static final String STOP_ICON_PATH = "/org/netbeans/modules/web/client/javascript/debugger/http/ui/resources/Kill.gif";
    private static final Model METHOD_COLUMN;
    private static final Model SENT_COLUMN;
    private static final Model RESPONSE_COLUMN;
    private static final Model VALUE_COLUMN;
    private static final String PREFERRED_ID = "HttpMonitorTopComponent";
    private static final HttpMonitorPreferences httpMonitorPreferences;
    private final ActivitiesPropertyChange activityPropertyChangeListener = new ActivitiesPropertyChange();
    private final DebuggerManagerListenerImpl debuggerManagerListener = new DebuggerManagerListenerImpl();
    private final Logger LOG = Logger.getLogger(HttpMonitorTopComponent.class.getName());
    private JComponent tableView;
    private Icon StartIcon;
    private Icon StopIcon;
    private static final String PREF_HttpMonitorSplitPane_DIVIDERLOC = "HttpMonitorSplitPane_DIVIDERLOC";
    private static final String PREF_DetailsSplitPane_DIVIDERLOC = "DetailsSplitPane_DIVIDERLOC";
    private JPanel activitiesModelPanel;
    private JToolBar activitiesToolbar;
    private JToggleButton all_filterButton;
    private JButton cleanButton;
    private JToggleButton css_filterButton;
    private JPanel detailsPanel;
    private JSplitPane detailsSplitPane;
    private JToggleButton flash_filterButton;
    private JToggleButton html_filterButton;
    private JSplitPane httpMonitorSplitPane;
    private JPanel httpReqPanel;
    private JPanel httpResPanel;
    private JToggleButton images_filterButton;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JToolBar.Separator jSeparator1;
    private JToggleButton js_filterButton;
    private JPanel outerActivitiesPanel;
    private JPanel reqHeaderPanel;
    private JLabel reqLabel;
    private JPanel reqParamPanel;
    private JTextArea reqParamTextArea;
    private JTabbedPane reqTabbedPane;
    private JEditorPane resBodyEditorPane;
    private JPanel resBodyPanel;
    private JPanel resHeaderPanel;
    private JLabel resLabel;
    private JTabbedPane resTabbedPane;
    private JButton start_stopMonitoring;
    private JToggleButton xhr_filterButton;

    private HttpMonitorTopComponent() {
        this.LOG.entering(HttpMonitorTopComponent.class.getName(), "constructor");
        this.initComponents();
        this.setName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"CTL_HttpMonitorTopComponent"));
        this.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HINT_HttpMonitorTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.LOG.exiting(HttpMonitorTopComponent.class.getName(), "constructor");
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        debuggerManager.addDebuggerListener("currentSession", (DebuggerManagerListener)this.debuggerManagerListener);
        debuggerManager.addDebuggerListener("sessions", (DebuggerManagerListener)this.debuggerManagerListener);
        this.resBodyEditorPane.setContentType("text/plain");
    }

    private final Icon getStartStopIcon() {
        Icon icon;
        if (HttpMonitorUtility.isEnabled()) {
            this.StopIcon = icon = this.StopIcon != null ? this.StopIcon : new ImageIcon(((Object)((Object)this)).getClass().getResource(STOP_ICON_PATH));
        } else {
            this.StartIcon = icon = this.StartIcon != null ? this.StartIcon : new ImageIcon(((Object)((Object)this)).getClass().getResource(START_ICON_PATH));
        }
        return icon;
    }

    public ExplorerManager getActivityExplorerManager() {
        assert (this.tableView instanceof ExplorerManager.Provider);
        ExplorerManager explorerManager = ((ExplorerManager.Provider)this.tableView).getExplorerManager();
        return explorerManager;
    }

    private JComponent createActivitiesTable() {
        Models.CompoundModel compoundModel = HttpMonitorTopComponent.createViewCompoundModel(HttpMonitorUtility.getCurrentHttpMonitorModel());
        this.tableView = Models.createView((Models.CompoundModel)compoundModel);
        this.getActivityExplorerManager().addPropertyChangeListener((PropertyChangeListener)this.activityPropertyChangeListener);
        return this.tableView;
    }

    private JComponent createResponseView() {
        HttpResponseModel httpResponseModel = new HttpResponseModel(this.getActivityExplorerManager());
        JComponent jComponent = Models.createView((Models.CompoundModel)this.createHeaderCompoundModel((Model)httpResponseModel));
        return jComponent;
    }

    private JComponent createRequestView() {
        HttpRequestModel httpRequestModel = new HttpRequestModel(this.getActivityExplorerManager());
        JComponent jComponent = Models.createView((Models.CompoundModel)this.createHeaderCompoundModel((Model)httpRequestModel));
        return jComponent;
    }

    private Models.CompoundModel createHeaderCompoundModel(Model model) {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        if (arrayList != null) {
            arrayList.add(model);
            arrayList.add(VALUE_COLUMN);
        }
        return Models.createCompoundModel(arrayList);
    }

    private void resetHttpActivitesModel(HttpActivitiesModel httpActivitiesModel) {
        Models.CompoundModel compoundModel = HttpMonitorTopComponent.createViewCompoundModel(httpActivitiesModel);
        Models.setModelsToView((JComponent)this.tableView, (Models.CompoundModel)compoundModel);
    }

    private static Models.CompoundModel createViewCompoundModel(HttpActivitiesModel httpActivitiesModel) {
        ArrayList<HttpActivitiesModel> arrayList = new ArrayList<HttpActivitiesModel>();
        if (httpActivitiesModel != null) {
            arrayList.add(httpActivitiesModel);
            arrayList.add((HttpActivitiesModel)METHOD_COLUMN);
            arrayList.add((HttpActivitiesModel)SENT_COLUMN);
            arrayList.add((HttpActivitiesModel)RESPONSE_COLUMN);
        }
        Models.CompoundModel compoundModel = Models.createCompoundModel(arrayList);
        return compoundModel;
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HttpMonitorTopComponent.this.detailsSplitPane.setDividerLocation(HttpMonitorTopComponent.this.getDetailsDividerLoc());
                HttpMonitorTopComponent.this.httpMonitorSplitPane.setDividerLocation(HttpMonitorTopComponent.this.getHttpMonitorDividerLoc());
            }
        });
    }

    public void removeNotify() {
        super.removeNotify();
        this.setDetailsDividerLoc();
        this.setHttpMonitorDividerLoc();
    }

    protected void componentClosed() {
        this.LOG.entering(HttpMonitorTopComponent.class.getName(), "componentClosed");
        super.componentClosed();
        HttpMonitorUtility.setHttpMonitorOpened(false);
        instance = null;
        this.LOG.exiting(HttpMonitorTopComponent.class.getName(), "componentClosed");
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
    }

    protected void componentActivated() {
        super.componentActivated();
    }

    protected void componentHidden() {
        super.componentHidden();
    }

    protected void componentShowing() {
        super.componentShowing();
    }

    protected void componentOpened() {
        this.LOG.entering(HttpMonitorTopComponent.class.getName(), "componentOpened");
        super.componentOpened();
        HttpMonitorUtility.setHttpMonitorOpened(true);
        this.LOG.exiting(HttpMonitorTopComponent.class.getName(), "componentOpened");
    }

    private double getHttpMonitorDividerLoc() {
        double d = NbPreferences.forModule(HttpMonitorTopComponent.class).getDouble(PREF_HttpMonitorSplitPane_DIVIDERLOC, 0.5);
        if (d >= 1.0 || d <= 0.0) {
            NbPreferences.forModule(HttpMonitorTopComponent.class).putDouble(PREF_HttpMonitorSplitPane_DIVIDERLOC, 0.5);
            d = 0.5;
        }
        return d;
    }

    private double getDetailsDividerLoc() {
        double d = NbPreferences.forModule(HttpMonitorTopComponent.class).getDouble(PREF_DetailsSplitPane_DIVIDERLOC, 0.5);
        if (d >= 1.0 || d <= 0.0) {
            NbPreferences.forModule(HttpMonitorTopComponent.class).putDouble(PREF_DetailsSplitPane_DIVIDERLOC, 0.5);
            d = 0.5;
        }
        return d;
    }

    private void setHttpMonitorDividerLoc() {
        double d;
        double d2 = this.httpMonitorSplitPane.getDividerLocation();
        if (d2 > 1.0) {
            double d3 = this.httpMonitorSplitPane.getHeight();
            d = d2 / d3;
            assert (d < 1.0 && d > 0.0);
        } else {
            d = d2;
        }
        NbPreferences.forModule(HttpMonitorTopComponent.class).putDouble(PREF_HttpMonitorSplitPane_DIVIDERLOC, d);
    }

    private void setDetailsDividerLoc() {
        double d;
        double d2 = this.detailsSplitPane.getDividerLocation();
        if (d2 > 1.0) {
            double d3 = this.detailsSplitPane.getWidth();
            d = d2 / d3;
            assert (d < 1.0);
        } else {
            d = d2;
        }
        NbPreferences.forModule(HttpMonitorTopComponent.class).putDouble(PREF_DetailsSplitPane_DIVIDERLOC, d);
    }

    private void initComponents() {
        this.httpMonitorSplitPane = new JSplitPane();
        this.outerActivitiesPanel = new JPanel();
        this.activitiesToolbar = new JToolBar();
        this.start_stopMonitoring = new JButton();
        this.cleanButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.all_filterButton = new JToggleButton();
        this.html_filterButton = new JToggleButton();
        this.js_filterButton = new JToggleButton();
        this.xhr_filterButton = new JToggleButton();
        this.css_filterButton = new JToggleButton();
        this.images_filterButton = new JToggleButton();
        this.flash_filterButton = new JToggleButton();
        this.activitiesModelPanel = new JPanel();
        this.detailsPanel = new JPanel();
        this.detailsSplitPane = new JSplitPane();
        this.httpReqPanel = new JPanel();
        this.reqLabel = new JLabel();
        this.reqTabbedPane = new JTabbedPane();
        this.reqHeaderPanel = new JPanel();
        this.reqParamPanel = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.reqParamTextArea = new JTextArea();
        this.httpResPanel = new JPanel();
        this.resLabel = new JLabel();
        this.resTabbedPane = new JTabbedPane();
        this.resHeaderPanel = new JPanel();
        this.resBodyPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.resBodyEditorPane = new JEditorPane();
        this.setLayout(new BorderLayout());
        this.httpMonitorSplitPane.setDividerLocation(this.getDetailsDividerLoc());
        this.httpMonitorSplitPane.setOrientation(0);
        this.httpMonitorSplitPane.setOneTouchExpandable(true);
        this.outerActivitiesPanel.setLayout(new BorderLayout());
        this.activitiesToolbar.setFloatable(false);
        this.activitiesToolbar.setRollover(true);
        this.activitiesToolbar.setFocusable(false);
        this.activitiesToolbar.setNextFocusableComponent(this.activitiesModelPanel);
        this.start_stopMonitoring.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource(STOP_ICON_PATH)));
        Mnemonics.setLocalizedText((AbstractButton)this.start_stopMonitoring, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.start_stopMonitoring.text"));
        this.start_stopMonitoring.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"TT_Start_StopMonitoring"));
        this.start_stopMonitoring.setEnabled(false);
        this.start_stopMonitoring.setHorizontalTextPosition(0);
        this.start_stopMonitoring.setVerticalTextPosition(3);
        this.start_stopMonitoring.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HttpMonitorTopComponent.this.StartStopButtonHandler(mouseEvent);
            }
        });
        this.activitiesToolbar.add(this.start_stopMonitoring);
        this.start_stopMonitoring.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_STOPSTART"));
        this.start_stopMonitoring.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_STOPSTART"));
        this.cleanButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/web/client/javascript/debugger/http/ui/resources/clean.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.cleanButton, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.cleanButton.text"));
        this.cleanButton.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_CLEAN_TT"));
        this.cleanButton.setEnabled(false);
        this.cleanButton.setHorizontalTextPosition(0);
        this.cleanButton.setVerticalTextPosition(3);
        this.cleanButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HttpMonitorTopComponent.this.cleanButtonMouseClicked(mouseEvent);
            }
        });
        this.activitiesToolbar.add(this.cleanButton);
        this.cleanButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_CLEAN"));
        this.cleanButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_CLEAN_TT"));
        this.activitiesToolbar.add(this.jSeparator1);
        this.all_filterButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.all_filterButton, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.all_filterButton.text"));
        this.all_filterButton.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_All_TT"));
        this.all_filterButton.setEnabled(false);
        this.all_filterButton.setHorizontalTextPosition(0);
        this.all_filterButton.setVerticalTextPosition(3);
        this.all_filterButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HttpMonitorTopComponent.this.all_filterMouseClicked(mouseEvent);
            }
        });
        this.activitiesToolbar.add(this.all_filterButton);
        this.all_filterButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_All"));
        this.all_filterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_All_TT"));
        Mnemonics.setLocalizedText((AbstractButton)this.html_filterButton, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.html_filterButton.text"));
        this.html_filterButton.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_HTML_TT"));
        this.html_filterButton.setEnabled(false);
        this.html_filterButton.setHorizontalTextPosition(0);
        this.html_filterButton.setVerticalTextPosition(3);
        this.html_filterButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HttpMonitorTopComponent.this.filterButtonItemStateChanged(itemEvent);
            }
        });
        this.activitiesToolbar.add(this.html_filterButton);
        this.html_filterButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_HTML"));
        this.html_filterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_HTML_TT"));
        Mnemonics.setLocalizedText((AbstractButton)this.js_filterButton, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.js_filterButton.text"));
        this.js_filterButton.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_JS_TT"));
        this.js_filterButton.setEnabled(false);
        this.js_filterButton.setHorizontalTextPosition(0);
        this.js_filterButton.setVerticalTextPosition(3);
        this.js_filterButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HttpMonitorTopComponent.this.filterButtonItemStateChanged(itemEvent);
            }
        });
        this.activitiesToolbar.add(this.js_filterButton);
        this.js_filterButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_JS"));
        this.js_filterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_JS_TT"));
        Mnemonics.setLocalizedText((AbstractButton)this.xhr_filterButton, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.xhr_filterButton.text"));
        this.xhr_filterButton.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_XHR_TT"));
        this.xhr_filterButton.setEnabled(false);
        this.xhr_filterButton.setHorizontalTextPosition(0);
        this.xhr_filterButton.setVerticalTextPosition(3);
        this.xhr_filterButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HttpMonitorTopComponent.this.filterButtonItemStateChanged(itemEvent);
            }
        });
        this.activitiesToolbar.add(this.xhr_filterButton);
        this.xhr_filterButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_XHR"));
        this.xhr_filterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_XHR_TT"));
        Mnemonics.setLocalizedText((AbstractButton)this.css_filterButton, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.css_filterButton.text"));
        this.css_filterButton.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_CSS_TT"));
        this.css_filterButton.setEnabled(false);
        this.css_filterButton.setHorizontalTextPosition(0);
        this.css_filterButton.setVerticalTextPosition(3);
        this.css_filterButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HttpMonitorTopComponent.this.filterButtonItemStateChanged(itemEvent);
            }
        });
        this.activitiesToolbar.add(this.css_filterButton);
        this.css_filterButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_CSS"));
        this.css_filterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_CSS_TT"));
        Mnemonics.setLocalizedText((AbstractButton)this.images_filterButton, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.images_filterButton.text"));
        this.images_filterButton.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_Images_TT"));
        this.images_filterButton.setEnabled(false);
        this.images_filterButton.setHorizontalTextPosition(0);
        this.images_filterButton.setVerticalTextPosition(3);
        this.images_filterButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HttpMonitorTopComponent.this.filterButtonItemStateChanged(itemEvent);
            }
        });
        this.activitiesToolbar.add(this.images_filterButton);
        this.images_filterButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_Images"));
        this.images_filterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_Images_TT"));
        Mnemonics.setLocalizedText((AbstractButton)this.flash_filterButton, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.flash_filterButton.text"));
        this.flash_filterButton.setToolTipText(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_Flash_TT"));
        this.flash_filterButton.setEnabled(false);
        this.flash_filterButton.setHorizontalTextPosition(0);
        this.flash_filterButton.setVerticalTextPosition(3);
        this.flash_filterButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HttpMonitorTopComponent.this.filterButtonItemStateChanged(itemEvent);
            }
        });
        this.activitiesToolbar.add(this.flash_filterButton);
        this.flash_filterButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_Flash"));
        this.flash_filterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"BTN_HTTPToolbar_Filter_Flash_TT"));
        this.outerActivitiesPanel.add((Component)this.activitiesToolbar, "North");
        HttpActivitiesModel httpActivitiesModel = HttpMonitorUtility.getCurrentHttpMonitorModel();
        this.start_stopMonitoring.setIcon(this.getStartStopIcon());
        if (httpMonitorPreferences.isShowAll()) {
            this.setFilterButtonsAllSelected();
        } else {
            this.all_filterButton.setSelected(false);
            this.resetOtherFilterButtonSelected();
        }
        this.setToolbarButtonsEnabled(httpActivitiesModel != null);
        this.activitiesModelPanel.setLayout(new BorderLayout());
        this.activitiesModelPanel.add((Component)this.createActivitiesTable(), "Center");
        this.outerActivitiesPanel.add((Component)this.activitiesModelPanel, "Center");
        this.httpMonitorSplitPane.setTopComponent(this.outerActivitiesPanel);
        this.detailsPanel.setLayout(new BorderLayout());
        this.httpReqPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.reqLabel, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.reqLabel.text"));
        this.httpReqPanel.add((Component)this.reqLabel, "North");
        this.reqHeaderPanel.setLayout(new BorderLayout());
        this.reqHeaderPanel.add((Component)this.createRequestView(), "Center");
        this.reqTabbedPane.addTab(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)" HttpMonitorTopComponent.headerPanel.TabConstraints.tabTitle"), this.reqHeaderPanel);
        this.reqHeaderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)" HttpMonitorTopComponent.reqHeaderPanel.TabConstraints.tabAsc"));
        this.reqHeaderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.reqHeader.TabConstraints.tabDescription"));
        this.reqParamPanel.setName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.reqHeader.TabConstraints.tabTitle"));
        this.reqParamPanel.setLayout(new BorderLayout());
        this.reqParamTextArea.setColumns(20);
        this.reqParamTextArea.setEditable(false);
        this.reqParamTextArea.setRows(5);
        this.jScrollPane4.setViewportView(this.reqParamTextArea);
        this.reqParamPanel.add((Component)this.jScrollPane4, "Center");
        this.reqTabbedPane.addTab(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.reqParamPanel.TabConstraints.tabTitle"), this.reqParamPanel);
        this.reqParamPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"TABBED_PANE_Param"));
        this.httpReqPanel.add((Component)this.reqTabbedPane, "Center");
        this.detailsSplitPane.setLeftComponent(this.httpReqPanel);
        this.httpResPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.resLabel, (String)NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.resLabel.text"));
        this.httpResPanel.add((Component)this.resLabel, "North");
        this.resTabbedPane.setName("");
        this.resHeaderPanel.setLayout(new BorderLayout());
        this.resHeaderPanel.add((Component)this.createResponseView(), "Center");
        this.resTabbedPane.addTab(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.headerPanel.TabConstraints.tabTitle"), this.resHeaderPanel);
        this.resHeaderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.resHeaderPanel.TabConstraints.tabAsc"));
        this.resHeaderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.resHeaderPanel.TabConstraints.tabDescription"));
        this.resBodyPanel.setLayout(new BorderLayout());
        this.jScrollPane2.setViewportView(this.resBodyEditorPane);
        this.resBodyPanel.add((Component)this.jScrollPane2, "Center");
        this.resTabbedPane.addTab(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"HttpMonitorTopComponent.resBodyPanel.TabConstraints.tabTitle"), this.resBodyPanel);
        this.resBodyPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpMonitorTopComponent.class, (String)"TABBED_PANE_Body"));
        this.httpResPanel.add((Component)this.resTabbedPane, "Center");
        this.detailsSplitPane.setRightComponent(this.httpResPanel);
        this.detailsPanel.add((Component)this.detailsSplitPane, "Center");
        this.httpMonitorSplitPane.setRightComponent(this.detailsPanel);
        this.add(this.httpMonitorSplitPane, "Center");
    }

    private void cleanButtonMouseClicked(MouseEvent mouseEvent) {
        this.LOG.entering(HttpMonitorTopComponent.class.getName(), "cleanButtonMouseClicked");
        HttpActivitiesModel httpActivitiesModel = HttpMonitorUtility.getCurrentHttpMonitorModel();
        if (httpActivitiesModel != null) {
            httpActivitiesModel.clearActivities();
        }
        this.LOG.exiting(HttpMonitorTopComponent.class.getName(), "cleanButtonMouseClicked");
    }

    private void StartStopButtonHandler(MouseEvent mouseEvent) {
        this.LOG.entering(HttpMonitorTopComponent.class.getName(), "StartStopButtonHandler", !HttpMonitorUtility.isEnabled());
        HttpMonitorUtility.setEnabled(!HttpMonitorUtility.isEnabled());
        this.start_stopMonitoring.setIcon(this.getStartStopIcon());
        this.LOG.exiting(HttpMonitorTopComponent.class.getName(), "StartStopButtonHandler");
    }

    private void all_filterMouseClicked(MouseEvent mouseEvent) {
        if (!this.all_filterButton.isSelected()) {
            this.setOtherFilterButtonsSelected(false);
        } else {
            this.setOtherFilterButtonsSelected(true);
            this.all_filterButton.setSelected(true);
        }
    }

    private void filterButtonItemStateChanged(ItemEvent itemEvent) {
        this.LOG.entering(HttpMonitorTopComponent.class.getName(), "filterButtonItemStateChanged", itemEvent);
        Object object = itemEvent.getItem();
        int n = itemEvent.getStateChange();
        if (object.equals(this.html_filterButton)) {
            httpMonitorPreferences.setShowHTML(n == 1);
        } else if (object.equals(this.js_filterButton)) {
            httpMonitorPreferences.setShowJS(n == 1);
        } else if (object.equals(this.xhr_filterButton)) {
            httpMonitorPreferences.setShowXHR(n == 1);
        } else if (object.equals(this.css_filterButton)) {
            httpMonitorPreferences.setShowCSS(n == 1);
        } else if (object.equals(this.images_filterButton)) {
            httpMonitorPreferences.setShowImages(n == 1);
        } else if (object.equals(this.flash_filterButton)) {
            httpMonitorPreferences.setShowFlash(n == 1);
        }
        if (httpMonitorPreferences.isShowAll()) {
            this.all_filterButton.setSelected(true);
        } else {
            this.all_filterButton.setSelected(false);
        }
        this.LOG.exiting(HttpMonitorTopComponent.class.getName(), "filterButtonItemStateChanged");
    }

    public static synchronized HttpMonitorTopComponent getDefault() {
        if (instance == null) {
            instance = new HttpMonitorTopComponent();
        }
        return instance;
    }

    public static synchronized HttpMonitorTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(HttpMonitorTopComponent.class.getName()).warning("Cannot find HttpMonitorTopComponent component. It will not be located properly in the window system.");
            return HttpMonitorTopComponent.getDefault();
        }
        if (topComponent instanceof HttpMonitorTopComponent) {
            return (HttpMonitorTopComponent)topComponent;
        }
        Logger.getLogger(HttpMonitorTopComponent.class.getName()).warning("There seem to be multiple components with the 'HttpMonitorTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return HttpMonitorTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void setToolbarButtonsEnabled(boolean bl) {
        this.cleanButton.setEnabled(bl);
        this.start_stopMonitoring.setEnabled(bl);
        this.all_filterButton.setEnabled(bl);
        this.html_filterButton.setEnabled(bl);
        this.js_filterButton.setEnabled(bl);
        this.images_filterButton.setEnabled(bl);
        this.css_filterButton.setEnabled(bl);
        this.flash_filterButton.setEnabled(bl);
        this.xhr_filterButton.setEnabled(bl);
    }

    private void setFilterButtonsAllSelected() {
        this.all_filterButton.setSelected(true);
        this.setOtherFilterButtonsSelected(true);
    }

    private void setOtherFilterButtonsSelected(boolean bl) {
        this.html_filterButton.setSelected(bl);
        this.js_filterButton.setSelected(bl);
        this.css_filterButton.setSelected(bl);
        this.images_filterButton.setSelected(bl);
        this.flash_filterButton.setSelected(bl);
        this.xhr_filterButton.setSelected(bl);
    }

    private void resetOtherFilterButtonSelected() {
        this.html_filterButton.setSelected(httpMonitorPreferences.isShowHTML());
        this.js_filterButton.setSelected(httpMonitorPreferences.isShowJS());
        this.css_filterButton.setSelected(httpMonitorPreferences.isShowCSS());
        this.images_filterButton.setSelected(httpMonitorPreferences.isShowImages());
        this.flash_filterButton.setSelected(httpMonitorPreferences.isShowFlash());
        this.xhr_filterButton.setSelected(httpMonitorPreferences.isShowXHR());
    }

    static {
        METHOD_COLUMN = HttpActivitiesModel.getColumnModel("METHOD_COLUMN");
        SENT_COLUMN = HttpActivitiesModel.getColumnModel("SENT_COLUMN");
        RESPONSE_COLUMN = HttpActivitiesModel.getColumnModel("RESPONSE_COLUMN");
        VALUE_COLUMN = HttpHeaderModel.getColumnModel("VALUE_COLUMN");
        httpMonitorPreferences = HttpMonitorPreferences.getInstance();
    }

    private class DebuggerManagerListenerImpl
    extends DebuggerManagerAdapter {
        private HttpActivitiesModel currentModel = null;

        private DebuggerManagerListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HttpActivitiesModel httpActivitiesModel = HttpMonitorUtility.getCurrentHttpMonitorModel();
            if (httpActivitiesModel != null) {
                HttpMonitorTopComponent.this.setToolbarButtonsEnabled(true);
            } else {
                HttpMonitorTopComponent.this.setToolbarButtonsEnabled(false);
            }
            if (this.currentModel != httpActivitiesModel) {
                this.currentModel = httpActivitiesModel;
                HttpMonitorTopComponent.this.resetHttpActivitesModel(httpActivitiesModel);
            }
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            HttpMonitorTopComponent httpMonitorTopComponent = HttpMonitorTopComponent.getDefault();
            return httpMonitorTopComponent;
        }
    }

    private class ActivitiesPropertyChange
    implements PropertyChangeListener {
        private ActivitiesPropertyChange() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                assert (propertyChangeEvent.getNewValue() instanceof Node[]);
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                if (nodeArray == null || nodeArray.length < 1) {
                    HttpMonitorTopComponent.this.reqParamTextArea.setText("");
                    HttpMonitorTopComponent.this.resBodyEditorPane.setText("");
                    return;
                }
                assert (nodeArray[0] instanceof Node);
                Node node = nodeArray[0];
                HttpActivity httpActivity = (HttpActivity)node.getLookup().lookup(HttpActivity.class);
                if (httpActivity != null) {
                    JSHttpRequest jSHttpRequest = httpActivity.getRequest();
                    assert (jSHttpRequest != null);
                    if (jSHttpRequest.getMethod().equals((Object)JSHttpMessage.MethodType.POST)) {
                        HttpMonitorTopComponent.this.reqParamTextArea.setText("POST: " + jSHttpRequest.getPostText());
                    } else {
                        HttpMonitorTopComponent.this.reqParamTextArea.setText("URL PARAMS: " + jSHttpRequest.getUrlParams());
                    }
                    HttpMonitorTopComponent.this.resBodyEditorPane.setText(httpActivity.getResponseText());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HttpRequestModel
    extends HttpHeaderModel {
        public HttpRequestModel(ExplorerManager explorerManager) {
            super(explorerManager);
        }

        @Override
        protected Map<String, String> getHeader() {
            HttpActivity httpActivity = this.getSelectedActivity();
            if (httpActivity == null) {
                return Collections.emptyMap();
            }
            return this.getSelectedActivity().getRequestHeader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HttpResponseModel
    extends HttpHeaderModel {
        public HttpResponseModel(ExplorerManager explorerManager) {
            super(explorerManager);
        }

        @Override
        protected Map<String, String> getHeader() {
            HttpActivity httpActivity = this.getSelectedActivity();
            if (httpActivity == null) {
                return Collections.emptyMap();
            }
            return this.getSelectedActivity().getResponseHeader();
        }
    }
}

