/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.attach;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSFileObjectLocation;
import org.netbeans.modules.web.client.tools.api.JSLocation;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.NbJSLocation;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSURILocation;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class URLAttachPanel
extends JPanel
implements Controller {
    private static Preferences preferences = NbPreferences.forModule(URLAttachPanel.class);
    private static final String DEBUG_URL = "debugURL";
    private static final String BROWSER = "browser";
    private static final Object[] MAPPERS = new Object[]{new FileToFileUriMapper(), new FileUriToFileMapper()};
    private final boolean ieBrowserSupported;
    private final boolean ffBrowserSupported;
    private JButton browseButton;
    private ButtonGroup browserButtonGroup;
    private JLabel debugURLLabel;
    private JTextField debugURLTextField;
    private JRadioButton firefoxRadioButton;
    private JRadioButton internetExplorerRadioButton;
    private JTextField messageTextField;
    private static final String[] SUPPORTED_MIME_TYPES = new String[]{"text/html", "text/javascript"};

    public URLAttachPanel() {
        this.initComponents();
        this.debugURLTextField.setText(preferences.get(DEBUG_URL, ""));
        this.debugURLTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void update() {
                URLAttachPanel.this.firePropertyChange("valid", null, null);
                URLAttachPanel.this.messageTextField.setText("");
            }
        });
        this.ieBrowserSupported = WebClientToolsProjectUtils.isInternetExplorerSupported();
        this.ffBrowserSupported = WebClientToolsProjectUtils.isFirefoxSupported();
        if (this.ieBrowserSupported && this.ffBrowserSupported) {
            String string = preferences.get("debugConfigBrowser", WebClientToolsProjectUtils.Browser.FIREFOX.name());
            String string2 = preferences.get(BROWSER, string);
            this.firefoxRadioButton.setSelected(WebClientToolsProjectUtils.Browser.valueOf((String)string2) == WebClientToolsProjectUtils.Browser.FIREFOX);
            this.internetExplorerRadioButton.setSelected(WebClientToolsProjectUtils.Browser.valueOf((String)string2) == WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER);
        } else if (!this.ieBrowserSupported && !this.ffBrowserSupported) {
            this.debugURLTextField.setEnabled(false);
            this.debugURLTextField.setEditable(false);
            this.firefoxRadioButton.setEnabled(false);
            this.internetExplorerRadioButton.setEnabled(false);
            this.messageTextField.setText(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel_noSupportedBrowserMsg"));
        } else {
            this.firefoxRadioButton.setEnabled(this.ffBrowserSupported);
            this.firefoxRadioButton.setSelected(this.ffBrowserSupported);
            this.internetExplorerRadioButton.setEnabled(this.ieBrowserSupported);
            this.internetExplorerRadioButton.setSelected(this.ieBrowserSupported);
        }
    }

    private void initComponents() {
        this.browserButtonGroup = new ButtonGroup();
        this.debugURLLabel = new JLabel();
        this.debugURLTextField = new JTextField();
        this.firefoxRadioButton = new JRadioButton();
        this.internetExplorerRadioButton = new JRadioButton();
        this.messageTextField = new JTextField();
        this.browseButton = new JButton();
        this.debugURLLabel.setLabelFor(this.debugURLTextField);
        Mnemonics.setLocalizedText((JLabel)this.debugURLLabel, (String)NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.debugURLLabel.text"));
        this.browserButtonGroup.add(this.firefoxRadioButton);
        this.firefoxRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.firefoxRadioButton, (String)NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.firefoxRadioButton.text"));
        this.browserButtonGroup.add(this.internetExplorerRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.internetExplorerRadioButton, (String)NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.internetExplorerRadioButton.text"));
        this.internetExplorerRadioButton.setToolTipText(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.internetExplorerRadioButton.tooltip"));
        this.messageTextField.setBackground(UIManager.getColor("Panel.background"));
        this.messageTextField.setEditable(false);
        this.messageTextField.setBorder(null);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URLAttachPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.messageTextField, -1, 520, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debugURLLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.internetExplorerRadioButton).add((Component)this.firefoxRadioButton).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debugURLTextField, -1, 312, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton))))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.debugURLLabel).add((Component)this.browseButton).add((Component)this.debugURLTextField, -2, -1, -2)).addPreferredGap(1).add((Component)this.firefoxRadioButton).addPreferredGap(1).add((Component)this.internetExplorerRadioButton).addPreferredGap(1).add((Component)this.messageTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.debugURLTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.debugURLTextField.AccessibleContext.accessibleName"));
        this.debugURLTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.debugURLTextField.AccessibleContext.accessibleDescription"));
        this.firefoxRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.firefoxRadioButton.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.jButton1.AccessibleContext.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(0);
        String string = null;
        try {
            object = this.debugURLTextField.getText().trim();
            if (((String)object).length() > 0) {
                URI uRI = new URI((String)object);
                file = new File(uRI);
                string = file.getAbsoluteFile().getAbsolutePath();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = null;
        }
        catch (URISyntaxException uRISyntaxException) {
            string = null;
        }
        Object object2 = object = string == null ? null : new File(string);
        if (object != null) {
            jFileChooser.setSelectedFile((File)object);
        }
        int n = jFileChooser.showOpenDialog(this);
        file = jFileChooser.getSelectedFile();
        if (n == 0 && file != null && file != null) {
            this.debugURLTextField.setText(file.toURI().toASCIIString());
        }
    }

    public boolean isValid() {
        return this.ieBrowserSupported || this.ffBrowserSupported;
    }

    public boolean ok() {
        block11: {
            preferences.put(DEBUG_URL, this.debugURLTextField.getText());
            if (Utilities.isWindows() && this.internetExplorerRadioButton.isSelected()) {
                preferences.put(BROWSER, WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER.name());
            } else {
                preferences.put(BROWSER, WebClientToolsProjectUtils.Browser.FIREFOX.name());
            }
            if (WebClientToolsSessionStarterService.isAvailable()) {
                try {
                    String string = this.debugURLTextField.getText().trim();
                    if (string.length() == 0) {
                        return false;
                    }
                    URI uRI = new URI(string);
                    try {
                        HtmlBrowser.Factory factory = null;
                        factory = this.internetExplorerRadioButton.isSelected() ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
                        if (factory == null) {
                            try {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(uRI.toURL());
                                break block11;
                            }
                            catch (MalformedURLException malformedURLException) {
                                this.messageTextField.setText(malformedURLException.getMessage());
                                return false;
                            }
                        }
                        WebClientToolsSessionStarterService.startSession((URI)uRI, (HtmlBrowser.Factory)factory, (Lookup)Lookups.fixed((Object[])MAPPERS));
                    }
                    catch (WebClientToolsSessionException webClientToolsSessionException) {
                        StatusDisplayer.getDefault().setStatusText(webClientToolsSessionException.getMessage());
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.messageTextField.setText(uRISyntaxException.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private static boolean hasSupportedMIMEType(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        String string = fileObject.getMIMEType();
        for (String string2 : SUPPORTED_MIME_TYPES) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static final class FileToFileUriMapper
    implements NbJSToJSLocationMapper {
        private FileToFileUriMapper() {
        }

        public JSLocation getJSLocation(NbJSLocation nbJSLocation, Lookup lookup) {
            File file;
            NbJSFileObjectLocation nbJSFileObjectLocation;
            FileObject fileObject;
            if (nbJSLocation instanceof NbJSFileObjectLocation && URLAttachPanel.hasSupportedMIMEType(fileObject = (nbJSFileObjectLocation = (NbJSFileObjectLocation)nbJSLocation).getFileObject()) && (file = FileUtil.toFile((FileObject)fileObject)) != null) {
                URI uRI = file.toURI();
                return new JSURILocation(uRI, nbJSFileObjectLocation.getLineNumber(), nbJSFileObjectLocation.getColumnNumber());
            }
            return null;
        }
    }

    private static final class FileUriToFileMapper
    implements JSToNbJSLocationMapper {
        private FileUriToFileMapper() {
        }

        public NbJSLocation getNbJSLocation(JSLocation jSLocation, Lookup lookup) {
            if (jSLocation instanceof JSURILocation) {
                JSURILocation jSURILocation = (JSURILocation)jSLocation;
                URI uRI = jSURILocation.getURI();
                try {
                    FileObject fileObject;
                    File file = new File(uRI);
                    if (file.exists() && file.isFile() && URLAttachPanel.hasSupportedMIMEType(fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)))) {
                        return new NbJSFileObjectLocation(fileObject, jSURILocation.getLineNumber(), jSURILocation.getColumnNumber());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            return null;
        }
    }
}

