/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.web.client.javascript.debugger.api.Log;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebuggerContentProvider;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSFileObjectLocation;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLContentProvider;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileObject;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileObjectFactory;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.HttpActivitiesModel;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.HttpActivitiesWrapper;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSPreferences;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSFileObjectBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSURIBreakpoint;
import org.netbeans.modules.web.client.tools.api.JSAbstractLocation;
import org.netbeans.modules.web.client.tools.api.JSLocation;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.NbJSLocation;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.common.dbgp.Feature;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSBreakpoint;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerConsoleEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerConsoleEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessageEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessageEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSSource;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSURILocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSWindow;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSBreakpointImpl;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;
import org.netbeans.modules.web.client.tools.javascript.debugger.spi.JSDebuggerFactory;
import org.netbeans.modules.web.client.tools.javascript.debugger.spi.JSDebuggerFactoryLookup;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class NbJSDebugger {
    private static final Object SESSION_LOCK = new Object();
    private final WebClientToolsProjectUtils.Browser browser;
    private final URI uri;
    private Lookup lookup;
    private final List<JSDebuggerEventListener> listeners;
    private final List<JSHttpMessageEventListener> httpListeners;
    private final PropertyChangeSupport propertyChangeSupport;
    public static final String PROPERTY_SELECTED_FRAME = "selectedFrame";
    private JSCallStackFrame selectedFrame;
    public static final String PROPERTY_SOURCES = "sources";
    public static final String PROPERTY_WINDOWS = "windows";
    public static final String PROPERTY_RELOADSOURCES = "reloadsources";
    private URLContentProvider contentProvider;
    private JSDebugger debugger;
    private HashMap<Breakpoint, JSBreakpointImpl> breakpointsMap = new HashMap();
    private StartDebuggerTask startDebuggerTask;
    private final boolean ignoreQueryStrings;
    private JSDebuggerEventListener debuggerListener;
    private JSDebuggerConsoleEventListener debuggerConsoleEventListener;
    private JSHttpMessageEventListener httpMessageEventListener;
    private PropertyChangeListener propertyChangeListener;
    private DebuggerManagerListenerImpl debuggerManagerListener;
    private BreakpointPropertyChangeListener breakpointPropertyChangeListener;
    private PreferenceChangeListener preferenceChangeListener;
    private InputOutput console;
    private JSDebuggerState state = JSDebuggerState.NOT_CONNECTED;

    NbJSDebugger(URI uRI, HtmlBrowser.Factory factory, Lookup lookup, JSDebugger jSDebugger) {
        this.uri = uRI;
        this.browser = factory == WebClientToolsProjectUtils.getInternetExplorerBrowser() ? WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER : WebClientToolsProjectUtils.Browser.FIREFOX;
        this.lookup = lookup;
        this.debugger = jSDebugger;
        this.listeners = new CopyOnWriteArrayList<JSDebuggerEventListener>();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.contentProvider = new NbJSDebuggerContentProvider(this);
        this.debuggerListener = new JSDebuggerEventListenerImpl();
        this.debugger.addJSDebuggerEventListener((JSDebuggerEventListener)WeakListeners.create(JSDebuggerEventListener.class, (EventListener)this.debuggerListener, (Object)this.debugger));
        this.debuggerConsoleEventListener = new JSDebuggerConsoleEventListenerImpl();
        this.debugger.addJSDebuggerConsoleEventListener((JSDebuggerConsoleEventListener)WeakListeners.create(JSDebuggerConsoleEventListener.class, (EventListener)this.debuggerConsoleEventListener, (Object)this.debugger));
        this.httpListeners = new CopyOnWriteArrayList<JSHttpMessageEventListener>();
        this.httpMessageEventListener = new JSHttpMessageEventListenerImpl();
        this.debugger.addJSHttpMessageEventListener((JSHttpMessageEventListener)WeakListeners.create(JSHttpMessageEventListener.class, (EventListener)this.httpMessageEventListener, (Object)this.debugger));
        this.debuggerManagerListener = new DebuggerManagerListenerImpl();
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)this.debuggerManagerListener);
        this.propertyChangeListener = new PropertyChangeListenerImpl();
        this.debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)this.debugger));
        this.breakpointPropertyChangeListener = new BreakpointPropertyChangeListener();
        this.console = IOProvider.getDefault().getIO(NbBundle.getMessage(NbJSDebugger.class, (String)"TITLE_CONSOLE", (Object)this.getURI(), (Object)this.getID()), true);
        NbJSPreferences nbJSPreferences = NbJSPreferences.getInstance();
        this.ignoreQueryStrings = nbJSPreferences.getIgnoreQueryStrings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startDebugging(URI uRI, HtmlBrowser.Factory factory, Lookup lookup) {
        JSDebuggerFactory jSDebuggerFactory = JSDebuggerFactoryLookup.getFactory((HtmlBrowser.Factory)factory, (URI)uRI);
        if (jSDebuggerFactory == null) {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRI.toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            JSToNbJSLocationMapper jSToNbJSLocationMapper;
            Object object;
            Session session;
            Object object2;
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            if (factory == WebClientToolsProjectUtils.getFirefoxBrowser()) {
                object2 = SESSION_LOCK;
                synchronized (object2) {
                    session = null;
                    for (Session session2 : object = debuggerManager.getSessions()) {
                        NbJSDebugger nbJSDebugger = (NbJSDebugger)session2.lookupFirst(null, NbJSDebugger.class);
                        if (nbJSDebugger == null || nbJSDebugger.getBrowser() != WebClientToolsProjectUtils.Browser.FIREFOX) continue;
                        session = session2;
                        break;
                    }
                    if (session != null) {
                        boolean bl = NbJSDebugger.displayReloadSessionDialog();
                        if (!bl) {
                            return;
                        }
                        session.kill();
                    }
                }
            }
            object2 = new NbJSDebugger(uRI, factory, lookup, jSDebuggerFactory.startDebugging(factory, uRI));
            session = new ArrayList();
            session.add(object2);
            object = new HttpActivitiesWrapper(new HttpActivitiesModel((NbJSDebugger)object2));
            session.add(object);
            NbJSToJSLocationMapper nbJSToJSLocationMapper = (NbJSToJSLocationMapper)lookup.lookup(NbJSToJSLocationMapper.class);
            if (nbJSToJSLocationMapper != null) {
                session.add(nbJSToJSLocationMapper);
            }
            if ((jSToNbJSLocationMapper = (JSToNbJSLocationMapper)lookup.lookup(JSToNbJSLocationMapper.class)) != null) {
                session.add(jSToNbJSLocationMapper);
            }
            DebuggerInfo debuggerInfo = DebuggerInfo.create((String)"netbeans-javascript-DebuggerInfo", (Object[])session.toArray());
            debuggerManager.startDebugging(debuggerInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startJSDebugging() {
        if (this.debugger != null) {
            this.startDebuggerTask = new StartDebuggerTask();
            RequestProcessor.Task task = RequestProcessor.getDefault().post((Runnable)this.startDebuggerTask);
            task.waitFinished();
            NbJSDebugger nbJSDebugger = this;
            synchronized (nbJSDebugger) {
                if (this.startDebuggerTask != null) {
                    boolean bl = this.startDebuggerTask.taskSucceeded();
                    this.startDebuggerTask = null;
                    if (!bl) {
                        this.setState(JSDebuggerState.DISCONNECTED);
                    }
                }
            }
        }
    }

    public WebClientToolsProjectUtils.Browser getBrowser() {
        return this.browser;
    }

    public boolean supportsHttpMonitor() {
        return this.browser == WebClientToolsProjectUtils.Browser.FIREFOX;
    }

    public String getID() {
        if (this.debugger != null) {
            return this.debugger.getID();
        }
        return null;
    }

    public boolean isIgnoringQueryStrings() {
        return this.ignoreQueryStrings;
    }

    public void addJSDebuggerEventListener(JSDebuggerEventListener jSDebuggerEventListener) {
        this.listeners.add(jSDebuggerEventListener);
    }

    public void removeJSDebuggerEventListener(JSDebuggerEventListener jSDebuggerEventListener) {
        this.listeners.remove(jSDebuggerEventListener);
    }

    private void fireJSDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
        for (JSDebuggerEventListener jSDebuggerEventListener : this.listeners) {
            try {
                jSDebuggerEventListener.onDebuggerEvent(jSDebuggerEvent);
            }
            catch (RuntimeException runtimeException) {
                Log.getLogger().log(Level.INFO, runtimeException.getMessage(), runtimeException);
            }
        }
    }

    public void addJSHttpMessageEventListener(JSHttpMessageEventListener jSHttpMessageEventListener) {
        this.httpListeners.add(jSHttpMessageEventListener);
    }

    public void removeJSHttpMessageEventListener(JSHttpMessageEventListener jSHttpMessageEventListener) {
        this.httpListeners.remove(jSHttpMessageEventListener);
    }

    private void fireJSHttpMessageEvent(JSHttpMessageEvent jSHttpMessageEvent) {
        for (JSHttpMessageEventListener jSHttpMessageEventListener : this.httpListeners) {
            try {
                jSHttpMessageEventListener.onHttpMessageEvent(jSHttpMessageEvent);
            }
            catch (RuntimeException runtimeException) {
                Log.getLogger().log(Level.INFO, runtimeException.getMessage(), runtimeException);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized JSDebuggerState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBooleanFeatures(Feature.Name name, boolean bl) {
        if (this.debugger != null) {
            if (Feature.Name.HTTP_MONITOR.equals((Object)name)) {
                NbJSDebugger nbJSDebugger = this;
                synchronized (nbJSDebugger) {
                    this.debugger.setBooleanFeature(name, bl);
                }
            } else {
                throw new UnsupportedOperationException("Setting features for Feature: " + name + " has yet to be implmented");
            }
        }
    }

    synchronized void setState(JSDebuggerState jSDebuggerState) {
        NbJSPreferences nbJSPreferences;
        JSDebuggerEvent jSDebuggerEvent;
        this.state = jSDebuggerState;
        if (jSDebuggerState == JSDebuggerState.STARTING_INIT) {
            jSDebuggerEvent = NbJSPreferences.getInstance();
            if (this.preferenceChangeListener == null) {
                this.preferenceChangeListener = new PreferenceChangeListenerImpl();
                nbJSPreferences = NbJSPreferences.getInstance();
                nbJSPreferences.addPreferenceChangeListener(this.preferenceChangeListener);
            }
            this.debugger.setBooleanFeature(Feature.Name.SHOW_FUNCTIONS, jSDebuggerEvent.getShowFunctions());
            this.debugger.setBooleanFeature(Feature.Name.SHOW_CONSTANTS, jSDebuggerEvent.getShowConstants());
            this.debugger.setBooleanFeature(Feature.Name.SUSPEND_ON_FIRST_LINE, jSDebuggerEvent.getSuspendOnFirstLine());
            this.debugger.setBooleanFeature(Feature.Name.SUSPEND_ON_EXCEPTIONS, jSDebuggerEvent.getSuspendOnExceptions());
            this.debugger.setBooleanFeature(Feature.Name.SUSPEND_ON_ERRORS, jSDebuggerEvent.getSuspendOnErrors());
            this.debugger.setBooleanFeature(Feature.Name.SUSPEND_ON_DEBUGGERKEYWORD, jSDebuggerEvent.getSuspendOnDebuggerKeyword());
            this.debugger.setBooleanFeature(Feature.Name.IGNORE_QUERY_STRINGS, this.ignoreQueryStrings);
            this.debugger.setBooleanFeature(Feature.Name.HTTP_MONITOR, jSDebuggerEvent.getHttpMonitorEnabled() && jSDebuggerEvent.getHttpMonitorOpened());
            this.setBreakPoints();
        }
        if (jSDebuggerState == JSDebuggerState.STARTING_READY && this.console != null) {
            this.console.getOut().println(NbBundle.getMessage(NbJSDebugger.class, (String)"MSG_CONSOLE_JSDEBUGGER_STARTED") + this.getURI());
        }
        if (jSDebuggerState.getState() == JSDebuggerState.State.SUSPENDED) {
            this.setCurrentSession();
            jSDebuggerEvent = this.getCallStackFrames();
            if (jSDebuggerEvent != null && ((JSCallStackFrame[])jSDebuggerEvent).length > 0) {
                this.selectFrame((JSCallStackFrame)jSDebuggerEvent[0]);
            } else {
                this.selectFrame(null);
            }
        } else {
            this.selectFrame(null);
        }
        jSDebuggerEvent = new JSDebuggerEvent((Object)this, this.state);
        this.fireJSDebuggerEvent(jSDebuggerEvent);
        if (jSDebuggerState.getState() == JSDebuggerState.State.DISCONNECTED) {
            if (this.debuggerManagerListener != null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this.debuggerManagerListener);
                this.debuggerManagerListener = null;
            }
            if (this.preferenceChangeListener != null) {
                nbJSPreferences = NbJSPreferences.getInstance();
                nbJSPreferences.removePreferenceChangeListener(this.preferenceChangeListener);
                this.preferenceChangeListener = null;
            }
            if (this.console != null) {
                this.console.getOut().println(NbBundle.getMessage(NbJSDebugger.class, (String)"MSG_CONSOLE_CLOSE_JAVASCRIPT_DEBUGGER"));
                this.console.closeInputOutput();
                this.console = null;
            }
            if (this.startDebuggerTask != null) {
                this.startDebuggerTask.cancel();
                this.startDebuggerTask = null;
            }
        }
    }

    private void setCurrentSession() {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        for (Session session : debuggerManager.getSessions()) {
            NbJSDebugger nbJSDebugger = (NbJSDebugger)session.lookupFirst(null, NbJSDebugger.class);
            if (nbJSDebugger != this) continue;
            debuggerManager.setCurrentSession(session);
            return;
        }
        Log.getLogger().warning("Could not find session for javascript debugger");
    }

    private void setBreakPoints() {
        for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(breakpoint instanceof NbJSBreakpoint)) continue;
            this.setBreakpoint((NbJSBreakpoint)breakpoint);
        }
    }

    private void setBreakpoint(final NbJSBreakpoint nbJSBreakpoint) {
        JSDebuggerState jSDebuggerState = this.getState();
        if (jSDebuggerState.getState() == JSDebuggerState.State.DISCONNECTED || jSDebuggerState.getState() == JSDebuggerState.State.NOT_CONNECTED) {
            return;
        }
        JSBreakpointImpl jSBreakpointImpl = this.breakpointsMap.get((Object)nbJSBreakpoint);
        if (jSBreakpointImpl != null) {
            return;
        }
        JSURILocation jSURILocation = null;
        if (nbJSBreakpoint instanceof NbJSFileObjectBreakpoint) {
            jSURILocation = (JSURILocation)this.getJSLocation((JSAbstractLocation)((NbJSFileObjectBreakpoint)nbJSBreakpoint).getLocation());
        } else if (nbJSBreakpoint instanceof NbJSURIBreakpoint) {
            jSURILocation = ((NbJSURIBreakpoint)nbJSBreakpoint).getLocation();
        }
        if (jSURILocation != null) {
            String string;
            jSBreakpointImpl = new JSBreakpointImpl(jSURILocation);
            jSBreakpointImpl.setType(JSBreakpoint.Type.LINE);
            jSBreakpointImpl.setEnabled(Boolean.valueOf(nbJSBreakpoint.isEnabled()));
            jSBreakpointImpl.setHitValue(0);
            jSBreakpointImpl.setHitCondition(Breakpoint.HIT_COUNT_FILTERING_STYLE.EQUAL);
            Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = nbJSBreakpoint.getHitCountFilteringStyle();
            int n = nbJSBreakpoint.getHitCountFilter();
            if (hIT_COUNT_FILTERING_STYLE != null && n > 0) {
                jSBreakpointImpl.setHitValue(nbJSBreakpoint.getHitCountFilter());
                jSBreakpointImpl.setHitCondition(hIT_COUNT_FILTERING_STYLE);
            }
            if ((string = nbJSBreakpoint.getCondition()) == null) {
                string = "";
            }
            jSBreakpointImpl.setCondition(string);
            final JSBreakpointImpl jSBreakpointImpl2 = jSBreakpointImpl;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    List list = NbJSDebugger.this.debugger.setBreakpoint((JSBreakpoint)jSBreakpointImpl2);
                    if (list != null) {
                        for (String string : list) {
                            jSBreakpointImpl2.addId(string);
                        }
                        NbJSDebugger.this.breakpointsMap.put(nbJSBreakpoint, jSBreakpointImpl2);
                        nbJSBreakpoint.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)NbJSDebugger.this.breakpointPropertyChangeListener, (Object)((Object)nbJSBreakpoint)));
                    }
                }
            });
        }
    }

    private void removeBreakpoint(Breakpoint breakpoint) {
        JSDebuggerState jSDebuggerState = this.getState();
        if (jSDebuggerState.getState() == JSDebuggerState.State.DISCONNECTED || jSDebuggerState.getState() == JSDebuggerState.State.NOT_CONNECTED) {
            return;
        }
        JSBreakpointImpl jSBreakpointImpl = this.breakpointsMap.get(breakpoint);
        if (jSBreakpointImpl != null) {
            boolean bl = false;
            for (String string : jSBreakpointImpl.getIds()) {
                bl = this.debugger.removeBreakpoint(string) || bl;
            }
            if (bl) {
                this.breakpointsMap.remove(breakpoint);
            }
        }
    }

    private void updateBreakpoint(NbJSBreakpoint nbJSBreakpoint) {
        JSDebuggerState jSDebuggerState = this.getState();
        if (jSDebuggerState.getState() == JSDebuggerState.State.DISCONNECTED || jSDebuggerState.getState() == JSDebuggerState.State.NOT_CONNECTED) {
            return;
        }
        JSBreakpointImpl jSBreakpointImpl = this.breakpointsMap.get((Object)nbJSBreakpoint);
        if (jSBreakpointImpl == null) {
            Log.getLogger().log(Level.INFO, "Cannot update non existing breakpoint");
            return;
        }
        Boolean bl = nbJSBreakpoint.isEnabled();
        int n = -1;
        int n2 = nbJSBreakpoint.getHitCountFilter();
        Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = nbJSBreakpoint.getHitCountFilteringStyle();
        String string = nbJSBreakpoint.getCondition();
        if (hIT_COUNT_FILTERING_STYLE == null) {
            n2 = 0;
            hIT_COUNT_FILTERING_STYLE = Breakpoint.HIT_COUNT_FILTERING_STYLE.EQUAL;
        }
        if (string == null) {
            string = "";
        }
        for (String string2 : jSBreakpointImpl.getIds()) {
            this.debugger.updateBreakpoint(string2, bl, n, n2, hIT_COUNT_FILTERING_STYLE, string);
        }
    }

    private JSLocation getJSLocation(JSAbstractLocation jSAbstractLocation) {
        Session session = null;
        NbJSToJSLocationMapper nbJSToJSLocationMapper = DebuggerManager.getDebuggerManager().getSessions();
        int n = ((Session[])nbJSToJSLocationMapper).length;
        for (int i = 0; i < n; ++i) {
            Session session2 = nbJSToJSLocationMapper[i];
            NbJSDebugger nbJSDebugger = (NbJSDebugger)session2.lookupFirst(null, NbJSDebugger.class);
            if (nbJSDebugger != this) continue;
            session = session2;
            break;
        }
        if (session != null && (nbJSToJSLocationMapper = (NbJSToJSLocationMapper)session.lookupFirst(null, NbJSToJSLocationMapper.class)) != null) {
            JSLocation jSLocation = null;
            if (jSAbstractLocation instanceof NbJSLocation) {
                jSLocation = nbJSToJSLocationMapper.getJSLocation((NbJSLocation)jSAbstractLocation, null);
            }
            return jSLocation;
        }
        return null;
    }

    public JSWindow[] getWindows() throws IllegalStateException {
        if (this.debugger != null) {
            return this.debugger.getWindows();
        }
        return JSWindow.EMPTY_ARRAY;
    }

    public JSSource[] getSources() {
        if (this.debugger != null) {
            return this.debugger.getSources();
        }
        return JSSource.EMPTY_ARRAY;
    }

    public FileObject getFileObjectForSource(JSSource jSSource) {
        return this.getFileObjectForSource(jSSource, false);
    }

    public FileObject getFileObjectForSource(JSSource jSSource, boolean bl) {
        NbJSLocation nbJSLocation;
        Object object;
        JSToNbJSLocationMapper jSToNbJSLocationMapper = null;
        JSSource jSSource2 = jSSource;
        if (this.lookup != null) {
            jSToNbJSLocationMapper = (JSToNbJSLocationMapper)this.lookup.lookup(JSToNbJSLocationMapper.class);
        }
        if (this.ignoreQueryStrings) {
            object = jSSource.getLocation().getURI();
            jSSource = JSFactory.createJSSource((String)this.getURIWithoutQuery((URI)object).toString());
        }
        object = jSSource.getLocation();
        if (jSToNbJSLocationMapper != null && (nbJSLocation = jSToNbJSLocationMapper.getNbJSLocation(object, this.lookup)) != null && nbJSLocation instanceof NbJSFileObjectLocation) {
            return ((NbJSFileObjectLocation)nbJSLocation).getFileObject();
        }
        if (this.ignoreQueryStrings && (bl || !this.isURLLoaded(jSSource))) {
            return this.getURLFileObjectForSource(jSSource2, jSSource);
        }
        if (this.ignoreQueryStrings) {
            return this.sourceToURLFileObject(jSSource);
        }
        return this.getURLFileObjectForSource(jSSource);
    }

    private boolean isURLLoaded(JSSource jSSource) {
        URI uRI = jSSource.getLocation().getURI();
        try {
            return URLFileObjectFactory.findFileObject(this.contentProvider, uRI.toURL()) != null;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private URI getURIWithoutQuery(URI uRI) {
        try {
            URI uRI2 = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), null, uRI.getFragment());
            return uRI2;
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.INFO, "Could not remove query string from URI: " + uRI.toASCIIString());
            return uRI;
        }
    }

    private URLFileObject sourceToURLFileObject(JSSource jSSource) {
        URI uRI = jSSource.getLocation().getURI();
        try {
            return this.getURLFileObject(uRI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private FileObject getURLFileObjectForSource(JSSource jSSource, JSSource jSSource2) {
        URLFileObject uRLFileObject = this.sourceToURLFileObject(jSSource2);
        if (uRLFileObject != null) {
            try {
                uRLFileObject.setActualURL(jSSource.getLocation().getURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Log.getLogger().log(Level.INFO, "URI with query string could not be converted to URL: " + jSSource.getLocation().getURI().toASCIIString());
            }
        }
        return uRLFileObject;
    }

    public FileObject getURLFileObjectForSource(JSSource jSSource) {
        return this.getURLFileObjectForSource(jSSource, false);
    }

    public FileObject getURLFileObjectForSource(JSSource jSSource, boolean bl) {
        if (this.ignoreQueryStrings) {
            URI uRI = jSSource.getLocation().getURI();
            JSSource jSSource2 = JSFactory.createJSSource((String)this.getURIWithoutQuery(uRI).toString());
            if (bl) {
                return this.getURLFileObjectForSource(jSSource, jSSource2);
            }
            return this.sourceToURLFileObject(jSSource2);
        }
        return this.sourceToURLFileObject(jSSource);
    }

    public JSCallStackFrame[] getCallStackFrames() throws IllegalStateException {
        if (this.debugger != null) {
            return this.debugger.getCallStackFrames();
        }
        return JSCallStackFrame.EMPTY_ARRAY;
    }

    public boolean isSelectedFrame(JSCallStackFrame jSCallStackFrame) {
        return this.selectedFrame == jSCallStackFrame;
    }

    public JSCallStackFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public boolean isSessionSuspended() {
        if (this.debugger != null) {
            return this.debugger.isSuspended();
        }
        return false;
    }

    public void setBreakpoint(NbJSFileObjectBreakpoint nbJSFileObjectBreakpoint) {
    }

    public boolean isSuspendedWindow(JSWindow jSWindow) {
        return jSWindow.isSuspended();
    }

    public void selectFrame(JSCallStackFrame jSCallStackFrame) {
        JSCallStackFrame jSCallStackFrame2 = this.selectedFrame;
        this.selectedFrame = jSCallStackFrame;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SELECTED_FRAME, jSCallStackFrame2, this.selectedFrame);
    }

    public NbJSToJSLocationMapper getNbJSToJSLocation() {
        if (this.lookup != null) {
            return (NbJSToJSLocationMapper)this.lookup.lookup(NbJSToJSLocationMapper.class);
        }
        return null;
    }

    public JSToNbJSLocationMapper getJSToNbJSLocation() {
        if (this.lookup != null) {
            return (JSToNbJSLocationMapper)this.lookup.lookup(JSToNbJSLocationMapper.class);
        }
        return null;
    }

    public void resume() {
        if (this.debugger != null) {
            this.debugger.resume();
        }
    }

    public void pause() {
        if (this.debugger != null) {
            this.debugger.pause();
            if (this.console != null) {
                this.console.getOut().println(NbBundle.getMessage(NbJSDebugger.class, (String)"MSG_WILL_PAUSE"));
            }
        }
    }

    public void stepInto() {
        if (this.debugger != null) {
            this.debugger.stepInto();
        }
    }

    public void stepOver() {
        if (this.debugger != null) {
            this.debugger.stepOver();
        }
    }

    public void stepOut() {
        if (this.debugger != null) {
            this.debugger.stepOut();
        }
    }

    public void runToCursor() {
        JSURILocation jSURILocation = null;
        if (this.debugger != null) {
            EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.getDefault();
            FileObject fileObject = editorContextDispatcher.getCurrentFile();
            int n = editorContextDispatcher.getCurrentLineNumber();
            if (fileObject instanceof URLFileObject) {
                try {
                    jSURILocation = new JSURILocation(fileObject.getURL().toString(), n, 0);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Log.getLogger().log(Level.INFO, fileStateInvalidException.getLocalizedMessage(), fileStateInvalidException);
                }
            } else {
                NbJSFileObjectLocation nbJSFileObjectLocation = new NbJSFileObjectLocation(fileObject, n);
                jSURILocation = (JSURILocation)this.getJSLocation((JSAbstractLocation)nbJSFileObjectLocation);
            }
            if (jSURILocation != null) {
                this.debugger.runToCursor(jSURILocation);
            }
        }
    }

    public boolean isRunningTo(JSLocation jSLocation) {
        return false;
    }

    public void finish(boolean bl, DebuggerEngine.Destructor destructor) {
        if (this.debugger != null) {
            this.debugger.finish(bl);
        }
        destructor.killEngine();
    }

    InputStream getInputStreamForURL(URL uRL) {
        if (this.debugger != null) {
            return this.debugger.getInputStreamForURL(uRL);
        }
        return null;
    }

    private URLFileObject getURLFileObject(URL uRL) {
        return URLFileObjectFactory.getFileObject(this.contentProvider, uRL);
    }

    public FileSystem getURLFileSystem() {
        return URLFileObjectFactory.getFileSystem(this.contentProvider);
    }

    public URI getURI() {
        return this.uri;
    }

    private void openEditorsForWindows() {
        JSWindow[] jSWindowArray;
        for (JSWindow jSWindow : jSWindowArray = this.getWindows()) {
            String string = jSWindow.getURI();
            JSSource jSSource = JSFactory.createJSSource((String)string);
            NbJSEditorUtil.openFileObject(this.getFileObjectForSource(jSSource, true));
        }
    }

    private void refreshCacheForSources(JSSource[] jSSourceArray) {
        if (jSSourceArray == null || jSSourceArray.length == 0) {
            return;
        }
        for (JSSource jSSource : jSSourceArray) {
            try {
                URI uRI = jSSource.getLocation().getURI();
                URI uRI2 = this.ignoreQueryStrings ? this.getURIWithoutQuery(uRI) : null;
                URLFileObject uRLFileObject = URLFileObjectFactory.findFileObject(this.contentProvider, uRI2 != null ? uRI2.toURL() : uRI.toURL());
                boolean bl = false;
                if (uRLFileObject != null && uRI2 != null) {
                    URL uRL = uRLFileObject.getActualURL();
                    URL uRL2 = uRI.toURL();
                    if (!uRL.toExternalForm().equals(uRL2.toExternalForm())) {
                        uRLFileObject.setActualURL(uRI.toURL());
                        bl = true;
                    }
                }
                if (uRLFileObject == null || bl) continue;
                uRLFileObject.invalidate();
            }
            catch (MalformedURLException malformedURLException) {
                Log.getLogger().log(Level.FINE, "Could not convert URI to URL", malformedURLException);
            }
        }
    }

    private static boolean displayReloadSessionDialog() {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(NbJSDebugger.class, (String)"RELOAD_DEBUGGER_QUESTION"), 2);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        return object == NotifyDescriptor.OK_OPTION;
    }

    private class StartDebuggerTask
    implements Cancellable,
    Runnable {
        private boolean success = false;
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NbJSDebugger.class, (String)"MSG_TASK_INITIALIZING_JAVASCRIPT_DEBUGGER"), (Cancellable)this);

        public void run() {
            this.handle.start();
            try {
                this.success = NbJSDebugger.this.debugger.startDebugging();
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.INFO, "Unexpected exception while starting debugger", exception);
            }
            this.handle.finish();
        }

        public boolean cancel() {
            try {
                NbJSDebugger.this.debugger.cancelStartDebugging();
                return true;
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.INFO, "Unexpected exception while canceling debugger start", exception);
                return false;
            }
        }

        public boolean taskSucceeded() {
            return this.success;
        }
    }

    private class PreferenceChangeListenerImpl
    implements PreferenceChangeListener {
        private PreferenceChangeListenerImpl() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if (NbJSPreferences.PROPERTIES.PROP_HTTP_MONITOR_ENABLED.equals(string)) {
                NbJSDebugger.this.setBooleanFeatures(Feature.Name.HTTP_MONITOR, Boolean.parseBoolean(preferenceChangeEvent.getNewValue()));
            } else if (NbJSPreferences.PROPERTIES.PROP_HTTP_MONITOR_OPENED.equals(string)) {
                NbJSPreferences nbJSPreferences = NbJSPreferences.getInstance();
                boolean bl = nbJSPreferences.getHttpMonitorEnabled();
                boolean bl2 = Boolean.parseBoolean(preferenceChangeEvent.getNewValue());
                if (bl2 && bl) {
                    NbJSDebugger.this.setBooleanFeatures(Feature.Name.HTTP_MONITOR, true);
                }
            }
        }
    }

    private class BreakpointPropertyChangeListener
    implements PropertyChangeListener {
        private BreakpointPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof NbJSBreakpoint) {
                NbJSBreakpoint nbJSBreakpoint = (NbJSBreakpoint)((Object)object);
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    NbJSDebugger.this.updateBreakpoint(nbJSBreakpoint);
                } else if (propertyChangeEvent.getPropertyName().equals("lineNumber")) {
                    NbJSDebugger.this.removeBreakpoint(nbJSBreakpoint);
                    NbJSDebugger.this.setBreakpoint(nbJSBreakpoint);
                } else if (propertyChangeEvent.getPropertyName().equals("updated")) {
                    NbJSDebugger.this.updateBreakpoint(nbJSBreakpoint);
                }
            }
        }
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(NbJSDebugger.PROPERTY_SOURCES) || propertyChangeEvent.getPropertyName().equals(NbJSDebugger.PROPERTY_WINDOWS) || propertyChangeEvent.getPropertyName().equals(NbJSDebugger.PROPERTY_RELOADSOURCES)) {
                try {
                    NbJSDebugger.this.propertyChangeSupport.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
                catch (RuntimeException runtimeException) {
                    Log.getLogger().log(Level.INFO, runtimeException.getMessage(), runtimeException);
                }
            }
            if (propertyChangeEvent.getPropertyName().equals(NbJSDebugger.PROPERTY_SOURCES) || propertyChangeEvent.getPropertyName().equals(NbJSDebugger.PROPERTY_WINDOWS)) {
                NbJSDebugger.this.openEditorsForWindows();
            } else if (propertyChangeEvent.getPropertyName().equals(NbJSDebugger.PROPERTY_RELOADSOURCES)) {
                NbJSDebugger.this.refreshCacheForSources((JSSource[])propertyChangeEvent.getNewValue());
            }
        }
    }

    private class DebuggerManagerListenerImpl
    extends DebuggerManagerAdapter {
        private DebuggerManagerListenerImpl() {
        }

        public void breakpointAdded(Breakpoint breakpoint) {
            if (breakpoint instanceof NbJSBreakpoint) {
                NbJSDebugger.this.setBreakpoint((NbJSBreakpoint)breakpoint);
            }
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
            if (breakpoint instanceof NbJSBreakpoint) {
                NbJSDebugger.this.removeBreakpoint(breakpoint);
            }
        }
    }

    private class JSHttpMessageEventListenerImpl
    implements JSHttpMessageEventListener {
        private JSHttpMessageEventListenerImpl() {
        }

        public void onHttpMessageEvent(JSHttpMessageEvent jSHttpMessageEvent) {
            if (jSHttpMessageEvent != null) {
                NbJSDebugger.this.fireJSHttpMessageEvent(jSHttpMessageEvent);
            }
        }
    }

    private class JSDebuggerConsoleEventListenerImpl
    implements JSDebuggerConsoleEventListener {
        private JSDebuggerConsoleEventListenerImpl() {
        }

        public void onConsoleEvent(JSDebuggerConsoleEvent jSDebuggerConsoleEvent) {
            if (NbJSDebugger.this.console != null) {
                String string = jSDebuggerConsoleEvent.getMessage();
                switch (jSDebuggerConsoleEvent.getType()) {
                    case STDERR: {
                        NbJSDebugger.this.console.getErr().println(string);
                        break;
                    }
                    case STDOUT: {
                        NbJSDebugger.this.console.getOut().println(string);
                    }
                }
            }
        }
    }

    private class JSDebuggerEventListenerImpl
    implements JSDebuggerEventListener {
        private JSDebuggerEventListenerImpl() {
        }

        public void onDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
            JSDebuggerState jSDebuggerState = jSDebuggerEvent.getDebuggerState();
            NbJSDebugger.this.setState(jSDebuggerState);
        }
    }
}

