/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.websvcmgr.consumer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderBeanInfoWriter;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderDesignInfoWriter;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderInfo;
import org.netbeans.modules.visualweb.websvcmgr.codegen.DataProviderWriter;
import org.netbeans.modules.visualweb.websvcmgr.codegen.WrapperClientBeanInfoWriter;
import org.netbeans.modules.visualweb.websvcmgr.codegen.WrapperClientWriter;
import org.netbeans.modules.visualweb.websvcmgr.consumer.DesignerWebServiceExtData;
import org.netbeans.modules.visualweb.websvcmgr.util.Util;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.spi.WebServiceManagerExt;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class DesignerWebServiceExtImpl
implements WebServiceManagerExt {
    protected static final String VW_DESIGNTIME_JAR = "vw-dt";
    public static final String CONSUMER_ID = DesignerWebServiceExtImpl.class.getName();
    private static final String WEBSVC_HOME_PROP = "websvc.home";
    private static final String USER_FILE_PROP = "user.properties.file";
    private static final String WSDL_DIRNAME_PROP = "serviceDirName";
    private static final String WSDL_NAME_PROP = "serviceName";
    private static final String WSDL_FILE_NAME_PROP = "wsdlFileName";
    private static final String PACKAGE_NAME = "packageName";
    private static final String PACKAGE_DIR = "packageDir";
    private static final String DESIGNTIME_CLASSPATH = "designtime.classpath";
    private static final String wsImportCompileScriptName = "ws_import_compile.xml";
    private static File wsImportCompileScript;
    private final String userDir = System.getProperty("netbeans.user");

    private void notifyError(int n) {
        String string = n == 1 ? "CODEGEN_ERROR_JAXWS" : "CODEGEN_ERROR_JAXRPC";
        String string2 = NbBundle.getMessage(DesignerWebServiceExtImpl.class, (String)string);
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public boolean wsServiceAddedExt(WebServiceDescriptor webServiceDescriptor) {
        boolean bl = this.createClientClasses(webServiceDescriptor);
        if (!bl) {
            this.notifyError(webServiceDescriptor.getWsType());
            return false;
        }
        boolean bl2 = this.jarGeneratedClasses(webServiceDescriptor);
        if (!bl2) {
            this.removeBuildFiles(webServiceDescriptor.getXmlDescriptorFile().getParentFile());
            webServiceDescriptor.removeConsumerData(CONSUMER_ID);
            this.notifyError(webServiceDescriptor.getWsType());
        } else {
            webServiceDescriptor.addJar(webServiceDescriptor.getName() + "-dt.jar", VW_DESIGNTIME_JAR);
            webServiceDescriptor.addJar(webServiceDescriptor.getName() + "-dt-src.jar", "source");
        }
        return bl2;
    }

    public boolean wsServiceRemovedExt(WebServiceDescriptor webServiceDescriptor) {
        this.removeBuildFiles(webServiceDescriptor.getXmlDescriptorFile().getParentFile());
        webServiceDescriptor.removeConsumerData(CONSUMER_ID);
        return true;
    }

    private boolean jarGeneratedClasses(WebServiceDescriptor webServiceDescriptor) {
        try {
            Properties properties = this.createAntProperties(webServiceDescriptor);
            String string = webServiceDescriptor.getWsType() == 1 ? "jaxws-dt-compile" : "jaxrpc-dt-compile";
            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)FileUtil.toFileObject((File)this.getAntScript()), (String[])new String[]{string}, (Properties)properties);
            executorTask.waitFinished();
            return executorTask.result() == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private File getAntScript() {
        if (wsImportCompileScript == null) {
            wsImportCompileScript = InstalledFileLocator.getDefault().locate(wsImportCompileScriptName, "", false);
        }
        return wsImportCompileScript;
    }

    private void removeBuildFiles(File file) {
        this.rmDir(new File(file, "build"));
        this.rmDir(new File(file, "dt"));
        this.rmDir(new File(file, "src"));
    }

    Properties createAntProperties(WebServiceDescriptor webServiceDescriptor) throws URISyntaxException {
        File file = null;
        try {
            file = new File(webServiceDescriptor.getWsdlUrl().toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(webServiceDescriptor.getWsdlUrl().getPath());
        }
        String string = file.getAbsolutePath();
        String string2 = webServiceDescriptor.getXmlDescriptorFile().getParentFile().getParentFile().getName();
        String string3 = webServiceDescriptor.getName();
        Properties properties = new Properties();
        properties.put(WEBSVC_HOME_PROP, WebServiceDescriptor.WEBSVC_HOME);
        properties.put(USER_FILE_PROP, this.userDir + "/build.properties");
        properties.put(WSDL_DIRNAME_PROP, string2);
        properties.put(WSDL_NAME_PROP, string3);
        properties.put(WSDL_FILE_NAME_PROP, string);
        properties.put(PACKAGE_NAME, webServiceDescriptor.getPackageName());
        properties.put(PACKAGE_DIR, webServiceDescriptor.getPackageName().replace('.', '/'));
        File file2 = InstalledFileLocator.getDefault().locate("modules/ext/designtime.jar", null, true);
        File file3 = InstalledFileLocator.getDefault().locate("modules/ext/designtime-base.jar", null, true);
        File file4 = InstalledFileLocator.getDefault().locate("modules/ext/editors.jar", null, true);
        String string4 = file2.getAbsolutePath() + ":" + file3.getAbsolutePath() + ":" + file4.getAbsolutePath();
        properties.put(DESIGNTIME_CLASSPATH, string4);
        return properties;
    }

    boolean createClientClasses(WebServiceDescriptor webServiceDescriptor) {
        boolean bl;
        boolean bl2 = webServiceDescriptor.getWsType() == 0;
        String string = webServiceDescriptor.getXmlDescriptorFile().getParent();
        String string2 = webServiceDescriptor.getPackageName().replace('.', '/');
        File file = new File(string + "/src/" + string2);
        File file2 = new File(string + "/dt/src/" + string2);
        file.mkdirs();
        file2.mkdirs();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> hashMap2 = new HashMap<String, Map<String, String>>();
        DesignerWebServiceExtData designerWebServiceExtData = new DesignerWebServiceExtData();
        designerWebServiceExtData.setPortToDataProviderMap(hashMap2);
        designerWebServiceExtData.setPortToProxyBeanNameMap(hashMap);
        int n = 0;
        List list = webServiceDescriptor.getModel().getPorts();
        assert (list.size() > 0) : "ports.size = " + list.size();
        for (WSPort wSPort : list) {
            if (wSPort.getAddress() == null) continue;
            HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>();
            String string3 = wSPort.getName() + "Client";
            String string4 = webServiceDescriptor.getModel().getJavaName();
            String string5 = wSPort.getJavaName();
            File file3 = new File(file, string3 + ".java");
            File file4 = new File(file2, string3 + "BeanInfo.java");
            WrapperClientWriter wrapperClientWriter = null;
            WrapperClientBeanInfoWriter wrapperClientBeanInfoWriter = null;
            try {
                Object object;
                String string6;
                String string7;
                Object object422;
                block26: {
                    File file5 = null;
                    for (Object object422 : webServiceDescriptor.getJars()) {
                        if (!object422.getType().equals("proxy")) continue;
                        file5 = new File(string, object422.getName());
                    }
                    if (file5 == null) {
                        ErrorManager.getDefault().log(65536, "Could not find proxy jar for port: " + wSPort.getName());
                        continue;
                    }
                    Object object5 = this.createTempCopy(file5);
                    if (object5 != null) {
                        ((File)object5).deleteOnExit();
                    } else {
                        object5 = file5;
                    }
                    object422 = new URLClassLoader(ManagerUtil.buildClasspath((File)object5, (webServiceDescriptor.getWsType() == 1 ? 1 : 0) != 0).toArray(new URL[0]), this.getClass().getClassLoader());
                    string7 = null;
                    string6 = null;
                    Class<?> clazz = null;
                    try {
                        clazz = ((ClassLoader)object422).loadClass(string4);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            string4 = webServiceDescriptor.getPackageName() + "." + webServiceDescriptor.getModel().getName();
                            clazz = ((ClassLoader)object422).loadClass(string4);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            ErrorManager.getDefault().log(1, "Unable to load service class for port: " + wSPort.getName());
                            continue;
                        }
                    }
                    try {
                        string7 = wSPort.getPortGetter();
                        clazz.getMethod(string7, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        for (Method method : clazz.getMethods()) {
                            Object object2 = method.getName();
                            if (!((String)object2).startsWith("get") || !((String)object2).toLowerCase().contains(wSPort.getName().toLowerCase())) continue;
                            string7 = method.getName();
                            string6 = method.getReturnType().getName();
                            break;
                        }
                        if (string6 != null) break block26;
                        ErrorManager.getDefault().log(1, "Unable to find getter method for port: " + wSPort.getName());
                        continue;
                    }
                }
                Class<?> clazz = null;
                try {
                    clazz = ((ClassLoader)object422).loadClass(string5);
                    string6 = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (string6 == null) {
                        ErrorManager.getDefault().log(1, "Could not load class: " + string5);
                        continue;
                    }
                    try {
                        clazz = ((ClassLoader)object422).loadClass(string6);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        ErrorManager.getDefault().log(1, "Could not load class: " + string6);
                        continue;
                    }
                }
                Method[] methodArray = clazz.getDeclaredMethods();
                ArrayList<Method> arrayList = new ArrayList<Method>();
                for (int i = 0; i < methodArray.length; ++i) {
                    arrayList.add(methodArray[i]);
                }
                wrapperClientWriter = new WrapperClientWriter(new FileWriter(file3), webServiceDescriptor, bl2, arrayList, wSPort.getOperations());
                wrapperClientBeanInfoWriter = new WrapperClientBeanInfoWriter(new FileWriter(file4));
                wrapperClientWriter.setClassLoader((ClassLoader)object422);
                wrapperClientWriter.setPackage(webServiceDescriptor.getPackageName());
                wrapperClientWriter.setClassName(string3);
                wrapperClientWriter.setContainedClassInfo(string4);
                wrapperClientWriter.addImport(webServiceDescriptor.getPackageName() + ".*");
                wrapperClientWriter.setPort(wSPort);
                wrapperClientWriter.setPortGetterMethod(string7);
                wrapperClientWriter.setPortClassName(string6);
                wrapperClientWriter.writeClass();
                wrapperClientWriter.flush();
                wrapperClientWriter.close();
                wrapperClientBeanInfoWriter.setPackage(webServiceDescriptor.getPackageName());
                wrapperClientBeanInfoWriter.setClassName(string3);
                wrapperClientBeanInfoWriter.writeBeanInfo();
                wrapperClientBeanInfoWriter.flush();
                wrapperClientBeanInfoWriter.close();
                HashMap<String, String> hashMap4 = new HashMap<String, String>();
                for (Object object2 : wrapperClientWriter.getDataProviders()) {
                    hashMap4.put(Util.getMethodSignatureAsString(((DataProviderInfo)object2).getMethod()), webServiceDescriptor.getPackageName() + "." + ((DataProviderInfo)object2).getClassName());
                    try {
                        object = new File(file, ((DataProviderInfo)object2).getClassName() + ".java");
                        DataProviderWriter dataProviderWriter = new DataProviderWriter(new FileWriter((File)object), (DataProviderInfo)object2, !bl2);
                        dataProviderWriter.setClassLoader((ClassLoader)object422);
                        dataProviderWriter.addImport(webServiceDescriptor.getPackageName() + ".*");
                        dataProviderWriter.writeClass();
                        dataProviderWriter.flush();
                        dataProviderWriter.close();
                        File file5 = new File(file2, ((DataProviderInfo)object2).getClassName() + "BeanInfo.java");
                        DataProviderBeanInfoWriter dataProviderBeanInfoWriter = new DataProviderBeanInfoWriter((Writer)new FileWriter(file5), (DataProviderInfo)object2);
                        dataProviderBeanInfoWriter.writeClass();
                        dataProviderBeanInfoWriter.flush();
                        dataProviderBeanInfoWriter.close();
                        File file6 = new File(file2, ((DataProviderInfo)object2).getClassName() + "DesignInfo.java");
                        DataProviderDesignInfoWriter dataProviderDesignInfoWriter = new DataProviderDesignInfoWriter((Writer)new FileWriter(file6), (DataProviderInfo)object2);
                        dataProviderDesignInfoWriter.writeClass();
                        dataProviderDesignInfoWriter.flush();
                        dataProviderDesignInfoWriter.close();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                        return false;
                    }
                }
                this.copyIcons(file2);
                hashMap2.put(wSPort.getName(), hashMap3);
                hashMap.put(wSPort.getName(), webServiceDescriptor.getPackageName() + "." + string3);
                for (Object object2 : hashMap4.keySet()) {
                    object = (String)hashMap4.get(object2);
                    hashMap3.put(object2, object);
                }
                ++n;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return false;
            }
        }
        boolean bl3 = bl = n > 0;
        if (bl) {
            webServiceDescriptor.addConsumerData(CONSUMER_ID, (Object)designerWebServiceExtData);
        }
        return bl;
    }

    private void copyIcons(File file) {
        try {
            URL[] uRLArray = new URL[]{ManagerUtil.class.getResource("/org/netbeans/modules/websvc/manager/resources/webservice.png"), ManagerUtil.class.getResource("/org/netbeans/modules/websvc/manager/resources/methodicon.png"), ManagerUtil.class.getResource("/org/netbeans/modules/websvc/manager/resources/table_dp_badge.png")};
            String[] stringArray = new String[]{ManagerUtil.getFileName((String)WrapperClientBeanInfoWriter.WEBSERVICE_ICON_FILENAME), ManagerUtil.getFileName((String)"methodicon.png"), ManagerUtil.getFileName((String)"table_dp_badge.png")};
            for (int i = 0; i < uRLArray.length; ++i) {
                DataInputStream dataInputStream = new DataInputStream(uRLArray[i].openStream());
                File file2 = new File(file, stringArray[i]);
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[1024];
                int n = dataInputStream.read(byArray);
                while (n > -1) {
                    dataOutputStream.write(byArray);
                    n = dataInputStream.read(byArray);
                }
                dataOutputStream.flush();
                dataOutputStream.close();
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private File createTempCopy(File file) {
        try {
            File file2 = File.createTempFile("proxyjar", "jar");
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
            fileChannel.close();
            fileChannel2.close();
            return file2;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
            return null;
        }
    }

    private void rmDir(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.rmDir(fileArray[i]);
            }
            fileArray[i].delete();
        }
        file.delete();
    }
}

