/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerUtilities {
    public static final int ACTION_TIMEOUT = 10000;
    public static final TimeUnit ACTION_TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    public static final String GFV3_MODULES_DIR_NAME = "modules";
    public static final String GFV3_VERSION_MATCHER = "(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String GFV3_JAR_MATCHER = "glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String PROP_FIRST_RUN = "first_run";

    private ServerUtilities() {
    }

    public static ServerInstance getServerInstance(String string) {
        return GlassfishInstanceProvider.getDefault().getInstance(string);
    }

    public static Lookup getLookupFor(ServerInstance serverInstance) {
        return GlassfishInstanceProvider.getDefault().getLookupFor(serverInstance);
    }

    public static <T> T getInstanceByCapability(String string, Class<T> clazz) {
        return GlassfishInstanceProvider.getDefault().getInstanceByCapability(string, clazz);
    }

    public static <T> List<T> getInstancesByCapability(Class<T> clazz) {
        return GlassfishInstanceProvider.getDefault().getInstancesByCapability(clazz);
    }

    public static ServerInstanceImplementation getInternalServerInstance(String string) {
        return GlassfishInstanceProvider.getDefault().getInternalInstance(string);
    }

    public static WizardDescriptor.InstantiatingIterator getAddInstanceIterator() {
        return new ServerWizardIterator();
    }

    public static ServerInstanceProvider getServerProvider() {
        return GlassfishInstanceProvider.getDefault();
    }

    public static File getJarName(String string, String string2) {
        File[] fileArray;
        File file = new File(string + File.separatorChar + GFV3_MODULES_DIR_NAME);
        int n = string2.lastIndexOf("/");
        if (n != -1) {
            fileArray = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            file = new File(file, (String)fileArray);
        }
        if ((fileArray = file.listFiles(new VersionFilter(string2))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    public static final String quote(String string) {
        return string.indexOf(32) == -1 ? string : "\"" + string + "\"";
    }

    public static boolean isTP2(String string) {
        return ServerUtilities.getJarName(string, GFV3_JAR_MATCHER).getName().indexOf("-tp-2-") > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> filterByManifest(List<String> list, File file, int n, boolean bl) {
        if (file.exists()) {
            int n2 = file.getPath().length();
            if (n == 1) {
                n2 = file.getParentFile().getPath().length();
            }
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    if (n >= 1) continue;
                    ServerUtilities.filterByManifest(list, file2, n + 1, bl);
                    continue;
                }
                if (!file2.getName().endsWith(".jar")) continue;
                JarFile jarFile = null;
                try {
                    String string;
                    Attributes attributes;
                    jarFile = new JarFile(file2, false);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null || (attributes = manifest.getMainAttributes()) == null || (string = attributes.getValue("Bundle-SymbolicName")) == null || !string.contains("javax")) continue;
                    String string2 = file2.getPath().substring(n2 + 1);
                    if (bl) {
                        string2 = string2.replace("\\", "\\\\");
                    }
                    list.add(string2);
                }
                catch (IOException iOException) {
                    Logger.getLogger(ServerUtilities.class.getName()).log(Level.INFO, file2.getAbsolutePath(), iOException);
                }
                finally {
                    if (null != jarFile) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(ServerUtilities.class.getName()).log(Level.INFO, file2.getAbsolutePath(), iOException);
                        }
                        jarFile = null;
                    }
                }
            }
        } else {
            Logger.getLogger(ServerUtilities.class.getName()).log(Level.FINER, file.getAbsolutePath() + " does not exist");
        }
        return list;
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String string) {
            this.pattern = Pattern.compile(string);
        }

        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }
}

