/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.RailsInstallationValidator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RailsInstallationPanel
extends JPanel {
    private static final String JRUBY_OPENSSL = "jruby-openssl";
    private static final String WARBLE_CMD = "warble";
    private static final String WARBLER = "warbler";
    private Panel firer;
    private WizardDescriptor wizardDescriptor;
    private JLabel descLabel;
    private JButton installWarblerButton;
    private JSeparator jSeparator1;
    private JLabel jrubyLabel;
    private JLabel jrubySslLabel;
    private JButton proxyButton;
    private JButton railsButton;
    private JButton railsDetailButton;
    private JComboBox railsVersionComboBox;
    private JLabel railsVersionLabel;
    private JButton sslButton;
    private JLabel warblerLabel;

    RailsInstallationPanel(Panel panel) {
        this.initComponents();
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(RailsInstallationPanel.class, (String)"LAB_InstallRails"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(RailsInstallationPanel.class, (String)"TXT_NewRoRApp"));
    }

    private void initRailsVersionComboBox() {
        List list = this.platform().getGemManager().getVersions("rails");
        int n = list.size();
        this.railsVersionComboBox.setEnabled(n > 0);
        this.railsVersionLabel.setEnabled(n > 0);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((GemInfo)list.get(i)).getVersion();
        }
        this.railsVersionComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    private RubyPlatform platform() {
        return (RubyPlatform)this.wizardDescriptor.getProperty("platform");
    }

    private GemManager gemManager() {
        return this.platform().getGemManager();
    }

    private void updateGemProblem() {
        String string = this.gemManager().getGemProblem();
        if (string != null) {
            String string2 = NbBundle.getMessage(RailsInstallationPanel.class, (String)"GemProblem");
            this.descLabel.setText(string2);
            this.railsButton.setEnabled(false);
            this.sslButton.setEnabled(false);
        } else {
            this.railsDetailButton.setVisible(false);
        }
    }

    private void updateLabel() {
        String string;
        RailsInstallationValidator.RailsInstallationInfo railsInstallationInfo = RailsInstallationValidator.getRailsInstallation(this.platform());
        if (railsInstallationInfo.isValid()) {
            this.descLabel.setText(railsInstallationInfo.getMessage());
            Mnemonics.setLocalizedText((AbstractButton)this.railsButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"UpdateRails"));
        } else {
            this.descLabel.setText(railsInstallationInfo.getMessage());
            Mnemonics.setLocalizedText((AbstractButton)this.railsButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"InstallRails"));
        }
        if (!this.isWarblerInstalled()) {
            this.warblerLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.warblerLabel.text"));
            Mnemonics.setLocalizedText((AbstractButton)this.installWarblerButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.installWarblerButton.text"));
        } else {
            string = this.gemManager().getLatestVersion(WARBLER);
            this.warblerLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.warblerLabel.text.installed", (Object)string));
            Mnemonics.setLocalizedText((AbstractButton)this.installWarblerButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.updateWarblerButton.text"));
        }
        if (!this.isJRubyOpenSSLInstalled()) {
            this.jrubySslLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.jrubySslLabel.text"));
            Mnemonics.setLocalizedText((AbstractButton)this.sslButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.sslButton.text"));
        } else {
            string = this.gemManager().getLatestVersion(JRUBY_OPENSSL);
            this.jrubySslLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.jrubySslLabel.installed.text", (Object)string));
            Mnemonics.setLocalizedText((AbstractButton)this.sslButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.update.sslButton.text"));
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        this.updateLabel();
        this.updateGemProblem();
        this.updateGemProblem();
        this.initRailsVersionComboBox();
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = (String)this.railsVersionComboBox.getSelectedItem();
        GemManager gemManager = this.gemManager();
        if (gemManager != null) {
            String string2 = gemManager.getLatestVersion("rails");
            if (string != null && !string.equals(string2)) {
                wizardDescriptor.putProperty("rails.version", this.railsVersionComboBox.getSelectedItem());
            }
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!this.platform().isValidRuby(false)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RailsInstallationPanel.class, (String)"NoRuby"));
            return false;
        }
        RailsInstallationValidator.RailsInstallationInfo railsInstallationInfo = RailsInstallationValidator.getRailsInstallation(this.platform());
        if (!railsInstallationInfo.isValid()) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)railsInstallationInfo.getMessage());
            return false;
        }
        if (((Boolean)this.wizardDescriptor.getProperty("warSupport")).booleanValue() && !this.isWarblerInstalled()) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RailsInstallationPanel.class, (String)"MSG_NoWarbler"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    private boolean isWarblerInstalled() {
        return this.gemManager().isGemInstalled(WARBLER) && this.platform().findExecutable(WARBLE_CMD) != null;
    }

    private boolean isJRubyOpenSSLInstalled() {
        return this.gemManager().isGemInstalled(JRUBY_OPENSSL);
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private void initComponents() {
        this.railsButton = new JButton();
        this.sslButton = new JButton();
        this.descLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jrubyLabel = new JLabel();
        this.jrubySslLabel = new JLabel();
        this.proxyButton = new JButton();
        this.railsDetailButton = new JButton();
        this.railsVersionLabel = new JLabel();
        this.railsVersionComboBox = new JComboBox();
        this.warblerLabel = new JLabel();
        this.installWarblerButton = new JButton();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((AbstractButton)this.railsButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"InstallRails"));
        this.railsButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.sslButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.sslButton.text"));
        this.sslButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.descLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"NoRails"));
        Mnemonics.setLocalizedText((JLabel)this.jrubyLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.jrubyLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jrubySslLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.jrubySslLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.proxyButton.text"));
        this.proxyButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.railsDetailButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.railsDetailButton.text"));
        this.railsDetailButton.addActionListener(formListener);
        this.railsVersionLabel.setLabelFor(this.railsVersionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.railsVersionLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.railsVersionLabel.text"));
        this.railsVersionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.warblerLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.warblerLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installWarblerButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.installWarblerButton.text"));
        this.installWarblerButton.addActionListener(formListener);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.proxyButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.railsVersionLabel).addPreferredGap(0).add((Component)this.railsVersionComboBox, -2, 87, -2)).add((Component)this.descLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.railsDetailButton).add((Component)this.railsButton)).add(162, 162, 162)).add((Component)this.jSeparator1, -1, 440, Short.MAX_VALUE).add((Component)this.jrubyLabel).add((Component)this.jrubySslLabel).add((Component)this.sslButton).add((Component)this.warblerLabel).add((Component)this.installWarblerButton)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.descLabel).add((Component)this.railsDetailButton)).add(13, 13, 13).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.railsVersionLabel).add((Component)this.railsVersionComboBox, -2, -1, -2).add((Component)this.railsButton)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jrubyLabel).addPreferredGap(0).add((Component)this.jrubySslLabel).addPreferredGap(0).add((Component)this.sslButton).addPreferredGap(0).add((Component)this.warblerLabel).addPreferredGap(0).add((Component)this.installWarblerButton).addPreferredGap(0, 18, Short.MAX_VALUE).add((Component)this.proxyButton).addContainerGap()));
        this.railsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.railsButton.AccessibleContext.accessibleDescription"));
        this.sslButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.sslButton.AccessibleContext.accessibleDescription"));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.proxyButton.AccessibleContext.accessibleDescription"));
        this.railsDetailButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.railsDetailButton.AccessibleContext.accessibleDescription"));
    }

    private void railsDetailButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.gemManager().getGemProblem();
        assert (string != null);
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private void proxyButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void sslButtonActionPerformed(ActionEvent actionEvent) {
        InstallationComplete installationComplete = new InstallationComplete();
        Gem gem = new Gem(JRUBY_OPENSSL, null, null);
        if (this.gemManager().isGemInstalled(JRUBY_OPENSSL)) {
            this.gemManager().update(new Gem[]{gem}, (Component)this, false, false, true, true, (Runnable)installationComplete);
        } else {
            this.gemManager().install(new Gem[]{gem}, (Component)this, false, false, null, true, true, (Runnable)installationComplete);
        }
    }

    private void railsButtonActionPerformed(ActionEvent actionEvent) {
        Gem[] gemArray;
        InstallationComplete installationComplete = new InstallationComplete();
        Gem gem = new Gem("rails", null, null);
        Gem gem2 = new Gem("activerecord-jdbc-adapter", null, null);
        if (this.platform().isJRuby()) {
            Gem[] gemArray2 = new Gem[2];
            gemArray2[0] = gem;
            gemArray = gemArray2;
            gemArray2[1] = gem2;
        } else {
            Gem[] gemArray3 = new Gem[1];
            gemArray = gemArray3;
            gemArray3[0] = gem;
        }
        Gem[] gemArray4 = gemArray;
        RailsInstallationValidator.RailsInstallationInfo railsInstallationInfo = RailsInstallationValidator.getRailsInstallation(this.platform());
        if (railsInstallationInfo.getVersion() == null) {
            this.gemManager().install(gemArray4, (Component)this, false, false, null, true, true, (Runnable)installationComplete);
        } else {
            this.gemManager().update(gemArray4, (Component)this, false, false, true, true, (Runnable)installationComplete);
        }
    }

    private void installWarblerButtonActionPerformed(ActionEvent actionEvent) {
        InstallationComplete installationComplete = new InstallationComplete();
        Gem gem = new Gem(WARBLER, null, null);
        Gem[] gemArray = new Gem[]{gem};
        GemManager gemManager = this.platform().getGemManager();
        if (gemManager.isGemInstalled(WARBLER)) {
            this.gemManager().update(gemArray, (Component)this, false, false, true, true, (Runnable)installationComplete);
        } else {
            this.gemManager().install(gemArray, (Component)this, false, false, null, true, true, (Runnable)installationComplete);
        }
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private ArrayList<ChangeListener> listeners;
        private RailsInstallationPanel component;
        private WizardDescriptor settings;

        Panel() {
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(changeListener);
        }

        public void readSettings(Object object) {
            this.settings = (WizardDescriptor)object;
            this.component.read(this.settings);
            Object object2 = this.component.getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.settings.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.component.store((WizardDescriptor)object);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new RailsInstallationPanel(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(RailsInstallationPanel.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            Iterator iterator = null;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)this.listeners.clone()).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }
    }

    private class InstallationComplete
    implements Runnable {
        private InstallationComplete() {
        }

        public void run() {
            RailsInstallationPanel.this.platform().recomputeRoots();
            RailsInstallationPanel.this.updateLabel();
            RailsInstallationPanel.this.firer.fireChangeEvent();
            RailsInstallationPanel.this.platform().recomputeRoots();
            RailsInstallationPanel.this.initRailsVersionComboBox();
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == RailsInstallationPanel.this.railsButton) {
                RailsInstallationPanel.this.railsButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == RailsInstallationPanel.this.sslButton) {
                RailsInstallationPanel.this.sslButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == RailsInstallationPanel.this.proxyButton) {
                RailsInstallationPanel.this.proxyButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == RailsInstallationPanel.this.railsDetailButton) {
                RailsInstallationPanel.this.railsDetailButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == RailsInstallationPanel.this.installWarblerButton) {
                RailsInstallationPanel.this.installWarblerButtonActionPerformed(actionEvent);
            }
        }
    }
}

