/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerManager;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelOptionsVisual
extends SettingsPanel
implements PropertyChangeListener {
    private final PanelConfigureProject panel;
    private JButton manageButton;
    private JComboBox platforms;
    private JLabel rubyPlatformLabel;
    private JComboBox serverComboBox;
    private JLabel serverLabel;
    private JCheckBox warCheckBox;

    public PanelOptionsVisual(PanelConfigureProject panelConfigureProject) {
        this.panel = panelConfigureProject;
        this.initComponents();
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                PanelOptionsVisual.this.fireChangeEvent();
                PanelOptionsVisual.this.initServerComboBox();
                PanelOptionsVisual.this.initWarCheckBox();
            }
        });
        Util.preselectWizardPlatform((JComboBox)this.platforms);
        this.fireChangeEvent();
        this.initWarCheckBox();
    }

    public void removeNotify() {
        Util.storeWizardPlatform((JComboBox)this.platforms);
        super.removeNotify();
    }

    private void initWarCheckBox() {
        this.warCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PanelOptionsVisual.this.fireChangeEvent();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("roots".equals(propertyChangeEvent.getPropertyName())) {
            this.fireChangeEvent();
        }
    }

    private void initComponents() {
        this.warCheckBox = new JCheckBox();
        this.rubyPlatformLabel = new JLabel();
        this.manageButton = new JButton();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.serverLabel = new JLabel();
        this.serverComboBox = RailsServerManager.getServerComboBox(this.getPlatform());
        this.setPreferredSize(new Dimension(226, 100));
        Mnemonics.setLocalizedText((AbstractButton)this.warCheckBox, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WarFile"));
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"RubyPlatformLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"RubyHomeBrowse"));
        this.manageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelOptionsVisual.this.manageButtonActionPerformed(actionEvent);
            }
        });
        this.platforms.setMinimumSize(new Dimension(27, 19));
        this.platforms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelOptionsVisual.this.platformsActionPerformed(actionEvent);
            }
        });
        this.serverLabel.setLabelFor(this.serverComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"PanelOptionsVisual.Server"));
        this.serverComboBox.setMinimumSize(new Dimension(27, 19));
        this.serverComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelOptionsVisual.this.serverComboBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.serverLabel).add((Component)this.rubyPlatformLabel)).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.serverComboBox, 0, 223, Short.MAX_VALUE).add((Component)this.platforms, 0, 223, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.manageButton).add(0, 0, 0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.warCheckBox).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.manageButton).add((Component)this.platforms, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serverLabel).add((Component)this.serverComboBox, -2, 22, -2)).add(18, 18, 18).add((Component)this.warCheckBox).addContainerGap()));
        this.warCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_WarFile"));
        this.rubyPlatformLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_RubyPlatformLabel"));
        this.manageButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCN_RubyHomeBrowse"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCD_RubyHomeBrowse"));
        this.serverLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_Server"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void manageButtonActionPerformed(ActionEvent actionEvent) {
        RubyPlatformCustomizer.manage((JComboBox)this.platforms);
    }

    private void serverComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void platformsActionPerformed(ActionEvent actionEvent) {
    }

    private void initServerComboBox() {
        RubyPlatform rubyPlatform = this.getPlatform();
        if (rubyPlatform != null) {
            this.serverComboBox.setModel(new RailsServerManager.ServerListModel(this.getPlatform()));
        } else {
            this.serverComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
        }
    }

    RubyPlatform getPlatform() {
        return PlatformComponentFactory.getPlatform((JComboBox)this.platforms);
    }

    boolean needWarSupport() {
        return this.warCheckBox.isSelected();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.warCheckBox.isSelected() && !this.isJdk()) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"MSG_NoJDK"));
        }
        return PlatformComponentFactory.getPlatform((JComboBox)this.platforms) != null;
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("setAsMain", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("warSupport", (Object)(this.warCheckBox.isSelected() && this.warCheckBox.isVisible() ? Boolean.TRUE : Boolean.FALSE));
        wizardDescriptor.putProperty("platform", this.platforms.getModel().getSelectedItem());
        wizardDescriptor.putProperty("serverInstance", this.serverComboBox.getModel().getSelectedItem());
    }

    private void fireChangeEvent() {
        this.panel.fireChangeEvent();
    }

    private boolean isJdk() {
        String string = System.getProperty("jdk.home");
        if (Utilities.isMac()) {
            return true;
        }
        File file = new File(string, "jre");
        return file.exists() && file.isDirectory();
    }
}

