/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerManager;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.RailsProjectProperties;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.CustomizerSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private final RailsProject project;
    private String originalEncoding;
    private boolean notified;
    private final JTextField[] configFields;
    private final String[] configPropsKeys;
    private final Map<String, Map<String, String>> configs;
    private final RailsProjectProperties uiProperties;
    private PlatformComponentFactory.PlatformChangeListener platformListener;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JSeparator configSep;
    private JComboBox encoding;
    private JLabel encodingLabel;
    private JPanel mainPanel;
    private JButton manageButton;
    private JComboBox platforms;
    private JTextField portField;
    private JLabel portLabel;
    private JComboBox railsEnvCombo;
    private JLabel railsEnvLabel;
    private JLabel rakeHelpLabel;
    private JLabel rakeLabel;
    private JTextField rakeTextField;
    private JLabel rubyPlatformLabel;
    private JComboBox serverComboBox;
    private JLabel serverLabel;

    public CustomizerRun(RailsProjectProperties railsProjectProperties) {
        Object object;
        this.uiProperties = railsProjectProperties;
        this.initComponents();
        this.project = railsProjectProperties.getRailsProject();
        this.configs = railsProjectProperties.getRunConfigs();
        this.configFields = new JTextField[]{this.portField, this.rakeTextField};
        JLabel[] jLabelArray = new JLabel[]{this.portLabel, this.rakeLabel};
        this.configPropsKeys = new String[]{"rails.port", "rake.args"};
        assert (this.configFields.length == this.configPropsKeys.length);
        this.configChanged(railsProjectProperties.getActiveConfig());
        this.configCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                String string2 = (String)object;
                if (string2 == null) {
                    string = null;
                } else if (string2.length() > 0) {
                    Map map = (Map)CustomizerRun.this.configs.get(string2);
                    String string3 = string = map != null ? (String)map.get("$label") : null;
                    if (string == null) {
                        string = string2;
                    }
                } else {
                    string = NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.default");
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        for (int i = 0; i < this.configFields.length; ++i) {
            object = this.configFields[i];
            String string = this.configPropsKeys[i];
            final JLabel jLabel = jLabelArray[i];
            ((JTextComponent)object).getDocument().addDocumentListener(new DocumentListener((JTextField)object, string){
                Font basefont;
                Font boldfont;
                final /* synthetic */ JTextField val$field;
                final /* synthetic */ String val$prop;
                {
                    this.val$field = jTextField;
                    this.val$prop = string;
                    this.basefont = jLabel.getFont();
                    this.boldfont = this.basefont.deriveFont(1);
                    this.updateFont();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changed();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changed();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                void changed() {
                    String string = CustomizerRun.this.getSelectedConfig();
                    String string2 = this.val$field.getText();
                    if (string2 != null && string != null && string2.equals(((Map)CustomizerRun.this.configs.get(null)).get(this.val$prop))) {
                        string2 = null;
                    }
                    ((Map)CustomizerRun.this.configs.get(string)).put(this.val$prop, string2);
                    this.updateFont();
                }

                void updateFont() {
                    String string = this.val$field.getText();
                    String string2 = CustomizerRun.this.getSelectedConfig();
                    String string3 = (String)((Map)CustomizerRun.this.configs.get(null)).get(this.val$prop);
                    jLabel.setFont(string2 != null && !Utilities.compareObjects((Object)(string != null ? string : ""), (Object)(string3 != null ? string3 : "")) ? this.boldfont : this.basefont);
                }
            });
        }
        this.originalEncoding = this.project.evaluator().getProperty("source.encoding");
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encoding.setModel(new EncodingModel(this.originalEncoding));
        this.encoding.setRenderer(new EncodingRenderer());
        String string = UIManager.getLookAndFeel().getID();
        if (!"Aqua".equals(string)) {
            this.encoding.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.encoding.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                    jComboBox.setPopupVisible(false);
                }
            });
        }
        this.encoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.handleEncodingChange();
            }
        });
        this.platforms.setSelectedItem(railsProjectProperties.getPlatform());
        object = this.project.evaluator().getProperty("rails.servertype");
        this.selectServer((String)object);
        this.serverComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.handleServerChanged();
            }
        });
        this.initRailsEnvCombo();
    }

    private void handleRailsEnvChanged() {
        String string = (String)this.railsEnvCombo.getSelectedItem();
        this.uiProperties.setRailsEnvironment(string, this.getSelectedConfig());
    }

    private void handleServerChanged() {
        RubyInstance rubyInstance = (RubyInstance)this.serverComboBox.getSelectedItem();
        this.uiProperties.setServer(rubyInstance, this.getSelectedConfig());
    }

    private void initRailsEnvCombo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("config/environments");
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (fileObject2.isFolder() || !"rb".equals(fileObject2.getExt())) continue;
                arrayList.add(fileObject2.getName());
            }
        }
        Collections.sort(arrayList);
        this.railsEnvCombo.setModel(new DefaultComboBoxModel<String>(arrayList.toArray(new String[arrayList.size()])));
        String string = this.project.evaluator().getProperty("rails.env");
        this.selectRailsEnv(string);
        this.railsEnvCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.handleRailsEnvChanged();
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.platformListener = new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                RubyPlatform rubyPlatform = (RubyPlatform)CustomizerRun.this.platforms.getSelectedItem();
                CustomizerRun.this.uiProperties.setPlatform(rubyPlatform);
                ((Map)CustomizerRun.this.configs.get(CustomizerRun.this.getSelectedConfig())).put("platform.active", rubyPlatform.getID());
            }
        };
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)this.platformListener);
    }

    public void removeNotify() {
        PlatformComponentFactory.removePlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)this.platformListener);
        super.removeNotify();
    }

    private void handleEncodingChange() {
        Charset charset = (Charset)this.encoding.getSelectedItem();
        String string = charset != null ? charset.name() : this.originalEncoding;
        if (!this.notified && string != null && !string.equals(this.originalEncoding)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"MSG_EncodingWarning"), 2));
            this.notified = true;
        }
        this.uiProperties.putAdditionalProperty("source.encoding", string);
    }

    private String getSelectedConfig() {
        String string = (String)this.configCombo.getSelectedItem();
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    private void selectServer(String string) {
        RubyPlatform rubyPlatform = this.uiProperties.getPlatform();
        if (rubyPlatform == null) {
            return;
        }
        RubyInstance rubyInstance = ServerRegistry.getDefault().getServer(string, rubyPlatform);
        if (rubyInstance != null) {
            this.serverComboBox.setSelectedItem(rubyInstance);
        }
    }

    private void selectRailsEnv(String string) {
        if (string != null && !"".equals(string.trim())) {
            this.railsEnvCombo.setSelectedItem(string);
        } else {
            this.railsEnvCombo.setSelectedIndex(-1);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initComponents() {
        this.configSep = new JSeparator();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.mainPanel = new JPanel();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.serverComboBox = RailsServerManager.getServerComboBox(this.getPlatform());
        this.serverLabel = new JLabel();
        this.railsEnvCombo = new JComboBox();
        this.railsEnvLabel = new JLabel();
        this.encoding = new JComboBox();
        this.encodingLabel = new JLabel();
        this.rakeTextField = new JTextField();
        this.rakeLabel = new JLabel();
        this.rakeHelpLabel = new JLabel();
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel"));
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew"));
        this.configNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configNewActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDelete"));
        this.configDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configDelActionPerformed(actionEvent);
            }
        });
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RubyPlatformLabel"));
        this.platforms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.platformsActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RubyHomeBrowse"));
        this.manageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.manageButtonActionPerformed(actionEvent);
            }
        });
        this.portLabel.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        this.portField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.portFieldActionPerformed(actionEvent);
            }
        });
        this.serverLabel.setLabelFor(this.serverComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"ServerLabel"));
        this.railsEnvCombo.setEditable(true);
        Mnemonics.setLocalizedText((JLabel)this.railsEnvLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RailsEnv"));
        this.encodingLabel.setLabelFor(this.encoding);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"TXT_Encoding"));
        this.rakeLabel.setLabelFor(this.rakeTextField);
        Mnemonics.setLocalizedText((JLabel)this.rakeLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RakeArgs"));
        Mnemonics.setLocalizedText((JLabel)this.rakeHelpLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RakeArgsEx"));
        GroupLayout groupLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.serverLabel, -1, -1, Short.MAX_VALUE).add((Component)this.portLabel, -1, -1, Short.MAX_VALUE)).add((Component)this.railsEnvLabel)).addPreferredGap(0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.encodingLabel, -1, 80, Short.MAX_VALUE).add(64, 64, 64))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rakeLabel).add(34, 34, 34))).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rakeHelpLabel).addContainerGap()).add(2, (GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.railsEnvCombo, 0, 476, Short.MAX_VALUE).add((Component)this.serverComboBox, 0, 476, Short.MAX_VALUE).add((Component)this.portField, -1, 476, Short.MAX_VALUE).add((Component)this.encoding, 0, 476, Short.MAX_VALUE).add((Component)this.rakeTextField, -1, 476, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(18, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serverLabel).add((Component)this.serverComboBox, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.portLabel).add((Component)this.portField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.railsEnvCombo, -2, -1, -2).add((Component)this.railsEnvLabel)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.encodingLabel).add((Component)this.encoding, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.rakeLabel).add((Component)this.rakeTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.rakeHelpLabel).addContainerGap()));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ServerPort"));
        this.portField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_ServerPort"));
        this.serverComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ServerEnvironment"));
        this.railsEnvCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RailsEnv"));
        this.railsEnvLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RailsEnv"));
        this.encoding.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_Encoding"));
        this.rakeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RakeArguments"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.configSep, -1, 632, Short.MAX_VALUE).add(2, (Component)this.mainPanel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.rubyPlatformLabel).add((Component)this.configLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.configCombo, 0, 410, Short.MAX_VALUE).add((Component)this.platforms, 0, 410, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.manageButton).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.configNew).addPreferredGap(0).add((Component)this.configDel)))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.manageButton).add((Component)this.platforms, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.configDel).add((Component)this.configNew).add((Component)this.configLabel).add((Component)this.configCombo, -2, -1, -2)).add(14, 14, 14).add((Component)this.configSep, -2, -1, -2).addPreferredGap(1).add((Component)this.mainPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.configCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_Configuration"));
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_NewConfiguration"));
        this.platforms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RubyPlatformLabel"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_RubyHomeBrowse"));
    }

    private void portFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void configDelActionPerformed(ActionEvent actionEvent) {
        String string = this.getSelectedConfig();
        assert (string != null);
        this.configs.put(string, null);
        this.configChanged(null);
        this.uiProperties.setActiveConfig(null);
    }

    private void configNewActionPerformed(ActionEvent actionEvent) {
        String string = CustomizerSupport.askForNewConfiguration(this.configs);
        this.configChanged(string);
        this.uiProperties.setActiveConfig(string);
    }

    private void configComboActionPerformed(ActionEvent actionEvent) {
        String string = this.getSelectedConfig();
        this.configChanged(string);
        this.uiProperties.setActiveConfig(string);
    }

    private void manageButtonActionPerformed(ActionEvent actionEvent) {
        RubyPlatformCustomizer.manage((JComboBox)this.platforms);
    }

    private void platformsActionPerformed(ActionEvent actionEvent) {
        this.initServerComboBox();
    }

    private void initServerComboBox() {
        if (this.getPlatform() == null) {
            this.serverComboBox.setModel(new DefaultComboBoxModel());
        } else {
            this.serverComboBox.setModel(new RailsServerManager.ServerListModel(this.getPlatform()));
            String string = this.configs.get(this.getSelectedConfig()).get("rails.servertype");
            if (string != null) {
                this.selectServer(string);
            }
        }
    }

    private RubyPlatform getPlatform() {
        return PlatformComponentFactory.getPlatform((JComboBox)this.platforms);
    }

    private void configChanged(String string) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("");
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String string, String string2) {
                return this.coll.compare(this.label(string), this.label(string2));
            }

            private String label(String string) {
                Map map = (Map)CustomizerRun.this.configs.get(string);
                String string2 = (String)map.get("$label");
                return string2 != null ? string2 : string;
            }
        });
        for (Map.Entry<String, Map<String, String>> object2 : this.configs.entrySet()) {
            String string2 = object2.getKey();
            if (string2 == null || object2.getValue() == null) continue;
            treeSet.add(string2);
        }
        for (String string3 : treeSet) {
            defaultComboBoxModel.addElement(string3);
        }
        this.configCombo.setModel(defaultComboBoxModel);
        this.configCombo.setSelectedItem(string != null ? string : "");
        Map<String, String> map = this.configs.get(string);
        Map<String, String> map2 = this.configs.get(null);
        if (map != null) {
            String string4;
            for (int i = 0; i < this.configFields.length; ++i) {
                string4 = (String)map.get(this.configPropsKeys[i]);
                if (string4 == null) {
                    string4 = map2.get(this.configPropsKeys[i]);
                }
                this.configFields[i].setText(string4);
            }
            String string5 = (String)map.get("platform.active");
            if (string5 == null) {
                string5 = map2.get("platform.active");
            }
            this.platforms.setSelectedItem(RubyPlatformManager.getPlatformByID((String)string5));
            string4 = (String)map.get("rails.servertype");
            if (string4 == null) {
                string4 = map2.get("rails.servertype");
            }
            this.selectServer(string4);
            String string6 = (String)map.get("rails.env");
            if (string6 == null) {
                string6 = map2.get("rails.env");
            }
            this.selectRailsEnv(string6);
        }
        this.configDel.setEnabled(string != null);
    }

    private static class UnknownCharset
    extends Charset {
        UnknownCharset(String string) {
            super(string, new String[0]);
        }

        public boolean contains(Charset charset) {
            throw new UnsupportedOperationException();
        }

        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EncodingModel
    extends DefaultComboBoxModel {
        public EncodingModel(String string) {
            Charset charset = null;
            for (Charset charset2 : Charset.availableCharsets().values()) {
                if (charset2.name().equals(string)) {
                    charset = charset2;
                }
                this.addElement(charset2);
            }
            if (charset == null) {
                try {
                    charset = new UnknownCharset(string);
                    this.addElement(charset);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Logger.getLogger(this.getClass().getName()).info("IllegalCharsetName: " + string);
                }
            }
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            this.setSelectedItem(charset);
        }
    }

    private static class EncodingRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public EncodingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof Charset);
            this.setName("ComboBox.listRenderer");
            this.setText(((Charset)object).displayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

