/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.GlassFishGem;
import org.netbeans.modules.ruby.railsprojects.server.RailsApplication;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.ServerResolver;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public final class RailsServerManager {
    private static boolean NO_BROWSER = Boolean.getBoolean("rails.nobrowser");
    private static final Logger LOGGER = Logger.getLogger(RailsServerManager.class.getName());
    private static final Set<Integer> IN_USE_PORTS = new HashSet<Integer>();
    private static final int SERVER_STARTUP_TIMEOUT = 120000;
    private ServerStatus status = ServerStatus.NOT_STARTED;
    private RubyServer server;
    private RubyInstance instance;
    private boolean portConflict;
    private int originalPort;
    private int port = -1;
    private RailsProject project;
    private RubyExecution execution;
    private File dir;
    private String projectName;
    private boolean debug;
    private boolean clientDebug;
    private boolean switchToDebugMode;
    private Semaphore debugSemaphore;
    private static boolean useHttpValidation = Boolean.parseBoolean(System.getProperty("rails.server.http.validation"));

    public RailsServerManager(RailsProject railsProject) {
        this.project = railsProject;
        this.dir = FileUtil.toFile((FileObject)railsProject.getProjectDirectory());
    }

    public synchronized void setDebug(boolean bl) {
        if (this.status == ServerStatus.RUNNING && !this.debug && bl) {
            this.switchToDebugMode = true;
        }
        this.debug = bl;
    }

    public void setClientDebug(boolean bl) {
        this.clientDebug = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureRunning() {
        Object object;
        Object object2;
        Object object3;
        Object object4 = this;
        synchronized (object4) {
            if (this.projectName == null) {
                this.projectName = ((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
            }
            if (this.status == ServerStatus.STARTING) {
                return false;
            }
            if (this.status == ServerStatus.RUNNING) {
                if (this.switchToDebugMode) {
                    if (!RailsServerManager.isPluginServer(this.instance)) {
                        assert (this.debugSemaphore == null) : "startSemaphor supposed to be null";
                        this.debugSemaphore = new Semaphore(0);
                    }
                    this.switchToDebugMode = false;
                } else if (RailsServerManager.isPortInUse(this.port)) {
                    if (!this.debug && RailsServerManager.isPluginServer(this.instance)) {
                        if (this.port == this.instance.getRailsPort()) {
                            this.status = ServerStatus.STARTING;
                            this.glassfishEnsureRunning(null);
                            return false;
                        }
                    } else {
                        return true;
                    }
                }
            }
        }
        if (this.debugSemaphore != null) {
            try {
                if (this.execution != null) {
                    this.execution.kill();
                }
                this.debugSemaphore.acquire();
                this.debugSemaphore = null;
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
        object4 = this;
        synchronized (object4) {
            this.status = ServerStatus.STARTING;
        }
        this.projectName = ((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
        object4 = this.project.evaluator().getProperty("javac.classpath");
        String string = this.project.evaluator().getProperty("jvm.args");
        String string2 = this.project.evaluator().getProperty("rails.servertype");
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        RubyInstance rubyInstance = ServerRegistry.getDefault().getServer(string2, rubyPlatform);
        if (rubyInstance == null) {
            object3 = ServerRegistry.getDefault().getServers();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!object.isPlatformSupported(rubyPlatform)) continue;
                rubyInstance = object;
                break;
            }
            assert (rubyInstance != null) : "No servers found for " + rubyPlatform;
        }
        this.instance = rubyInstance;
        if (RailsServerManager.isPluginServer(this.instance)) {
            if (!this.debug) {
                this.glassfishEnsureRunning(rubyPlatform);
                return false;
            }
            this.ensurePortAvailable();
            object3 = NbBundle.getMessage(RailsServerManager.class, (String)"LBL_ServerTab", (Object)this.instance.getDisplayName(), (Object)this.projectName, (Object)Integer.toString(this.port));
            object2 = new ExecutionDescriptor(rubyPlatform, (String)object3, this.dir, "unknown");
            object2.cmd(this.getJavaExecutable());
            object2.useInterpreter(false);
            object2.initialArgs(this.instance.getServerCommand(rubyPlatform, (String)object4, this.dir, this.port, this.debug));
            object2.postBuild(this.getFinishAction());
            object2.jvmArguments(string);
            object2.addStandardRecognizers();
            object2.addOutputRecognizer((OutputRecognizer)new GrizzlyServerRecognizer(this.instance));
            object2.frontWindow(false);
            object2.debug(this.debug);
            object2.fastDebugRequired(this.debug);
            object2.fileLocator((FileLocator)new DirectoryFileLocator(FileUtil.toFileObject((File)this.dir)));
            object2.showSuspended(true);
            object = this.project.evaluator().getProperty("source.encoding");
            IN_USE_PORTS.add(this.port);
            this.execution = new RubyExecution((ExecutionDescriptor)object2, (String)object);
            this.execution.run();
            return false;
        }
        object3 = ServerResolver.getExplicitlySpecifiedServer(this.project);
        if (object3 instanceof RubyServer) {
            this.server = (RubyServer)object3;
            this.instance = object3;
        } else {
            this.server = (RubyServer)this.instance;
        }
        this.ensurePortAvailable();
        object2 = RailsServerManager.getServerTabName(this.server, this.projectName, this.port);
        object = this.server.getServerPath();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor(rubyPlatform, (String)object2, this.dir, (String)object);
        String string3 = this.server.getLocation();
        if (string3 != null) {
            executionDescriptor.initialArgs("-I \"" + string3 + File.separatorChar + "bin\" " + "-I \"" + string3 + File.separatorChar + "lib\"");
        }
        executionDescriptor.scriptPrefix(this.server.getScriptPrefix());
        executionDescriptor.additionalArgs(this.buildStartupArgs());
        executionDescriptor.postBuild(this.getFinishAction());
        executionDescriptor.jvmArguments(string);
        executionDescriptor.classPath((String)object4);
        executionDescriptor.addStandardRecognizers();
        executionDescriptor.addOutputRecognizer((OutputRecognizer)new RailsServerRecognizer(this.server));
        executionDescriptor.frontWindow(false);
        executionDescriptor.debug(this.debug);
        executionDescriptor.fastDebugRequired(this.debug);
        executionDescriptor.fileLocator((FileLocator)new DirectoryFileLocator(FileUtil.toFileObject((File)this.dir)));
        executionDescriptor.showSuspended(true);
        String string4 = this.project.evaluator().getProperty("source.encoding");
        IN_USE_PORTS.add(this.port);
        this.execution = new RubyExecution(executionDescriptor, string4);
        this.execution.run();
        return false;
    }

    private String[] buildStartupArgs() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.server.getStartupParam() != null) {
            arrayList.add(this.server.getStartupParam());
        }
        if ((string = this.project.evaluator().getProperty("rails.env")) != null && !"".equals(string.trim())) {
            arrayList.add("-e");
            arrayList.add(string);
        }
        if (this.server instanceof GlassFishGem) {
            arrayList.add(this.dir.getAbsolutePath());
        } else {
            arrayList.add("--port");
            arrayList.add(Integer.toString(this.port));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void ensurePortAvailable() {
        this.portConflict = false;
        String string = this.project.evaluator().getProperty("rails.port");
        LOGGER.fine("Port number in project properties:" + string);
        this.port = 0;
        if (string != null) {
            this.port = Integer.parseInt(string);
        }
        if (this.port == 0) {
            this.port = 3000;
        }
        this.originalPort = this.port;
        while (RailsServerManager.isPortInUse(this.port)) {
            ++this.port;
        }
    }

    private Runnable getFinishAction() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RailsServerManager railsServerManager = RailsServerManager.this;
                synchronized (railsServerManager) {
                    RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                    if (RailsServerManager.this.server != null) {
                        RailsServerManager.this.server.removeApplication(RailsServerManager.this.port);
                    }
                    IN_USE_PORTS.remove(RailsServerManager.this.port);
                    if (RailsServerManager.this.portConflict) {
                        RailsServerManager.this.notifyPortConflict();
                    }
                    if (RailsServerManager.this.debugSemaphore != null) {
                        RailsServerManager.this.debugSemaphore.release();
                    } else {
                        RailsServerManager.this.debug = false;
                    }
                }
            }
        };
    }

    private File getJavaExecutable() {
        String string = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + (Utilities.isWindows() ? "java.exe" : "java");
        File file = new File(string);
        if (!file.exists()) {
            LOGGER.log(Level.SEVERE, "Unable to locate java executable: " + string);
        }
        return file;
    }

    private static boolean isPluginServer(RubyInstance rubyInstance) {
        return rubyInstance != null && !(rubyInstance instanceof RubyServer);
    }

    private static String getServerTabName(RubyServer rubyServer, String string, int n) {
        return NbBundle.getMessage(RailsServerManager.class, (String)"LBL_ServerTab", (Object)rubyServer.getDisplayName(), (Object)string, (Object)String.valueOf(n));
    }

    private void notifyPortConflict() {
        String string = NbBundle.getMessage(RailsServerManager.class, (String)"Conflict", (Object)Integer.toString(this.originalPort));
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private String getContextRoot() {
        if (!this.debug && this.instance != null) {
            return this.instance.getContextRoot(this.projectName);
        }
        return "";
    }

    public void showUrl(final String string) {
        if (this.ensureRunning()) {
            RailsServerManager.showURL(this.getContextRoot(), string, this.port, this.clientDebug, this.project);
        } else {
            String string2 = NbBundle.getMessage(RailsServerManager.class, (String)"ServerStartup");
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    return true;
                }
            }, (Action)new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            progressHandle.start();
            progressHandle.switchToIndeterminate();
            final boolean bl = this.clientDebug;
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        int n;
                        int n2 = 20;
                        for (n = 0; n <= 120000; n += n2) {
                            try {
                                Thread.sleep(n2);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            RailsServerManager railsServerManager = RailsServerManager.this;
                            synchronized (railsServerManager) {
                                block14: {
                                    if (RailsServerManager.this.status != ServerStatus.RUNNING) break block14;
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Server " + (RailsServerManager.this.server != null ? RailsServerManager.this.server : RailsServerManager.this.instance) + " started in " + (n + 500) / 1000 + " seconds.");
                                    }
                                    RailsServerManager.showURL(RailsServerManager.this.getContextRoot(), string, RailsServerManager.this.port, bl, RailsServerManager.this.project);
                                    return;
                                }
                                if (RailsServerManager.this.status == ServerStatus.NOT_STARTED) {
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Server starup failed, server type is: " + (RailsServerManager.this.server != null ? RailsServerManager.this.server : RailsServerManager.this.instance));
                                    }
                                    break;
                                }
                                continue;
                            }
                        }
                        LOGGER.fine("Could not start " + (RailsServerManager.this.server != null ? RailsServerManager.this.server : RailsServerManager.this.instance) + " in " + (n + 500) / 1000 + " seconds, current server status is " + (Object)((Object)RailsServerManager.this.status));
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RailsServerManager.class, (String)"NoServerFound", (Object)("http://localhost:" + RailsServerManager.this.port + "/" + string)));
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkIsPortInUseUsingServerSocket(int n) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Port " + n + " is in use.", iOException);
            boolean bl = true;
            return bl;
        }
        finally {
            if (serverSocket != null && !serverSocket.isClosed()) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Exception while closing ServerSocked in port " + n, iOException);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isPortInUse(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void showURL(String string, String string2, int n, boolean bl, RailsProject railsProject) {
        if (NO_BROWSER) {
            return;
        }
        LOGGER.fine("Opening URL: http://localhost:" + n + "/" + string2);
        try {
            URL uRL = new URL("http://localhost:" + n + string + "/" + string2);
            if (!bl) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            } else {
                FileObject fileObject = railsProject.getRakeProjectHelper().resolveFileObject("public");
                String string3 = "http://localhost:" + n + "/";
                HtmlBrowser.Factory factory = null;
                factory = WebClientToolsProjectUtils.isInternetExplorer((Project)railsProject) ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
                if (factory == null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                    return;
                }
                LocationMappersFactory locationMappersFactory = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
                Lookup lookup = null;
                if (locationMappersFactory != null) {
                    URI uRI = new URI(string3);
                    HashMap<String, String> hashMap = null;
                    FileObject fileObject2 = fileObject.getFileObject("index.html");
                    if (fileObject2 != null) {
                        hashMap = new HashMap<String, String>();
                        hashMap.put("welcome-file", "index.html");
                    }
                    JSToNbJSLocationMapper jSToNbJSLocationMapper = locationMappersFactory.getJSToNbJSLocationMapper(fileObject, uRI, hashMap);
                    NbJSToJSLocationMapper nbJSToJSLocationMapper = locationMappersFactory.getNbJSToJSLocationMapper(fileObject, uRI, hashMap);
                    lookup = Lookups.fixed((Object[])new Object[]{jSToNbJSLocationMapper, nbJSToJSLocationMapper, railsProject});
                } else {
                    lookup = Lookups.fixed((Object[])new Object[]{railsProject});
                }
                WebClientToolsSessionStarterService.startSession((URI)uRL.toURI(), (HtmlBrowser.Factory)factory, (Lookup)lookup);
            }
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
        }
        catch (WebClientToolsSessionException webClientToolsSessionException) {
            ErrorManager.getDefault().notify((Throwable)webClientToolsSessionException);
        }
    }

    private void glassfishEnsureRunning(RubyPlatform rubyPlatform) {
        final Future<RubyInstance.OperationState> future = rubyPlatform != null ? this.instance.runApplication(rubyPlatform, this.projectName, this.dir) : this.instance.deploy(this.projectName, this.dir);
        final RubyInstance rubyInstance = this.instance;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block12: {
                    try {
                        RubyInstance.OperationState operationState = (RubyInstance.OperationState)((Object)future.get(120L, TimeUnit.SECONDS));
                        if (operationState == RubyInstance.OperationState.COMPLETED) {
                            RailsServerManager railsServerManager = RailsServerManager.this;
                            synchronized (railsServerManager) {
                                RailsServerManager.this.port = rubyInstance.getRailsPort();
                                RailsServerManager.this.status = ServerStatus.RUNNING;
                                break block12;
                            }
                        }
                        RailsServerManager railsServerManager = RailsServerManager.this;
                        synchronized (railsServerManager) {
                            RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.INFO, exception.getMessage(), exception);
                        RailsServerManager railsServerManager = RailsServerManager.this;
                        synchronized (railsServerManager) {
                            RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                        }
                    }
                }
            }
        });
    }

    static boolean isAddressInUseMsg(String string) {
        return string.matches(".*in.*: Address.+in use.+(Errno::EADDRINUSE).*");
    }

    public static JComboBox getServerComboBox(RubyPlatform rubyPlatform) {
        JComboBox jComboBox = new JComboBox();
        if (rubyPlatform != null) {
            jComboBox.setModel(new ServerListModel(rubyPlatform));
        }
        jComboBox.setRenderer(new ServerListCellRendered());
        return jComboBox;
    }

    private static class ServerListCellRendered
    extends JLabel
    implements ListCellRenderer {
        public ServerListCellRendered() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            RubyInstance rubyInstance = (RubyInstance)object;
            if (rubyInstance != null) {
                this.setText(rubyInstance.getDisplayName());
                this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            }
            return this;
        }
    }

    public static class ServerListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<? extends RubyInstance> servers;
        private Object selected;

        public ServerListModel(RubyPlatform rubyPlatform) {
            this.servers = ServerRegistry.getDefault().getServers(rubyPlatform);
            if (!this.servers.isEmpty()) {
                this.selected = this.servers.get(0);
            }
        }

        public int getSize() {
            return this.servers.size();
        }

        public Object getElementAt(int n) {
            return this.servers.get(n);
        }

        public void setSelectedItem(Object object) {
            if (this.selected != object) {
                this.selected = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selected;
        }
    }

    private class GrizzlyServerRecognizer
    extends OutputRecognizer {
        private RubyInstance server;

        GrizzlyServerRecognizer(RubyInstance rubyInstance) {
            this.server = rubyInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputRecognizer.ActionText processLine(String string) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Processing output line: " + string);
            }
            String string2 = string;
            if (this.isStartupMsg(string)) {
                RailsServerManager railsServerManager = RailsServerManager.this;
                synchronized (railsServerManager) {
                    LOGGER.fine("Identified " + this.server + " as running");
                    RailsServerManager.this.status = ServerStatus.RUNNING;
                }
            } else if (this.isAddressInUseMsg(string)) {
                LOGGER.fine("Detected port conflict: " + string);
                RailsServerManager.this.portConflict = true;
            }
            if (!string2.equals(string)) {
                return new OutputRecognizer.ActionText(new String[]{string2}, null, null, null);
            }
            return null;
        }

        private boolean isStartupMsg(String string) {
            return string.contains("Grizzly configuration for port");
        }

        private boolean isAddressInUseMsg(String string) {
            return string.contains("BindException");
        }
    }

    private class RailsServerRecognizer
    extends OutputRecognizer {
        private final RubyServer server;

        RailsServerRecognizer(RubyServer rubyServer) {
            this.server = rubyServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputRecognizer.ActionText processLine(String string) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Processing output line: " + string);
            }
            String string2 = string;
            if (this.server.isStartupMsg(string)) {
                RailsServerManager railsServerManager = RailsServerManager.this;
                synchronized (railsServerManager) {
                    LOGGER.fine("Identified " + this.server + " as running");
                    RailsServerManager.this.status = ServerStatus.RUNNING;
                    String string3 = ((ProjectInformation)RailsServerManager.this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
                    this.server.addApplication(new RailsApplication(string3, RailsServerManager.this.port, RailsServerManager.this.execution));
                }
            } else if (RailsServerManager.isAddressInUseMsg(string)) {
                LOGGER.fine("Detected port conflict: " + string);
                RailsServerManager.this.portConflict = true;
            }
            if (!string2.equals(string)) {
                return new OutputRecognizer.ActionText(new String[]{string2}, null, null, null);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ServerStatus {
        NOT_STARTED,
        STARTING,
        RUNNING;

    }
}

